package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.activity.Package;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;

import java.util.List;

public interface PackageRepository extends Neo4jRepository<Package, Long> {

   // @Query("match (te:TenantEntity{tenantId:$0})-[:ACTIVITY]->(a:Activity{pattern:$1,version:$2})<-[:Contains]-(p:Package) return distinct p")
    @Query("match (a:Activity{pattern:$1,version:$2})<-[:Contains]-(p:Package) where (a.tenantId in ['SYSTEM',$0] or a.tenantId is null) return distinct p")
    List<Package> getTenantPackages(String tenantId, String pattern, String tenantVersion);

}
