/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.action.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kmservice.action.metadata.model.ApiDataMetadataDTO;
import com.digiwin.athena.kmservice.action.metadata.model.ApiListRequestDTO;
import com.digiwin.athena.kmservice.action.metadata.model.ApiListResponseDTO;
import com.digiwin.athena.kmservice.action.metadata.model.ApiMetadataRequestDTO;
import com.digiwin.athena.kmservice.action.metadata.model.ApiMetadataResponseDTO;
import com.digiwin.athena.kmservice.action.model.ApiInfoDTO;
import com.digiwin.athena.knowledgegraph.action.dao.ActionMetadataDAO;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiSynchronizer {
    @Autowired
    private ActionMetadataDAO actionMetadataDAO;
    private final String MDC_URL = "https://mdc.apps.digiwincloud.com.cn/restful/standard/mdc";

    public void SynchronizeOne(String apiName, String productName, String productVersion) throws Exception {
        String apiMetadataUrl = "https://mdc.apps.digiwincloud.com.cn/restful/standard/mdc/ApiMetadata/Get";
        URL restURL = new URL(apiMetadataUrl);
        HttpURLConnection conn = (HttpURLConnection)restURL.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        ApiMetadataRequestDTO metadataReuest = new ApiMetadataRequestDTO();
        metadataReuest.setApi_name(apiName);
        metadataReuest.setProduct_name(productName);
        metadataReuest.setProduct_version(productVersion);
        PrintStream ps = new PrintStream(conn.getOutputStream());
        ps.print(JSON.toJSON((Object)metadataReuest));
        ps.close();
        ApiMetadataResponseDTO metadataResponse = (ApiMetadataResponseDTO)JSON.parseObject((InputStream)conn.getInputStream(), ApiMetadataResponseDTO.class, (Feature[])new Feature[0]);
        String apiVersion = metadataResponse.getData().getApi_version();
        String category = metadataResponse.getData().getCategory();
        String remark_cn = metadataResponse.getData().getRemark().getZh_CN();
        String remark_tw = metadataResponse.getData().getRemark().getZh_TW();
        String desc_cn = metadataResponse.getData().getDescription().getZh_CN();
        String desc_tw = metadataResponse.getData().getDescription().getZh_TW();
        ApiDataMetadataDTO dataMetadata = metadataResponse.getData().getData_metadata();
        List fieldsOfParameter = ((ApiDataFieldMetadataDTO)dataMetadata.getRequest().getBody().getField().get(0)).getField();
        ArrayList<ApiDataFieldMetadataDTO> fieldRequestObjects = new ArrayList<ApiDataFieldMetadataDTO>();
        for (ApiDataFieldMetadataDTO fieldOfParameter : fieldsOfParameter) {
            if (fieldOfParameter.getData_name().equals("enterprise_no") || fieldOfParameter.getData_name().equals("site_no") || fieldOfParameter.getData_name().equals("call_id")) continue;
            fieldRequestObjects.add(fieldOfParameter);
            break;
        }
        String request_str = JSON.toJSONString(fieldRequestObjects);
        List fieldsOfResponse = dataMetadata.getResponse_success().getBody().getField();
        ApiDataFieldMetadataDTO fieldReponseObject = null;
        for (ApiDataFieldMetadataDTO fieldOfResponse : fieldsOfResponse) {
            if (!fieldOfResponse.getData_name().equals("parameter")) continue;
            fieldReponseObject = fieldOfResponse;
            break;
        }
        String response_str = "";
        if (fieldReponseObject != null) {
            response_str = JSON.toJSONString(fieldReponseObject.getField().get(0));
        }
        String actionId = "esp_" + apiName;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Create (action:Action {");
        stringBuffer.append("actionId:'");
        stringBuffer.append(actionId);
        stringBuffer.append("', serviceName:'");
        stringBuffer.append(apiName);
        stringBuffer.append("', serviceVersion:'");
        stringBuffer.append(apiVersion);
        stringBuffer.append("', actionName:'");
        stringBuffer.append(desc_cn);
        stringBuffer.append("', actionName_tw:'");
        stringBuffer.append(desc_tw);
        stringBuffer.append("', desc:'");
        stringBuffer.append(remark_cn);
        stringBuffer.append("', desc_tw:'");
        stringBuffer.append(remark_tw);
        stringBuffer.append("', request_parameters:'");
        stringBuffer.append(request_str);
        stringBuffer.append("', response_object:'");
        stringBuffer.append(response_str);
        stringBuffer.append("'})");
        Neo4jManager.getNeo4jManager().ExecuteQuery(stringBuffer.toString());
        this.actionMetadataDAO.upsertActionMetadata(actionId, apiVersion, JSONObject.parseArray((String)request_str), JSONObject.parseObject((String)response_str), apiName);
    }

    public List<String> SynchronizeAll(String tenantId) throws Exception {
        String apiListUrl = "https://mdc.apps.digiwincloud.com.cn/restful/standard/mdc/ApiList/Get";
        URL restURL = new URL(apiListUrl);
        HttpURLConnection conn = (HttpURLConnection)restURL.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        ApiListRequestDTO apiListRequest = new ApiListRequestDTO();
        apiListRequest.setLanguage("zh_CN");
        PrintStream ps = new PrintStream(conn.getOutputStream());
        ps.print(JSON.toJSON((Object)apiListRequest));
        ps.close();
        if (conn.getResponseCode() != 200) {
            throw new DWBusinessException(Integer.toString(conn.getResponseCode()), I18nUtils.getValue("knowledgegraph.apiError", new Object[0]) + conn.getResponseMessage());
        }
        ApiListResponseDTO apiListResponse = (ApiListResponseDTO)JSON.parseObject((InputStream)conn.getInputStream(), ApiListResponseDTO.class, (Feature[])new Feature[0]);
        List apiInfos = apiListResponse.getData().getApi_info();
        ArrayList<String> succeeded = new ArrayList<String>();
        for (ApiInfoDTO apiInfo : apiInfos) {
            try {
                this.SynchronizeOne(apiInfo.getName(), "E10", "6.0.0.1");
                succeeded.add(apiInfo.getName());
            }
            catch (Exception ex) {
                System.out.println("api failed to synchronize: " + apiInfo.getName());
            }
        }
        return succeeded;
    }
}

