/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.app;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.domain.application.AppTenantVersion;
import com.digiwin.athena.knowledgegraph.repo.AppTenantVersionRepository;
import com.digiwin.athena.knowledgegraph.service.IAppTenantVersionService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AppTenantVersionService
implements IAppTenantVersionService {
    private static final Logger log = LoggerFactory.getLogger(AppTenantVersionService.class);
    @Autowired
    private AppTenantVersionRepository appTenantVersionRepository;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;

    @Override
    public Object put(AppTenantVersion appTenantVersion) throws DWBusinessException {
        if (StringUtils.isEmpty((Object)appTenantVersion.getAppCode())) {
            throw new DWArgumentException("appTenantVersion", I18nUtils.getValue("knowledgegraph.appTenantVersion.appCodeEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((Object)appTenantVersion.getAppVersion())) {
            throw new DWArgumentException("appTenantVersion", I18nUtils.getValue("knowledgegraph.appTenantVersion.appVersionEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((Object)appTenantVersion.getDevVersion())) {
            throw new DWArgumentException("appTenantVersion", I18nUtils.getValue("knowledgegraph.appTenantVersion.devVersionEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((Object)appTenantVersion.getTenantId())) {
            appTenantVersion.setTenantId(AthenaUtils.getTenantId());
        }
        try {
            AppTenantVersion re = this.appTenantVersionRepository.findOneByTenantIdAndAppCode(appTenantVersion.getTenantId(), appTenantVersion.getAppCode());
            if (re == null) {
                this.appTenantVersionRepository.insert(appTenantVersion);
            } else {
                re.setAppVersion(appTenantVersion.getAppVersion());
                re.setDevVersion(appTenantVersion.getDevVersion());
                this.appTenantVersionRepository.save(re);
            }
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object post(AppTenantVersion appTenantVersion) throws DWBusinessException {
        if (StringUtils.isEmpty((Object)appTenantVersion.getAppCode())) {
            throw new DWArgumentException("appTenantVersion", I18nUtils.getValue("knowledgegraph.appTenantVersion.appCodeEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((Object)appTenantVersion.getAppVersion()) && StringUtils.isEmpty((Object)appTenantVersion.getDevVersion())) {
            throw new DWArgumentException("appTenantVersion", I18nUtils.getValue("knowledgegraph.appTenantVersion.appVersionAndDevVersionEmpty", new Object[0]));
        }
        if (StringUtils.isEmpty((Object)appTenantVersion.getTenantId())) {
            appTenantVersion.setTenantId(AthenaUtils.getTenantId());
        }
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)appTenantVersion.getTenantId()).and("appCode").is((Object)appTenantVersion.getAppCode());
        Update update = new Update();
        if (!StringUtils.isEmpty((Object)appTenantVersion.getAppVersion())) {
            update.set("appVersion", (Object)appTenantVersion.getAppVersion());
        }
        if (!StringUtils.isEmpty((Object)appTenantVersion.getDevVersion())) {
            update.set("devVersion", (Object)appTenantVersion.getDevVersion());
        }
        try {
            this.mongoTemplate.upsert(new Query((CriteriaDefinition)criteria), update, AppTenantVersion.class);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object delete(String appCode) throws DWBusinessException {
        if (StringUtils.isEmpty((Object)appCode)) {
            throw new DWArgumentException("appTenantVersion", I18nUtils.getValue("knowledgegraph.appTenantVersion.appCodeEmpty", new Object[0]));
        }
        try {
            Criteria criteria = new Criteria();
            criteria.and("tenantId").is((Object)AthenaUtils.getTenantId()).and("appCode").is((Object)appCode);
            this.mongoTemplate.remove(new Query((CriteriaDefinition)criteria), AppTenantVersion.class);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public AppTenantVersion postQueryVersion(String appCode) throws DWBusinessException {
        AppTenantVersion re;
        try {
            re = this.appTenantVersionRepository.findOneByTenantIdAndAppCode(AthenaUtils.getTenantId(), appCode);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return re;
    }
}

