/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.component;

import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.annotation.ScheduledCall;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.component.bo.MechanismVariableComponentBO;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import com.digiwin.athena.domain.component.bo.TenantAppComponentListBO;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyContext;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyService;
import com.digiwin.athena.knowledgegraph.component.dao.ComponentStructuredListDAO;
import com.digiwin.athena.knowledgegraph.component.dao.TenantAppComponentListDAO;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismTenantParadigm;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Principle;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ComponentManager {
    private static final Logger log = LoggerFactory.getLogger(ComponentManager.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    SessionFactory neo4jSessionFactory;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactoryDomain1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactoryDomain2;
    @Autowired
    @Lazy
    private ComponentStructuredListDAO componentStructuredListDAO;
    @Autowired
    private TenantAppComponentListDAO tenantAppComponentListDAO;
    @Autowired
    IMechanismService mechanismService;
    @Autowired
    AppService appService;
    @Autowired
    private List<ComponentApplyService> applyServices;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private DataPickService dataPickService;
    public static final String APP_CODE = "appCode";
    public static final String PARADIGM = "paradigm";
    public static final String TYPE = "type";
    public static final String VERSION = "version";
    public static final String TENANT_ID = "tenantId";
    public static final String MECHANISM_CODE = "mechanismCode";

    public void applyComponent(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        ComponentApplyService componentApplyService = null;
        for (ComponentApplyService applyService : this.applyServices) {
            if (!applyService.accept(componentBO)) continue;
            componentApplyService = applyService;
            break;
        }
        if (null != componentApplyService) {
            componentApplyService.apply(componentBO, context);
        }
    }

    public void unApplyComponent(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        ComponentApplyService componentApplyService = null;
        for (ComponentApplyService applyService : this.applyServices) {
            if (!applyService.accept(componentBO)) continue;
            componentApplyService = applyService;
            break;
        }
        if (null != componentApplyService) {
            componentApplyService.unApply(componentBO, context);
        }
    }

    public ComponentStructuredList findBaseFunctionComponentStructuredList(String appCode, String paradigm, String version, String tenantId) throws DWBusinessException {
        return this.componentStructuredListDAO.findBaseFunctionComponentStructuredList(appCode, paradigm, version, tenantId);
    }

    public List<ComponentStructuredList> findBaseFunctionComponentStructuredList(String appCode, List<String> paradigms, String version, String tenantId) throws DWBusinessException {
        return this.componentStructuredListDAO.findBaseFunctionComponentStructuredList(appCode, paradigms, version, tenantId);
    }

    public ComponentStructuredList findMechanismComponentStructuredList(String mechanismCode) throws DWBusinessException {
        String version = this.kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
        return this.componentStructuredListDAO.findMechanismComponentStructuredList(mechanismCode, version, null);
    }

    public ComponentStructuredList findMechanismComponentStructuredList(String mechanismCode, String version, String tenantId) throws DWBusinessException {
        return this.componentStructuredListDAO.findMechanismComponentStructuredList(mechanismCode, version, tenantId);
    }

    public List<ComponentStructuredList> findMechanismComponentStructuredList(List<String> mechanismCodes, String version, String tenantId) throws DWBusinessException {
        return this.componentStructuredListDAO.findMechanismComponentStructuredList(mechanismCodes, version, tenantId);
    }

    public TenantAppComponentListBO findTenantComponentList(String appCode, String tenantId) throws DWBusinessException {
        TenantAppComponentListBO list = this.tenantAppComponentListDAO.findTenantAppComponentList(appCode, tenantId);
        if (list == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.noAvailableComponent4", tenantId, appCode));
        }
        return list;
    }

    private void clearMechanismTenantParadigm(String appCode, String tenantId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").is((Object)appCode).and(TENANT_ID).is((Object)tenantId);
        query.addCriteria((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, "mechanismTenantParadigm");
    }

    private void initMechanismTenantParadigm(String appCode, String tenantId, List<String> mechanismCodes, List<String> paradigms) {
        Update update;
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").is((Object)appCode).and(TENANT_ID).is((Object)tenantId);
        query.addCriteria((CriteriaDefinition)criteria);
        Update update2 = update = new Update();
        update2.getClass();
        Update.AddToSetBuilder add = new Update.AddToSetBuilder(update2, "value");
        Update update3 = update = add.each(new Object[]{mechanismCodes});
        update3.getClass();
        Update.AddToSetBuilder addParadigms = new Update.AddToSetBuilder(update3, "paradigms");
        update = addParadigms.each(new Object[]{paradigms});
        this.mongoTemplate.upsert(query, update, MechanismTenantParadigm.class);
    }

    public void InitializeTenantApplicationComponentList(String appCode, String tenantId, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        TenantAppComponentListBO list = this.tenantAppComponentListDAO.findTenantAppComponentList(appCode, tenantId);
        String version = this.kgInnerService.getTenantVersion(tenantId);
        if (list != null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.initializedComponent", tenantId, appCode));
        }
        this.checkDependMechanism(appCode, tenantId, mechanismCodes, false);
        TenantAppComponentListBO tenantAppComponentList = this.GetTenantAllApplicationComponentList(appCode, tenantId, paradigm, mechanismCodes);
        List<String> allMechanismCodes = this.componentStructuredListDAO.findAllMechanismCodes(appCode, version, tenantId);
        TenantAppComponentListBO allAppComponentList = this.GetAllApplicationComponentList(appCode, tenantId, allMechanismCodes);
        log.info("\u5f00\u59cb\u4f9d\u636e\u79df\u6237\u7ec4\u4ef6\u6e05\u5355\u66f4\u65b0\u7ec4\u4ef6:{}", (Object)tenantId);
        Application application = this.appService.getApplicationByCode(appCode, tenantId);
        if (application == null) {
            log.error("appEntity\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u8005appEntity\u8282\u70b9\u4e2dnameSpace\u4e3a\u7a7a\uff0c\u8bf7\u5148\u521b\u5efa\u540e\u518d\u521d\u59cb\u5316!");
            throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist", new Object[0]));
        }
        ArrayList<String> cypherList = new ArrayList<String>();
        allAppComponentList.getComponents().forEach(component -> {
            if (!ComponentManager.Contains(tenantAppComponentList.getComponents(), (ComponentBaseInfoBO)component).booleanValue()) {
                this.DisableComponent((ComponentBO)component, tenantId, false, (List<String>)cypherList, appCode, mechanismCodes, null);
            }
        });
        tenantAppComponentList.getComponents().forEach(component -> {
            try {
                this.SetDefaultComponent((ComponentBO)component, tenantId, true, (List<String>)cypherList, mechanismCodes, null, null);
            }
            catch (Exception e) {
                log.error("error while setting variable {} for tenant {}", (Object)component.getCode(), (Object)tenantId);
            }
        });
        this.executeCypher(cypherList, this.sessionFactoryDomain1);
        this.executeCypher(cypherList, this.sessionFactoryDomain2);
        this.tenantAppComponentListDAO.SaveTenantAppComponentList(tenantAppComponentList);
        this.initMechanismTenantParadigm(appCode, tenantId, mechanismCodes, Arrays.asList(paradigm));
    }

    @ScheduledCall
    public void InitializeTenantApplicationComponentList(String appCode, String tenantId, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException {
        TenantAppComponentListBO list = this.tenantAppComponentListDAO.findTenantAppComponentList(appCode, tenantId);
        String version = this.kgInnerService.getTenantVersion(tenantId);
        if (list != null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.initializedComponent", tenantId, appCode));
        }
        this.checkDependMechanism(appCode, tenantId, mechanismCodes, false);
        TenantAppComponentListBO tenantAppComponentList = this.GetTenantAllApplicationComponentList(appCode, tenantId, paradigms, mechanismCodes);
        List<String> allMechanismCodes = this.componentStructuredListDAO.findAllMechanismCodes(appCode, version, tenantId);
        TenantAppComponentListBO allAppComponentList = this.GetAllApplicationComponentList(appCode, tenantId, allMechanismCodes);
        log.info("\u5f00\u59cb\u4f9d\u636e\u79df\u6237\u7ec4\u4ef6\u6e05\u5355\u66f4\u65b0\u7ec4\u4ef6:{}", (Object)tenantId);
        Application application = this.appService.getApplicationByCode(appCode, tenantId);
        if (application == null) {
            log.error("appEntity\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u8005appEntity\u8282\u70b9\u4e2dnameSpace\u4e3a\u7a7a\uff0c\u8bf7\u5148\u521b\u5efa\u540e\u518d\u521d\u59cb\u5316!");
            throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist", new Object[0]));
        }
        ArrayList<String> cypherList = new ArrayList<String>();
        allAppComponentList.getComponents().forEach(component -> {
            if (!ComponentManager.Contains(tenantAppComponentList.getComponents(), (ComponentBaseInfoBO)component).booleanValue()) {
                this.DisableComponent((ComponentBO)component, tenantId, false, (List<String>)cypherList, appCode, mechanismCodes, null);
            }
        });
        tenantAppComponentList.getComponents().forEach(component -> {
            try {
                this.SetDefaultComponent((ComponentBO)component, tenantId, true, (List<String>)cypherList, mechanismCodes, null, null);
            }
            catch (Exception e) {
                log.error("error while setting variable {} for tenant {}", (Object)component.getCode(), (Object)tenantId);
            }
        });
        this.executeCypher(cypherList, this.sessionFactoryDomain1);
        this.executeCypher(cypherList, this.sessionFactoryDomain2);
        this.tenantAppComponentListDAO.SaveTenantAppComponentList(tenantAppComponentList);
        this.initMechanismTenantParadigm(appCode, tenantId, mechanismCodes, paradigms);
    }

    private void executeCypher(List<String> cypherList, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(cypherList)) {
            return;
        }
        if (sessionFactory == null) {
            return;
        }
        Session session1 = sessionFactory.openSession();
        Transaction transaction1 = session1.beginTransaction();
        cypherList.forEach(cypher -> session1.query(cypher, new HashMap()));
        transaction1.commit();
        session1.clear();
    }

    public void UpdateTenantApplicationComponentListByMechanism(String appCode, String tenantId, String paradigm, List<String> mechanismCodes, String mechanismCode) throws DWBusinessException {
        TenantAppComponentListBO list = this.tenantAppComponentListDAO.findTenantAppComponentList(appCode, tenantId);
        if (list == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.noAvailableComponent4", tenantId, appCode));
        }
        this.checkDependMechanism(appCode, tenantId, mechanismCodes, true);
        TenantAppComponentListBO allAppComponentList = this.GetTenantAllApplicationComponentList(appCode, tenantId, paradigm, mechanismCodes);
        String version = this.kgInnerService.getTenantVersion(tenantId);
        TenantAppComponentListBO tenantAppComponentList = this.GetTenantUsingApplicationComponentList(appCode, tenantId, paradigm, mechanismCodes, version);
        log.info("\u5f00\u59cb\u4f9d\u636e\u79df\u6237\u7ec4\u4ef6\u6e05\u5355\u66f4\u65b0\u7ec4\u4ef6:{}", (Object)tenantId);
        Application application = this.appService.getApplicationByCode(appCode, tenantId);
        if (application == null) {
            log.error("appEntity\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u8005appEntity\u8282\u70b9\u4e2dnameSpace\u4e3a\u7a7a\uff0c\u8bf7\u5148\u521b\u5efa\u540e\u518d\u521d\u59cb\u5316!");
            throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist", new Object[0]));
        }
        ArrayList<String> cypherList = new ArrayList<String>();
        allAppComponentList.getComponents().forEach(component -> {
            if (!ComponentManager.Contains(tenantAppComponentList.getComponents(), (ComponentBaseInfoBO)component).booleanValue()) {
                component.setDisabled(true);
                this.DisableComponent((ComponentBO)component, tenantId, true, (List<String>)cypherList, appCode, mechanismCodes, mechanismCode);
            }
        });
        if (StringUtils.isEmpty((CharSequence)mechanismCode)) {
            tenantAppComponentList.getComponents().forEach(component -> {
                try {
                    if (!component.isDisabled()) {
                        this.SetDefaultComponent((ComponentBO)component, tenantId, false, (List<String>)cypherList, mechanismCodes, mechanismCode, null);
                    }
                }
                catch (Exception e) {
                    log.error("error while setting variable {} for tenant {}", (Object)component.getCode(), (Object)tenantId);
                }
            });
        } else {
            List<ComponentBO> componentBOS = this.GetTenantMechanismComponentList(mechanismCode, tenantId, version);
            Map allMechanismVariable = this.getAllMechanismVariable(componentBOS);
            componentBOS.forEach(component -> {
                try {
                    if (!component.isDisabled()) {
                        this.SetDefaultComponent((ComponentBO)component, tenantId, true, (List<String>)cypherList, mechanismCodes, mechanismCode, allMechanismVariable);
                    }
                }
                catch (Exception e) {
                    log.error("error while setting variable {} for tenant {}", (Object)component.getCode(), (Object)tenantId);
                }
            });
        }
        this.executeCypher(cypherList, this.sessionFactoryDomain1);
        this.executeCypher(cypherList, this.sessionFactoryDomain2);
        tenantAppComponentList.setUid(list.getUid());
        this.tenantAppComponentListDAO.SaveTenantAppComponentList(tenantAppComponentList);
        this.initMechanismTenantParadigm(appCode, tenantId, mechanismCodes, Arrays.asList(paradigm));
    }

    private Map getAllMechanismVariable(List<ComponentBO> componentBOS) {
        List<String> collect = componentBOS.stream().filter(e -> ComponentTypeEnum.MechanismVariable.equals((Object)e.getType()) || ComponentTypeEnum.MechanismParam.equals((Object)e.getType())).map(ComponentBaseInfoBO::getCode).distinct().collect(Collectors.toList());
        HashMap map = new HashMap();
        if (CollectionUtils.isNotEmpty(collect)) {
            collect.forEach(key -> {
                try {
                    Object variable = this.mechanismService.getVariable((String)key, AthenaUtils.getTenantId());
                    if (!ObjectUtils.isEmpty((Object)variable)) {
                        Map variableMap = (Map)variable;
                        map.putAll(variableMap);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        return map;
    }

    @ScheduledCall
    public void UpdateTenantApplicationComponentListByMechanism(String appCode, String tenantId, List<String> paradigms, List<String> mechanismCodes, String mechanismCode) throws DWBusinessException {
        TenantAppComponentListBO list = this.tenantAppComponentListDAO.findTenantAppComponentList(appCode, tenantId);
        if (list == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.noAvailableComponent4", tenantId, appCode));
        }
        this.checkDependMechanism(appCode, tenantId, mechanismCodes, true);
        String version = this.kgInnerService.getTenantVersion(tenantId);
        TenantAppComponentListBO allAppComponentList = this.GetTenantAllApplicationComponentList(appCode, tenantId, paradigms, mechanismCodes);
        TenantAppComponentListBO tenantAppComponentList = this.GetTenantUsingApplicationComponentList(appCode, tenantId, paradigms, mechanismCodes);
        log.info("\u5f00\u59cb\u4f9d\u636e\u79df\u6237\u7ec4\u4ef6\u6e05\u5355\u66f4\u65b0\u7ec4\u4ef6:{}", (Object)tenantId);
        Application application = this.appService.getApplicationByCode(appCode, tenantId);
        if (application == null) {
            log.error("appEntity\u8282\u70b9\u4e0d\u5b58\u5728\u6216\u8005appEntity\u8282\u70b9\u4e2dnameSpace\u4e3a\u7a7a\uff0c\u8bf7\u5148\u521b\u5efa\u540e\u518d\u521d\u59cb\u5316!");
            throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist", new Object[0]));
        }
        ArrayList<String> cypherList = new ArrayList<String>();
        allAppComponentList.getComponents().forEach(component -> {
            if (!ComponentManager.Contains(tenantAppComponentList.getComponents(), (ComponentBaseInfoBO)component).booleanValue()) {
                component.setDisabled(true);
                this.DisableComponent((ComponentBO)component, tenantId, true, (List<String>)cypherList, appCode, mechanismCodes, mechanismCode);
            }
        });
        if (StringUtils.isEmpty((CharSequence)mechanismCode)) {
            tenantAppComponentList.getComponents().forEach(component -> {
                try {
                    if (!component.isDisabled()) {
                        this.SetDefaultComponent((ComponentBO)component, tenantId, false, (List<String>)cypherList, mechanismCodes, mechanismCode, null);
                    }
                }
                catch (Exception e) {
                    log.error("error while setting variable {} for tenant {}", (Object)component.getCode(), (Object)tenantId);
                }
            });
        } else {
            List<ComponentBO> componentBOS = this.GetTenantMechanismComponentList(mechanismCode, tenantId, version);
            Map allMechanismVariable = this.getAllMechanismVariable(componentBOS);
            componentBOS.forEach(component -> {
                try {
                    if (!component.isDisabled()) {
                        this.SetDefaultComponent((ComponentBO)component, tenantId, true, (List<String>)cypherList, mechanismCodes, mechanismCode, allMechanismVariable);
                    }
                }
                catch (Exception e) {
                    log.error("error while setting variable {} for tenant {}", (Object)component.getCode(), (Object)tenantId);
                }
            });
        }
        this.executeCypher(cypherList, this.sessionFactoryDomain1);
        this.executeCypher(cypherList, this.sessionFactoryDomain2);
        tenantAppComponentList.setUid(list.getUid());
        this.tenantAppComponentListDAO.SaveTenantAppComponentList(tenantAppComponentList);
        this.initMechanismTenantParadigm(appCode, tenantId, mechanismCodes, paradigms);
    }

    public List<ComponentBaseInfoBO> FilterByTenantApplicationComponentList(String appCode, String tenantId, List<ComponentBaseInfoBO> components) throws DWBusinessException {
        try {
            TenantAppComponentListBO appComponentListDO = this.tenantAppComponentListDAO.findTenantAppComponentList(appCode, tenantId);
            if (appComponentListDO == null || appComponentListDO.getComponents().isEmpty()) {
                return components;
            }
            ArrayList<ComponentBaseInfoBO> filteredComponents = new ArrayList<ComponentBaseInfoBO>();
            List tenantComponents = appComponentListDO.getComponents();
            for (ComponentBaseInfoBO component : components) {
                boolean enabled = false;
                for (ComponentBO tenantComonent : tenantComponents) {
                    if (!component.getCode().equals(tenantComonent.getCode()) || !component.getType().equals((Object)tenantComonent.getType())) continue;
                    if (tenantComonent.isDisabled()) break;
                    enabled = true;
                    break;
                }
                if (!enabled) continue;
                filteredComponents.add(component);
            }
            return filteredComponents;
        }
        catch (Exception exception) {
            log.error("error while filtering components: " + exception.getLocalizedMessage());
            return components;
        }
    }

    private TenantAppComponentListBO GetTenantAllApplicationComponentList(String appCode, String tenantId, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        ArrayList<ComponentBaseInfoBO> emptyList = new ArrayList<ComponentBaseInfoBO>();
        String version = this.kgInnerService.getTenantVersion(tenantId);
        ComponentStructuredList baseFunctionList = this.findBaseFunctionComponentStructuredList(appCode, paradigm, version, tenantId);
        ArrayList<ComponentBO> mergedList = new ArrayList<ComponentBO>();
        this.Merge(mergedList, baseFunctionList.getComponents(), emptyList);
        if (CollectionUtils.isNotEmpty(mechanismCodes)) {
            for (String mechanismCode : mechanismCodes) {
                this.Merge(mergedList, this.findMechanismComponentStructuredList(mechanismCode, version, tenantId).getComponents(), emptyList);
            }
        }
        TenantAppComponentListBO tenantAppComponentList = new TenantAppComponentListBO();
        tenantAppComponentList.setTenantId(tenantId);
        tenantAppComponentList.setAppCode(appCode);
        tenantAppComponentList.setComponents(mergedList);
        return tenantAppComponentList;
    }

    private TenantAppComponentListBO GetTenantAllApplicationComponentList(String appCode, String tenantId, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException {
        ArrayList<ComponentBaseInfoBO> emptyList = new ArrayList<ComponentBaseInfoBO>();
        String version = this.kgInnerService.getTenantVersion(tenantId);
        List<ComponentStructuredList> baseFunctionComponentStructuredList = this.findBaseFunctionComponentStructuredList(appCode, paradigms, version, tenantId);
        ArrayList<ComponentBO> mergedList = new ArrayList<ComponentBO>();
        if (CollectionUtils.isNotEmpty(baseFunctionComponentStructuredList)) {
            for (ComponentStructuredList baseFunctionList : baseFunctionComponentStructuredList) {
                this.Merge(mergedList, baseFunctionList.getComponents(), emptyList);
            }
        }
        if (CollectionUtils.isNotEmpty(mechanismCodes)) {
            for (String mechanismCode : mechanismCodes) {
                this.Merge(mergedList, this.findMechanismComponentStructuredList(mechanismCode, version, tenantId).getComponents(), emptyList);
            }
        }
        TenantAppComponentListBO tenantAppComponentList = new TenantAppComponentListBO();
        tenantAppComponentList.setTenantId(tenantId);
        tenantAppComponentList.setAppCode(appCode);
        tenantAppComponentList.setComponents(mergedList);
        return tenantAppComponentList;
    }

    private TenantAppComponentListBO GetAllApplicationComponentList(String appCode, String tenantId, List<String> mechanismCodes) throws DWBusinessException {
        ArrayList<ComponentBaseInfoBO> emptyList = new ArrayList<ComponentBaseInfoBO>();
        String version = this.kgInnerService.getTenantVersion(tenantId);
        List<ComponentStructuredList> baseFunctionLists = this.componentStructuredListDAO.findBaseFunctionComponentStructuredList(appCode, version, tenantId);
        ArrayList<ComponentBO> mergedList = new ArrayList<ComponentBO>();
        baseFunctionLists.forEach(baseFunctionList -> this.Merge(mergedList, baseFunctionList.getComponents(), emptyList));
        for (String mechanismCode : mechanismCodes) {
            this.Merge(mergedList, this.findMechanismComponentStructuredList(mechanismCode, version, tenantId).getComponents(), emptyList);
        }
        TenantAppComponentListBO tenantAppComponentList = new TenantAppComponentListBO();
        tenantAppComponentList.setTenantId(tenantId);
        tenantAppComponentList.setAppCode(appCode);
        tenantAppComponentList.setComponents(mergedList);
        return tenantAppComponentList;
    }

    public TenantAppComponentListBO GetTenantUsingApplicationComponentList(String appCode, String tenantId, String paradigm, List<String> mechanismCodes, String version) throws DWBusinessException {
        ArrayList<ComponentBaseInfoBO> emptyList = new ArrayList<ComponentBaseInfoBO>();
        ComponentStructuredList baseFunctionList = this.findBaseFunctionComponentStructuredList(appCode, paradigm, version, tenantId);
        ArrayList<ComponentBO> mergedList = new ArrayList<ComponentBO>();
        this.Merge(mergedList, baseFunctionList.getComponents(), emptyList);
        for (String mechanismCode : mechanismCodes) {
            List<ComponentBO> mechanismComponents = this.GetTenantMechanismComponentList(mechanismCode, tenantId, version);
            mechanismComponents.forEach(mechanismComponent -> {
                if (!ComponentManager.Contains(mergedList, (ComponentBaseInfoBO)mechanismComponent).booleanValue()) {
                    mergedList.add((ComponentBO)mechanismComponent);
                }
            });
        }
        TenantAppComponentListBO tenantAppComponentList = new TenantAppComponentListBO();
        tenantAppComponentList.setTenantId(tenantId);
        tenantAppComponentList.setAppCode(appCode);
        tenantAppComponentList.setComponents(mergedList);
        return tenantAppComponentList;
    }

    public TenantAppComponentListBO GetTenantUsingApplicationComponentList(String appCode, String tenantId, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException {
        ArrayList<ComponentBaseInfoBO> emptyList = new ArrayList<ComponentBaseInfoBO>();
        String version = this.kgInnerService.getTenantVersion(tenantId);
        List<ComponentStructuredList> baseFunctionComponentStructuredList = this.findBaseFunctionComponentStructuredList(appCode, paradigms, version, tenantId);
        ArrayList<ComponentBO> mergedList = new ArrayList<ComponentBO>();
        if (CollectionUtils.isNotEmpty(baseFunctionComponentStructuredList)) {
            for (ComponentStructuredList baseFunctionList : baseFunctionComponentStructuredList) {
                this.Merge(mergedList, baseFunctionList.getComponents(), emptyList);
            }
        }
        for (String mechanismCode : mechanismCodes) {
            List<ComponentBO> mechanismComponents = this.GetTenantMechanismComponentList(mechanismCode, tenantId, version);
            mechanismComponents.forEach(mechanismComponent -> {
                if (!ComponentManager.Contains(mergedList, (ComponentBaseInfoBO)mechanismComponent).booleanValue()) {
                    mergedList.add((ComponentBO)mechanismComponent);
                }
            });
        }
        TenantAppComponentListBO tenantAppComponentList = new TenantAppComponentListBO();
        tenantAppComponentList.setTenantId(tenantId);
        tenantAppComponentList.setAppCode(appCode);
        tenantAppComponentList.setComponents(mergedList);
        return tenantAppComponentList;
    }

    private List<ComponentBO> GetTenantMechanismComponentList(String mechanismCode, String tenantId, String version) throws DWBusinessException {
        ArrayList<ComponentBO> components = new ArrayList<ComponentBO>();
        ComponentStructuredList mechanismComponentList = this.findMechanismComponentStructuredList(mechanismCode, version, tenantId);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").is((Object)mechanismCode).and(TENANT_ID).is((Object)tenantId);
        query.addCriteria((CriteriaDefinition)criteria);
        ArrayList<ComponentBaseInfoBO> componentsToRemove = new ArrayList<ComponentBaseInfoBO>();
        Mechanism mechanism = (Mechanism)((Object)this.mongoTemplate.findOne(query, Mechanism.class));
        if (mechanism != null) {
            mechanismComponentList.getComponents().forEach(principleComponent -> {
                Principle principle = null;
                if (CollectionUtils.isNotEmpty(mechanism.getPrinciples())) {
                    for (Principle item : mechanism.getPrinciples()) {
                        if (!principleComponent.getCode().equals(item.getCode())) continue;
                        principle = item;
                    }
                }
                if (principle == null) {
                    ComponentBaseInfoBO componentToRemove = new ComponentBaseInfoBO();
                    componentToRemove.setCode(principleComponent.getCode());
                    componentToRemove.setType(ComponentTypeEnum.MechanismPrinciple);
                    componentsToRemove.add(componentToRemove);
                } else {
                    ArrayList principleDetailCodes = new ArrayList();
                    principle.getDetails().forEach(principleDetail -> principleDetailCodes.add(principleDetail.getCode()));
                    principleComponent.getSubComponents().forEach(detailComponent -> {
                        if (detailComponent.getType().equals((Object)ComponentTypeEnum.MechanismPrincipleDetail) && !principleDetailCodes.contains(detailComponent.getCode())) {
                            ComponentBaseInfoBO componentToRemove = new ComponentBaseInfoBO();
                            componentToRemove.setCode(detailComponent.getCode());
                            componentToRemove.setType(ComponentTypeEnum.MechanismPrincipleDetail);
                            componentsToRemove.add(componentToRemove);
                        }
                    });
                }
            });
            this.Merge(components, mechanismComponentList.getComponents(), componentsToRemove);
        } else {
            this.Merge(components, mechanismComponentList.getComponents(), new ArrayList<ComponentBaseInfoBO>());
        }
        return components;
    }

    public void Merge(List<ComponentBO> original, List<StructuredComponentBO> toAdd, List<ComponentBaseInfoBO> skipList) {
        if (CollectionUtils.isNotEmpty(toAdd)) {
            for (StructuredComponentBO componentToAdd : toAdd) {
                boolean toSkip = false;
                for (ComponentBaseInfoBO item : skipList) {
                    if (!componentToAdd.getCode().equals(item.getCode()) || !componentToAdd.getType().equals((Object)item.getType())) continue;
                    toSkip = true;
                }
                if (toSkip) continue;
                List subComponents = componentToAdd.getSubComponents();
                if (!ComponentManager.Contains(original, (ComponentBaseInfoBO)componentToAdd).booleanValue()) {
                    componentToAdd.setSubComponents(null);
                    original.add((ComponentBO)componentToAdd);
                }
                if (!CollectionUtils.isNotEmpty((Collection)subComponents)) continue;
                this.Merge(original, subComponents, skipList);
            }
        }
    }

    private static Boolean Contains(List<ComponentBO> components, ComponentBaseInfoBO component) {
        for (ComponentBO item : components) {
            if (!component.getCode().equals(item.getCode()) || !component.getType().equals((Object)item.getType())) continue;
            return true;
        }
        return false;
    }

    private void DisableComponent(ComponentBO componentBO, String tenantId, boolean update, List<String> cypherList, String appNameSpace, List<String> mechanismCodes, String mechanismCode) {
        if (componentBO.getType().equals((Object)ComponentTypeEnum.MechanismVariable)) {
            if (update) {
                this.TryDeleteVariable(componentBO.getCode(), tenantId);
            }
        } else if (!componentBO.getType().equals((Object)ComponentTypeEnum.BaseDataEntry) && !componentBO.getType().equals((Object)ComponentTypeEnum.Report)) {
            try {
                if (StringUtils.isNotEmpty((CharSequence)mechanismCode)) {
                    ComponentApplyContext componentApplyContext = new ComponentApplyContext();
                    componentApplyContext.setMechanismCode(mechanismCode);
                    this.unApplyComponent(componentBO, componentApplyContext);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void SetDefaultComponent(ComponentBO componentBO, String tenantId, boolean update, List<String> cypherList, List<String> mechanismCodes, String mechanismCode, Map allMechaniseVariables) throws Exception {
        if (componentBO.getType().equals((Object)ComponentTypeEnum.MechanismVariable)) {
            MechanismVariableComponentBO mechanismVariableComponent;
            if (componentBO instanceof MechanismVariableComponentBO && !ObjectUtils.isEmpty((Object)(mechanismVariableComponent = (MechanismVariableComponentBO)componentBO).getValue())) {
                this.mechanismService.postVariable(mechanismVariableComponent.getCode(), tenantId, mechanismVariableComponent.getValue());
                log.info("set variable {} value {} for tenant {}", new Object[]{mechanismVariableComponent.getCode(), mechanismVariableComponent.getValue(), tenantId});
            }
        } else if (componentBO.getType().equals((Object)ComponentTypeEnum.BaseDataEntry) || componentBO.getType().equals((Object)ComponentTypeEnum.Report)) {
            if (update) {
                // empty if block
            }
        } else if (StringUtils.isNotEmpty((CharSequence)mechanismCode)) {
            ComponentApplyContext componentApplyContext = new ComponentApplyContext();
            componentApplyContext.setMechanismCode(mechanismCode);
            componentApplyContext.setMechanismVariables(allMechaniseVariables);
            this.applyComponent(componentBO, componentApplyContext);
        }
    }

    private boolean TryDeleteVariable(String variableName, String tenantId) {
        try {
            this.mechanismService.deleteVariable(variableName, tenantId);
            log.info("deleted variable {} of tenant {}", (Object)variableName, (Object)tenantId);
            return true;
        }
        catch (Exception e) {
            log.error("error while deleting variable {} of tenant {}", (Object)variableName, (Object)tenantId);
            return false;
        }
    }

    private boolean checkDependMechanism(String appCode, String tenantId, List<String> mechanismCodes, boolean update) throws DWBusinessException {
        if (CollectionUtils.isEmpty(mechanismCodes)) {
            return false;
        }
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").in(mechanismCodes);
        query.addCriteria((CriteriaDefinition)criteria);
        List<Mechanism> mechanismList = this.dataPickService.find(criteria, Mechanism.class, "mechanism");
        ArrayList<String> allMechanismCodes = new ArrayList<String>();
        allMechanismCodes.addAll(mechanismCodes);
        if (update) {
            Query query2 = new Query();
            Criteria criteria2 = Criteria.where((String)"code").is((Object)appCode).and(TENANT_ID).is((Object)tenantId);
            query2.addCriteria((CriteriaDefinition)criteria2);
            MechanismTenantParadigm tenantParadigm = (MechanismTenantParadigm)this.mongoTemplate.findOne(query, MechanismTenantParadigm.class);
            if (tenantParadigm != null && CollectionUtils.isNotEmpty(tenantParadigm.getValue())) {
                allMechanismCodes.addAll(tenantParadigm.getValue());
            }
        }
        mechanismList.forEach(e -> {
            boolean subCollection;
            List<String> dependMechanismCodes = e.getDependMechanismCodes();
            if (CollectionUtils.isNotEmpty(dependMechanismCodes) && !(subCollection = CollectionUtils.isSubCollection(dependMechanismCodes, (Collection)allMechanismCodes))) {
                throw new RuntimeException(I18nUtils.getValue("knowledgegraph.machineNotExist", e.getCode(), e.getName(), dependMechanismCodes));
            }
        });
        return false;
    }

    public FieldDescription createFieldDescriptionByComponent(ComponentBO componentBO) throws DWBusinessException {
        return this.createFieldDescriptionByComponent(componentBO, null);
    }

    public FieldDescription createFieldDescriptionByComponent(ComponentBO componentBO, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        if (ComponentTypeEnum.MonitorRule.equals((Object)componentBO.getType())) {
            FieldDescription monitorRuleParam = this.appService.createMonitorRuleParam(componentBO.getCode(), false, variableDefinitionsMap);
            return monitorRuleParam;
        }
        if (ComponentTypeEnum.MechanismParam.equals((Object)componentBO.getType()) || ComponentTypeEnum.ApplicationParam.equals((Object)componentBO.getType())) {
            FieldDescription variableParam = this.appService.createVariableParam(componentBO.getCode(), variableDefinitionsMap);
            return variableParam;
        }
        if (ComponentTypeEnum.BaseDataEntry.equals((Object)componentBO.getType())) {
            FieldDescription linkParam = this.appService.createLinkParam(componentBO.getCode(), variableDefinitionsMap);
            return linkParam;
        }
        FieldDescription defaultParam = this.appService.createDefaultParam(componentBO.getCode(), variableDefinitionsMap);
        return defaultParam;
    }

    public List<FieldDescription> generateParamDescriptionList(List<ComponentBO> paramDescriptionComponentList) throws DWBusinessException {
        ArrayList<FieldDescription> paramDescriptionList = new ArrayList<FieldDescription>();
        if (CollectionUtils.isNotEmpty(paramDescriptionComponentList)) {
            String tenantId = AthenaUtils.getTenantId();
            String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
            Set collect = paramDescriptionComponentList.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toSet());
            Criteria criteria = Criteria.where((String)"code").in(collect);
            List<VariableDefinition> variableDefinitions = this.dataPickService.find(criteria, VariableDefinition.class, "variableDefinition");
            Map variableDefinitionsMap = variableDefinitions.stream().collect(Collectors.toMap(CodedEntity::getCode, Function.identity(), (a, b) -> a));
            paramDescriptionComponentList.forEach(e -> {
                try {
                    FieldDescription fieldDescriptionByComponent = this.createFieldDescriptionByComponent((ComponentBO)e, variableDefinitionsMap);
                    if (fieldDescriptionByComponent != null) {
                        this.appService.setFieldDescriptionValue(fieldDescriptionByComponent);
                        paramDescriptionList.add(fieldDescriptionByComponent);
                    }
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            });
        }
        return paramDescriptionList;
    }

    public void clearTenantApplicationComponentListByMechanism(String appCode, String tenantId, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        log.info("clearTenantApplicationComponentListByMechanism appCode:{}, tenantId:{}, paradigm:{}, mechanismCodes:{}", new Object[]{appCode, tenantId, paradigm, mechanismCodes});
        this.tenantAppComponentListDAO.removeTenantAppComponentList(appCode, tenantId);
        this.clearMechanismTenantParadigm(appCode, tenantId);
    }

    public List<ComponentBO> getExtraComponent(List<ComponentBO> newComponentBO, List<StructuredComponentBO> existsComponents, Map<String, Set<String>> existsParadigmAppComponent, String paradigmCode) {
        ArrayList<ComponentBO> result = new ArrayList<ComponentBO>();
        if (CollectionUtils.isEmpty(existsComponents)) {
            return newComponentBO;
        }
        ArrayList<ComponentBO> mergedList = new ArrayList<ComponentBO>();
        this.Merge(mergedList, existsComponents, new ArrayList<ComponentBaseInfoBO>());
        Set collect = mergedList.stream().map(e -> e.getType().toString() + "#" + e.getCode()).collect(Collectors.toSet());
        for (ComponentBO componentBO : newComponentBO) {
            if (collect.contains(componentBO.getType().toString() + "#" + componentBO.getCode()) || this.existsInOtherParadigm(existsParadigmAppComponent, paradigmCode, componentBO.getType().toString() + "#" + componentBO.getCode())) continue;
            result.add(componentBO);
        }
        return result;
    }

    private boolean existsInOtherParadigm(Map<String, Set<String>> existsParadigmAppComponent, String paradigmCode, String key) {
        if (existsParadigmAppComponent == null) {
            return false;
        }
        Set<Map.Entry<String, Set<String>>> entries = existsParadigmAppComponent.entrySet();
        for (Map.Entry<String, Set<String>> entry : entries) {
            Set<String> value;
            if (StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)paradigmCode) || !(value = entry.getValue()).contains(key)) continue;
            return true;
        }
        return false;
    }

    public Map<String, List<String>> getTenantParadigm(MechanismTenantParadigm mechanismTenantParadigm, String version, String tenantId) {
        if (CollectionUtils.isNotEmpty(mechanismTenantParadigm.getValue())) {
            List<ComponentStructuredList> mechanismComponentStructuredList = null;
            try {
                mechanismComponentStructuredList = this.findMechanismComponentStructuredList(mechanismTenantParadigm.getValue(), version, tenantId);
            }
            catch (DWBusinessException e2) {
                log.error(e2.getMessage(), (Throwable)e2);
            }
            if (mechanismComponentStructuredList == null || mechanismComponentStructuredList.isEmpty()) {
                return null;
            }
            Map<String, List<String>> collect = mechanismComponentStructuredList.stream().collect(Collectors.toMap(ComponentStructuredList::getParadigm, p -> {
                ArrayList<String> list = new ArrayList<String>();
                list.add(p.getMechanismCode());
                return list;
            }, (list1, list2) -> {
                list1.addAll(list2);
                return list1;
            }));
            return collect;
        }
        List<String> paradigms = mechanismTenantParadigm.getParadigms();
        if (CollectionUtils.isEmpty(paradigms)) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        paradigms.forEach(e -> result.put((String)e, new ArrayList()));
        return result;
    }

    public List<ComponentBO> filterComponentByType(List<ComponentStructuredList> componentStructuredList, List<ComponentTypeEnum> mechanismArrayList, String theoryCode) {
        ArrayList<ComponentBO> list = new ArrayList<ComponentBO>();
        for (ComponentStructuredList structuredList : componentStructuredList) {
            List<StructuredComponentBO> components = structuredList.getComponents();
            List<StructuredComponentBO> collect = components.stream().filter(v -> v.getType().equals((Object)ComponentTypeEnum.MechanismPrinciple) && v.getCode().equals(theoryCode)).collect(Collectors.toList());
            this.recursion(collect, mechanismArrayList, list);
        }
        return list;
    }

    private void recursion(List<StructuredComponentBO> components, List<ComponentTypeEnum> mechanismArrayList, ArrayList<ComponentBO> list) {
        if (CollectionUtils.isNotEmpty(components)) {
            for (StructuredComponentBO component : components) {
                if (mechanismArrayList.contains(component.getType())) {
                    list.add((ComponentBO)component);
                }
                if (!CollectionUtils.isNotEmpty((Collection)component.getSubComponents())) continue;
                this.recursion(component.getSubComponents(), mechanismArrayList, list);
            }
        }
    }
}

