/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.configuration;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=0)
public class KgCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(KgCacheAspect.class);
    @Resource
    KgInnerService kgInnerService;

    @Around(value="@annotation(com.digiwin.athena.kmservice.cache.old.Cache)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        ServletRequestAttributes requestAttributes;
        Map profile = DWServiceContext.getContext().getProfile();
        Signature sig = point.getSignature();
        MethodSignature msig = (MethodSignature)sig;
        Method method = msig.getMethod();
        Cache annotation = method.getAnnotation(Cache.class);
        if (annotation.tenant() && (requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()) != null) {
            HttpServletRequest request = requestAttributes.getRequest();
            String tenantId = profile.getOrDefault("tenantId", "");
            request.setAttribute("tenantId", (Object)tenantId);
        }
        Object exResult = point.proceed();
        return exResult;
    }
}

