/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.configuration;

import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.http.client.DWHttpClientProperties;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateConfiguration
implements SmartInitializingSingleton {
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner httpRoutePlanner;
    @Autowired(required=false)
    @Qualifier(value="dw-httpclient-request-retry-handler")
    HttpRequestRetryHandler requestRetryHandler;
    @Autowired(required=false)
    @Qualifier(value="dw-httpclient-response-retry-strategy")
    ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy;
    HttpClient httpClient;

    public RestTemplate initRT(boolean routePlanner, boolean retry) {
        DWEAIProperties dweaiProperties = new DWEAIProperties();
        dweaiProperties.setRestfulServiceBasePath("");
        DWEAIProperties.setProperties((DWEAIProperties)dweaiProperties);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (routePlanner && null != this.httpRoutePlanner) {
            httpClientBuilder.setRoutePlanner(this.httpRoutePlanner);
        }
        if (retry && null != this.requestRetryHandler) {
            httpClientBuilder.setRetryHandler(this.requestRetryHandler);
        }
        if (retry && null != this.serviceUnavailableRetryStrategy) {
            httpClientBuilder.setServiceUnavailableRetryStrategy(this.serviceUnavailableRetryStrategy);
        }
        PoolingHttpClientConnectionManager connectionManager = this.getConnectionManager();
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(100);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        this.httpClient = httpClientBuilder.setConnectionManagerShared(true).build();
        return new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(this.httpClient));
    }

    public RestTemplate initTagSystem(boolean routePlanner, boolean retry) {
        DWEAIProperties dweaiProperties = new DWEAIProperties();
        dweaiProperties.setRestfulServiceBasePath("");
        DWEAIProperties.setProperties((DWEAIProperties)dweaiProperties);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (routePlanner && null != this.httpRoutePlanner) {
            httpClientBuilder.setRoutePlanner(this.httpRoutePlanner);
        }
        if (retry && null != this.requestRetryHandler) {
            httpClientBuilder.setRetryHandler(this.requestRetryHandler);
        }
        if (retry && null != this.serviceUnavailableRetryStrategy) {
            httpClientBuilder.setServiceUnavailableRetryStrategy(this.serviceUnavailableRetryStrategy);
        }
        PoolingHttpClientConnectionManager connectionManager = this.getConnectionManager();
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(100);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        this.httpClient = httpClientBuilder.setConnectionManagerShared(true).build();
        return new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(this.httpClient));
    }

    public RestTemplate initSD(boolean routePlanner, boolean retry) {
        DWEAIProperties dweaiProperties = new DWEAIProperties();
        dweaiProperties.setRestfulServiceBasePath("");
        DWEAIProperties.setProperties((DWEAIProperties)dweaiProperties);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (routePlanner && null != this.httpRoutePlanner) {
            httpClientBuilder.setRoutePlanner(this.httpRoutePlanner);
        }
        if (retry && null != this.requestRetryHandler) {
            httpClientBuilder.setRetryHandler(this.requestRetryHandler);
        }
        if (retry && null != this.serviceUnavailableRetryStrategy) {
            httpClientBuilder.setServiceUnavailableRetryStrategy(this.serviceUnavailableRetryStrategy);
        }
        PoolingHttpClientConnectionManager connectionManager = this.getConnectionManager();
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(100);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        this.httpClient = httpClientBuilder.build();
        return new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(this.httpClient));
    }

    @Bean(name={"mdcRestTemplate"})
    public RestTemplate mdcRestTemplate() {
        return this.initRT(true, true);
    }

    @Bean(name={"routeRestTemplate"})
    public RestTemplate routeRestTemplate() {
        return this.initRT(true, true);
    }

    @Bean(name={"restTemplate"})
    public RestTemplate restTemplate() {
        return this.initRT(true, true);
    }

    @Bean(name={"iamRestTemplate"})
    public RestTemplate iamRestTemplate() {
        return this.initRT(false, true);
    }

    @Bean(name={"cacRestTemplate"})
    public RestTemplate cacRestTemplate() {
        return this.initRT(false, true);
    }

    @Bean(name={"eocRestTemplate"})
    public RestTemplate eocRestTemplate() {
        return this.initRT(false, true);
    }

    @Bean(name={"dmcRestTemplate"})
    public RestTemplate dmcRestTemplate() {
        return this.initRT(false, true);
    }

    @Bean(name={"gmcRestTemplate"})
    public RestTemplate gmcRestTemplate() {
        return this.initRT(false, true);
    }

    @Bean(name={"aimRestTemplate"})
    public RestTemplate aimRestTemplate() {
        return this.initRT(true, true);
    }

    @Bean(name={"dataFootprintTemplate"})
    public RestTemplate dataFootprintTemplate() {
        return this.initRT(true, true);
    }

    @Bean(name={"sdRestTemplate"})
    public RestTemplate sdRestTemplate() {
        return this.initSD(true, true);
    }

    @Bean(name={"tagSystemRestTemplate"})
    public RestTemplate tagSystemRestTemplate() {
        return this.initTagSystem(true, true);
    }

    public void afterSingletonsInstantiated() {
        List beanList = JaSpringBeanUtil.getBeanList(RestTemplate.class);
        if (JaCollectionUtil.isNotEmpty((Collection)beanList)) {
            beanList.forEach(restTemplate -> ((RestTemplate)JaSpringAopUtil.getSingletonTarget((Object)restTemplate)).getInterceptors().add(0, new AttachAppInfoInterceptor()));
        }
    }

    @Bean(value={"httpClientConnectionManager"})
    public PoolingHttpClientConnectionManager getConnectionManager() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        return new PoolingHttpClientConnectionManager(registry);
    }

    public static class AttachAppInfoInterceptor
    implements ClientHttpRequestInterceptor {
        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            AttachAppInfoInterceptor.attachAppAuthInfo(request.getURI().getHost(), request);
            return execution.execute(request, body);
        }

        public static void attachAppAuthInfo(String host, HttpRequest request) {
            String apToken;
            HttpHeaders httpHeaders = request.getHeaders();
            if (!httpHeaders.containsKey((Object)"digi-middleware-auth-app") && (apToken = DWHttpClientProperties.getProperties().getIamApToken()) != null && !apToken.isEmpty()) {
                httpHeaders.add("digi-middleware-auth-app", apToken);
            }
        }
    }
}

