/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.data;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.stereotype.Component;

@Component
public class MongoDBManager
implements InitializingBean {
    private static String connectString = "mongodb://localhost:27017";
    private static String dbName = "tenant_config";
    private static MongoDBManager mongoDBManager = new MongoDBManager();
    @Autowired
    private MongoDbFactory mongoDbFactory;
    private MongoDatabase database = null;

    public static MongoDBManager getMongoDBManager() {
        return mongoDBManager;
    }

    private MongoDBManager() {
    }

    public MongoDatabase getDatabase() {
        return this.database;
    }

    public MongoCollection<Document> getCollection(String colName, String keyName) {
        MongoCollection col = this.database.getCollection(colName);
        boolean keyExisted = false;
        for (Document index : col.listIndexes()) {
            if (!keyName.equals(index.get((Object)"name"))) continue;
            keyExisted = true;
            break;
        }
        if (!keyExisted) {
            IndexOptions indexOptions = new IndexOptions().name(keyName).unique(false).background(true);
            col.createIndex(Indexes.ascending((String[])new String[]{keyName}), indexOptions);
        }
        return col;
    }

    public MongoCollection<Document> getCollectionWithKeys(String colName, String indexName, String ... keyName) throws DWBusinessException {
        if (indexName == null || indexName.isEmpty() || keyName.length == 0) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.needKey", new Object[0]));
        }
        MongoCollection col = this.database.getCollection(colName);
        boolean indexExisted = false;
        for (Document index : col.listIndexes()) {
            if (!indexName.equals(index.get((Object)"name"))) continue;
            indexExisted = true;
            break;
        }
        if (!indexExisted) {
            IndexOptions indexOptions = new IndexOptions().name(indexName).unique(false).background(true);
            col.createIndex(Indexes.ascending((String[])keyName), indexOptions);
        }
        return col;
    }

    public void afterPropertiesSet() throws Exception {
        mongoDBManager = this;
        this.database = this.mongoDbFactory.getDb(KnowledgeGraphDb.SYSTEM.getValue());
    }
}

