/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismCapacityParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MechanismBuilderService {
    @Autowired
    private List<MechanismCapacityParser> capacityParsers;

    public MechanismLogic build(MechanismParseContext context) throws DWBusinessException {
        MechanismCapacity capacity = context.getCapacity();
        MechanismLogic mechanismLogic = new MechanismLogic();
        mechanismLogic.setTenantId(context.getTenantId());
        mechanismLogic.setVersion(context.getTenantVersion());
        mechanismLogic.setApplication(capacity.getApplication());
        mechanismLogic.setCode(capacity.getCode());
        mechanismLogic.setName(capacity.getName());
        mechanismLogic.setDescription(capacity.getDescription());
        mechanismLogic.setLang(capacity.getLang());
        mechanismLogic.setType(capacity.getType());
        mechanismLogic.setCreatedByDevPlatform(capacity.isCreatedByDevPlatform());
        this.parseCapacity(context, capacity);
        MechanismAbility logic = context.getLogic();
        if (logic instanceof DriveAbilityBo) {
            mechanismLogic.setType(ComponentTypeEnum.MechanismDrive.name());
        }
        mechanismLogic.setLogic((Object)logic);
        return mechanismLogic;
    }

    public void parseCapacity(MechanismParseContext context, MechanismCapacity capacity) throws DWBusinessException {
        for (MechanismCapacityParser parser : this.capacityParsers) {
            if (!parser.accept(capacity)) continue;
            parser.parse(context, capacity);
            if (!"SYSTEM".equals(capacity.getFrom())) {
                parser.generateCypher(context, capacity, null);
            }
            return;
        }
        throw new DWBusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MechanismCapacityParser by:" + capacity);
    }

    @Deprecated
    public String geneCypherRoot(MechanismParseContext context, MechanismCapacity capacity) {
        String rootNodeId = "MechanismCapacity_" + capacity.getCode();
        context.getCypherSb().append("create(").append(rootNodeId).append(":MechanismCapacity:MechanismComponent{").append("code").append(":'").append(capacity.getCode()).append("',").append("name").append(":'").append(capacity.getName()).append("',").append("type").append(":'").append(capacity.getType()).append("',").append("description").append(":'").append(capacity.getDescription()).append("',").append("mechanismTheoryCode").append(":'").append(capacity.getMechanismCode()).append("',").append("mechanismCode01").append(":'").append(capacity.getMechanismCode()).append("',").append("status").append(":").append(capacity.getStatus()).append(",").append("pluginId").append(":'").append(context.getPluginId()).append("'").append("})\r\n");
        return rootNodeId;
    }
}

