/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.common.MechanismPlanType;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.LimitTaskActionPart;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.Widget;
import com.digiwin.athena.mechanism.widgets.action.AutoProcess;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.plan.AutoProcessPlan;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AutoProcessParser
extends AbstractMechanismPartParser {
    private static final Logger log = LoggerFactory.getLogger(AutoProcessParser.class);

    @Override
    public boolean accept(MechanismPart part) {
        return "autoProcess".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart)part;
        AutoProcess autoProcess = limitTaskActionPart.getAutoProcess();
        LimitAbilityBo logic = (LimitAbilityBo)context.getLogic();
        for (SingleStrategyWidget strategy : logic.getStrategies()) {
            strategy.setCode(autoProcess.getCode());
            strategy.setActionHookType(MechanismEnum.ComponentType.ASSIGNMENT.getCode());
            AutoProcessPlan positiveTarget = (AutoProcessPlan)JSON.parseObject((String)JSON.toJSONString((Object)strategy.getPositiveTarget()), AutoProcessPlan.class);
            positiveTarget.setType(MechanismPlanType.autoProcessPlan.name());
            positiveTarget.setActionType(MechanismEnum.LimitActionType.AUTO_PROCESS.getCode());
            positiveTarget.setParams((List)context.getNamedParams().get("fields"));
            positiveTarget.setParentParameter(autoProcess.getParentParameter());
            positiveTarget.setSubParameter(autoProcess.getSubParameter());
            strategy.setPositiveTarget((PlanWidget)positiveTarget);
        }
        limitTaskActionPart.setStrategies(logic.getStrategies());
        if (null != logic) {
            logic.setAutoProcess(autoProcess);
        }
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        LimitTaskActionPart limitTaskActionPart = (LimitTaskActionPart)part;
        List strategies = limitTaskActionPart.getStrategies();
        for (SingleStrategyWidget strategy : strategies) {
            super.generateCypherSimple(context, (Widget)strategy, parentNode);
        }
    }
}

