/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.kg.monitorRule.DynamicParam;
import com.digiwin.athena.kg.monitorRule.MonitorRule;
import com.digiwin.athena.knowledgegraph.enums.MechanismParameterTypeEnum;
import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskOnTimeOverPart;
import com.digiwin.athena.mechanism.pre.parts.SourceSchedulePart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.check.CheckCompleteParam;
import com.digiwin.athena.mechanism.widgets.condition.ByTimeCondition;
import com.digiwin.athena.mechanism.widgets.condition.OnTimeCheckRange;
import com.digiwin.athena.mechanism.widgets.condition.OnTimeCheckType;
import com.digiwin.athena.mechanism.widgets.condition.OnTimeCheckUnit;
import com.digiwin.athena.mechanism.widgets.source.ScheduleSourceWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckTaskOnTimeOverParser
extends AbstractMechanismPartParser {
    @Autowired
    private DataMapService dataMapService;

    @Override
    public boolean accept(MechanismPart part) {
        return "checkTaskOnTimeOver".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) throws DWBusinessException {
        String checkJob;
        CheckTaskOnTimeOverPart checkPart = (CheckTaskOnTimeOverPart)part;
        if (null == checkPart.getCheckComplete() || checkPart.getCheckComplete().getCheckDay() == null && checkPart.getCheckComplete().getCheckVariableCode() == null) {
            throw new DWBusinessException("checkDay is requird by CheckTaskOnTimeOverPart");
        }
        DriveAbilityBo logic = (DriveAbilityBo)context.getLogic();
        ScheduleSourceWidget checkSource = (ScheduleSourceWidget)logic.getCheckSource();
        MonitorRule rule = checkSource.getMonitorRule();
        if (null == rule.getStaticParams()) {
            rule.setStaticParams(new ArrayList());
        }
        if (null == logic.getPreActivities()) {
            logic.setPreActivities(new ArrayList());
        }
        if (null == (checkJob = checkPart.getCheckComplete().getCheckJob())) {
            throw new DWBusinessException("checkJob is required by CheckTaskOnTimeOverPart");
        }
        if ("taskOver".equalsIgnoreCase(checkJob)) {
            this.handleForTimePoint(context, checkPart, rule, logic);
        } else if ("taskReport".equalsIgnoreCase(checkJob)) {
            rule.setMonitorActionId("mechanism_CheckTaskReportAction");
            SourceWidget targetSource = context.getTargetSource();
            DynamicParam param1 = new DynamicParam();
            param1.setParam_name("workCode");
            param1.setParam_value(targetSource.getTarget());
            rule.getStaticParams().add(param1);
            DynamicParam param2 = new DynamicParam();
            param2.setParam_name("workType");
            param2.setParam_value("TASK");
            rule.getStaticParams().add(param2);
            String dy1 = "[{\"param_name\":\"startTime\",\"param_target\":\"MONITOR_ACTION\",\"param_type\":\"DATE_TIME\",\"rule\":{\"add_day\":\"0\",\"day\":\"0\",\"period\":\"DAY\",\"range\":\"0\",\"time_type\":\"START\"},\"source_name\":\"monitor_time\"},{\"param_name\":\"endTime\",\"param_target\":\"MONITOR_ACTION\",\"param_type\":\"DATE_TIME\",\"rule\":{\"add_day\":\"0\",\"day\":\"0\",\"period\":\"DAY\",\"range\":\"0\",\"time_type\":\"END\"},\"source_name\":\"monitor_time\"}]";
            rule.setDynamicParamsDto(dy1);
            ActivityWidget activityWidget0 = new ActivityWidget();
            activityWidget0.setType("http");
            activityWidget0.setConfig(new HashMap());
            activityWidget0.getConfig().put("executionMode", "script");
            activityWidget0.getConfig().put("method", "post");
            activityWidget0.getConfig().put("domain", "taskengine");
            activityWidget0.getConfig().put("contentType", "json");
            activityWidget0.getConfig().put("url", "/restful/standard/ptm/v2/api/backlog/list/by-condition");
            HashMap<String, String> scriptMode0 = new HashMap<String, String>();
            String requestScript0 = "var request = {\"taskDefCode\":\"#taskDefCode#\",\"closed\":false}; return request;";
            requestScript0 = requestScript0.replaceAll("#taskDefCode#", targetSource.getTarget());
            scriptMode0.put("requestScript", requestScript0);
            String responseScript0 = "var response = $(response);var datas = response.response.data; var userIds = [];var cards = [];for(var idx in datas){    var item = datas[idx];    try{        if(userIds.indexOf(item.performerId)==-1){            userIds.push(item.performerId);cards.push(item)         }     }catch (e){}}return {\"success\":true,\"processVariable\":{\"userIds\":userIds,\"cards\":cards}}";
            scriptMode0.put("responseScript", responseScript0);
            activityWidget0.getConfig().put("scriptMode", scriptMode0);
            activityWidget0.setName("\u83b7\u53d6\u4efb\u52a1\u5f85\u529e\u4eba\u5458\u5217\u8868");
            logic.getPreActivities().add(activityWidget0);
            checkPart.setActivityWidget0(activityWidget0);
            ActivityWidget activityWidget1 = new ActivityWidget();
            activityWidget1.setType("script");
            activityWidget1.setConfig(new HashMap());
            activityWidget1.getConfig().put("executionMode", "script");
            HashMap<String, String> scriptMode = new HashMap<String, String>();
            scriptMode.put("requestScript", "");
            String responseScript = "var userIds1 = $(userIds);var cards = $(cards);var datas = $(data)[0].datas;var userIds2 = [];var list1 = [];var list2=[];for(var idx in datas){    try{        var item = datas[idx];        if(userIds2.indexOf(item.userId)==-1){            userIds2.push(item.userId);        }    }catch (e){ }} for(var idx1 in userIds1){    var userid1 = userIds1[idx1];    if(userIds2.indexOf(userid1)==-1){        list1.push(userid1);    }} for(var idx2 in cards){var card = cards[idx2];if(list1.indexOf(card.performerId)!=-1){list2.push(card);}} return {    processVariable:{        list1:list1,list:list2    }}";
            scriptMode.put("responseScript", responseScript);
            activityWidget1.getConfig().put("scriptMode", scriptMode);
            activityWidget1.setName("\u5bfb\u627e\u4e0d\u5728\u57cb\u70b9\u6570\u636e\u4e2d\u7684\u7528\u6237");
            logic.getPreActivities().add(activityWidget1);
            checkPart.setActivityWidget1(activityWidget1);
            context.getNamedParams().put("im_userId", "$(list)[*].personInCharge");
            context.getNamedParams().put("im_performerId", "$(performerId)");
        }
    }

    private void handleForTimePoint(MechanismParseContext context, CheckTaskOnTimeOverPart checkPart, MonitorRule rule, DriveAbilityBo logic) {
        if (!"METADATA".equals(checkPart.getCheckComplete().getBusinessFieldSource())) {
            CheckTaskOnTimeOverParser.setMonitorRule(context, rule);
            CheckTaskOnTimeOverParser.setActivityWidget0(checkPart, logic);
            context.getNamedParams().put("im_userId", "$(list)[*].personInCharge");
            context.getNamedParams().put("im_performerId", "$(performerId)");
        } else {
            CheckTaskOnTimeOverParser.createActivityForGetDataFromEspApi(checkPart, logic);
            CheckTaskOnTimeOverParser.createActivityForFilterData(checkPart, logic);
            this.tagLightDetection(context, logic);
        }
    }

    private void tagLightDetection(MechanismParseContext context, DriveAbilityBo logic) {
        Task task = new Task();
        task.setCode(context.getTargetSource().getTarget());
        task.setNeedScheduledTaskDetail(Boolean.TRUE);
        task.setVersion(context.getTenantVersion());
        this.dataMapService.updateTaskScheduleFlag(task);
        logic.setNeedLightDetection(Boolean.TRUE);
        logic.setProjectCode(UUID.randomUUID().toString().trim().replaceAll("-", ""));
    }

    private static void createActivityForGetDataFromEspApi(CheckTaskOnTimeOverPart checkPart, DriveAbilityBo logic) {
        ActivityWidget activityWidget = new ActivityWidget();
        activityWidget.setType("http");
        activityWidget.setConfig(new HashMap());
        activityWidget.getConfig().put("executionMode", "script");
        activityWidget.getConfig().put("method", "post");
        activityWidget.getConfig().put("domain", "thememap");
        activityWidget.getConfig().put("contentType", "json");
        activityWidget.getConfig().put("url", "/restful/service/knowledgegraph/mechanismEnhancement/InvokeEspApi");
        String kgRequestScript = "var request = { \"espApi\": \"$(espApi)\", \"requestParams\": $(espReq)}; return request;";
        String kgResponseScript = "var data = $(response); var processData = data['response']['" + checkPart.getCheckComplete().getFullPath() + "']; return {processVariable: { dataList: processData} }";
        HashMap<String, String> scriptMode2 = new HashMap<String, String>();
        scriptMode2.put("requestScript", kgRequestScript);
        scriptMode2.put("responseScript", kgResponseScript);
        activityWidget.getConfig().put("scriptMode", scriptMode2);
        activityWidget.setName("\u8c03\u7528espApi\u83b7\u53d6\u6570\u636e");
        logic.getPreActivities().add(activityWidget);
        checkPart.setActivityWidget0(activityWidget);
    }

    private static void createActivityForFilterData(CheckTaskOnTimeOverPart checkPart, DriveAbilityBo logic) {
        ActivityWidget activityWidget = new ActivityWidget();
        activityWidget.setType("http");
        activityWidget.setConfig(new HashMap());
        activityWidget.getConfig().put("executionMode", "script");
        activityWidget.getConfig().put("method", "post");
        activityWidget.getConfig().put("domain", "thememap");
        activityWidget.getConfig().put("contentType", "json");
        activityWidget.getConfig().put("url", "/restful/service/knowledgegraph/mechanismEnhancement/FilterByTimeCondition");
        String kgRequestScript = "var request = { \"dataList\": $(dataList), \"businessCondition\": #businessCondition#, \"byTimeCondition\": #byTimeCondition#}; return request;";
        String businessConditionStr = JSON.toJSONString((Object)checkPart.getCheckComplete().getBusinessCondition());
        kgRequestScript = kgRequestScript.replace("#businessCondition#", businessConditionStr);
        ByTimeCondition byTimeCondition = new ByTimeCondition();
        byTimeCondition.setCheckField(checkPart.getCheckComplete().getCheckField());
        byTimeCondition.setCheckRange(OnTimeCheckRange.valueOf((String)checkPart.getCheckComplete().getCheckRange().toUpperCase()));
        byTimeCondition.setCheckNumber(OnTimeCheckType.MECHANISM_PARAMETER.name().equalsIgnoreCase(checkPart.getCheckComplete().getCheckDayType()) || StringUtil.isEmpty((CharSequence)checkPart.getCheckComplete().getCheckDay()) ? 0 : Integer.parseInt(checkPart.getCheckComplete().getCheckDay()));
        byTimeCondition.setCheckUnit(OnTimeCheckUnit.valueOf((String)checkPart.getCheckComplete().getCheckUnit().toUpperCase()));
        byTimeCondition.setCheckType(OnTimeCheckType.valueOf((String)checkPart.getCheckComplete().getCheckDayType().toUpperCase()));
        byTimeCondition.setCheckVariableCode(checkPart.getCheckComplete().getCheckVariableCode());
        kgRequestScript = kgRequestScript.replace("#byTimeCondition#", JSON.toJSONString((Object)byTimeCondition));
        String kgResponseScript = "var data = $(response); var processData = data['response']; return {processVariable: { taskBizData: processData, list : processData} }";
        HashMap<String, String> scriptMode2 = new HashMap<String, String>();
        scriptMode2.put("requestScript", kgRequestScript);
        scriptMode2.put("responseScript", kgResponseScript);
        activityWidget.getConfig().put("scriptMode", scriptMode2);
        activityWidget.setName("\u8fd4\u56de\u5305\u542b\u4e1a\u52a1\u6570\u636e\u7684\u4efb\u52a1");
        logic.getPreActivities().add(activityWidget);
        checkPart.setActivityWidget1(activityWidget);
    }

    private static void setActivityWidget0(CheckTaskOnTimeOverPart checkPart, DriveAbilityBo logic) {
        ActivityWidget activityWidget1 = new ActivityWidget();
        activityWidget1.setType("script");
        activityWidget1.setConfig(new HashMap());
        activityWidget1.getConfig().put("executionMode", "script");
        HashMap<String, String> scriptMode = new HashMap<String, String>();
        scriptMode.put("requestScript", "");
        String timePoint = Optional.ofNullable(checkPart.getCheckComplete().getCheckField()).orElse("planEndTime");
        String unit = checkPart.getCheckComplete().getCheckUnit();
        int factor = 1;
        if (null != unit) {
            if ("week".equalsIgnoreCase(unit)) {
                factor = 604800;
            } else if ("month".equalsIgnoreCase(unit)) {
                factor = 2592000;
            } else if ("hour".equalsIgnoreCase(unit)) {
                factor = 3600;
            } else if ("day".equalsIgnoreCase(unit)) {
                factor = 86400;
            } else if ("minute".equalsIgnoreCase(unit)) {
                factor = 60;
            }
        }
        String responseScript = "var day = #checkDay# * " + factor + ";var data = $(data)[0].data;var timeNow = new Date().getTime();var dayTime=day * 1000;var list = [];for(var idx in data){   try {       var item = data[idx];       var timeItem = Date.parse(item." + timePoint + ");       if(#checkCondition#) {           list.push(item);       }   } catch (e) {       console.log(e)   }} return {   processVariable: {       list: list   }}";
        if (MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue().equals(checkPart.getCheckComplete().getCheckDayType())) {
            String checkRange = checkPart.getCheckComplete().getCheckRange();
            String checkCondition = "before".equals(checkRange) ? "timeItem - timeNow > dayTime" : "timeNow - timeItem > dayTime";
            responseScript = responseScript.replaceAll("#checkDay#", "#" + checkPart.getCheckComplete().getCheckVariableCode() + "#").replaceAll("#checkCondition#", checkCondition);
        } else {
            long checkDay;
            String checkDayStr = checkPart.getCheckComplete().getCheckDay();
            try {
                checkDay = Long.parseLong(checkDayStr);
            }
            catch (NumberFormatException e) {
                checkDay = 99999999L;
            }
            String checkCondition = checkDay < 0L ? "timeItem - timeNow > Math.abs(dayTime)" : "timeNow - timeItem > dayTime";
            responseScript = responseScript.replaceAll("#checkDay#", checkDay + "").replaceAll("#checkCondition#", checkCondition);
        }
        scriptMode.put("responseScript", responseScript);
        activityWidget1.getConfig().put("scriptMode", scriptMode);
        activityWidget1.setName("\u8fc7\u6ee4\u4e0d\u5408\u9002\u7684\u4efb\u52a1");
        logic.getPreActivities().add(activityWidget1);
        checkPart.setActivityWidget0(activityWidget1);
    }

    private static void setMonitorRule(MechanismParseContext context, MonitorRule rule) {
        rule.setMonitorActionId("mechanism_CheckTaskOnTimeOverAction");
        SourceWidget targetSource = context.getTargetSource();
        DynamicParam param1 = new DynamicParam();
        param1.setParam_name("taskDefCode");
        param1.setParam_value(targetSource.getTarget());
        rule.getStaticParams().add(param1);
        DynamicParam param2 = new DynamicParam();
        param2.setParam_name("closed");
        param2.setParam_value("false");
        rule.getStaticParams().add(param2);
    }

    private JSONObject getTaskName(MechanismParseContext context) {
        JSONObject nameLang = new JSONObject();
        nameLang.put("zh_CN", (Object)"");
        nameLang.put("zh_TW", (Object)"");
        SourceSchedulePart sourceSchedulePart = (SourceSchedulePart)context.getCapacity().getSource();
        String taskCode = sourceSchedulePart.getTargetSource().getTarget();
        Object response = this.dataMapService.getTaskName(taskCode);
        if (response != null) {
            JSONObject task = JSONObject.parseObject((String)JSON.toJSONString((Object)response));
            JSONObject lang = task.getJSONObject("lang");
            if (lang != null && lang.containsKey((Object)"name")) {
                return lang.getJSONObject("name");
            }
            nameLang.put("zh_CN", (Object)task.getString("name"));
        }
        return nameLang;
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        CheckTaskOnTimeOverPart checkPart = (CheckTaskOnTimeOverPart)part;
        CheckCompleteParam widget = checkPart.getCheckComplete();
        ActivityWidget activityWidget0 = checkPart.getActivityWidget0();
        ActivityWidget activityWidget1 = checkPart.getActivityWidget1();
        if (null != activityWidget0) {
            super.generateCypherActivity(context, activityWidget0, parentNode);
        }
        if (null != activityWidget1) {
            super.generateCypherActivity(context, activityWidget1, parentNode);
        }
    }

    public static void main(String[] args) {
        String str = " [            {                \"source_name\": \"monitor_time\",                \"rule\": {                    \"period\": \"DAY\",                    \"range\": \"0\",                    \"day\": \"0\",                    \"add_day\": \"0\",                    \"time_type\": \"START\"                },                \"param_name\": \"startTime\",                \"param_type\": \"DATE_TIME\",                \"param_target\": \"MONITOR_ACTION\"            },            {                \"source_name\": \"monitor_time\",                \"rule\": {                    \"period\": \"DAY\",                    \"range\": \"0\",                    \"day\": \"0\",                    \"add_day\": \"0\",                    \"time_type\": \"END\"                },                \"param_name\": \"endTime\",                \"param_type\": \"DATE_TIME\",                \"param_target\": \"MONITOR_ACTION\"            }        ]";
        List dynamicParams = JSON.parseArray((String)str, DynamicParam.class);
        System.out.println(JSON.toJSONString((Object)dynamicParams));
    }
}

