/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mechanism.partparsers;

import com.digiwin.athena.knowledgegraph.mechanism.AbstractMechanismPartParser;
import com.digiwin.athena.knowledgegraph.mechanism.MechanismParseContext;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.LimitSourceTaskPart;
import com.digiwin.athena.mechanism.widgets.SourceWidget;
import com.digiwin.athena.mechanism.widgets.Widget;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LimitSourceTaskParser
extends AbstractMechanismPartParser {
    @Override
    public boolean accept(MechanismPart part) {
        return "sourceTaskInExecution".equals(part.getCode());
    }

    @Override
    public void parse(MechanismParseContext context, MechanismPart part) {
        LimitSourceTaskPart limitSourceTaskPart = (LimitSourceTaskPart)part;
        SourceWidget targetSource = limitSourceTaskPart.getTargetSource();
        if (!CollectionUtils.isEmpty((Collection)limitSourceTaskPart.getFields())) {
            targetSource.setWatchFields(limitSourceTaskPart.getFields().stream().map(v -> v.getData_name()).collect(Collectors.toList()));
        }
        context.getNamedParams().put("fields", limitSourceTaskPart.getFields());
        context.setTargetSource(targetSource);
        LimitAbilityBo logic = new LimitAbilityBo();
        logic.setCheckSource(targetSource);
        context.setLogic((MechanismAbility)logic);
    }

    @Override
    public void generateCypher(MechanismParseContext context, MechanismPart part, String parentNode) {
        LimitSourceTaskPart sourcePart = (LimitSourceTaskPart)part;
        SourceWidget targetSource = sourcePart.getTargetSource();
        super.generateCypherSimple(context, (Widget)targetSource, parentNode);
    }
}

