/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.knowledgegraph.domain.tenant.TenantInitRouterKey;
import com.digiwin.athena.knowledgegraph.service.KgService;
import com.digiwin.athena.knowledgegraph.service.RedisLock;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.rabbitmq.client.Channel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnProperty(value={"rabbitMQEnabled"})
public class MQListenerService {
    private static final Logger log = LoggerFactory.getLogger(MQListenerService.class);
    public static final String kgMdcMessageListenerLockName = "knowledgegraph:mdc:messageListenerLockName_";
    @Autowired
    SessionFactory sessionFactory;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactoryDomain1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactoryDomain2;
    @Autowired
    ActionRepository actionRepository;
    @Autowired
    RedisLock redisLock;
    @Autowired
    KgService kgService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    private static final String SERVICE_NAME = "Action/AddMdcApiMetadataToNeo4j";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RabbitListener(containerFactory="mdcMessageListenerContainer", queues={"mdc_api_metadata_to_km"})
    public void mdcMetadataListener(Message message, Channel channel) throws Exception {
        block9: {
            block8: {
                String messageStr = new String(message.getBody(), StandardCharsets.UTF_8);
                String kgMdcMessageListenerContainerLock = null;
                String lockName = null;
                try {
                    log.info("receiveMdcApiMetadata:{}", (Object)messageStr);
                    JSONObject jsonObject = JSON.parseObject((String)messageStr);
                    String action = jsonObject.getString("action");
                    String api_name = jsonObject.getString("api_name");
                    String timestamp = jsonObject.getString("timestamp");
                    lockName = kgMdcMessageListenerLockName + api_name;
                    do {
                        kgMdcMessageListenerContainerLock = this.redisLock.tryLock(lockName, 300000L);
                        log.info("{}:{}", (Object)lockName, (Object)kgMdcMessageListenerContainerLock);
                    } while (kgMdcMessageListenerContainerLock == null);
                    if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"add")) {
                        this.addMdcApiMetadataToNeo4j(messageStr);
                    }
                    if (kgMdcMessageListenerContainerLock == null) break block8;
                }
                catch (Exception e) {
                    log.error("MdcApiMetadataError error:{} , message:{} , ", (Object)e, (Object)messageStr);
                    break block9;
                }
                finally {
                    if (kgMdcMessageListenerContainerLock != null) {
                        log.info("\u91ca\u653e\u9501{}\uff1a{}", lockName, kgMdcMessageListenerContainerLock);
                        this.redisLock.unlock(lockName, kgMdcMessageListenerContainerLock);
                    }
                    channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
                }
                log.info("\u91ca\u653e\u9501{}\uff1a{}", (Object)lockName, (Object)kgMdcMessageListenerContainerLock);
                this.redisLock.unlock(lockName, kgMdcMessageListenerContainerLock);
            }
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
        }
    }

    private void deteleMdcApiMetadataToNeo4j(String messageStr) {
        JSONObject jsonObject = JSON.parseObject((String)messageStr);
        String apiName = jsonObject.getString("api_name");
        String actionId = "esp_" + apiName;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("match (espAction:Action{").append("actionId:'").append(actionId).append("'}) detach delete espAction");
        ArrayList<String> executeNeo4jScripts = new ArrayList<String>();
        executeNeo4jScripts.add(stringBuffer.toString());
        this.executeNeo4jScript(executeNeo4jScripts, this.sessionFactoryDomain1);
        this.executeNeo4jScript(executeNeo4jScripts, this.sessionFactoryDomain2);
    }

    public String getTenantInitRouterKey() {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"status").is((Object)1);
        query.addCriteria((CriteriaDefinition)criteria);
        TenantInitRouterKey one = (TenantInitRouterKey)this.mongoTemplate.findOne(query, TenantInitRouterKey.class);
        return one == null ? null : one.getRouterKey();
    }

    public void addMdcApiMetadataToNeo4j(String messageStr) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("messageStr", messageStr);
        this.kgService.requestKg(SERVICE_NAME, "post", param);
        String tenantInitRouterKey = this.getTenantInitRouterKey();
        if (StringUtils.isNotEmpty((CharSequence)tenantInitRouterKey)) {
            this.kgService.requestKg(SERVICE_NAME, "post", param, tenantInitRouterKey);
        }
    }

    private void executeNeo4jScript(List<String> executeNeo4jScripts, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(executeNeo4jScripts)) {
            return;
        }
        if (sessionFactory == null) {
            return;
        }
        Session session = sessionFactory.openSession();
        try (Transaction transaction = session.beginTransaction();){
            for (String str : executeNeo4jScripts) {
                session.query(str, new HashMap());
            }
            transaction.commit();
        }
        session.clear();
    }

    private void putEnumKey(ApiDataFieldMetadataDTO toApiDataFieldMeta, ApiDataFieldMetadataDTO fromApiDataFieldMeta) {
        if (toApiDataFieldMeta.getData_name().equals(fromApiDataFieldMeta.getData_name())) {
            if ("object".equals(toApiDataFieldMeta.getData_type()) && "object".equals(fromApiDataFieldMeta.getData_type())) {
                List toApiSubDataFieldMeta = toApiDataFieldMeta.getField();
                List fromApiSubDataFieldMeta = fromApiDataFieldMeta.getField();
                this.putEnumKey(toApiSubDataFieldMeta, fromApiSubDataFieldMeta);
            } else {
                toApiDataFieldMeta.setEnum_key(fromApiDataFieldMeta.getEnum_key());
            }
        }
    }

    private void putEnumKey(List<ApiDataFieldMetadataDTO> toApiDataFieldMetas, List<ApiDataFieldMetadataDTO> fromApiDataFieldMetas) {
        toApiDataFieldMetas.forEach(toApiDataFieldMetadata -> {
            Optional<ApiDataFieldMetadataDTO> fromApiDataFieldMeta = fromApiDataFieldMetas.stream().filter(fromApiDataFieldMetadata -> fromApiDataFieldMetadata.getData_name().equals(toApiDataFieldMetadata.getData_name())).findFirst();
            if (fromApiDataFieldMeta.isPresent()) {
                this.putEnumKey((ApiDataFieldMetadataDTO)toApiDataFieldMetadata, fromApiDataFieldMeta.get());
            }
        });
    }
}

