/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.rule;

import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.IManageMonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigRemoveDto;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@MyExceptionHandler
@Service
public class ManageMonitorRuleConfigService
implements IManageMonitorRuleConfigService {
    private static final Logger log = LoggerFactory.getLogger(ManageMonitorRuleConfigService.class);
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;

    @Override
    public Object postRemoveMonitorRuleConfig(MonitorRuleConfigRemoveDto monitorRuleConfigRemoveDto) throws Exception {
        log.warn("MonitorRuleConfigNewService.postRemoveMonitorRuleConfig start, param={}", (Object)monitorRuleConfigRemoveDto);
        if (null == monitorRuleConfigRemoveDto || StringUtils.isEmpty((CharSequence)monitorRuleConfigRemoveDto.getTenantId()) || StringUtils.isEmpty((CharSequence)monitorRuleConfigRemoveDto.getCorpId())) {
            log.warn("MonitorRuleConfigNewService.postRemoveMonitorRuleConfig parameter error param={}", (Object)monitorRuleConfigRemoveDto);
            return null;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)monitorRuleConfigRemoveDto.getTenantId()).and("eocMap").exists(true).and("eocMap.eocCompanyId").is((Object)monitorRuleConfigRemoveDto.getCorpId());
        if (StringUtils.isNotEmpty((CharSequence)monitorRuleConfigRemoveDto.getFactoryId())) {
            criteria.and("eocMap.eocSiteId").is((Object)monitorRuleConfigRemoveDto.getFactoryId());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        List monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        if (CollectionUtils.isNotEmpty((Collection)monitorRuleTenantConfigs)) {
            for (MonitorRuleTenantConfig config : monitorRuleTenantConfigs) {
                MonitorRuleConfigDTO configDTO = this.transToMonitorRuleConfigDTO(config);
                if (null == configDTO) continue;
                this.monitorRuleConfigService.delete(configDTO);
            }
        }
        return null;
    }

    private MonitorRuleConfigDTO transToMonitorRuleConfigDTO(MonitorRuleTenantConfig config) {
        if (null == config) {
            return null;
        }
        MonitorRuleConfigDTO configDTO = new MonitorRuleConfigDTO();
        configDTO.setTenantId(config.getTenantId());
        configDTO.setMonitorRuleId(config.getMonitorRuleId());
        configDTO.setEocMap(config.getEocMap());
        return configDTO;
    }
}

