/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.rule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kg.domain.OperationUnitV2;
import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kg.monitorRule.MonitorVO;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.kg.monitorRule.product.ActionParamConfigDO;
import com.digiwin.athena.kg.monitorRule.product.DefaultParamConfigDO;
import com.digiwin.athena.kg.monitorRule.product.FieldMappingConfigDO;
import com.digiwin.athena.kg.monitorRule.product.MonitorRuleProductConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionTypeEnum;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.IntoDynamicConditionDO;
import com.digiwin.athena.kg.monitorRule.tenant.MonitorRuleTenantConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.StaticParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.TenantDynamicConditionDO;
import com.digiwin.athena.kg.report.hz.model.sence.RuleSceneDTO;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.data.MongoDBManager;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.product.dao.ProductTenantConfigDAO;
import com.digiwin.athena.knowledgegraph.rule.AbstractMonitorRuleCategoryService;
import com.digiwin.athena.knowledgegraph.rule.dao.MonitorRuleProductConfigDAO;
import com.digiwin.athena.knowledgegraph.rule.dao.MonitorRuleTenantConfigDAO;
import com.digiwin.athena.knowledgegraph.rule.model.ActionParamDTO;
import com.digiwin.athena.knowledgegraph.rule.model.DefaultParamDTO;
import com.digiwin.athena.knowledgegraph.rule.model.DynamicConditionDTO;
import com.digiwin.athena.knowledgegraph.rule.model.DynamicGroupConditionDTO;
import com.digiwin.athena.knowledgegraph.rule.model.Event;
import com.digiwin.athena.knowledgegraph.rule.model.Extension;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleDTO;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleTemplateDO;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorTypeEnum;
import com.digiwin.athena.knowledgegraph.rule.model.ReturnColumnDTO;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.model.OmMapDTO;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class MonitorRuleManager {
    private static final Logger log = LoggerFactory.getLogger(MonitorRuleManager.class);
    @Autowired
    private MonitorRuleRepository monitorRuleRepository;
    @Autowired
    private MonitorRuleProductConfigDAO monitorRuleProductConfigDAO;
    @Autowired
    private MonitorRuleTenantConfigDAO monitorRuleTenantConfigDAO;
    @Autowired
    private ProductTenantConfigDAO productTenantConfigDAO;
    @Autowired
    private ESPUtils espUtils;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSys;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    private List<AbstractMonitorRuleCategoryService> monitorRuleCategoryServices;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    IAMUtils iamUtils;
    @Autowired
    IamService iamService;
    private static final String TENANT_CONFIG_COLLECTION_NAME = "monitorRuleTenantConfig";
    private static final String PRODUCT_CONFIG_COLLECTION_NAME = "monitorRuleProductConfig";
    public static final String TENANT_CONFIG_INDEX_NAME = "idx_TenantConfig";
    public static final String PRODUCT_CONFIG_INDEX_NAME = "idx_ProductConfig";
    public static final String TENANT_ID_FIELD = "tenantId";
    public static final String PRODUCT_NAME_FIELD = "productName";
    public static final String MONITOR_RULE_ID_FIELD = "monitorRuleId";
    public static final String VERSION_FIELD = "version";
    public static final String STATUS_FIELD = "status";
    @Autowired
    private IAMUtils iAMUtils;

    @Deprecated
    public MonitorRuleDTO get2(String ruleId, String tenantId, String tenantVersion) throws Exception {
        List<DynamicParamsDO> allDynamicParams;
        MonitorRuleDTO ruleDTO = new MonitorRuleDTO();
        MonitorRuleTemplateDO templateDO = this.readTemplateFromNeo4j2(ruleId, tenantId, tenantVersion);
        MonitorRuleTenantConfig tenantConfig = this.monitorRuleTenantConfigDAO.findTenantConfigByRuleIdAndTenantId(ruleId, tenantId);
        String productName = tenantConfig.getProductName();
        ruleDTO.setRule_id(ruleId);
        ruleDTO.setAction_id(templateDO.getActionId());
        ruleDTO.setMonitor_type(templateDO.getType());
        ruleDTO.setIs_deduplication(tenantConfig.getIs_deduplication());
        ruleDTO.setBk_info(tenantConfig.getBk_info());
        ruleDTO.setProcedure_name(tenantConfig.getProcedure_name());
        ruleDTO.setProcedure_input(tenantConfig.getProcedure_input());
        if (!this.checkValueEmpty(tenantConfig.getStandardPollingRule())) {
            ruleDTO.setStandard_polling_rule((TriggerDTO)JSON.parseObject((String)JSON.toJSONString((Object)tenantConfig.getStandardPollingRule()), TriggerDTO.class));
        } else {
            ruleDTO.setStandard_polling_rule(templateDO.getStandardPollingRule());
        }
        ruleDTO.setProduct_name(productName);
        ruleDTO.setTenant_id(tenantId);
        ruleDTO.setIs_continue(templateDO.isContinue());
        MonitorRuleCategoryEnum category = templateDO.getCategory();
        ruleDTO.setCategory(category);
        MonitorRuleProductConfig productConfig = null;
        if (category == MonitorRuleCategoryEnum.SCAN || templateDO.getType() == MonitorTypeEnum.ATHENA) {
            List defaultParamsConfigDOs;
            Criteria criteria = Criteria.where((String)MONITOR_RULE_ID_FIELD).is((Object)ruleId).and(PRODUCT_NAME_FIELD).is((Object)productName);
            productConfig = this.dataPickService.findOneByCondition(criteria, MonitorRuleProductConfig.class, PRODUCT_CONFIG_COLLECTION_NAME);
            ruleDTO.setTable(productConfig.getEntityMapping().getTable());
            ruleDTO.setAlias(productConfig.getEntityMapping().getAlias());
            ruleDTO.setSelect_type(productConfig.getEntityMapping().getSelectType());
            List joinParams = productConfig.getEntityMapping().getJoinParams();
            if (joinParams != null && !joinParams.isEmpty()) {
                ruleDTO.setJoinParamsFromDO(joinParams);
            }
            String[] returnColumnTemplate = templateDO.getReturnFields();
            List fieldMappings = productConfig.getFieldMappings();
            ArrayList<ReturnColumnDTO> returnColumns = new ArrayList<ReturnColumnDTO>();
            for (FieldMappingConfigDO fieldMapping : fieldMappings) {
                for (String returnFieldName : returnColumnTemplate) {
                    if (!fieldMapping.getField().equals(returnFieldName)) continue;
                    ReturnColumnDTO columnDTO = new ReturnColumnDTO();
                    columnDTO.setName(fieldMapping.getColumn());
                    columnDTO.setAlias(fieldMapping.getAlias());
                    returnColumns.add(columnDTO);
                }
            }
            ruleDTO.setReturn_columns(returnColumns);
            List actionParamConfigDOs = productConfig.getActionParams();
            if (!CollectionUtils.isEmpty((Collection)actionParamConfigDOs)) {
                ArrayList<ActionParamDTO> actionParamDTOs = new ArrayList<ActionParamDTO>();
                for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                    actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
                }
                if (actionParamDTOs.size() > 0) {
                    ruleDTO.setAction_params(actionParamDTOs);
                }
            }
            if ((defaultParamsConfigDOs = productConfig.getDefaultParams()) != null) {
                ArrayList<DefaultParamDTO> defaultParamDTOs = new ArrayList<DefaultParamDTO>();
                for (DefaultParamConfigDO configDO : defaultParamsConfigDOs) {
                    defaultParamDTOs.add(new DefaultParamDTO(configDO.getName(), configDO.getValues()));
                }
                if (defaultParamDTOs.size() > 0) {
                    ruleDTO.setDefault_params(defaultParamDTOs);
                }
            }
            ruleDTO.setIs_polling_ids(productConfig.getIsPollingIds() == null ? false : productConfig.getIsPollingIds());
        }
        if (category == MonitorRuleCategoryEnum.SCAN && templateDO.getType() == MonitorTypeEnum.CUSTOM) {
            allDynamicParams = this.mergeProductAndUserDynamicParams(productConfig.getDynamicParams(), tenantConfig.getDynamicParams());
            ruleDTO.setDynamic_params(allDynamicParams);
        }
        if (category == MonitorRuleCategoryEnum.API) {
            allDynamicParams = this.mergeProductAndUserDynamicParams(templateDO.getDynamicParams(), tenantConfig.getDynamicParams());
            ruleDTO.setDynamic_params(allDynamicParams);
            ruleDTO.setStatic_params(productConfig == null || CollectionUtils.isEmpty((Collection)productConfig.getStaticParams()) ? new ArrayList<StaticParamsDO>() : productConfig.getStaticParams());
            ruleDTO.setMonitor_action_id(templateDO.getMonitorActionId());
        }
        ruleDTO.setDynamic_condition(this.mergeProductAndUserDynamicCondition(productConfig == null ? null : productConfig.getDynamicCondition(), tenantConfig.getDynamicCondition(), new HashMap()));
        if (ruleDTO.getDynamic_params() == null) {
            ruleDTO.setDynamic_params(new ArrayList<DynamicParamsDO>());
        }
        if (ruleDTO.getStatic_params() == null) {
            ruleDTO.setStatic_params(new ArrayList<StaticParamsDO>());
        }
        return ruleDTO;
    }

    public List<MonitorRuleProductConfig> getMonitorRuleProductConfigsById(List<String> monitorRuleIds, String tenantId, String version) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)MONITOR_RULE_ID_FIELD).in(monitorRuleIds);
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            criteria.and(VERSION_FIELD).is((Object)version);
        }
        return this.dataPickService.find(criteria, tenantId, MonitorRuleProductConfig.class, PRODUCT_CONFIG_COLLECTION_NAME);
    }

    private boolean checkValueEmpty(Object object) {
        return ObjectUtils.isEmpty((Object)object) || "{}".equals(String.valueOf(object)) || StringUtils.isEmpty((CharSequence)String.valueOf(object));
    }

    private DynamicConditionDTO mergeProductAndUserDynamicCondition(DynamicConditionConfigDO productCondition, TenantDynamicConditionDO userCondition, Map constantMap) throws DWBusinessException {
        if (productCondition != null && productCondition.getType() != null && userCondition != null) {
            if (!CollectionUtils.isEmpty((Collection)userCondition.getOrToTarget())) {
                List orList = userCondition.getOrToTarget();
                for (IntoDynamicConditionDO or : orList) {
                    productCondition = this.combineOr(productCondition, or);
                }
            }
            if (userCondition.getUnion() != null) {
                DynamicGroupConditionDTO groupConditionDTO = new DynamicGroupConditionDTO();
                groupConditionDTO.setType(DynamicConditionTypeEnum.AND_GROUP);
                ArrayList<DynamicConditionDTO> conditionDTOs = new ArrayList<DynamicConditionDTO>();
                conditionDTOs.add(DynamicConditionDTO.parseFromDO(productCondition, constantMap));
                conditionDTOs.add(DynamicConditionDTO.parseFromDO(userCondition.getUnion(), constantMap));
                groupConditionDTO.setItems(conditionDTOs);
                return groupConditionDTO;
            }
        }
        if (productCondition != null && productCondition.getType() != null) {
            return DynamicConditionDTO.parseFromDO(productCondition, constantMap);
        }
        if (userCondition != null && userCondition.getUnion() != null) {
            return DynamicConditionDTO.parseFromDO(userCondition.getUnion(), constantMap);
        }
        return null;
    }

    private DynamicConditionConfigDO combineOr(DynamicConditionConfigDO productCondition, IntoDynamicConditionDO or) throws DWBusinessException {
        if (StringUtils.equals((CharSequence)productCondition.getLeft(), (CharSequence)or.getTargetColumn())) {
            DynamicConditionConfigDO orConditon = new DynamicConditionConfigDO();
            orConditon.setType(DynamicConditionTypeEnum.OR_GROUP);
            ArrayList<DynamicConditionConfigDO> conditionDOs = new ArrayList<DynamicConditionConfigDO>();
            conditionDOs.add(productCondition);
            conditionDOs.addAll(or.getItems());
            orConditon.setItems(conditionDOs);
            return orConditon;
        }
        if (CollectionUtils.isEmpty((Collection)productCondition.getItems())) {
            return productCondition;
        }
        List items = productCondition.getItems();
        for (int i = 0; i < items.size(); ++i) {
            items.set(i, this.combineOr((DynamicConditionConfigDO)items.get(i), or));
        }
        return productCondition;
    }

    private DynamicConditionDTO mergeProductAndUserDynamicCondition(DynamicConditionConfigDO productCondition, DynamicConditionConfigDO userCondition, Map constantMap) throws DWBusinessException {
        if (productCondition != null && productCondition.getType() != null && userCondition != null && userCondition.getType() != null) {
            DynamicGroupConditionDTO groupConditionDTO = new DynamicGroupConditionDTO();
            groupConditionDTO.setType(DynamicConditionTypeEnum.AND_GROUP);
            ArrayList<DynamicConditionDTO> conditionDTOs = new ArrayList<DynamicConditionDTO>();
            conditionDTOs.add(DynamicConditionDTO.parseFromDO(productCondition, constantMap));
            conditionDTOs.add(DynamicConditionDTO.parseFromDO(userCondition, constantMap));
            groupConditionDTO.setItems(conditionDTOs);
            return groupConditionDTO;
        }
        if (productCondition != null && productCondition.getType() != null) {
            return DynamicConditionDTO.parseFromDO(productCondition, constantMap);
        }
        if (userCondition != null && userCondition.getType() != null) {
            return DynamicConditionDTO.parseFromDO(userCondition, constantMap);
        }
        return null;
    }

    private String fetchGroupKey(DynamicParamsDO dynamicParamsDO) {
        return dynamicParamsDO.getParam_name();
    }

    private List<DynamicParamsDO> mergeProductAndUserDynamicParams(List<DynamicParamsDO> productDynamicParams, List<DynamicParamsDO> userDynamicParams) {
        ArrayList<DynamicParamsDO> allDynamicParams = new ArrayList<DynamicParamsDO>();
        Map<String, List<DynamicParamsDO>> collect = null;
        if (!CollectionUtils.isEmpty(userDynamicParams)) {
            collect = userDynamicParams.stream().collect(Collectors.groupingBy(e -> this.fetchGroupKey((DynamicParamsDO)e)));
            allDynamicParams.addAll(userDynamicParams);
        }
        if (!CollectionUtils.isEmpty(productDynamicParams)) {
            if (collect != null) {
                for (DynamicParamsDO dynamicParamsDO : productDynamicParams) {
                    if (collect.containsKey(this.fetchGroupKey(dynamicParamsDO))) continue;
                    allDynamicParams.add(dynamicParamsDO);
                }
            } else {
                allDynamicParams.addAll(productDynamicParams);
            }
        }
        return allDynamicParams;
    }

    @Deprecated
    public MonitorRule queryMonitorRule(String ruleId, String tenantId, String tenantVersion) throws Exception {
        log.info("queryMonitorRule ruleId:{} tenantId:{} tenantVersion:{}", new Object[]{ruleId, tenantId, tenantVersion});
        List<MonitorRule> monitorRules = this.monitorRuleRepository.getAddedCustomByCode(ruleId, tenantId, tenantVersion);
        if (monitorRules == null || monitorRules.isEmpty()) {
            monitorRules = this.dataPickService.excludeWithSameCodeAndFilterTenant(this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion), tenantId);
        }
        if (monitorRules == null || monitorRules.size() == 0) {
            throw new DWBusinessException("P.KG.500.0030", I18nUtils.getValue("knowledgegraph.monitorNotFound", ruleId));
        }
        MonitorRule monitorRule = monitorRules.get(0);
        return monitorRule;
    }

    private MonitorRuleTemplateDO readTemplateFromNeo4j2(String ruleId, String tenantId, String tenantVersion) throws Exception {
        MonitorRule monitorRule = this.queryMonitorRule(ruleId, tenantId, tenantVersion);
        List<Action> actions = monitorRule.getActions();
        String actionId = null;
        if (StringUtils.isNotEmpty((CharSequence)monitorRule.getActionCommonId())) {
            actionId = monitorRule.getActionCommonId();
        }
        if (actions == null || actions.size() == 0) {
            if (StringUtils.isEmpty((CharSequence)actionId) && !monitorRule.isDataCheck()) {
                throw new DWBusinessException("P.KG.500.0027", I18nUtils.getValue("knowledgegraph.monitorAction", ruleId));
            }
        } else {
            actionId = actions.get(0).getActionId();
        }
        if (!this.checkMonitorRuleSchema(monitorRule)) {
            throw new DWBusinessException("P.KG.500.0028", I18nUtils.getValue("knowledgegraph.monitorTemplateInvalid", ruleId));
        }
        MonitorRuleTemplateDO templateDO = new MonitorRuleTemplateDO();
        templateDO.setActionId(actionId);
        templateDO.setActionType(monitorRule.getActionType());
        templateDO.setChillInterval(monitorRule.getChillInterval());
        templateDO.setName(monitorRule.getName());
        templateDO.setCode(monitorRule.getCode());
        templateDO.setType(Enum.valueOf(MonitorTypeEnum.class, monitorRule.getType()));
        templateDO.setStandardPollingRule((TriggerDTO)JSON.parseObject((String)monitorRule.getStandardPollingRule(), TriggerDTO.class));
        templateDO.setContinue(monitorRule.getIsContinue());
        templateDO.setExecuteOnStartup(monitorRule.getExecuteOnStartup());
        templateDO.setScene((RuleSceneDTO)JSON.parseObject((String)monitorRule.getScene(), RuleSceneDTO.class));
        MonitorRuleCategoryEnum category = Enum.valueOf(MonitorRuleCategoryEnum.class, monitorRule.getCategory());
        templateDO.setCategory(category);
        if (category == MonitorRuleCategoryEnum.API || category == MonitorRuleCategoryEnum.SQL_SCRIPT) {
            templateDO.setMonitorActionId(monitorRule.getMonitorActionId());
            String dynamicParams = monitorRule.getDynamicParams();
            if (StringUtils.isNotEmpty((CharSequence)dynamicParams)) {
                templateDO.setDynamicParams(JSON.parseArray((String)dynamicParams, DynamicParamsDO.class));
            }
        } else if (category == MonitorRuleCategoryEnum.SCAN || category == MonitorRuleCategoryEnum.CHECK_SUM) {
            String returnFieldsStr = monitorRule.getReturnFields();
            templateDO.setReturnFields(returnFieldsStr.split(","));
            String dynamicConditionFields = monitorRule.getDynamicConditionFields();
            if (StringUtils.isNotEmpty((CharSequence)dynamicConditionFields)) {
                templateDO.setDynamicConditionFields(dynamicConditionFields.split(","));
            }
        } else if (category == MonitorRuleCategoryEnum.MQTT) {
            templateDO.setMqttSource(monitorRule.getMqttSource());
            templateDO.setMqttTopic(monitorRule.getMqttTopic());
        }
        return templateDO;
    }

    private MonitorRuleTenantConfigDO readTenantConfig(String ruleId, String tenantId) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(TENANT_CONFIG_COLLECTION_NAME, TENANT_CONFIG_INDEX_NAME, TENANT_ID_FIELD, MONITOR_RULE_ID_FIELD);
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)MONITOR_RULE_ID_FIELD, (Object)ruleId), Filters.eq((String)TENANT_ID_FIELD, (Object)tenantId), Filters.eq((String)STATUS_FIELD, (Object)1)})).first();
        if (doc != null) {
            MonitorRuleTenantConfigDO tenantConfigDO = (MonitorRuleTenantConfigDO)JSON.parseObject((String)doc.toJson(), MonitorRuleTenantConfigDO.class);
            return tenantConfigDO;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.tenantNotEnable", tenantId, ruleId));
    }

    private MonitorRuleProductConfigDO readProductConfig(String ruleId, String productName, String tenantVersion) throws DWBusinessException {
        MongoCollection<Document> col = MongoDBManager.getMongoDBManager().getCollectionWithKeys(PRODUCT_CONFIG_COLLECTION_NAME, PRODUCT_CONFIG_INDEX_NAME, PRODUCT_NAME_FIELD, MONITOR_RULE_ID_FIELD, VERSION_FIELD);
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)MONITOR_RULE_ID_FIELD, (Object)ruleId), Filters.eq((String)PRODUCT_NAME_FIELD, (Object)productName), Filters.eq((String)VERSION_FIELD, (Object)tenantVersion)})).first();
        if (doc != null) {
            MonitorRuleProductConfigDO productConfigDO = (MonitorRuleProductConfigDO)JSON.parseObject((String)doc.toJson(), MonitorRuleProductConfigDO.class);
            return productConfigDO;
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.noAvailableConfiguration", ruleId, productName));
    }

    private boolean CheckMonitorRuleSchema(Map<String, Object> entity) {
        return entity.containsKey("code") && entity.containsKey("name") && entity.containsKey("type") && entity.containsKey("standardPollingRule") && entity.containsKey("category");
    }

    private boolean checkMonitorRuleSchema(MonitorRule monitorRule) {
        return StringUtils.isNotEmpty((CharSequence)monitorRule.getCode()) && StringUtils.isNotEmpty((CharSequence)monitorRule.getName()) && StringUtils.isNotEmpty((CharSequence)monitorRule.getType()) && (MonitorTypeEnum.REPORT.toString().equals(monitorRule.getType()) || StringUtils.isNotEmpty((CharSequence)monitorRule.getStandardPollingRule()) || StringUtils.equals((CharSequence)monitorRule.getType(), (CharSequence)MonitorTypeEnum.MQTT.name())) && StringUtils.isNotEmpty((CharSequence)monitorRule.getCategory());
    }

    public MonitorRuleDTO getMonitorRule(Map<String, Object> config, String tenantVersion) throws Exception {
        AbstractMonitorRuleCategoryService abstractMonitorRuleCategoryService;
        List<DynamicParamsDO> allDynamicParams;
        ArrayList<ActionParamDTO> actionParamDTOs;
        List actionParamConfigDOs;
        String ruleId = (String)config.get("ruleId");
        String tenantId = (String)config.get(TENANT_ID_FIELD);
        Map map = (Map)config.get("eocMap");
        EocMapDTO eocMap = null;
        if (map != null && !map.isEmpty()) {
            eocMap = new EocMapDTO();
            eocMap.setEocCompanyId((String)map.get("eocCompanyId"));
            eocMap.setEocSiteId((String)map.get("eocSiteId"));
            eocMap.setEocRegionId((String)map.get("eocRegionId"));
            if (map.get("operation_unit_v2") != null) {
                OperationUnitV2 operationUnitV2 = new OperationUnitV2();
                String eocMappingId = Optional.ofNullable(map.get("operation_unit_v2")).map(o -> {
                    Map unitV2 = MapUtils.getMap((Map)map, (Object)"operation_unit_v2");
                    return MapUtils.getString((Map)unitV2, (Object)"eoc_mapping_id");
                }).orElse(null);
                operationUnitV2.setEoc_mapping_id(eocMappingId);
                eocMap.setOperation_unit_v2(operationUnitV2);
            }
        }
        MonitorRuleDTO ruleDTO = new MonitorRuleDTO();
        MonitorRuleTemplateDO templateDO = this.readTemplateFromNeo4j2(ruleId, tenantId, tenantVersion);
        MonitorRuleTenantConfig tenantConfig = this.monitorRuleTenantConfigDAO.findTenantConfigByRuleTenantEoc(ruleId, tenantId, eocMap);
        String productName = tenantConfig.getProductName();
        ruleDTO.setIs_deduplication(tenantConfig.getIs_deduplication());
        ruleDTO.setBk_info(tenantConfig.getBk_info());
        ruleDTO.setProcedure_name(tenantConfig.getProcedure_name());
        ruleDTO.setProcedure_input(tenantConfig.getProcedure_input());
        HashMap<String, String> ouMap = new HashMap<String, String>();
        if (eocMap != null) {
            ouMap.put("$eoc_company_id", eocMap.getEocCompanyId());
            ouMap.put("$eoc_site_id", eocMap.getEocSiteId());
            ouMap.put("$eoc_region_id", eocMap.getEocRegionId());
            OmMapDTO omMap = this.getOM(tenantId, productName, eocMap);
            if (omMap != null && !omMap.isEmpty()) {
                ouMap.put("$om_company_id", omMap.getOmCompanyId());
                ouMap.put("$om_site_id", omMap.getOmSiteId());
                ouMap.put("$om_region_id", omMap.getOmRegionId());
            }
        }
        ruleDTO.setRule_id(ruleId);
        ruleDTO.setAction_id(templateDO.getActionId());
        ruleDTO.setMonitor_type(templateDO.getType());
        ruleDTO.setAction_type(templateDO.getActionType());
        ruleDTO.setChill_interval(templateDO.getChillInterval());
        if (tenantConfig.getStandardPollingRules() != null && !CollectionUtils.isEmpty((Collection)((List)tenantConfig.getStandardPollingRules()))) {
            ruleDTO.setStandard_polling_rules(JSON.parseArray((String)JSON.toJSONString((Object)tenantConfig.getStandardPollingRules()), TriggerDTO.class));
        } else {
            ArrayList<TriggerDTO> triggers = new ArrayList<TriggerDTO>();
            TriggerDTO trigger = templateDO.getStandardPollingRule();
            if (!this.checkValueEmpty(tenantConfig.getStandardPollingRule())) {
                trigger = (TriggerDTO)JSON.parseObject((String)JSON.toJSONString((Object)tenantConfig.getStandardPollingRule()), TriggerDTO.class);
            }
            triggers.add(trigger);
            ruleDTO.setStandard_polling_rules(triggers);
        }
        ruleDTO.setProduct_name(productName);
        ruleDTO.setTenant_id(tenantId);
        ruleDTO.setIs_continue(templateDO.isContinue());
        MonitorRuleCategoryEnum category = templateDO.getCategory();
        ruleDTO.setCategory(category);
        Criteria criteria = Criteria.where((String)MONITOR_RULE_ID_FIELD).is((Object)ruleId).and(PRODUCT_NAME_FIELD).is((Object)productName);
        MonitorRuleProductConfig productConfig = this.dataPickService.findOneByCondition(criteria, MonitorRuleProductConfig.class, PRODUCT_CONFIG_COLLECTION_NAME);
        if (null == ruleDTO.getIs_deduplication()) {
            ruleDTO.setIs_deduplication(productConfig.getIs_deduplication());
        }
        if (null == ruleDTO.getBk_info()) {
            ruleDTO.setBk_info(productConfig.getBk_info());
        }
        if (null == ruleDTO.getProcedure_name()) {
            ruleDTO.setProcedure_name(productConfig.getProcedure_name());
        }
        if (null == ruleDTO.getProcedure_input()) {
            ruleDTO.setProcedure_input(productConfig.getProcedure_input());
        }
        String application = productConfig.getApplication();
        ruleDTO.setApplication(application);
        if (category == MonitorRuleCategoryEnum.PROCEDURE && !CollectionUtils.isEmpty((Collection)(actionParamConfigDOs = productConfig.getActionParams()))) {
            actionParamDTOs = new ArrayList<ActionParamDTO>();
            for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
            }
            if (actionParamDTOs.size() > 0) {
                ruleDTO.setAction_params(actionParamDTOs);
            }
        }
        if (category == MonitorRuleCategoryEnum.SCAN || templateDO.getType() == MonitorTypeEnum.ATHENA || category == MonitorRuleCategoryEnum.CDC || category == MonitorRuleCategoryEnum.CHECK_SUM) {
            List defaultParamsConfigDOs;
            ruleDTO.setTable(productConfig.getEntityMapping().getTable());
            ruleDTO.setAlias(productConfig.getEntityMapping().getAlias());
            ruleDTO.setSelect_type(productConfig.getEntityMapping().getSelectType());
            List joinParams = productConfig.getEntityMapping().getJoinParams();
            if (joinParams != null && !joinParams.isEmpty()) {
                ruleDTO.setJoinParamsFromDO(joinParams);
            }
            String[] returnColumnTemplate = templateDO.getReturnFields();
            List fieldMappings = productConfig.getFieldMappings();
            ArrayList<ReturnColumnDTO> returnColumns = new ArrayList<ReturnColumnDTO>();
            if (null != returnColumnTemplate) {
                Iterator iterator = fieldMappings.iterator();
                while (iterator.hasNext()) {
                    FieldMappingConfigDO fieldMapping = (FieldMappingConfigDO)iterator.next();
                    for (String returnFieldName : returnColumnTemplate) {
                        if (!fieldMapping.getField().equals(returnFieldName)) continue;
                        ReturnColumnDTO columnDTO = new ReturnColumnDTO();
                        columnDTO.setName(fieldMapping.getColumn());
                        columnDTO.setAlias(fieldMapping.getAlias());
                        returnColumns.add(columnDTO);
                    }
                }
            }
            ruleDTO.setReturn_columns(returnColumns);
            List actionParamConfigDOs2 = productConfig.getActionParams();
            if (!CollectionUtils.isEmpty((Collection)actionParamConfigDOs2)) {
                ArrayList<ActionParamDTO> actionParamDTOs2 = new ArrayList<ActionParamDTO>();
                for (ActionParamConfigDO configDO : actionParamConfigDOs2) {
                    actionParamDTOs2.add(ActionParamDTO.parseFromDO(configDO));
                }
                if (actionParamDTOs2.size() > 0) {
                    ruleDTO.setAction_params(actionParamDTOs2);
                }
            }
            if ((defaultParamsConfigDOs = productConfig.getDefaultParams()) != null) {
                ArrayList<DefaultParamDTO> defaultParamDTOs = new ArrayList<DefaultParamDTO>();
                for (DefaultParamConfigDO configDO : defaultParamsConfigDOs) {
                    defaultParamDTOs.add(new DefaultParamDTO(configDO.getName(), configDO.getValues()));
                }
                if (defaultParamDTOs.size() > 0) {
                    ruleDTO.setDefault_params(defaultParamDTOs);
                }
            }
            ruleDTO.setEocLevel(productConfig.getEocLevel());
        }
        if (category == MonitorRuleCategoryEnum.SQL_SCRIPT) {
            actionParamConfigDOs = productConfig.getActionParams();
            if (!CollectionUtils.isEmpty((Collection)actionParamConfigDOs)) {
                actionParamDTOs = new ArrayList();
                for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                    actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
                }
                if (actionParamDTOs.size() > 0) {
                    ruleDTO.setAction_params(actionParamDTOs);
                }
            }
            List<DynamicParamsDO> allDynamicParams2 = this.mergeProductAndUserDynamicParams(templateDO.getDynamicParams(), tenantConfig.getDynamicParams());
            if (null != productConfig && !CollectionUtils.isEmpty((Collection)productConfig.getDynamicParams())) {
                ruleDTO.setDynamic_params(productConfig.getDynamicParams());
            } else {
                ruleDTO.setDynamic_params(allDynamicParams2);
            }
            ruleDTO.setScript(StringUtils.isNotEmpty((CharSequence)tenantConfig.getScript()) ? tenantConfig.getScript() : productConfig.getScript());
            ruleDTO.setDb_tag(productConfig.getDbTag());
            ruleDTO.setDb_name(productConfig.getDbName());
        }
        if (category == MonitorRuleCategoryEnum.SCAN && templateDO.getType() == MonitorTypeEnum.CUSTOM || category == MonitorRuleCategoryEnum.PROCEDURE) {
            allDynamicParams = this.mergeProductAndUserDynamicParams(productConfig.getDynamicParams(), tenantConfig.getDynamicParams());
            ruleDTO.setDynamic_params(allDynamicParams);
        }
        if (category == MonitorRuleCategoryEnum.API) {
            allDynamicParams = this.mergeProductAndUserDynamicParams(templateDO.getDynamicParams(), tenantConfig.getDynamicParams());
            if (null != productConfig && !CollectionUtils.isEmpty((Collection)productConfig.getDynamicParams())) {
                ruleDTO.setDynamic_params(productConfig.getDynamicParams());
            } else {
                ruleDTO.setDynamic_params(allDynamicParams);
            }
            if (productConfig != null) {
                ruleDTO.setStatic_params(CollectionUtils.isEmpty((Collection)productConfig.getStaticParams()) ? new ArrayList() : productConfig.getStaticParams());
                ruleDTO.setEocLevel(productConfig.getEocLevel());
                ruleDTO.setObserve(productConfig.getObserve());
            }
            ruleDTO.setMonitor_action_id(templateDO.getMonitorActionId());
        }
        if (category == MonitorRuleCategoryEnum.SCHEDULE) {
            if (productConfig != null) {
                ruleDTO.setEocLevel(productConfig.getEocLevel());
            }
            if (null != templateDO.getScene()) {
                ruleDTO.setScene(templateDO.getScene());
            }
            if (!CollectionUtils.isEmpty((Map)productConfig.getActionParamDefine())) {
                ruleDTO.setActionParamDefine(productConfig.getActionParamDefine());
            }
            if (!CollectionUtils.isEmpty((Map)productConfig.getRecast())) {
                ruleDTO.setRecast(productConfig.getRecast());
            }
        }
        if (productConfig != null) {
            ruleDTO.setIs_polling_ids(productConfig.getIsPollingIds() == null ? false : productConfig.getIsPollingIds());
        }
        ruleDTO.setDynamic_condition(this.mergeProductAndUserDynamicCondition(productConfig == null ? null : productConfig.getDynamicCondition(), tenantConfig.getDynamicCondition(), ouMap));
        if (ruleDTO.getDynamic_params() == null) {
            ruleDTO.setDynamic_params(new ArrayList<DynamicParamsDO>());
        }
        if (ruleDTO.getStatic_params() == null) {
            ruleDTO.setStatic_params(new ArrayList<StaticParamsDO>());
        }
        if (BooleanUtils.isTrue((Boolean)templateDO.getExecuteOnStartup())) {
            Event event = new Event();
            event.setEventType("detect_after_create");
            Extension extension = new Extension();
            ArrayList<Event> events = new ArrayList<Event>();
            events.add(event);
            extension.setEvents(events);
            ruleDTO.setExtension(extension);
        }
        ruleDTO.setExecute_page_size(productConfig.getExecutePageSize());
        if (category == MonitorRuleCategoryEnum.CDC) {
            ruleDTO.setTable_name(productConfig.getTable_name() == null ? productConfig.getEntityMapping().getTable() : productConfig.getTable_name());
            ruleDTO.setChange_type(productConfig.getChange_type());
            ruleDTO.setEoc_company_id((String)ouMap.get("$eoc_company_id"));
            ruleDTO.setEoc_site_id((String)ouMap.get("$eoc_site_id"));
            ruleDTO.setOperation_unit_v2(eocMap != null ? eocMap.getOperation_unit_v2() : null);
            ruleDTO.setChange_fields(productConfig.getChange_fields());
            ruleDTO.setFilter_condition(productConfig.getFilter_condition());
            ruleDTO.setFilter_params(productConfig.getFilter_params());
            ruleDTO.setIs_need_eoc(productConfig.getIs_need_eoc());
            ruleDTO.setEoc_company_key(productConfig.getEoc_company_key());
            ruleDTO.setEoc_site_key(productConfig.getEoc_site_key());
            ruleDTO.setStart_time(productConfig.getStart_time());
            ruleDTO.setValid(productConfig.getValid());
        }
        if (!Objects.isNull(abstractMonitorRuleCategoryService = (AbstractMonitorRuleCategoryService)this.monitorRuleCategoryServices.stream().filter(service -> service.support(category)).findFirst().orElse(null))) {
            abstractMonitorRuleCategoryService.execute(ruleDTO, productConfig, templateDO, tenantConfig);
        }
        return ruleDTO;
    }

    private boolean isTenantV2(String tenantId) throws DWBusinessException {
        String tenantToken = null;
        try {
            tenantToken = this.iamService.getTenantToken(tenantId);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u79df\u6237:{}\u83b7\u53d6token\u51fa\u9519\uff0c\u51fa\u9519\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.toString());
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.getTenantTokenFail", new Object[0]));
        }
        String tenantOperationUnitVersion = this.iamUtils.getTenantOperationUnitVersion(tenantToken);
        return "v2".equals(tenantOperationUnitVersion);
    }

    public OmMapDTO getOM(String tenantId, String productName, EocMapDTO eocMap) throws ParseException, DWBusinessException, IOException {
        OmMapDTO omMap;
        block9: {
            Map re;
            block10: {
                omMap = new OmMapDTO();
                if (StringUtils.isEmpty((CharSequence)productName)) {
                    return omMap;
                }
                if (eocMap == null) break block9;
                boolean tenantOperationUnitV2 = this.isTenantV2(tenantId);
                if (tenantOperationUnitV2 && (eocMap.getOperation_unit_v2() == null || StringUtils.isEmpty((CharSequence)eocMap.getOperation_unit_v2().getEoc_mapping_id()))) {
                    return omMap;
                }
                re = this.espUtils.getTenantProductOperationList(tenantId, productName, tenantOperationUnitV2);
                if (!tenantOperationUnitV2) break block10;
                List eocList = (List)re.get("org_type_mapping");
                for (Map eoc : eocList) {
                    if (!eocMap.getOperation_unit_v2().getEoc_mapping_id().equals(MapUtils.getString((Map)eoc, (Object)"eoc_mapping_id"))) continue;
                    String type = MapUtils.getString((Map)eoc, (Object)"type");
                    String omMappingId = MapUtils.getString((Map)eoc, (Object)"om_mapping_id");
                    if ("company_id".equals(type)) {
                        omMap.setOmCompanyId(omMappingId);
                        continue;
                    }
                    if ("site_id".equals(type)) {
                        omMap.setOmSiteId(omMappingId);
                        continue;
                    }
                    if (!"region_id".equals(type)) continue;
                    omMap.setOmRegionId(omMappingId);
                }
                break block9;
            }
            List orgCompany = (List)re.get("org_type_company");
            if (StringUtils.isNotEmpty((CharSequence)eocMap.getEocCompanyId()) && orgCompany != null && !orgCompany.isEmpty()) {
                block1: for (Map company : orgCompany) {
                    String eocCompanyId = (String)company.get("eoc_company_id");
                    if (!eocMap.getEocCompanyId().equals(eocCompanyId)) continue;
                    omMap.setOmCompanyId((String)company.get("om_company_id"));
                    if (!StringUtils.isNotEmpty((CharSequence)eocMap.getEocSiteId())) break;
                    List orgSite = (List)company.get("org_type_site");
                    for (Map site : orgSite) {
                        String eocSiteId = (String)site.get("eoc_site_id");
                        if (!eocMap.getEocSiteId().equals(eocSiteId)) continue;
                        omMap.setOmSiteId((String)site.get("om_site_id"));
                        break block1;
                    }
                }
            }
            List orgRegion = (List)re.get("org_type_region");
            if (!StringUtils.isNotEmpty((CharSequence)eocMap.getEocRegionId()) || orgRegion == null || orgRegion.isEmpty()) break block9;
            for (Map region : orgRegion) {
                String eocRegion = (String)region.get("eoc_region_id");
                if (!eocMap.getEocRegionId().equals(eocRegion)) continue;
                omMap.setOmRegionId((String)region.get("om_region_id"));
                break;
            }
        }
        return omMap;
    }

    public Object queryAllMonitor() throws Exception {
        String currentLocale = AthenaUtils.getCurrentLocale();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)TENANT_ID_FIELD).is((Object)tenantId).and(STATUS_FIELD).is((Object)1));
        List monitorRuleTenantConfigs = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        Criteria criteria = Criteria.where((String)"displayType").in(new Object[]{"PERIODIC", "PERIODIC_MULTIPLE"}).and(VERSION_FIELD).is((Object)tenantVersion);
        List<VariableDefinition> variableDefinitions = this.dataPickService.find(criteria, VariableDefinition.class, "variableDefinition");
        LanguageUtil.processLocaleLanguage(variableDefinitions, currentLocale);
        Map variableDefinitionMap = variableDefinitions.stream().collect(Collectors.toMap(VariableDefinition::getExtendData, Function.identity(), (oldValue, newValue) -> newValue));
        List<Application> applications = this.dataPickService.find(new Criteria(), Application.class, "application");
        ArrayList paramDescriptions = new ArrayList();
        for (Application application : applications) {
            List paramDescription = application.getParamDescription();
            if (ObjectUtils.isEmpty((Object)paramDescription)) continue;
            List collect = paramDescription.stream().filter(v -> Arrays.asList("PERIODIC", "PERIODIC_MULTIPLE").contains(v.getDisplayType())).collect(Collectors.toList());
            TranslateUtil.dealLangRecusive(collect, (String)currentLocale);
            paramDescriptions.addAll(collect);
        }
        Map descriptionMap = paramDescriptions.stream().collect(Collectors.toMap(FieldDescription::getExtendData, Function.identity(), (oldValue, newValue) -> newValue));
        List<MonitorRule> byVersion = this.monitorRuleRepository.findByVersion(tenantVersion);
        Map map = byVersion.stream().collect(Collectors.toMap(CodedEntity::getCode, Function.identity(), (oldValue, newValue) -> newValue));
        ArrayList<MonitorVO> list = new ArrayList<MonitorVO>();
        for (MonitorRuleTenantConfig m : monitorRuleTenantConfigs) {
            String monitorRuleId = m.getMonitorRuleId();
            if (variableDefinitionMap.containsKey(monitorRuleId)) {
                list.add(MonitorVO.builder().monitorRuleId(monitorRuleId).name(((VariableDefinition)((Object)variableDefinitionMap.get(monitorRuleId))).getName()).build());
                continue;
            }
            if (descriptionMap.containsKey(monitorRuleId)) {
                list.add(MonitorVO.builder().monitorRuleId(monitorRuleId).name(((FieldDescription)descriptionMap.get(monitorRuleId)).getName()).build());
                continue;
            }
            if (!map.containsKey(monitorRuleId)) continue;
            list.add(MonitorVO.builder().monitorRuleId(monitorRuleId).name(((MonitorRule)((Object)map.get(monitorRuleId))).getName()).build());
        }
        return list.stream().distinct().collect(Collectors.toList());
    }

    public Object getAllTenantMonitorRule() {
        List<Map> allMonitorRuleCodes = this.monitorRuleRepository.getAllMonitorRuleCodes();
        List monitorRuleList = JSONArray.parseArray((String)JSON.toJSONString(allMonitorRuleCodes), MonitorRule.class);
        Map monitorRuleMap = monitorRuleList.stream().collect(Collectors.toMap(CodedEntity::getCode, Function.identity(), (a, b) -> b));
        Query query = new Query();
        query.fields().include(TENANT_ID_FIELD).include(MONITOR_RULE_ID_FIELD).include(STATUS_FIELD).include("eocMap");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"closed").ne((Object)true));
        List tenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        ArrayList result = new ArrayList();
        for (MonitorRuleTenantConfig e : tenantConfigList) {
            MonitorRule monitorRule = (MonitorRule)((Object)monitorRuleMap.get(e.getMonitorRuleId()));
            if (monitorRule != null && monitorRule.isDataCheck()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TENANT_ID_FIELD, e.getTenantId());
            map.put("ruleId", e.getMonitorRuleId());
            if (e.getEocMap() != null) {
                map.put("eocCompanyId", e.getEocMap().getEocCompanyId());
                map.put("eocSiteId", e.getEocMap().getEocSiteId());
            }
            map.put("enable", e.getStatus() != null && 1 == e.getStatus() ? "Y" : "N");
            if (monitorRule == null) {
                map.put("hasDelete", true);
            } else {
                map.put("backtrackDate", monitorRule.getBacktrackDate());
                map.put("ruleType", StringUtils.equalsIgnoreCase((CharSequence)"CDC", (CharSequence)monitorRule.getCategory()) ? "2" : "1");
            }
            result.add(map);
        }
        return result;
    }
}

