/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.rule.category;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.kg.monitorRule.product.ActionParamConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionTypeEnum;
import com.digiwin.athena.knowledgegraph.rule.AbstractMonitorRuleCategoryService;
import com.digiwin.athena.knowledgegraph.rule.model.ActionParamDTO;
import com.digiwin.athena.knowledgegraph.rule.model.DynamicConditionDTO;
import com.digiwin.athena.knowledgegraph.rule.model.DynamicGroupConditionDTO;
import com.digiwin.athena.knowledgegraph.rule.model.DynamicSingleConditionDTO;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleDTO;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleTemplateDO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MQTTMonitorRuleCategoryService
extends AbstractMonitorRuleCategoryService {
    private static final Logger log = LoggerFactory.getLogger(MQTTMonitorRuleCategoryService.class);

    @Override
    public MonitorRuleCategoryEnum monitorRuleCategory() {
        return MonitorRuleCategoryEnum.MQTT;
    }

    @Override
    public void execute(MonitorRuleDTO ruleDTO, MonitorRuleProductConfig productConfig, MonitorRuleTemplateDO templateDO, MonitorRuleTenantConfig tenantConfig) throws DWBusinessException {
        log.info("\u5f00\u59cb\u5c01\u88c5{}\u7c7b\u578b\u7684\u4fa6\u6d4b", (Object)ruleDTO.getCategory());
        ruleDTO.setMqttSource(templateDO.getMqttSource());
        ruleDTO.setMqttTopic(templateDO.getMqttTopic());
        ruleDTO.setChange_type(StringUtils.isBlank((CharSequence)productConfig.getChange_type()) ? "create" : productConfig.getChange_type());
        this.setActionParams(ruleDTO, productConfig);
        List<TriggerDTO> standardPollingRules = ruleDTO.getStandard_polling_rules();
        if (CollectionUtils.isNotEmpty(standardPollingRules)) {
            TriggerDTO triggerDTO = standardPollingRules.stream().findFirst().orElse(null);
            ruleDTO.setStart_time(triggerDTO.getStart_time());
        }
        ruleDTO.setFilter_condition(productConfig.getFilter_condition());
        ArrayList<JSONObject> conversionFilterCondition = new ArrayList<JSONObject>();
        this.conversionFilterCondition(ruleDTO, conversionFilterCondition);
        ruleDTO.setConversionFilterCondition(conversionFilterCondition);
        log.info("\u5c01\u88c5{}\u7c7b\u578b\u7684\u4fa6\u6d4b\u7ed3\u675f", (Object)ruleDTO.getCategory());
    }

    private void originalFilterConditionConversion(List<DynamicConditionConfigDO> tmpList, DynamicConditionConfigDO dynamicConditionConfig, List<JSONObject> conversionFilterCondition) {
        List items;
        if (DynamicConditionTypeEnum.SINGLE == dynamicConditionConfig.getType()) {
            DynamicConditionConfigDO dynamicConditionConfigDO = new DynamicConditionConfigDO();
            dynamicConditionConfigDO.setLeft(dynamicConditionConfig.getLeft());
            dynamicConditionConfigDO.setOp(dynamicConditionConfig.getOp());
            dynamicConditionConfigDO.setType(dynamicConditionConfig.getType());
            dynamicConditionConfigDO.setRight(dynamicConditionConfig.getRight());
            dynamicConditionConfigDO.setLeftValueType(dynamicConditionConfig.getLeftValueType());
            dynamicConditionConfigDO.setRightValueType(dynamicConditionConfig.getRightValueType());
            tmpList.add(dynamicConditionConfigDO);
        }
        if ((DynamicConditionTypeEnum.AND_GROUP == dynamicConditionConfig.getType() || DynamicConditionTypeEnum.OR_GROUP == dynamicConditionConfig.getType()) && CollectionUtils.isNotEmpty((Collection)(items = dynamicConditionConfig.getItems()))) {
            ArrayList<DynamicConditionConfigDO> groupList = new ArrayList<DynamicConditionConfigDO>();
            items.forEach(res -> this.originalFilterConditionConversion((List<DynamicConditionConfigDO>)groupList, (DynamicConditionConfigDO)res, conversionFilterCondition));
            this.outputItems(groupList, conversionFilterCondition);
        }
    }

    private void conversionFilterCondition(MonitorRuleDTO ruleDTO, List<JSONObject> conversionFilterCondition) {
        DynamicConditionDTO dynamicCondition = ruleDTO.getDynamic_condition();
        if (!Objects.isNull(dynamicCondition)) {
            DynamicConditionTypeEnum type = dynamicCondition.getType();
            if (DynamicConditionTypeEnum.AND_GROUP == type || DynamicConditionTypeEnum.OR_GROUP == type) {
                this.dealCondition(conversionFilterCondition, (DynamicGroupConditionDTO)dynamicCondition);
            } else {
                ArrayList<DynamicConditionConfigDO> groupList = new ArrayList<DynamicConditionConfigDO>();
                this.generateConditionConfigDO(dynamicCondition, groupList, conversionFilterCondition);
                this.outputItems(groupList, conversionFilterCondition);
            }
        }
    }

    private void dealCondition(List<JSONObject> conversionFilterCondition, DynamicGroupConditionDTO dynamicCondition) {
        DynamicGroupConditionDTO dynamicGroupConditionDTO = dynamicCondition;
        List<DynamicConditionDTO> items = dynamicGroupConditionDTO.getItems();
        if (CollectionUtils.isNotEmpty(items)) {
            ArrayList<DynamicConditionConfigDO> groupList = new ArrayList<DynamicConditionConfigDO>();
            items.forEach(res -> this.generateConditionConfigDO((DynamicConditionDTO)res, (List<DynamicConditionConfigDO>)groupList, conversionFilterCondition));
            this.outputItems(groupList, conversionFilterCondition);
        }
    }

    private void outputItems(List<DynamicConditionConfigDO> groupList, List<JSONObject> conversionFilterCondition) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("items", groupList);
        conversionFilterCondition.add(jsonObject);
    }

    private void generateConditionConfigDO(DynamicConditionDTO dynamicCondition, List<DynamicConditionConfigDO> tmpList, List<JSONObject> conversionFilterCondition) {
        if (DynamicConditionTypeEnum.SINGLE == dynamicCondition.getType()) {
            DynamicSingleConditionDTO dynamicSingleConditionDTO = (DynamicSingleConditionDTO)dynamicCondition;
            DynamicConditionConfigDO dynamicConditionConfigDO = new DynamicConditionConfigDO();
            dynamicConditionConfigDO.setLeft(dynamicSingleConditionDTO.getLeft());
            dynamicConditionConfigDO.setOp(dynamicSingleConditionDTO.getOp());
            dynamicConditionConfigDO.setType(dynamicSingleConditionDTO.getType());
            dynamicConditionConfigDO.setRight(dynamicSingleConditionDTO.getRight());
            dynamicConditionConfigDO.setLeftValueType(dynamicSingleConditionDTO.getLeft_value_type());
            dynamicConditionConfigDO.setRightValueType(dynamicSingleConditionDTO.getRight_value_type());
            tmpList.add(dynamicConditionConfigDO);
        } else {
            this.dealCondition(conversionFilterCondition, (DynamicGroupConditionDTO)dynamicCondition);
        }
    }

    private void setActionParams(MonitorRuleDTO ruleDTO, MonitorRuleProductConfig productConfig) throws DWBusinessException {
        List actionParamConfigDOs = productConfig.getActionParams();
        if (CollectionUtils.isNotEmpty((Collection)actionParamConfigDOs)) {
            ArrayList<ActionParamDTO> actionParamDTOs = new ArrayList<ActionParamDTO>();
            for (ActionParamConfigDO configDO : actionParamConfigDOs) {
                actionParamDTOs.add(ActionParamDTO.parseFromDO(configDO));
            }
            if (CollectionUtils.isNotEmpty(actionParamDTOs)) {
                ruleDTO.setAction_params(actionParamDTOs);
            }
        }
    }
}

