/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.rule.parameter;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.rule.AbstractMonitorRuleMechanismParameterService;
import com.digiwin.athena.knowledgegraph.rule.model.parameter.MechanismParameterReqDO;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;

@Service
@MyExceptionHandler
public class FrequencyTypeMechanismParameterService
extends AbstractMonitorRuleMechanismParameterService<MechanismParameterReqDO, TriggerDTO> {
    private static final Logger log = LoggerFactory.getLogger(FrequencyTypeMechanismParameterService.class);
    @Autowired
    private MechanismService mechanismService;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    private static final String DISPLAY_TYPE = "FREQUENCY";
    private static final String FIX_INTERVAL = "fixInterval";

    @Override
    public boolean accept(String code) {
        Criteria criteria = Criteria.where((String)"displayType").is((Object)DISPLAY_TYPE);
        List<VariableDefinition> variableDefinitions = null;
        try {
            variableDefinitions = this.dataPickService.find(criteria, VariableDefinition.class, "variableDefinition");
        }
        catch (DWBusinessException e) {
            log.error("\u63a7\u5236\u80fd\u529b\u4f7f\u7528\u4fa6\u6d4b\u7c7b\u578b\u53c2\u6570\u51fa\u9519\uff1a", (Throwable)e);
            variableDefinitions = Collections.emptyList();
        }
        List codes = variableDefinitions.stream().map(CodedEntity::getCode).collect(Collectors.toList());
        return codes.contains(code);
    }

    @Override
    public TriggerDTO parse(MechanismParameterReqDO mechanismParameterReqDO) {
        try {
            Map map = (Map)this.mechanismService.getVariable(mechanismParameterReqDO.getVariableCode(), mechanismParameterReqDO.getTenantId());
            Object o = map.get(mechanismParameterReqDO.getVariableCode());
            if (o == null) {
                return null;
            }
            String value = null;
            if (o instanceof List) {
                List list = (List)o;
                if (list.isEmpty()) {
                    return null;
                }
                value = (String)list.get(0);
            } else if (o instanceof String) {
                value = String.valueOf(o);
            }
            if (null == value || value.isEmpty()) {
                return null;
            }
            String[] split = value.split(";");
            if (split.length != 2) {
                throw new DWBusinessException("\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
            }
            TriggerDTO triggerDTO = new TriggerDTO();
            String time = split[1] + ":00";
            LocalDateTime localDateTime = LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss"));
            triggerDTO.setStart_time(localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            String frequency = split[0];
            if (frequency.startsWith(FIX_INTERVAL)) {
                frequency = frequency.substring(FIX_INTERVAL.length());
            }
            String cycle = frequency.substring(0, 1);
            String timePoint = frequency.substring(1);
            switch (cycle) {
                case "F": {
                    triggerDTO.setRepeat_type(Integer.valueOf(1));
                    triggerDTO.setFrequency(Integer.valueOf(Integer.parseInt(timePoint)));
                    break;
                }
                case "H": {
                    triggerDTO.setRepeat_type(Integer.valueOf(2));
                    triggerDTO.setFrequency(Integer.valueOf(Integer.parseInt(timePoint)));
                    break;
                }
                case "D": {
                    triggerDTO.setRepeat_type(Integer.valueOf(3));
                    triggerDTO.setFrequency(Integer.valueOf(StringUtils.isEmpty((CharSequence)timePoint) ? 1 : Integer.parseInt(timePoint)));
                    break;
                }
                case "W": {
                    triggerDTO.setWeekly(Integer.valueOf(1));
                    triggerDTO.setByday(FrequencyTypeMechanismParameterService.convertWeekDay(timePoint));
                    break;
                }
                case "M": {
                    triggerDTO.setMonthly(Integer.valueOf(1));
                    triggerDTO.setBymonthday((Object)timePoint);
                    break;
                }
            }
            return triggerDTO;
        }
        catch (DWBusinessException e) {
            log.error("knowledgegraph,getVariable \u5f02\u5e38{},{}", (Object)mechanismParameterReqDO.getVariableCode(), (Object)e.getMessage());
            return null;
        }
    }

    private static String convertWeekDay(String weekDay) {
        switch (weekDay) {
            case "1": {
                return "MO";
            }
            case "2": {
                return "TU";
            }
            case "3": {
                return "WE";
            }
            case "4": {
                return "TH";
            }
            case "5": {
                return "FR";
            }
            case "6": {
                return "SA";
            }
            case "7": {
                return "SU";
            }
        }
        return null;
    }
}

