/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import com.digiwin.athena.knowledgegraph.domain.qr.TaskAndActivity;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class KgInnerService {
    private Logger logger = LoggerFactory.getLogger(KgInnerService.class);
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplateSystem;
    @Autowired
    TaskRepository taskRepository;
    private static ThreadLocal<String> tenantVersionHolder = new ThreadLocal();

    public String currentTenantVersion() {
        String version = null;
        try {
            String tenantId = AthenaUtils.getTenantId();
            version = this.getTenantVersion(tenantId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == version) {
            version = "2.0";
        }
        return version;
    }

    public String getTenantVersion(String tenantId) {
        boolean timedTask = false;
        String version = null;
        try {
            version = (String)DWServiceContext.getContext().getRequestHeader().get(tenantId + "tenantVersion");
        }
        catch (Exception e) {
            timedTask = true;
            this.logger.info("getTenantVersion warn");
        }
        if (null != version) {
            return version;
        }
        String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":tenantversion";
        this.logger.info("getTenantVersion:{}", (Object)tenantId);
        version = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
        if (null != version) {
            DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion", version);
            return version;
        }
        TenantEntity tenantEntity = (TenantEntity)((Object)this.mongoTemplateSystem.findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantEntity.class));
        if (null == tenantEntity || null == tenantEntity.getVersion()) {
            version = "2.0";
            this.logger.warn("P.KG.500.0006\uff0cmessage\uff1a{}", (Object)I18nUtils.getValue("knowledgegraph.tenantEmpty", tenantId));
        } else {
            version = tenantEntity.getVersion();
        }
        this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)version, 7200L, TimeUnit.SECONDS);
        if (!timedTask) {
            DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion", version);
        }
        return version;
    }

    public Activity activityBasic(String taskId, String activityCode) throws DWBusinessException {
        String tenantVersion;
        String tenantId = AthenaUtils.getTenantId();
        TaskAndActivity tt = this.taskRepository.findTaskAndActivity(tenantId, taskId, activityCode, tenantVersion = this.getTenantVersion(tenantId));
        if (null != tt && null != tt.getActivity()) {
            Activity activity = tt.getActivity();
            Activity activityBetter = this.findBetterActivity(tenantId, activityCode, activity.getVersion());
            return activityBetter;
        }
        return null;
    }

    public Activity findBetterActivity(String tenantId, String activityCode, String activityVersion) throws DWBusinessException {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)activityCode).and("version").is((Object)activityVersion));
        Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)activityCode).and("version").is((Object)activityVersion).and("tenantId").is((Object)tenantId));
        Activity defaultActivity = (Activity)this.mongoTemplateSystem.findOne(query, Activity.class, "activityConfigs");
        Activity tenantActivity = (Activity)this.mongoTemplateUser.findOne(query2, Activity.class, "activityConfigs");
        if (null != tenantActivity) {
            AthenaUtils.mergeObject(tenantActivity, defaultActivity);
        }
        return defaultActivity;
    }

    public static void cleanThreads() {
        tenantVersionHolder.remove();
    }
}

