/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ActionRequestMetadataDTO;
import com.digiwin.athena.kg.action.ActionResponseMetadataDTO;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import io.seata.common.util.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KgService {
    private static final Logger log = LoggerFactory.getLogger(KgService.class);
    @Value(value="${knowledgeGraphUrl}")
    private String knowledgeGraphUrl;
    private String kghost = null;
    @Autowired
    HttpServletRequest request;
    @Autowired
    @Qualifier(value="routeRestTemplate")
    RestTemplate restTemplate;
    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private DataPickService dataPickService;

    public Object requestKg(String service, String httpMethod, Map<String, Object> params) {
        try {
            HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)new HttpHeaders());
            ResponseEntity resEntity = this.restTemplate.exchange(this.knowledgeGraphUrl + service, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            JSONObject result = JSON.parseObject((String)JSON.toJSONString((Object)resEntity.getBody()));
            if (null != result && result.getIntValue("status") == HttpStatus.OK.value()) {
                return result;
            }
        }
        catch (Exception e) {
            log.error("requestKg mdc:{}", (Throwable)e);
        }
        return null;
    }

    public Object requestKg(String service, String httpMethod, Map<String, Object> params, String routerKey) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.set("routerKey", routerKey);
            HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
            ResponseEntity resEntity = this.restTemplate.exchange(this.knowledgeGraphUrl + service, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            JSONObject result = JSON.parseObject((String)JSON.toJSONString((Object)resEntity.getBody()));
            if (null != result && result.getIntValue("status") == HttpStatus.OK.value()) {
                return result;
            }
        }
        catch (Exception e) {
            log.error("requestKg mdc:{}", (Throwable)e);
        }
        return null;
    }

    public List<ApiDataFieldMetadataDTO> getActionParameters(String actionId, String tenantId, String tenantVersion) {
        EspActionMetadataDTO responseDTO = null;
        try {
            responseDTO = this.getActionMetadata(actionId, tenantId, tenantVersion);
        }
        catch (Exception e) {
            log.error("getActionParameters error:{}", (Throwable)e);
        }
        if (responseDTO != null && responseDTO.getRequest() != null) {
            return responseDTO.getRequest().getParameters();
        }
        return Collections.emptyList();
    }

    public ApiDataFieldMetadataDTO getActionResponse(String actionId, String tenantId, String tenantVersion) {
        EspActionMetadataDTO responseDTO = null;
        try {
            responseDTO = this.getActionMetadata(actionId, tenantId, tenantVersion);
        }
        catch (Exception e) {
            log.error("getActionResponse error:{}", (Throwable)e);
        }
        if (responseDTO != null && responseDTO.getRequest() != null) {
            return responseDTO.getResponse().getData();
        }
        return null;
    }

    public EspActionMetadataDTO getActionMetadata(String actionId, String tenantId, String tenantVersion) throws Exception {
        List actionAndLabels = this.dataPickService.excludeWithSameCode(this.actionRepository.findByActionIdAndVersion(actionId, tenantVersion));
        if (CollectionUtils.isEmpty(actionAndLabels)) {
            throw new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionId, tenantId));
        }
        Action action = (Action)actionAndLabels.get(0);
        EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
        metadataDTO.setActionId(actionId);
        metadataDTO.setServiceName(action.getServiceName());
        metadataDTO.setIdempotency(action.getIdempotency());
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray((String)action.getRequest_parameters(), ApiDataFieldMetadataDTO.class));
        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData((ApiDataFieldMetadataDTO)JSON.parseObject((String)action.getResponse_object(), ApiDataFieldMetadataDTO.class));
        metadataDTO.setRequest(requestMetadataDTO);
        metadataDTO.setResponse(responseMetadataDTO);
        return metadataDTO;
    }
}

