/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kg.report.hz.model.assistDimension.AssistDimensionConfig;
import com.digiwin.athena.kg.report.hz.model.assistDimension.AssistDimensionTenantConfig;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.service.IAssistDimensionService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class AssistDimensionService
implements IAssistDimensionService {
    private static final Logger log = LoggerFactory.getLogger(AssistDimensionService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    KgInnerService kgInnerService;

    @Override
    public Object postQueryAssistDimension(String appCode, List<String> dimensions) throws Exception {
        List assistDimensionTenantConfigs;
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        String tenantId = AthenaUtils.getTenantId();
        Map<String, List> resultMap = dimensions.stream().collect(Collectors.toMap(dimension -> dimension, dimension -> Collections.emptyList(), (existing, replacement) -> existing));
        List assistDimensionConfigs = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"key").in(dimensions).and("appCode").is((Object)appCode).and("version").is((Object)tenantVersion)), AssistDimensionConfig.class);
        if (!CollectionUtils.isEmpty((Collection)assistDimensionConfigs)) {
            resultMap.putAll(assistDimensionConfigs.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll));
        }
        if (!CollectionUtils.isEmpty((Collection)(assistDimensionTenantConfigs = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"key").in(dimensions).and("appCode").is((Object)appCode).and("tenantId").is((Object)tenantId)), AssistDimensionTenantConfig.class)))) {
            resultMap.putAll(assistDimensionTenantConfigs.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll));
        }
        return resultMap;
    }
}

