/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.po.CommonResp;
import com.digiwin.athena.knowledgegraph.po.MongoCrudReq;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IBatchService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.model.BatchRequest;
import com.digiwin.athena.knowledgegraph.service.model.TaskActivityReq;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.bson.types.ObjectId;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Lang
@Service
public class BatchService
implements IBatchService {
    @Autowired
    TaskRepository taskRepository;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    KgInnerService kgInnerService;

    @Override
    public Object postTaskBasic(BatchRequest q) throws DWBusinessException {
        if (CollectionUtils.isEmpty(q.getCodes())) {
            return null;
        }
        List datamapTasks = this.dataMapService.batchProjects(q.getCodes());
        return datamapTasks;
    }

    @Override
    public Object postActivityBasic(BatchRequest q) throws DWBusinessException {
        if (CollectionUtils.isEmpty(q.getTaskAndActivities())) {
            return null;
        }
        ArrayList<String> codes2 = new ArrayList<String>();
        int len = q.getTaskAndActivities().size();
        for (int i = 0; i < len; ++i) {
            TaskActivityReq ta = q.getTaskAndActivities().get(i);
            if (null == ta.getTaskCode() || null == ta.getActivityCode()) continue;
            codes2.add(ta.getActivityCode());
        }
        List datamapActivities = this.dataMapService.batchTasks(codes2);
        return datamapActivities;
    }

    @Override
    public CommonResp postMongo(MongoCrudReq q) throws DWBusinessException {
        MongoTemplate template = this.mongoTemplate;
        if ("user".equalsIgnoreCase(q.getDb())) {
            template = this.mongoTemplateUser;
        }
        CommonResp obj = new CommonResp();
        Query query1 = new Query();
        q.getQuery().forEach((k, v) -> {
            if (v instanceof Collection) {
                ArrayList list = new ArrayList();
                Collection collection = (Collection)v;
                collection.forEach(ele -> list.add(ele));
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)k).in(list));
            } else {
                query1.addCriteria((CriteriaDefinition)Criteria.where((String)k).is(v));
            }
        });
        switch (q.getOp()) {
            case "select": {
                List list = template.find(query1, Map.class, q.getCol());
                for (Map doc : list) {
                    try {
                        ObjectId objectId = (ObjectId)doc.get("_id");
                        doc.put("_id", objectId.toHexString());
                    }
                    catch (Exception objectId) {}
                }
                obj.setData(list);
                break;
            }
            case "insert": {
                template.insert((Collection)q.getDocs(), q.getCol());
                break;
            }
            case "save": {
                Map doc = (Map)q.getDoc();
                String _id = (String)doc.get("_id");
                if (null != _id) {
                    ObjectId objectId = new ObjectId(_id);
                    doc.put("_id", objectId);
                }
                template.save(q.getDoc(), q.getCol());
                break;
            }
        }
        return obj;
    }
}

