/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import com.digiwin.athena.knowledgegraph.po.DeployMessagePO;
import com.digiwin.athena.knowledgegraph.service.IDeployService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.ConvertObjectMapper;
import com.digiwin.athena.knowledgegraph.vo.DeployRequest;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@Service
public class DeployService
implements IDeployService {
    private static final Logger log = LoggerFactory.getLogger(DeployService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSys;
    @Autowired
    private ConvertObjectMapper convertObjectMapper;
    @Autowired
    TenantService tenantService;

    @Override
    public Object postQueryDeploy(DeployRequest request) throws Exception {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((CharSequence)request.getMongoId())) {
            criteria.and("_id").is((Object)request.getMongoId());
            query.addCriteria((CriteriaDefinition)criteria);
            List deployMessages = this.mongoTemplateSys.find(query, DeployMessagePO.class);
            TranslateUtil.dealLangRecusive((Object)deployMessages, (String)AthenaUtils.getCurrentLocale());
            return this.convertObjectMapper.deployPoToVo(deployMessages);
        }
        if (ObjectUtils.isEmpty((Object)request.getEndTime())) {
            criteria.and("updateTime").gte((Object)request.getStartTime());
        } else {
            criteria.and("updateTime").gte((Object)request.getStartTime()).lte((Object)request.getEndTime());
        }
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add("athena");
        List<String> appCodes = this.tenantService.getAppCodes();
        codeList.addAll(appCodes);
        criteria.and("code").in(codeList);
        if (CollectionUtils.isNotEmpty(request.getFiled())) {
            for (String filed : request.getFiled()) {
                query.fields().include(filed);
            }
        }
        query.addCriteria((CriteriaDefinition)criteria);
        long count = this.mongoTemplateSys.count(query, DeployMessagePO.class);
        if (count <= 0L) {
            request.setTotalCount(0);
            return new ArrayList();
        }
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"updateTime")})).skip((long)(request.getPageNum() - 1) * (long)request.getPageNum().intValue()).limit(request.getPageSize().intValue());
        List deployMessages = this.mongoTemplateSys.find(query, DeployMessagePO.class);
        TranslateUtil.dealLangRecusive((Object)deployMessages, (String)AthenaUtils.getCurrentLocale());
        return this.convertObjectMapper.deployPoToVo(deployMessages);
    }

    @Override
    public Object put(List<DeployMessagePO> deployMessagePOList) throws Exception {
        this.mongoTemplateSys.insert(deployMessagePOList, DeployMessagePO.class);
        return "success";
    }

    @Override
    public Object delete(List<String> ids) throws Exception {
        for (String id : ids) {
            Query query = new Query();
            Criteria criteria = new Criteria();
            criteria.and("_id").is((Object)new ObjectId(id));
            query.addCriteria((CriteriaDefinition)criteria);
            this.mongoTemplateSys.remove(query, DeployMessagePO.class);
        }
        return "success";
    }
}

