/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.AtmcUtils;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaff;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaffCatgInfoDto;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaffDto;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaffSumInfoDto;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.TaskHistory;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IDigitalStaffService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.knowledgegraph.utils.ObjectUseUtil;
import com.luhuiguo.chinese.ChineseUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Lang
@Service
public class DigitalStaffService
implements IDigitalStaffService {
    private static final Logger log = LoggerFactory.getLogger(DigitalStaffService.class);
    @Autowired
    private DataPickService dataPickService;
    private static final String EOCDUTYLIST = "/api/eoc/v2/duty/list";
    private static final String ENHANCE = "enhance";
    private static final String DIGITALSTAFF = "digitalStaff";
    private static final String APPCODE = "appCode";
    private static final String APPNAME = "appName";
    private static final String DESCRIPTION = "description";
    private static final String TASK = "task";
    private static final String ACTIVITY = "activity";
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    CACUtils cacUtils;
    @Autowired
    AtmcUtils atmcUtils;
    @Autowired
    TenantService tenantService;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    TaskService taskService;
    @Autowired
    AppService appService;
    @Autowired
    KgInnerService kgInnerService;
    @Value(value="${iamApToken}")
    String appToken;

    @Override
    public List<DigitalStaffDto> getList() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        log.info("language:" + locale);
        Map<String, Map<String, String>> appDigiStaffInfo = this.getDigitalStaffCodeListByTenantId(locale);
        if (appDigiStaffInfo.isEmpty()) {
            log.info("\u5f53\u524d\u79df\u6237\u65e0\u6cd5\u83b7\u53d6\u589e\u5f3a\u5e94\u7528\u4fe1\u606f");
            return null;
        }
        ArrayList<String> digitalStaffCodeList = new ArrayList<String>(appDigiStaffInfo.keySet());
        List<DigitalStaff> digitalStaffList = this.getDigitalStaffInfoList(digitalStaffCodeList, locale, tenantVersion);
        JSONArray functionList = this.getFunctionList();
        ArrayList<DigitalStaffDto> tempDigiStaffInfoList = new ArrayList<DigitalStaffDto>();
        for (DigitalStaff digitalStaff : digitalStaffList) {
            DigitalStaffDto digitalStaffInfo = new DigitalStaffDto();
            BeanUtils.copyProperties((Object)digitalStaffInfo, (Object)digitalStaff);
            String gradeName = this.getGradeNameByLang(digitalStaffInfo.getGradeCode(), locale);
            digitalStaffInfo.setGradeName(gradeName);
            String functionName = this.getFunctionName(functionList, digitalStaffInfo.getFunctionCode());
            digitalStaffInfo.setFunctionName(functionName);
            Map<String, String> appCodeAndNameAndDesc = appDigiStaffInfo.get(digitalStaffInfo.getCode());
            String appCode = appCodeAndNameAndDesc.get(APPCODE);
            String appName = appCodeAndNameAndDesc.get(APPNAME);
            String appDesc = appCodeAndNameAndDesc.get(DESCRIPTION);
            Map<String, String> appInfo = this.cacUtils.getAppAuthDate(tenantId, appCode);
            String startDate = appInfo.get("effectiveTime");
            String endDate = appInfo.get("expiredTime");
            String startDate2 = startDate.replace("-", "/");
            String endDate2 = endDate.replace("-", "/");
            digitalStaffInfo.setStartDate(startDate);
            digitalStaffInfo.setEndDate(endDate);
            digitalStaffInfo.setValidPeriod(startDate2 + " - " + endDate2);
            digitalStaffInfo.setTitleName(appName);
            digitalStaffInfo.setWorkTargetDescribe(appDesc);
            List<ApplicationRelation> applicationRelaInfo = this.getTaskInfoByAppCode(appCode, tenantId);
            List<String> activitiesCodeList = this.getActivityInfoByAppCode(appCode, tenantId);
            String taskNameStr = "";
            HashSet<String> activityNameList = new HashSet<String>();
            Map<String, Object> findActivityCode = new HashMap<String, Object>();
            if (CollectionUtils.isNotEmpty(applicationRelaInfo)) {
                Map<String, Object> taskAndActivity = this.getTaskAndActivityInfo(applicationRelaInfo, activitiesCodeList, locale, findActivityCode);
                Object object = taskAndActivity.get("taskName");
                Object activitiesCodeNameObj = taskAndActivity.get("activitiesCodeNameMap");
                taskNameStr = ObjectUtils.isEmpty((Object)object) ? "" : (String)object;
                findActivityCode = ObjectUtils.isEmpty((Object)activitiesCodeNameObj) ? new HashMap() : (Map)activitiesCodeNameObj;
            }
            this.getActivityNameDirect(activitiesCodeList, "", findActivityCode);
            digitalStaffInfo.setProjectDescribe(taskNameStr);
            for (Map.Entry entry : findActivityCode.entrySet()) {
                Object nameObj = entry.getValue();
                if (null == nameObj || ObjectUtils.isEmpty(nameObj)) continue;
                activityNameList.add((String)nameObj);
            }
            Integer finishJobNum = this.getWholeFinishJobNum(activityNameList);
            digitalStaffInfo.setFinishJobNum(finishJobNum);
            String string = appName + " " + finishJobNum.toString() + " " + this.handleLang("\u6b21", locale);
            digitalStaffInfo.setSpliceStr(string);
            digitalStaffInfo.setEducateSetting(false);
            digitalStaffInfo.setAppCode(appCode);
            String relaAppCode = "";
            String relaAppName = "";
            List<ApplicationRelation> applicationRelationList = this.appService.getAppCodeByTypeAndCode(ENHANCE, appCode);
            if (CollectionUtils.isNotEmpty(applicationRelationList)) {
                ApplicationRelation appRela = applicationRelationList.get(0);
                relaAppCode = appRela.getAppCode();
                relaAppName = appRela.getAppName();
            }
            digitalStaffInfo.setRelaAppCode(relaAppCode);
            digitalStaffInfo.setRelaAppName(relaAppName);
            tempDigiStaffInfoList.add(digitalStaffInfo);
        }
        return tempDigiStaffInfoList;
    }

    @Override
    public DigitalStaffSumInfoDto getVisualizeList() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        Map<String, Map<String, String>> appDigiStaffInfo = this.getDigitalStaffCodeListByTenantId(locale);
        ArrayList<String> digitalStaffCodeList = new ArrayList<String>(appDigiStaffInfo.keySet());
        if (appDigiStaffInfo.isEmpty()) {
            log.info("\u5f53\u524d\u79df\u6237\u65e0\u6cd5\u83b7\u53d6\u589e\u5f3a\u5e94\u7528\u4fe1\u606f");
            return null;
        }
        List<DigitalStaff> digitalStaffList = this.getDigitalStaffInfoList(digitalStaffCodeList, locale, tenantVersion);
        ArrayList<DigitalStaffDto> tempDigiStaffInfoList = new ArrayList<DigitalStaffDto>();
        DigitalStaffSumInfoDto result = new DigitalStaffSumInfoDto();
        ArrayList<DigitalStaffCatgInfoDto> digitalStaffCatgInfo = new ArrayList<DigitalStaffCatgInfoDto>();
        int digitalStaffNum = 0;
        int totalFinishJobNum = 0;
        for (DigitalStaff digitalStaff : digitalStaffList) {
            ++digitalStaffNum;
            DigitalStaffDto digitalStaffDto = new DigitalStaffDto();
            BeanUtils.copyProperties((Object)digitalStaffDto, (Object)digitalStaff);
            Map<String, String> appCodeAndNameAndDesc = appDigiStaffInfo.get(digitalStaffDto.getCode());
            String appCode = appCodeAndNameAndDesc.get(APPCODE);
            String gradeName = this.getGradeNameByLang(digitalStaffDto.getGradeCode(), locale);
            digitalStaffDto.setGradeName(gradeName);
            List<ApplicationRelation> applicationRelaInfo = this.getTaskInfoByAppCode(appCode, tenantId);
            List<String> activitiesCodeList = this.getActivityInfoByAppCode(appCode, tenantId);
            HashSet<String> activityNameList = new HashSet<String>();
            Map<String, Object> findActivityCode = new HashMap<String, Object>();
            if (CollectionUtils.isNotEmpty(applicationRelaInfo)) {
                Map<String, Object> taskAndActivity = this.getTaskAndActivityInfo(applicationRelaInfo, activitiesCodeList, locale, findActivityCode);
                Object object = taskAndActivity.get("activitiesCodeNameMap");
                findActivityCode = ObjectUtils.isEmpty((Object)object) ? new HashMap() : (Map)object;
            }
            this.getActivityNameDirect(activitiesCodeList, "", findActivityCode);
            for (Map.Entry entry : findActivityCode.entrySet()) {
                Object nameObj = entry.getValue();
                if (null == nameObj || ObjectUtils.isEmpty(nameObj)) continue;
                activityNameList.add((String)nameObj);
            }
            Map<String, Object> jobInfo = this.getFinishJobInfo(activityNameList, locale);
            int n = (Integer)jobInfo.get("totalFinishjobNum");
            totalFinishJobNum += n;
            digitalStaffDto.setFinishJobNum(n);
            digitalStaffDto.setFinishJobList((List)jobInfo.get("taskFinishList"));
            digitalStaffDto.setJobList((String)jobInfo.get("jobList"));
            digitalStaffDto.setAppCode(appCode);
            String relaAppCode = "";
            String relaAppName = "";
            List<ApplicationRelation> applicationRelationList = this.appService.getAppCodeByTypeAndCode(ENHANCE, appCode);
            if (CollectionUtils.isNotEmpty(applicationRelationList)) {
                ApplicationRelation appRela = applicationRelationList.get(0);
                relaAppCode = appRela.getAppCode();
                relaAppName = appRela.getAppName();
            }
            digitalStaffDto.setRelaAppCode(relaAppCode);
            digitalStaffDto.setRelaAppName(relaAppName);
            tempDigiStaffInfoList.add(digitalStaffDto);
        }
        HashMap<String, List> classify = new HashMap<String, List>();
        for (DigitalStaffDto digitalStaffDto : tempDigiStaffInfoList) {
            ArrayList temp = new ArrayList();
            String category = digitalStaffDto.getCategoryCode();
            if (classify.containsKey(category)) continue;
            classify.put(digitalStaffDto.getCategoryCode(), temp);
        }
        for (DigitalStaffDto digitalStaffDto : tempDigiStaffInfoList) {
            String catgCode = digitalStaffDto.getCategoryCode();
            List temp = (List)classify.get(catgCode);
            temp.add(digitalStaffDto);
            classify.put(catgCode, temp);
        }
        for (Map.Entry entry : classify.entrySet()) {
            DigitalStaffCatgInfoDto tempDto = new DigitalStaffCatgInfoDto();
            tempDto.setCategoryCode((String)entry.getKey());
            tempDto.setCategoryName(((DigitalStaffDto)((List)entry.getValue()).get(0)).getCategoryName());
            tempDto.setEmployee((List)entry.getValue());
            HashMap<String, Integer> categoryNoSettingNum = new HashMap<String, Integer>();
            categoryNoSettingNum.put("ASSISTANT", 0);
            categoryNoSettingNum.put("EXPERT", 0);
            categoryNoSettingNum.put("MASTER", 0);
            tempDto.setCategoryNoSettingNum(categoryNoSettingNum);
            digitalStaffCatgInfo.add(tempDto);
        }
        result.setDigitalStaffNum(digitalStaffNum);
        result.setTotalFinishJobNum(totalFinishJobNum);
        result.setDigital(digitalStaffCatgInfo);
        result.setNoSettingTotalNum(0);
        return result;
    }

    private List<ApplicationRelation> getTaskInfoByAppCode(String appCode, String tenantId) throws Exception {
        return this.appService.getApplicationRelationByTypeAndAppCode(tenantId, TASK, appCode);
    }

    private List<String> getActivityInfoByAppCode(String appCode, String tenantId) throws Exception {
        List<String> activitiesCodeList = new ArrayList<String>();
        List<ApplicationRelation> applicationRelation = this.appService.getApplicationRelationByTypeAndAppCode(tenantId, ACTIVITY, appCode);
        if (null != applicationRelation) {
            activitiesCodeList = applicationRelation.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        }
        return activitiesCodeList;
    }

    private Map<String, Object> getTaskAndActivityInfo(List<ApplicationRelation> apprelaList, List<String> activitiesCodeList, String locale, Map<String, Object> findActivityCode) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder proName = new StringBuilder();
        for (ApplicationRelation temp : apprelaList) {
            Object activitieList;
            String taskId = temp.getCode();
            Object taskInfo = this.taskService.getActivitiesWithMultiLanguage(taskId);
            if (ObjectUtils.isEmpty((Object)taskInfo)) continue;
            String combinName = "taskName." + locale;
            Object taskName = JSONPath.eval((Object)taskInfo, (String)combinName);
            if (null != taskName && !StringUtils.isEmpty((Object)taskName)) {
                proName = proName.append(taskName).append(" ");
            }
            if (null == (activitieList = JSONPath.eval((Object)taskInfo, (String)"activities")) || ObjectUtils.isEmpty((Object)activitieList)) continue;
            this.getActivityName(activitieList, activitiesCodeList, locale, findActivityCode);
        }
        result.put("activitiesCodeNameMap", findActivityCode);
        String taskNameStr = proName.toString();
        String nameStr = "";
        if (StringUtils.isEmpty((Object)taskNameStr)) {
            result.put("taskName", nameStr);
        } else {
            nameStr = taskNameStr.substring(0, taskNameStr.length() - 1);
            result.put("taskName", nameStr);
        }
        return result;
    }

    private void getActivityName(Object activitieList, List<String> activitiesCodeList, String locale, Map<String, Object> findActivityCode) {
        List activityInfo = (List)activitieList;
        for (Activity temp : activityInfo) {
            String code = temp.getCode();
            if (!activitiesCodeList.contains(code) || findActivityCode.containsKey(code)) continue;
            Object activityNameMap = temp.getActivityName();
            Object activityName = ObjectUseUtil.getValueFromObject(activityNameMap, locale);
            findActivityCode.put(code, activityName);
        }
    }

    private void getActivityNameDirect(List<String> activitiesCodeList, String taskId, Map<String, Object> findActivityCode) throws Exception {
        for (String activitiesCode : activitiesCodeList) {
            if (findActivityCode.containsKey(activitiesCode)) continue;
            Object taskInfo = this.taskService.getActivityDefinition(taskId, activitiesCode, "");
            Object taskName = ObjectUseUtil.getValueFromObject(taskInfo, "name");
            if (ObjectUtils.isEmpty((Object)taskInfo)) continue;
            findActivityCode.put(activitiesCode, taskName);
        }
    }

    private Map<String, Map<String, String>> getDigitalStaffCodeListByTenantId(String locale) throws Exception {
        HashMap<String, Map<String, String>> appDigiStaffInfo = new HashMap<String, Map<String, String>>();
        String tenantId = AthenaUtils.getTenantId();
        List<String> appCodes = this.dataPickService.tenantInitializedAppCodes(AthenaUtils.getTenantId());
        if (CollectionUtils.isEmpty(appCodes)) {
            log.info("\u5f53\u524d\u79df\u6237\u6ca1\u6709\u76f8\u5173\u5e94\u7528\u4fe1\u606f");
            return appDigiStaffInfo;
        }
        for (String appCode : appCodes) {
            Boolean authOrNot;
            Criteria criteria = Criteria.where((String)"code").is((Object)appCode).and("category").is((Object)ENHANCE).and("extendType").is((Object)DIGITALSTAFF);
            Application applicationInfo = this.dataPickService.findOneByCondition(criteria, Application.class, "application");
            if (applicationInfo == null || !(authOrNot = this.cacUtils.getAppAuth(tenantId, appCode)).booleanValue()) continue;
            LanguageUtil.processLocaleLanguage(applicationInfo, locale);
            HashMap<String, String> appCodeAndName = new HashMap<String, String>();
            appCodeAndName.put(APPCODE, appCode);
            appCodeAndName.put(APPNAME, applicationInfo.getName());
            appCodeAndName.put(DESCRIPTION, applicationInfo.getDescription());
            appDigiStaffInfo.put(applicationInfo.getExtendData(), appCodeAndName);
        }
        return appDigiStaffInfo;
    }

    private List<DigitalStaff> getDigitalStaffInfoList(List<String> dsCodeList, String locale, String tenantVersion) throws NoSuchFieldException, IllegalAccessException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").in(dsCodeList).and("version").is((Object)tenantVersion));
        List digitalStaffList = this.mongoTemplateSystem.find(query, DigitalStaff.class, DIGITALSTAFF);
        if (CollectionUtils.isEmpty((Collection)digitalStaffList)) {
            log.info("\u6682\u65e0\u6570\u5b57\u5458\u5de5\u4fe1\u606f");
            return new ArrayList<DigitalStaff>();
        }
        LanguageUtil.processLocaleLanguage(digitalStaffList, locale);
        return digitalStaffList;
    }

    public String getGradeNameByLang(String code, String language) {
        String gradeName = "";
        switch (language) {
            case "zh_CN": 
            case "zh_TW": {
                if (GradeCode.ASSISTANT.name().equals(code)) {
                    gradeName = "\u52a9\u624b\u578b";
                    break;
                }
                if (GradeCode.EXPERT.name().equals(code)) {
                    gradeName = "\u80fd\u624b\u578b";
                    break;
                }
                if (!GradeCode.MASTER.name().equals(code)) break;
                gradeName = "\u9ad8\u624b\u578b";
                break;
            }
            case "en_US": {
                if (GradeCode.ASSISTANT.name().equals(code)) {
                    gradeName = "Assistant";
                    break;
                }
                if (GradeCode.EXPERT.name().equals(code)) {
                    gradeName = "Expert";
                    break;
                }
                if (!GradeCode.MASTER.name().equals(code)) break;
                gradeName = "Master";
                break;
            }
        }
        return gradeName;
    }

    private JSONArray getFunctionList() throws IOException {
        JSONObject resp = AthenaUtils.getEoc(EOCDUTYLIST, null, new HashMap<String, String>(), this.appToken);
        Object data = resp.get((Object)"data");
        JSONArray functionList = ((JSONObject)data).getJSONArray("list");
        return functionList;
    }

    private String getFunctionName(JSONArray functionList, String functionCode) {
        for (Object functionInfo : functionList) {
            if (!functionCode.equals(((JSONObject)functionInfo).get((Object)"id"))) continue;
            return (String)((JSONObject)functionInfo).get((Object)"name");
        }
        return "";
    }

    public Integer getWholeFinishJobNum(Set<String> jobNameList) {
        int wholeFinishJobNum = 0;
        for (String jobName : jobNameList) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("name", jobName);
            param.put("type", "1");
            param.put("state", "0");
            param.put("startTime", null);
            param.put("endTime", null);
            param.put("page", 1);
            param.put("rows", 10000);
            HashMap resp = this.atmcUtils.postAtmcTask(null, JSON.toJSONString(param));
            Object response = resp.get("response");
            int overTaskNum = (Integer)((JSONObject)response).get((Object)"total");
            wholeFinishJobNum += overTaskNum;
            param.put("state", "2");
            HashMap resp2 = this.atmcUtils.postAtmcTask(null, JSON.toJSONString(param));
            Object response2 = resp2.get("response");
            int onTimeTaskNum = (Integer)((JSONObject)response2).get((Object)"total");
            wholeFinishJobNum += onTimeTaskNum;
        }
        return wholeFinishJobNum;
    }

    public Map<String, Object> getFinishJobInfo(Set<String> jobNameList, String language) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<TaskHistory> taskLastTimeList = new ArrayList<TaskHistory>();
        ArrayList<String> taskFinishList = new ArrayList<String>();
        StringBuilder jobList = new StringBuilder().append(this.handleLang("\u5305\u62ec", language)).append(":");
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String curDate = formatter.format(date);
        String startTime = curDate + " 00:00:00";
        String endTime = curDate + " 59:59:59";
        Integer totalFinishjobNum = 0;
        for (String string : jobNameList) {
            Object records22;
            ArrayList<TaskHistory> taskHistoryList = new ArrayList<TaskHistory>();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("name", string);
            param.put("type", "1");
            param.put("state", "0");
            param.put("startTime", startTime);
            param.put("endTime", endTime);
            param.put("page", 1);
            param.put("rows", 10000);
            HashMap resp0 = this.atmcUtils.postAtmcTask(null, JSON.toJSONString(param));
            Object response0 = resp0.get("response");
            int overTaskNum = (Integer)((JSONObject)response0).get((Object)"total");
            param.put("state", "2");
            HashMap resp2 = this.atmcUtils.postAtmcTask(null, JSON.toJSONString(param));
            Object response2 = resp2.get("response");
            int onTimeTaskNum = (Integer)((JSONObject)response2).get((Object)"total");
            int taskTotalNum = overTaskNum + onTimeTaskNum;
            totalFinishjobNum = totalFinishjobNum + taskTotalNum;
            if (taskTotalNum <= 0) continue;
            JSONArray records1 = ((JSONObject)response0).getJSONArray("records");
            for (Object records22 : records1) {
                TaskHistory temp = (TaskHistory)JSONObject.toJavaObject((JSON)((JSON)records22), TaskHistory.class);
                taskHistoryList.add(temp);
            }
            JSONArray records23 = ((JSONObject)response2).getJSONArray("records");
            records22 = records23.iterator();
            while (records22.hasNext()) {
                Object records3 = records22.next();
                TaskHistory temp = (TaskHistory)JSONObject.toJavaObject((JSON)((JSON)records3), TaskHistory.class);
                taskHistoryList.add(temp);
            }
            List taskListSorted = taskHistoryList.stream().sorted(Comparator.comparing(TaskHistory::getEndTime).reversed()).collect(Collectors.toList());
            TaskHistory latstedTask = (TaskHistory)taskListSorted.get(0);
            latstedTask.setTotalJobNum(taskTotalNum);
            taskLastTimeList.add(latstedTask);
        }
        List taskListSorted = taskLastTimeList.stream().sorted(Comparator.comparing(TaskHistory::getEndTime).reversed()).collect(Collectors.toList());
        result.put("totalFinishjobNum", totalFinishjobNum);
        for (TaskHistory taskInfo : taskListSorted) {
            String time = taskInfo.getEndTime().substring(11, 16);
            String temp = time + " " + this.handleLang("\u5b8c\u6210", language) + taskInfo.getTotalJobNum() + this.handleLang("\u9879", language) + taskInfo.getName();
            taskFinishList.add(temp);
            jobList = jobList.append(taskInfo.getName()).append("\u3001");
        }
        result.put("taskFinishList", taskFinishList);
        String string2 = jobList.toString();
        string2 = string2.substring(0, string2.length() - 1);
        result.put("jobList", string2);
        return result;
    }

    public String handleLang(String name, String language) {
        String result = name;
        switch (language) {
            case "zh_CN": {
                ChineseUtils.toSimplified((String)name);
                break;
            }
            case "zh_TW": {
                ChineseUtils.toTraditional((String)name);
                break;
            }
            case "en_US": {
                if ("\u6b21".equals(name)) {
                    result = "second";
                    break;
                }
                if ("\u5305\u62ec".equals(name)) {
                    result = "include";
                    break;
                }
                if ("\u5b8c\u6210".equals(name)) {
                    result = " complete";
                    break;
                }
                if (!"\u9879".equals(name)) break;
                result = "term";
                break;
            }
        }
        return result;
    }

    public static enum GradeCode {
        ASSISTANT,
        EXPERT,
        MASTER;

    }
}

