/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.knowledgegraph.service.IDutyService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.repository.neo4j.DutyRepository;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Lang
@Service
public class DutyService
implements IDutyService {
    static Logger logger = LoggerFactory.getLogger(DutyService.class);
    static Log log = LogFactory.getLog(DutyService.class);
    @Autowired
    private DutyRepository repository;
    @Value(value="${hello1}")
    String hello1;
    @Value(value="${iamApToken}")
    String appToken;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    AppService appService;
    @Autowired
    AppMetaCaller appMetaCaller;

    @Override
    public Object getDutyByCode(String code) {
        Map<String, Object> map = AppMetaCaller.of("code", code);
        RespObject respObject = this.appMetaCaller.call("/duty/dutyByCode", "get", map, RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object getList() {
        RespObject respObject = this.appMetaCaller.call("/duty/list", "get", null, RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object syncAllDuty() throws DWBusinessException {
        RespObject respObject = this.appMetaCaller.call("/duty/syncAllDuty", "get", null, RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object syncAllDuty(String token, String appCode, String tenantId) throws Exception {
        Map<String, Object> map = AppMetaCaller.of("token", token);
        map.put("appCode", appCode);
        map.put("tenantId", tenantId);
        RespObject respObject = this.appMetaCaller.call("/duty/syncAllDuty", "get", map, RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object syncAllDuty(String token) throws DWBusinessException {
        Map<String, Object> map = AppMetaCaller.of("token", token);
        RespObject respObject = this.appMetaCaller.call("/duty/syncAllDuty", "get", map, RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object getTest(String p) {
        Map<String, Object> map = AppMetaCaller.of("p", p);
        RespObject respObject = this.appMetaCaller.call("/duty/test", "get", map, RespObject.class);
        return respObject.getResponse();
    }
}

