/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.activity.ActivityConfig;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.knowledgegraph.domain.mechanism.BacklogVO;
import com.digiwin.athena.knowledgegraph.domain.mechanism.BatchNoticeVO;
import com.digiwin.athena.knowledgegraph.domain.mechanism.NoticeVO;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMechanismEnhancementService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.mechanismEnum.VariableTypeEnum;
import com.digiwin.athena.mechanism.widgets.check.CheckAccordingToStandard;
import com.digiwin.athena.mechanism.widgets.condition.BusinessCondition;
import com.digiwin.athena.mechanism.widgets.condition.ByQuantityCondition;
import com.digiwin.athena.mechanism.widgets.condition.ByTimeCondition;
import com.digiwin.athena.mechanism.widgets.condition.OnTimeCheckRange;
import com.digiwin.athena.mechanism.widgets.condition.OnTimeCheckType;
import com.digiwin.athena.mechanism.widgets.condition.QuantityFixed;
import com.digiwin.athena.mechanism.widgets.condition.QuantityVar;
import com.digiwin.athena.mechanism.widgets.condition.QuantityVarDetail;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionConfig;
import com.digiwin.athena.mechanism.widgets.config.MechanismConditionGroup;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class MechanismEnhancementService
implements IMechanismEnhancementService {
    private static final Logger log = LoggerFactory.getLogger(MechanismEnhancementService.class);
    @Autowired
    TaskService taskService;
    @Autowired
    ActionService actionService;
    @Autowired
    ESPUtils espUtils;
    @Autowired
    IamService iamService;
    @Autowired
    EocService eocService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    IMechanismService iMechanismService;
    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object postTaskInformPersonByEoc(String taskCode, List<BacklogVO> taskList, String checkDataSource, String tenantId, String eocField) throws Exception {
        Activity taskDto = this.getActivity(taskCode);
        Map dataSource = (Map)taskDto.getDataSources().get("data");
        if (CollectionUtils.isEmpty((Map)dataSource)) {
            return null;
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        if (CollectionUtils.isEmpty(taskList)) {
            result.put("data", new ArrayList());
            return result;
        }
        HashSet<String> eocIds = new HashSet<String>();
        if (!CollectionUtils.isEmpty(taskList)) {
            taskList.forEach(task -> {
                String checkField = eocField;
                String[] checkFieldArray = checkField.split("\\.");
                String checkFieldHead = checkFieldArray[0];
                String checkFieldBody = checkFieldArray[1];
                Map<String, Object> executeResult = task.getExecuteResult();
                if (!CollectionUtils.isEmpty(executeResult)) {
                    List dataList = (List)executeResult.get(checkFieldHead);
                    dataList.forEach(dataItem -> {
                        if (dataItem.get(checkFieldBody) instanceof Collection) {
                            eocIds.addAll((Collection)dataItem.get(checkFieldBody));
                        } else {
                            eocIds.add((String)dataItem.get(checkFieldBody));
                        }
                    });
                }
            });
        }
        Set<String> strings = this.transformToUserId(eocIds, tenantId);
        List collect = strings.stream().collect(Collectors.toList());
        result.put("data", collect);
        return result;
    }

    private Activity getActivity(String taskCode) {
        Object taskDef = this.taskService.getTaskInfoFromDataMap(taskCode);
        return JsonUtil.toObject(JSON.toJSONString((Object)taskDef), Activity.class);
    }

    private Set<String> transformToUserId(Set<String> eocIds, String tenantId) throws Exception {
        String token = this.iamService.getTenantToken(tenantId);
        List<String> userIds = this.eocService.getUserIdsByStaffs(new ArrayList<String>(eocIds), token);
        return new HashSet<String>(userIds);
    }

    @Override
    public Object postTaskBizData(String taskCode, List<BacklogVO> taskList, String checkDataSource, String tenantId, CheckAccordingToStandard checkAccordingToStandard) throws Exception {
        HashMap<String, List<BacklogVO>> result = new HashMap<String, List<BacklogVO>>();
        if (!StringUtils.equals((CharSequence)"fixInterval", (CharSequence)checkAccordingToStandard.getStandardPollingRule().getTimeType()) || CollectionUtils.isEmpty(taskList) || !StringUtils.equals((CharSequence)"day", (CharSequence)checkAccordingToStandard.getStandardPollingRule().getInterval())) {
            result.put("data", Collections.EMPTY_LIST);
            return result;
        }
        Activity taskDto = this.getActivity(taskCode);
        Map dataSource = (Map)taskDto.getDataSources().get("data");
        if (CollectionUtils.isEmpty((Map)dataSource)) {
            return Collections.EMPTY_LIST;
        }
        String serviceName = this.getServiceName(tenantId, dataSource);
        String token = this.iamService.getTenantToken(tenantId);
        String finalServiceName = serviceName;
        LoginInfo loginInfo = KgFilter.getLoginInfo();
        if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty((CharSequence)taskDto.getApplication())) {
            loginInfo.setApplication(taskDto.getApplication());
        }
        this.fillTaskExecuteResult(taskList, tenantId, dataSource, token, finalServiceName);
        List<BacklogVO> taskResult = this.checkFilterTaskData(taskList, checkAccordingToStandard, tenantId);
        result.put("data", taskResult);
        return result;
    }

    public Object postSendNotice(List taskBizData, String tenantId, String message, String businessFields) {
        log.warn("\u5f00\u59cb\u53d1\u9001\u4fe1\u606f\uff1a{}", (Object)message);
        Pattern pattern = Pattern.compile("\\$\\{[^}]+\\}");
        if (!MechanismEnhancementService.containsExpression(message, pattern)) {
            return this.degradeToBatchSend(taskBizData, tenantId, message, businessFields);
        }
        if (!CollectionUtils.isEmpty((Collection)taskBizData)) {
            String token = this.iamService.getTenantToken(tenantId);
            taskBizData.forEach(res -> {
                block5: {
                    Object acceptList;
                    block6: {
                        Map object = JsonUtil.toObject(JsonUtil.toJsonString(res), Map.class);
                        acceptList = object.get(businessFields);
                        if (Objects.isNull(object.get(businessFields))) break block5;
                        if (!(acceptList instanceof List)) break block6;
                        List executorNoList = (List)acceptList;
                        for (Object executorNo : executorNoList) {
                            ObjectMapper objectMapper = new ObjectMapper();
                            Map map = (Map)objectMapper.convertValue(res, Map.class);
                            Set<String> userIds = null;
                            try {
                                userIds = this.transformToUserId(Stream.of(String.valueOf(executorNo)).collect(Collectors.toSet()), tenantId);
                                String msgReplace = MechanismEnhancementService.symbolStringMessage(message, map);
                                log.warn("\u66ff\u6362\u540e\u7684\u6d88\u606f\uff1a{}", (Object)msgReplace);
                                if (CollectionUtils.isEmpty(userIds)) continue;
                                this.iamService.dispatcherMessage(token, userIds.stream().collect(Collectors.toList()), msgReplace, tenantId);
                            }
                            catch (Exception e) {
                                log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
                            }
                        }
                        break block5;
                    }
                    if (!(acceptList instanceof String)) break block5;
                    ObjectMapper objectMapper = new ObjectMapper();
                    Map map = (Map)objectMapper.convertValue(res, Map.class);
                    try {
                        String msgReplace = MechanismEnhancementService.symbolStringMessage(message, map);
                        log.warn("\u66ff\u6362\u540e\u7684\u6d88\u606f\uff1a{}", (Object)msgReplace);
                        Set<String> userIds = this.transformToUserId(new HashSet<String>(Collections.singletonList(String.valueOf(acceptList))), tenantId);
                        this.iamService.dispatcherMessage(token, new ArrayList<String>(userIds), msgReplace, tenantId);
                    }
                    catch (Exception e) {
                        log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
                    }
                }
            });
        }
        return ResultBean.success(null);
    }

    private Object degradeToBatchSend(List taskBizData, String tenantId, String message, String businessFields) throws Exception {
        return this.degradeToBatchSend(taskBizData, tenantId, message, businessFields, null);
    }

    private Object degradeToBatchSend(List<Map<String, Object>> taskBizData, String tenantId, String message, String businessFields, List<String> userIds) throws Exception {
        LinkedList<BatchNoticeVO> batchNoticeVOS = new LinkedList<BatchNoticeVO>();
        if (!CollectionUtils.isEmpty(userIds)) {
            BatchNoticeVO batchNoticeVO = new BatchNoticeVO();
            batchNoticeVO.setReceivers(new HashSet<String>(userIds));
            batchNoticeVO.setMsg(message);
            batchNoticeVOS.add(batchNoticeVO);
            return this.postBatchSendNotice(batchNoticeVOS, tenantId);
        }
        HashSet<String> userSet = new HashSet<String>();
        taskBizData.forEach(bizData -> {
            Map object = JsonUtil.toObject(JsonUtil.toJsonString(bizData), Map.class);
            Object acceptList = object.get(businessFields);
            if (!Objects.isNull(object.get(businessFields))) {
                if (acceptList instanceof List) {
                    List executorNoList = (List)acceptList;
                    for (Object executorNo : executorNoList) {
                        Set<Object> userIdSet = new HashSet();
                        try {
                            userIdSet = this.transformToUserId(Stream.of(String.valueOf(executorNo)).collect(Collectors.toSet()), tenantId);
                        }
                        catch (Exception e) {
                            log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
                        }
                        userSet.addAll(userIdSet);
                    }
                } else if (acceptList instanceof String) {
                    Set<Object> userIdSet = new HashSet();
                    try {
                        userIdSet = this.transformToUserId(new HashSet<String>(Collections.singletonList(String.valueOf(acceptList))), tenantId);
                    }
                    catch (Exception e) {
                        log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
                    }
                    userSet.addAll(userIdSet);
                }
            }
        });
        BatchNoticeVO batchNoticeVO = new BatchNoticeVO();
        batchNoticeVO.setReceivers(userSet);
        batchNoticeVO.setMsg(message);
        batchNoticeVOS.add(batchNoticeVO);
        return this.postBatchSendNotice(batchNoticeVOS, tenantId);
    }

    @Override
    public Object postMessageHand(List<BacklogVO> taskList, String tenantId, String msg) {
        IdentityHashMap<Object, Object> mockPhpHashMap = CollectionUtils.isEmpty(taskList) ? new IdentityHashMap() : this.getMockPhpHashMap(taskList);
        String token = this.iamService.getTenantToken(tenantId);
        for (Map.Entry<Object, Object> outerEntry : mockPhpHashMap.entrySet()) {
            Set<String> userIds = this.transformToUserId(Stream.of(outerEntry.getKey()).collect(Collectors.toSet()), tenantId);
            Map innerMap = (Map)outerEntry.getValue();
            String msgReplace = MechanismEnhancementService.symbolStringMessage(msg, innerMap);
            if (CollectionUtils.isEmpty(userIds)) continue;
            this.iamService.dispatcherMessage(token, userIds.stream().collect(Collectors.toList()), msgReplace, tenantId);
        }
        return ResultBean.success(null);
    }

    @Override
    public Object postSendNotice(List<Map<String, Object>> taskBizData, String tenantId, String message, String businessFields, List<String> userIds) {
        log.warn("\u5f00\u59cb\u53d1\u9001\u4fe1\u606f\uff1a{}", (Object)message);
        if (!CollectionUtils.isEmpty(taskBizData)) {
            Pattern pattern = Pattern.compile("\\$\\{[^}]+\\}");
            if (!MechanismEnhancementService.containsExpression(message, pattern)) {
                return this.degradeToBatchSend(taskBizData, tenantId, message, businessFields, userIds);
            }
            String token = this.iamService.getTenantToken(tenantId);
            taskBizData.forEach(res -> {
                Map object = JsonUtil.toObject(JsonUtil.toJsonString(res), Map.class);
                Object acceptList = object.get(businessFields);
                ObjectMapper objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.convertValue(res, Map.class);
                String msgReplace = MechanismEnhancementService.symbolStringMessage(message, map);
                if (!CollectionUtils.isEmpty((Collection)userIds)) {
                    this.iamService.dispatcherMessage(token, userIds, msgReplace, tenantId);
                } else if (!Objects.isNull(object.get(businessFields)) && acceptList instanceof List) {
                    List executorNoList = (List)acceptList;
                    for (Object executorNo : executorNoList) {
                        Set<String> userIdSet = null;
                        try {
                            userIdSet = this.transformToUserId(Stream.of(String.valueOf(executorNo)).collect(Collectors.toSet()), tenantId);
                            log.warn("\u66ff\u6362\u540e\u7684\u6d88\u606f\uff1a{}", (Object)msgReplace);
                            if (CollectionUtils.isEmpty(userIdSet)) continue;
                            this.iamService.dispatcherMessage(token, userIdSet.stream().collect(Collectors.toList()), msgReplace, tenantId);
                        }
                        catch (Exception e) {
                            log.error("\u53d1\u9001\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
                        }
                    }
                }
            });
        }
        return ResultBean.success(null);
    }

    @Override
    public Object postSendNotice(NoticeVO noticeVO) throws Exception {
        if (!CollectionUtils.isEmpty(noticeVO.getGroupFields())) {
            return this.postSendNoticeByGroup(noticeVO);
        }
        return this.postSendNotice((List)noticeVO.getTaskBizData(), noticeVO.getTenantId(), noticeVO.getMessage(), noticeVO.getBusinessFields());
    }

    public Object postSendNoticeByGroup(NoticeVO noticeVO) throws Exception {
        if (CollectionUtils.isEmpty(noticeVO.getTaskBizData()) || StringUtils.isEmpty((CharSequence)noticeVO.getMessage())) {
            return null;
        }
        Pattern foreachPattern = Pattern.compile("\\{\\{FOREACH\\((.*?)\\)}}");
        Matcher foreachMatcher = foreachPattern.matcher(noticeVO.getMessage());
        StringBuffer foreachContentBuffer = new StringBuffer();
        String itemStr = "";
        if (foreachMatcher.find()) {
            itemStr = foreachMatcher.group(1);
            foreachMatcher.appendReplacement(foreachContentBuffer, "#itemsStr#");
        }
        foreachMatcher.appendTail(foreachContentBuffer);
        Map<String, List<Map>> groupMap = noticeVO.getTaskBizData().stream().collect(Collectors.groupingBy(data -> {
            StringBuilder sb = new StringBuilder();
            for (String groupField : noticeVO.getGroupFields()) {
                String value = "#placeholeder#";
                if (data.get(groupField) != null && StringUtils.isNotEmpty((CharSequence)data.get(groupField).toString())) {
                    value = data.get(groupField).toString();
                }
                sb.append(value).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }));
        ArrayList<BatchNoticeVO> batchNoticeVOS = new ArrayList<BatchNoticeVO>();
        for (Map.Entry<String, List<Map>> entry : groupMap.entrySet()) {
            BatchNoticeVO vo = new BatchNoticeVO();
            String handledMsg = foreachContentBuffer.toString();
            HashSet<String> receivers = new HashSet<String>();
            ArrayList<String> replacedItemList = new ArrayList<String>();
            for (Map item : entry.getValue()) {
                Object o;
                if (StringUtils.isNotEmpty((CharSequence)itemStr)) {
                    replacedItemList.add(MechanismEnhancementService.symbolStringMessage(itemStr, item));
                }
                if (!CollectionUtils.isEmpty(noticeVO.getUserIds()) || !StringUtils.isNotEmpty((CharSequence)noticeVO.getBusinessFields()) || (o = item.get(noticeVO.getBusinessFields())) == null) continue;
                if (o instanceof List) {
                    List list = (List)o;
                    receivers.addAll(list);
                    continue;
                }
                receivers.add(o.toString());
            }
            handledMsg = handledMsg.replace("#itemsStr#", Joiner.on((String)"\u3001").join(replacedItemList));
            HashMap<String, Object> map = new HashMap<String, Object>();
            String[] split = entry.getKey().split(",");
            for (int i = 0; i < noticeVO.getGroupFields().size(); ++i) {
                map.put(noticeVO.getGroupFields().get(i), "#placeholeder#".equals(split[i]) ? "" : split[i]);
            }
            handledMsg = MechanismEnhancementService.symbolStringMessage(handledMsg, map);
            vo.setMsg(handledMsg);
            if (!CollectionUtils.isEmpty(noticeVO.getUserIds())) {
                vo.setReceivers(new HashSet<String>(noticeVO.getUserIds()));
            } else {
                vo.setReceivers(receivers);
            }
            batchNoticeVOS.add(vo);
        }
        this.postBatchSendNotice(batchNoticeVOS, noticeVO.getTenantId());
        return ResultBean.success(null);
    }

    @Override
    public Object postBatchSendNotice(List<BatchNoticeVO> batchNoticeVOS, String tenantId) throws Exception {
        log.info("\u6279\u91cf\u53d1\u9001IM\u6d88\u606f\uff0cbatchNoticeVOS\uff1a{}\uff0c tenantId\uff1a{}", (Object)JSON.toJSONString(batchNoticeVOS), (Object)tenantId);
        if (!CollectionUtils.isEmpty(batchNoticeVOS)) {
            String token = this.iamService.getTenantToken(tenantId);
            for (BatchNoticeVO batchNoticeVO : batchNoticeVOS) {
                if (!StringUtils.isNotEmpty((CharSequence)batchNoticeVO.getMsg()) || CollectionUtils.isEmpty(batchNoticeVO.getReceivers())) continue;
                this.iamService.dispatcherMessage(token, new ArrayList<String>(batchNoticeVO.getReceivers()), batchNoticeVO.getMsg(), tenantId);
            }
        }
        return ResultBean.success(null);
    }

    @Override
    public Object postFilterByQuantity(List dataList, BusinessCondition businessCondition, ByQuantityCondition quantityCondition) {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("groups", businessCondition.getGroups());
        query.put("dataList", JSONArray.parseArray((String)JSON.toJSONString((Object)dataList)));
        DapResponse dapResponse = this.dataMapService.filterListByBusinessCondition(query);
        JSONArray result = (JSONArray)dapResponse.getResponse();
        this.filterByQuantity(result, quantityCondition);
        return result;
    }

    private void filterByQuantity(JSONArray result, ByQuantityCondition quantityCondition) {
        if (quantityCondition == null) {
            return;
        }
        String quantityField = quantityCondition.getQuantityField();
        String operator = quantityCondition.getOperator();
        String valueType = quantityCondition.getValueType();
        if (quantityField == null || operator == null || valueType == null) {
            return;
        }
        JSONArray filteredResult = new JSONArray();
        for (int i = 0; i < result.size(); ++i) {
            JSONObject obj = result.getJSONObject(i);
            if (!obj.containsKey((Object)quantityField)) continue;
            Object fieldValue = obj.get((Object)quantityField);
            boolean match = false;
            if (valueType.equals("fixed")) {
                match = this.checkFixedCondition(fieldValue, quantityCondition.getFixed(), operator);
            } else if (valueType.equals("var")) {
                match = this.checkVarCondition(fieldValue, obj, quantityCondition.getVar(), operator);
            }
            if (match) continue;
            filteredResult.add((Object)obj);
        }
        result.clear();
        result.addAll((Collection)filteredResult);
    }

    private boolean checkFixedCondition(Object fieldValue, QuantityFixed fixed, String operator) {
        if (fixed == null) {
            return false;
        }
        switch (operator) {
            case "eq": {
                Object fixedValue = this.getFixedValue(fixed.getValue().getValueSource(), fixed.getValue().getValue());
                return this.compare(fieldValue, fixedValue) == 0;
            }
            case "gte": {
                Object fixedValue = this.getFixedValue(fixed.getValue().getValueSource(), fixed.getValue().getValue());
                return this.compare(fieldValue, fixedValue) >= 0;
            }
            case "gt": {
                Object fixedValue = this.getFixedValue(fixed.getValue().getValueSource(), fixed.getValue().getValue());
                return this.compare(fieldValue, fixedValue) > 0;
            }
            case "lte": {
                Object fixedValue = this.getFixedValue(fixed.getValue().getValueSource(), fixed.getValue().getValue());
                return this.compare(fieldValue, fixedValue) <= 0;
            }
            case "lt": {
                Object fixedValue = this.getFixedValue(fixed.getValue().getValueSource(), fixed.getValue().getValue());
                return this.compare(fieldValue, fixedValue) < 0;
            }
            case "between": {
                Object fromValue = this.getFixedValue(fixed.getFrom().getValueSource(), fixed.getFrom().getValue());
                Object toValue = this.getFixedValue(fixed.getTo().getValueSource(), fixed.getTo().getValue());
                return this.compare(fieldValue, fromValue) >= 0 && this.compare(fieldValue, toValue) <= 0;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> postInvokeEspApi(String espApi, List<Map<String, Object>> requestParams) throws Exception {
        if (espApi.startsWith("esp_")) {
            espApi = espApi.substring(4);
        }
        HashMap<String, Object> finalRequestParams = new HashMap<String, Object>();
        if (requestParams != null && !requestParams.isEmpty()) {
            for (Map<String, Object> each : requestParams) {
                finalRequestParams.putAll(each);
            }
        }
        return this.espUtils.execute(AthenaUtils.getHeaderToken(), AthenaUtils.getTenantId(), espApi, finalRequestParams);
    }

    @Override
    public Map<String, Object> postInvokeEspApiV2(String espApi, String jsonBody, Map<String, Object> eocMap, Map<String, Object> headerMap) throws Exception {
        if (espApi.startsWith("esp_")) {
            espApi = espApi.substring(4);
        }
        return this.espUtils.executeV2(AthenaUtils.getHeaderToken(), AthenaUtils.getTenantId(), espApi, jsonBody, eocMap, headerMap);
    }

    @Override
    public JSONArray postFilterByTimeCondition(List dataList, BusinessCondition businessCondition, ByTimeCondition byTimeCondition) throws DWBusinessException {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("groups", businessCondition == null ? null : businessCondition.getGroups());
        query.put("dataList", JSONArray.parseArray((String)JSON.toJSONString((Object)dataList)));
        DapResponse dapResponse = this.dataMapService.filterListByBusinessCondition(query);
        JSONArray result = (JSONArray)dapResponse.getResponse();
        return this.filterByTimeCondition(result, byTimeCondition);
    }

    public JSONArray filterByTimeCondition(JSONArray result, ByTimeCondition byTimeCondition) throws DWBusinessException {
        if (byTimeCondition == null || result == null) {
            return result;
        }
        String checkField = byTimeCondition.getCheckField();
        OnTimeCheckRange checkRange = byTimeCondition.getCheckRange();
        Optional<Long> duration = this.getDuration(byTimeCondition);
        return duration.map(timeDuration -> this.doFilter(result, checkField, checkRange, (long)timeDuration)).orElseGet(JSONArray::new);
    }

    private Optional<Long> getDuration(ByTimeCondition byTimeCondition) throws DWBusinessException {
        if (byTimeCondition.getCheckType() == OnTimeCheckType.MECHANISM_PARAMETER) {
            String tenantId = AthenaUtils.getTenantId();
            Object value = this.iMechanismService.postSelectVariable(byTimeCondition.getCheckVariableCode(), tenantId);
            if (value == null) {
                return Optional.empty();
            }
            long checkNumber = Double.valueOf(Double.parseDouble(value.toString())).longValue();
            return Optional.of(checkNumber * byTimeCondition.getCheckUnit().getFactor());
        }
        return Optional.of((long)byTimeCondition.getCheckNumber() * byTimeCondition.getCheckUnit().getFactor());
    }

    private JSONArray doFilter(JSONArray result, String checkField, OnTimeCheckRange checkRange, long durationTime) {
        JSONArray filteredResult = new JSONArray();
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < result.size(); ++i) {
            Object fieldValue;
            Optional<Long> fieldTime;
            JSONObject obj = result.getJSONObject(i);
            if (!obj.containsKey((Object)checkField) || obj.get((Object)checkField) == null || !(fieldTime = MechanismEnhancementService.parseToLongTime(fieldValue = obj.get((Object)checkField))).isPresent() || !(checkRange == OnTimeCheckRange.BEFORE ? fieldTime.get() - currentTime > durationTime : currentTime - fieldTime.get() > durationTime)) continue;
            filteredResult.add((Object)obj);
        }
        return filteredResult;
    }

    private static Optional<Long> parseToLongTime(Object fieldValue) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd[' 'HH:mm:ss]")).appendOptional(DateTimeFormatter.ofPattern("yyyy/MM/dd[' 'HH:mm:ss]")).appendOptional(DateTimeFormatter.ofPattern("dd/MM/yyyy[' 'HH:mm:ss]")).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
        if (fieldValue instanceof Long) {
            return Optional.of((Long)fieldValue);
        }
        if (fieldValue instanceof String) {
            String dateString = (String)fieldValue;
            try {
                return Optional.of(LocalDateTime.parse(dateString, formatter).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
            }
            catch (Exception e) {
                log.error("parse time error for value: {}", (Object)dateString);
            }
        }
        return Optional.empty();
    }

    private Object getFixedValue(String valueSource, String value) {
        Object fixedValue;
        if ("MechanismVariable".equals(valueSource)) {
            try {
                String tenantId = AthenaUtils.getTenantId();
                fixedValue = this.iMechanismService.postSelectVariable(value, tenantId);
            }
            catch (DWBusinessException e) {
                fixedValue = "";
                log.error("Route==>MechanismEnhancementService method=getValue error:", (Throwable)e);
            }
        } else {
            fixedValue = value;
        }
        return fixedValue;
    }

    private boolean checkVarCondition(Object fieldValue, JSONObject varObj, QuantityVar var, String operator) {
        if (var == null) {
            return false;
        }
        switch (operator) {
            case "eq": {
                Object varValue = varObj.get((Object)var.getValue().getQuantityField());
                varValue = this.applyCalOperator(varValue, var.getValue());
                return this.compare(fieldValue, varValue) == 0;
            }
            case "gte": {
                Object varValue = varObj.get((Object)var.getValue().getQuantityField());
                varValue = this.applyCalOperator(varValue, var.getValue());
                return this.compare(fieldValue, varValue) >= 0;
            }
            case "gt": {
                Object varValue = varObj.get((Object)var.getValue().getQuantityField());
                varValue = this.applyCalOperator(varValue, var.getValue());
                return this.compare(fieldValue, varValue) > 0;
            }
            case "lte": {
                Object varValue = varObj.get((Object)var.getValue().getQuantityField());
                varValue = this.applyCalOperator(varValue, var.getValue());
                return this.compare(fieldValue, varValue) <= 0;
            }
            case "lt": {
                Object varValue = varObj.get((Object)var.getValue().getQuantityField());
                varValue = this.applyCalOperator(varValue, var.getValue());
                return this.compare(fieldValue, varValue) < 0;
            }
            case "between": {
                Object fromValue = varObj.get((Object)var.getFrom().getQuantityField());
                Object toValue = varObj.get((Object)var.getTo().getQuantityField());
                fromValue = this.applyCalOperator(fromValue, var.getFrom());
                toValue = this.applyCalOperator(toValue, var.getTo());
                return this.compare(fieldValue, fromValue) >= 0 && this.compare(fieldValue, toValue) <= 0;
            }
        }
        return false;
    }

    private int compare(Object a, Object b) {
        Double aa = Double.parseDouble(a.toString());
        Double bb = Double.parseDouble(b.toString());
        return aa.compareTo(bb);
    }

    private Object applyCalOperator(Object value, QuantityVarDetail quantityVarDetail) {
        String calOperator = quantityVarDetail.getCalOperator();
        String calValue = null;
        Object fixedValue = this.getFixedValue(quantityVarDetail.getValueSource(), quantityVarDetail.getValue());
        if (fixedValue != null) {
            calValue = String.valueOf(fixedValue);
        }
        Double douVal = StringUtils.isEmpty(calValue) ? 0.0 : Double.parseDouble(calValue);
        double doubleValue = Double.parseDouble(value.toString());
        if ("+".equals(calOperator)) {
            return doubleValue + douVal;
        }
        if ("-".equals(calOperator)) {
            return doubleValue - douVal;
        }
        return value;
    }

    @Override
    public Object postControlBaseData(String code, String tenantId) throws Exception {
        return this.postControlBaseData(code);
    }

    @Override
    public Object postControlBaseData(String code) throws Exception {
        String tenantIdFromToken = AthenaUtils.getTenantId();
        String token = this.iamService.getTenantToken(tenantIdFromToken);
        ActivityConfig activityConfig = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)code), ActivityConfig.class, "activityConfigs");
        Map dataSources = activityConfig.getDataSources();
        Map dataSource = this.getRealDataSource(dataSources);
        Preconditions.checkArgument((boolean)dataSource.containsKey("actionId"));
        String actionId = (String)dataSource.get("actionId");
        String espServiceName = this.getServiceNameByActionId(actionId);
        LoginInfo loginInfo = KgFilter.getLoginInfo();
        if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty((CharSequence)activityConfig.getApplication())) {
            loginInfo.setApplication(activityConfig.getApplication());
        }
        Map<String, Object> result = this.espUtils.execute(token, tenantIdFromToken, espServiceName, new HashMap());
        this.replaceDateKey(result);
        log.info("invoke result is:{}", result);
        return result;
    }

    private void replaceDateKey(Map<String, Object> map) {
        Map.Entry<String, Object> firstEntry = map.entrySet().iterator().next();
        String oldKey = firstEntry.getKey();
        Object value = firstEntry.getValue();
        map.remove(oldKey);
        String newKey = "data";
        map.put(newKey, value);
    }

    private String getServiceNameByActionId(String actionId) throws DWBusinessException {
        if (actionId.startsWith("esp_")) {
            return actionId.substring(4);
        }
        throw new DWBusinessException("unsupported action");
    }

    private Map getRealDataSource(Map<String, Object> dataSources) {
        if (dataSources == null || dataSources.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)dataSources.entrySet().iterator().next().getValue()), Map.class);
    }

    public static void main(String[] args) {
        String str1 = "Hello, ${[user]}!";
        String str2 = "Hello, user!";
        Pattern pattern = Pattern.compile("\\$\\{[^}]+\\}");
        boolean contains1 = MechanismEnhancementService.containsExpression(str1, pattern);
        System.out.println("String 1 contains ${}: " + contains1);
        boolean contains2 = MechanismEnhancementService.containsExpression(str2, pattern);
        System.out.println("String 2 contains ${}: " + contains2);
    }

    public static boolean containsExpression(String str, Pattern pattern) {
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private static String symbolStringMessage(String msg, Map<String, Object> innerMap) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(msg);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String key = matcher.group(1);
            if (!innerMap.containsKey(key)) continue;
            if (innerMap.getOrDefault(key, matcher.group()) instanceof Double) {
                Double value = (Double)innerMap.getOrDefault(key, matcher.group());
                replacement = MechanismEnhancementService.formatValue(value);
            } else {
                replacement = String.valueOf(innerMap.getOrDefault(key, matcher.group()));
            }
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String formatValue(Double value) {
        if (value % 1.0 == 0.0) {
            return String.valueOf(value.intValue());
        }
        BigDecimal bdValue = new BigDecimal(value.toString());
        return bdValue.toString();
    }

    private IdentityHashMap<String, Map<String, Object>> getMockPhpHashMap(List<BacklogVO> taskList) {
        Object projectInfoObj;
        Map<String, Object> executeResult;
        IdentityHashMap<String, Map<String, Object>> mockPhpHashMap = new IdentityHashMap<String, Map<String, Object>>();
        BacklogVO backlogVO = taskList.stream().findFirst().orElse(null);
        if (backlogVO != null && (executeResult = backlogVO.getExecuteResult()) != null && (projectInfoObj = executeResult.get("project_info")) instanceof List) {
            List dataList = (List)projectInfoObj;
            dataList.forEach(stringObjectMap -> this.processExecutorNo(mockPhpHashMap, (Map<String, Object>)stringObjectMap));
        }
        return mockPhpHashMap;
    }

    private void processExecutorNo(IdentityHashMap<String, Map<String, Object>> mockPhpHashMap, Map<String, Object> stringObjectMap) {
        Object executorNoObj = stringObjectMap.get("executor_no");
        if (executorNoObj instanceof Collection) {
            List executorNoList = (List)executorNoObj;
            executorNoList.forEach(ids -> {
                HashMap clonedMap = new HashMap(stringObjectMap);
                clonedMap.remove("executor_no");
                mockPhpHashMap.put((String)ids, clonedMap);
            });
        }
    }

    private List<BacklogVO> checkFilterTaskData(List<BacklogVO> taskList, CheckAccordingToStandard checkAccordingToStandard, String tenantId) {
        Integer intervalTime = this.parseTimeValue(checkAccordingToStandard.getStandardPollingRule().getTimeValue());
        LinkedList<BacklogVO> taskResult = new LinkedList<BacklogVO>();
        BusinessCondition businessCondition = checkAccordingToStandard.getBusinessCondition();
        if (!CollectionUtils.isEmpty((Collection)businessCondition.getGroups())) {
            List mechanismConditionGroups = businessCondition.getGroups();
            String checkField = checkAccordingToStandard.getCheckField();
            String[] checkFieldArray = checkField.split("\\.");
            String checkFieldHead = checkFieldArray[0];
            String checkFieldDetails = checkFieldArray[1];
            List finalMechanismConditionGroups = mechanismConditionGroups;
            this.processMechanismConditionGroups(finalMechanismConditionGroups, tenantId);
            taskList.forEach(task -> {
                Map<String, Object> executeResult = task.getExecuteResult();
                if (!CollectionUtils.isEmpty(executeResult)) {
                    List dataList = (List)executeResult.get(checkFieldHead);
                    LocalDate currentDate = LocalDate.now();
                    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    dataList.removeIf(data -> this.checkIfRemoveByData(intervalTime, checkFieldDetails, currentDate, dateFormatter, (Map<String, Object>)data));
                    dataList.removeIf(data -> this.checkByRule(finalMechanismConditionGroups, (Map<String, Object>)data));
                    if (!CollectionUtils.isEmpty((Collection)dataList)) {
                        task.setVariables(null);
                        taskResult.add((BacklogVO)task);
                    }
                }
            });
        }
        return taskResult;
    }

    private void fillTaskExecuteResult(List<BacklogVO> taskList, String tenantId, Map<String, Object> dataSource, String token, String finalServiceName) {
        taskList.forEach(task -> {
            try {
                Map<String, Object> variables = task.getVariables();
                Map<String, Object> requestObj = this.buildRequestObj(variables, dataSource);
                Map<String, Object> executeResult = this.espUtils.execute(token, tenantId, finalServiceName, requestObj);
                task.setExecuteResult(executeResult);
            }
            catch (Exception e) {
                log.error("invoke esp error for service:{}, request:{}", (Object)finalServiceName, task.getVariables());
            }
        });
    }

    private String getServiceName(String tenantId, Map<String, Object> dataSource) {
        String serviceName;
        String actionId = (String)dataSource.get("actionId");
        try {
            HashMap<String, String> profile = new HashMap<String, String>();
            profile.put("tenantId", tenantId);
            DWServiceContext.getContext().setProfile(profile);
            GetActionLocaleResponseDTO getActionLocaleResponseDTO = (GetActionLocaleResponseDTO)this.actionService.getMetadata(actionId);
            serviceName = getActionLocaleResponseDTO.getServiceName();
        }
        catch (Exception e) {
            log.error("getActionError for actionId:{},{}", (Object)actionId, (Object)e);
            serviceName = this.degradeToParseByActionId(actionId);
        }
        return serviceName;
    }

    private boolean checkByRule(List<MechanismConditionGroup> mechanismConditionGroups, Map<String, Object> data) {
        HashSet<Boolean> set = new HashSet<Boolean>();
        if (!CollectionUtils.isEmpty(mechanismConditionGroups)) {
            MechanismConditionGroup mechanismConditionGroup = mechanismConditionGroups.get(0);
            List mechanismConditionConfigs = mechanismConditionGroup.getConditions();
            block16: for (int i = 0; i < mechanismConditionConfigs.size(); ++i) {
                String opType;
                MechanismConditionConfig config = (MechanismConditionConfig)mechanismConditionConfigs.get(i);
                String dataType = config.getLeft().getData_type();
                Object leftValue = this.extractValue(config.getLeft(), data);
                Object rightValue = this.extractValue(config.getRight());
                if (leftValue == null || rightValue == null) {
                    return false;
                }
                switch (opType = config.getOpType()) {
                    case "eq": {
                        set.add(StringUtils.equals((CharSequence)String.valueOf(leftValue), (CharSequence)String.valueOf(rightValue)) ? Boolean.TRUE : Boolean.FALSE);
                        continue block16;
                    }
                    case "gt": {
                        return this.compareValues(dataType, leftValue, rightValue) > 0;
                    }
                    case "lt": {
                        return this.compareValues(dataType, leftValue, rightValue) < 0;
                    }
                    case "gte": {
                        return this.compareValues(dataType, leftValue, rightValue) >= 0;
                    }
                    case "lte": {
                        return this.compareValues(dataType, leftValue, rightValue) <= 0;
                    }
                    case "between": {
                        return this.compareValues(dataType, leftValue, rightValue) <= 0 && this.compareValues(dataType, rightValue, leftValue) <= 0;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return set.contains(Boolean.FALSE);
    }

    private Object extractValue(MechanismVariable right) {
        return right.getTo().getValue();
    }

    private Object extractValue(MechanismVariable variable, Map<String, Object> data) {
        String path = variable.getPath();
        path = path.substring(path.lastIndexOf(".") + 1);
        return data.get(path);
    }

    private int compareValues(String dataType, Object leftValue, Object rightValue) {
        switch (dataType) {
            case "string": {
                return -1;
            }
        }
        Double left = Double.parseDouble(leftValue.toString());
        Double right = Double.parseDouble(rightValue.toString());
        return Double.compare(left, right);
    }

    private boolean checkIfRemoveByData(Integer intervalTime, String checkFieldBody, LocalDate currentDate, DateTimeFormatter dateFormatter, Map<String, Object> data) {
        String dateString = String.valueOf(data.get(checkFieldBody));
        LocalDate dataDate = LocalDate.parse(dateString, dateFormatter);
        long daysDiff = ChronoUnit.DAYS.between(dataDate, currentDate);
        boolean ifRemove = Math.abs(daysDiff) < (long)intervalTime.intValue();
        return ifRemove;
    }

    private Integer parseTimeValue(String timeValue) {
        try {
            if (timeValue.indexOf(";") != -1) {
                String subStrOfTime = timeValue.substring(0, timeValue.indexOf(";"));
                return Integer.parseInt(subStrOfTime);
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private Map<String, Object> buildRequestObj(Map<String, Object> variables, Map<String, Object> dataSource) throws DWBusinessException {
        JsonNode actionParamsNode;
        String actionParamsJSON = JSON.toJSONString((Object)dataSource.get("actionParams"));
        ObjectMapper mapper = new ObjectMapper();
        try {
            actionParamsNode = mapper.readTree(actionParamsJSON);
        }
        catch (IOException e) {
            log.error("parse actionParams error:{}", (Object)actionParamsJSON);
            throw new DWBusinessException();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (JsonNode paramNode : actionParamsNode) {
            String name = paramNode.get("name").asText();
            String type = paramNode.get("type").asText();
            String value = paramNode.get("value").asText();
            if ("PROCESS_VARIABLE".equals(type)) {
                paramMap.put(name, variables.get(value));
                continue;
            }
            if (!"CONSTANT".equals(type)) continue;
            paramMap.put(name, value);
        }
        return paramMap;
    }

    private String degradeToParseByActionId(String actionId) {
        String espPrefix = "esp_";
        if (actionId.startsWith(espPrefix)) {
            return actionId.substring(4);
        }
        return actionId;
    }

    public void processMechanismConditionGroups(List<MechanismConditionGroup> mechanismConditionGroups, String tenantId) {
        if (mechanismConditionGroups == null || mechanismConditionGroups.isEmpty()) {
            return;
        }
        List<MechanismConditionConfig> mechanismConditionConfigList = mechanismConditionGroups.stream().flatMap(group -> Optional.ofNullable(group.getConditions()).map(conditionList -> conditionList.stream()).orElseGet(Stream::empty)).filter(condition -> condition.getConditionValueType() == VariableTypeEnum.VARIABLE_VALUE.getKey()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mechanismConditionConfigList)) {
            mechanismConditionConfigList.forEach(condition -> this.processCondition((MechanismConditionConfig)condition, tenantId));
        }
    }

    private void processCondition(MechanismConditionConfig condition, String tenantId) {
        String variableValue = Optional.ofNullable(this.iMechanismService.postSelectVariable(condition.getVariableCode(), tenantId)).orElse(null).toString();
        MechanismVariable mechanismVariable = (MechanismVariable)JSONPath.eval((Object)condition, (String)"$.right.to");
        mechanismVariable.setValue((Object)variableValue);
    }
}

