/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.MechanismApplyRecord;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.MechanismPrincipleDetailComponentBO;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.action.Variable;
import com.digiwin.athena.kg.domain.OperationUnitV2;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.MechanismSettings;
import com.digiwin.athena.knowledgegraph.domain.MechanismTenantVariable;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismContext;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismRelation;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Paradigm;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Principle;
import com.digiwin.athena.knowledgegraph.domain.mechanism.PrincipleDetail;
import com.digiwin.athena.knowledgegraph.domain2.base.AbsEntityDict;
import com.digiwin.athena.knowledgegraph.domain2.base.Dimension;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismAchiveRecord;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismItemRecord;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismOld;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismScene;
import com.digiwin.athena.knowledgegraph.mechanism.partparsers.AdvancedAssignDefinitionParser;
import com.digiwin.athena.knowledgegraph.po.MechanismUserDesignerInfo;
import com.digiwin.athena.knowledgegraph.repo.MechanismAchiveRecordRepository;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.OperationUnitService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.KgProductService;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismDesignService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.inner.MechanismGraphService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.support.AbstractionHandler;
import com.digiwin.athena.knowledgegraph.support.CompositeMechanismCustomer;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.knowledgegraph.utils.VersionUtil;
import com.digiwin.athena.knowledgegraph.vo.GlobalMessagePageTypeVO;
import com.digiwin.athena.knowledgegraph.vo.MechanismMergeVO;
import com.digiwin.athena.knowledgegraph.vo.TraceMaterialIntervalVO;
import com.digiwin.athena.knowledgegraph.vo.VariableBean;
import com.digiwin.athena.knowledgegraph.vo.VariableQueryVO;
import com.digiwin.athena.knowledgegraph.vo.VariableVo;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import com.digiwin.athena.mechanism.pre.MechanismTheory;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.assign.AdvancedUserDefinitionWidget;
import com.digiwin.athena.repository.neo4j.MechanismRepository;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Lang
@Service
@MyExceptionHandler
public class MechanismService
implements IMechanismService {
    private static final Logger log = LoggerFactory.getLogger(MechanismService.class);
    private static final String MECHANISM_VARIABLE_COLLECTION_NAME = "mechanismVariable";
    private static final String MECHANISM_VARIABLE_ID_KEY_NAME = "variableId";
    private static final String MECHANISM_VARIABLE_VALUE_FIELD_NAME = "value";
    private static final String TENANT_ID_KEY_NAME = "tenantId";
    private static final String MECHANISM_VARIABLE_INDEX_NAME = "mechanismVariable";
    private static final String MECHANISM_TENANT_PARADIGM = "mechanismTenantParadigm";
    private static final String SYSTEM = "SYSTEM";
    @Autowired
    MechanismGraphService mechanismGraphService;
    @Autowired
    private MechanismRepository mechanismRepository;
    @Autowired
    AbstractionHandler abstractionHandler;
    @Autowired
    MechanismAchiveRecordRepository mechanismAchiveRecordRepository;
    @Autowired
    ComponentManager componentManager;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplate2;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    CompositeMechanismCustomer compositeMechanismCustomer;
    @Autowired
    OperationUnitService operationUnitService;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    TenantService tenantService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    AppService appService;
    @Autowired
    MongoEntityBaseDAO mongoEntityBaseDAO;
    @Autowired
    KgProductService productService;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    MechanismDesignService mechanismDesignService;
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    @Qualifier(value="baseExecutor")
    Executor executor;
    @Autowired
    AdvancedAssignDefinitionParser advancedAssignDefinitionParser;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    private IAMUtils iamUtils;

    @Override
    public Object getVariable(String variableName, String tenantId) throws DWBusinessException {
        log.info("enter getVariable");
        Map<String, Object> result = this.getStringObjectMap(variableName, tenantId, true);
        return result;
    }

    @Override
    public Object postQueryVariable(VariableQueryVO queryData) throws DWBusinessException {
        String variableName = queryData.getVariableName();
        String tenantId = queryData.getTenantId();
        if (StringUtils.isEmpty((CharSequence)variableName) || StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("P.KG.500.0033", I18nUtils.getValue("knowledgegraph.variableOrtenantEmpty", new Object[0]));
        }
        String eocLevel = queryData.getEocLevel();
        return this.getStringObjectMap(variableName, tenantId, true, this.transEocMap(queryData.getEocMap(), eocLevel));
    }

    private OperationUnit transEocMap(Map<String, Object> orgEocMap, String eocLevel) {
        OperationUnit operationUnit = new OperationUnit();
        if (orgEocMap == null) {
            return operationUnit;
        }
        Map operationUnitV2 = MapUtils.getMap(orgEocMap, (Object)"operation_unit_v2");
        if (operationUnitV2 != null && operationUnitV2.get("eoc_mapping_id") != null) {
            OperationUnitV2 unitV2 = new OperationUnitV2();
            unitV2.setEoc_mapping_id(MapUtils.getString((Map)operationUnitV2, (Object)"eoc_mapping_id"));
            operationUnit.setOperation_unit_v2(unitV2);
            return operationUnit;
        }
        if (StringUtils.isEmpty((CharSequence)eocLevel)) {
            return operationUnit;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)eocLevel, (CharSequence)"company")) {
            String eocCompanyId = MapUtils.getString(orgEocMap, (Object)"eoc_company_id");
            if (StringUtils.isNotEmpty((CharSequence)eocCompanyId)) {
                operationUnit.setEoc_company_id(eocCompanyId);
            } else {
                operationUnit.setEoc_company_id(MapUtils.getString(orgEocMap, (Object)"eocCompanyId"));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)eocLevel, (CharSequence)"site")) {
            String eocCompanyId = MapUtils.getString(orgEocMap, (Object)"eoc_company_id");
            if (StringUtils.isNotEmpty((CharSequence)eocCompanyId)) {
                operationUnit.setEoc_company_id(eocCompanyId);
            } else {
                operationUnit.setEoc_company_id(MapUtils.getString(orgEocMap, (Object)"eocCompanyId"));
            }
            String eocSiteId = MapUtils.getString(orgEocMap, (Object)"eoc_site_id");
            if (StringUtils.isNotEmpty((CharSequence)eocSiteId)) {
                operationUnit.setEoc_site_id(eocSiteId);
            } else {
                operationUnit.setEoc_site_id(MapUtils.getString(orgEocMap, (Object)"eocSiteId"));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)eocLevel, (CharSequence)"region")) {
            String eocRegionId = MapUtils.getString(orgEocMap, (Object)"eoc_region_id");
            if (StringUtils.isNotEmpty((CharSequence)eocRegionId)) {
                operationUnit.setEoc_region_id(eocRegionId);
            } else {
                operationUnit.setEoc_region_id(MapUtils.getString(orgEocMap, (Object)"eocRegionId"));
            }
        } else {
            return operationUnit;
        }
        return operationUnit;
    }

    private Map<String, Object> getStringObjectMap(String variableName, String tenantId, boolean isGetDefault, OperationUnit eocMap) throws DWBusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.equals((CharSequence)variableName, (CharSequence)"hasGroundEnd")) {
            Object hasGroundEnd = this.getHasGroundEnd();
            result.put(variableName, hasGroundEnd);
            result.put(TENANT_ID_KEY_NAME, tenantId);
            return result;
        }
        boolean missingTenantSet = true;
        Query query = new Query();
        query.fields().include(MECHANISM_VARIABLE_VALUE_FIELD_NAME);
        Criteria criteria = Criteria.where((String)MECHANISM_VARIABLE_ID_KEY_NAME).is((Object)variableName).and(TENANT_ID_KEY_NAME).is((Object)tenantId);
        Criteria criteria1 = this.operationUnitService.addOperationToCriteria(eocMap, criteria);
        query.addCriteria((CriteriaDefinition)criteria1);
        Map resultMap = (Map)this.mongoTemplate2.findOne(query, Map.class, "mechanismVariable");
        if (resultMap != null) {
            missingTenantSet = false;
            Object val = resultMap.get(MECHANISM_VARIABLE_VALUE_FIELD_NAME);
            if (isGetDefault) {
                val = this.getDefValue(val, variableName);
            }
            result.put(variableName, val);
            result.put(TENANT_ID_KEY_NAME, tenantId);
        } else {
            if (!isGetDefault) {
                return result;
            }
            VariableDefinition def = this.getDefinition(variableName);
            if (def != null) {
                result.put(variableName, def.getDefaultValue());
                result.put(TENANT_ID_KEY_NAME, tenantId);
            }
        }
        result.put("missingTenantSet", missingTenantSet);
        return result;
    }

    private Map<String, Object> getStringObjectMap(String variableName, String tenantId, boolean isGetDefault) throws DWBusinessException {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty", new Object[0]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.equals((CharSequence)variableName, (CharSequence)"hasGroundEnd")) {
            Object hasGroundEnd = this.getHasGroundEnd();
            result.put(variableName, hasGroundEnd);
            result.put(TENANT_ID_KEY_NAME, tenantId);
            return result;
        }
        MongoCollection col = this.mongoTemplate2.getCollection("mechanismVariable");
        Document doc = (Document)col.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)MECHANISM_VARIABLE_ID_KEY_NAME, (Object)variableName), Filters.eq((String)TENANT_ID_KEY_NAME, (Object)tenantId)})).first();
        if (doc != null) {
            Object val = doc.get((Object)MECHANISM_VARIABLE_VALUE_FIELD_NAME);
            if (isGetDefault) {
                val = this.getDefValue(val, variableName);
            }
            result.put(variableName, val);
            result.put(TENANT_ID_KEY_NAME, doc.get((Object)TENANT_ID_KEY_NAME));
        } else {
            if (!isGetDefault) {
                return result;
            }
            VariableDefinition def = this.getDefinition(variableName);
            if (def != null) {
                result.put(variableName, def.getDefaultValue());
                result.put(TENANT_ID_KEY_NAME, tenantId);
            }
        }
        return result;
    }

    private Object getDefValue(Object val, String variableName) throws DWBusinessException {
        if (val instanceof List) {
            String key = null;
            String valKey = null;
            VariableDefinition def = this.getDefinition(variableName);
            if (def != null) {
                List cols;
                Map typeDef;
                if (StringUtils.equals((CharSequence)def.getDisplayType(), (CharSequence)"TABLE") && def.getDisplayTypeDefinition() != null && def.getDisplayTypeDefinition() instanceof Map && (typeDef = (Map)def.getDisplayTypeDefinition()).get("category").equals("radioboxgroup") && typeDef.get("columns") instanceof List && !CollectionUtils.isEmpty((Collection)(cols = (List)typeDef.get("columns"))) && cols.get(0) instanceof Map) {
                    Map col = (Map)cols.get(0);
                    key = (String)col.get("key");
                    List exts = (List)col.get("extends");
                    if (!CollectionUtils.isEmpty((Collection)exts) && exts.get(0) instanceof Map) {
                        Map ext = (Map)exts.get(0);
                        valKey = (String)ext.get("key");
                    }
                }
                if (StringUtils.isEmpty(key) || StringUtils.isEmpty(valKey)) {
                    return val;
                }
                if (def.getDefaultValue() != null && def.getDefaultValue() instanceof List) {
                    List defValList = (List)def.getDefaultValue();
                    List valList = (List)val;
                    for (Map defVal : defValList) {
                        boolean exist = false;
                        for (Map v : valList) {
                            if (!defVal.get(key).equals(v.get(key))) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        HashMap d = new HashMap();
                        d.put(key, defVal.get(key));
                        d.put(valKey, defVal.get(valKey));
                        valList.add(d);
                    }
                }
            }
        }
        return val;
    }

    private VariableDefinition getDefinition(String variableName) throws DWBusinessException {
        return this.dataPickService.findByCode(variableName, VariableDefinition.class, "variableDefinition");
    }

    @Override
    public Object postVariableList(VariableBean map) throws Exception {
        List<VariableVo> list = map.getVariableVoList();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.tenantService.getTenantVersion(tenantId);
        block8: for (VariableVo variableVo : list) {
            String category;
            Map<String, Object> variableMap = this.getStringObjectMap(variableVo.getVariableId(), tenantId, map.isNeedGetDefault(), map.getEocMap());
            HashMap<String, Object> value = variableMap.get(variableVo.getVariableId());
            List<GlobalMessagePageTypeVO> globalMessagePageTypeVOS = new ArrayList<GlobalMessagePageTypeVO>();
            HashMap<String, Object> resVo = new HashMap<String, Object>();
            if (variableVo.getVariableId().equals("globalMessagePageType")) {
                Criteria criteria = Criteria.where((String)"code").is((Object)variableVo.getVariableId());
                VariableDefinition vo = this.dataPickService.findOneByCondition(criteria, VariableDefinition.class, "variableDefinition");
                if (vo == null) {
                    throw new DWException("P.KG.500.0034", I18nUtils.getValue("knowledgegraph.globalMessagePageTypeMiss", new Object[0]));
                }
                Map defaultValue = (Map)vo.getDefaultValue();
                globalMessagePageTypeVOS = JSON.parseArray((String)JSONUtils.toJSONString(defaultValue.get("dataList")), GlobalMessagePageTypeVO.class);
                globalMessagePageTypeVOS.sort(Comparator.comparing(GlobalMessagePageTypeVO::getSequence));
                resVo.put("dataList", globalMessagePageTypeVOS);
                if (value instanceof Map) {
                    Map value1 = value;
                    resVo.put("chooseList", value1.get("chooseList"));
                }
                value = resVo;
            }
            switch (category = variableVo.getCategory() == null ? "" : variableVo.getCategory()) {
                case "global-table": {
                    Map o = this.loopValue(value, variableVo.getFieldNameList());
                    variableVo.setResult(o);
                    continue block8;
                }
                case "reportList": {
                    this.handleReportRes(resVo, globalMessagePageTypeVOS, variableVo);
                    continue block8;
                }
            }
            variableVo.setResult(value);
        }
        return list;
    }

    @Override
    public Object postVariableListSimple(VariableBean map) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(map.getVariableIds())) {
            return result;
        }
        String tenantId = AthenaUtils.getTenantId();
        for (String vid : map.getVariableIds()) {
            Map<String, Object> variableMap = this.getStringObjectMap(vid, tenantId, true, map.getEocMap());
            Object value = variableMap.get(vid);
            result.put(vid, value);
        }
        return result;
    }

    private void handleReportRes(HashMap<String, Object> res, List<GlobalMessagePageTypeVO> globalMessagePageTypeVOS, VariableVo vo) {
        if (!res.containsKey("chooseList") || ObjectUtils.isEmpty((Object)res.get("chooseList"))) {
            vo.setResult(null);
            return;
        }
        if (ObjectUtils.isEmpty(globalMessagePageTypeVOS)) {
            vo.setResult(I18nUtils.getValue("knowledgegraph.typeNotSupport", new Object[0]));
        }
        List strings = JSON.parseArray((String)JSONUtils.toJSONString((Object)res.get("chooseList")), String.class);
        List collect = globalMessagePageTypeVOS.stream().filter(v -> strings.contains(v.getChartId())).collect(Collectors.toList());
        vo.setResult(collect);
    }

    private <T> Map loopValue(T obj, List<String> fieldNameList) {
        Map res;
        if (CollectionUtils.isEmpty(fieldNameList) || obj == null) {
            return null;
        }
        if (obj instanceof List) {
            for (Object vo : (List)obj) {
                res = this.loopValue(vo, fieldNameList);
                if (res == null || res.isEmpty()) continue;
                return res;
            }
        }
        if (obj instanceof Map) {
            HashMap resMap = new HashMap();
            block1: for (String fieldName : fieldNameList) {
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    if (entry.getKey() instanceof String && entry.getKey().equals(fieldName)) {
                        if (resMap.containsKey(fieldName)) continue block1;
                        resMap.put(fieldName, entry.getValue());
                        continue block1;
                    }
                    res = this.loopValue(entry.getValue(), Collections.singletonList(fieldName));
                    if (null == res || res.isEmpty() || resMap.containsKey(fieldName)) continue;
                    resMap.put(fieldName, res.get(fieldName));
                    continue block1;
                }
            }
            return resMap;
        }
        return null;
    }

    @Override
    public Object putVariable(String variableName, String tenantId, Object value) throws Exception {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty", new Object[0]));
        }
        Document doc = new Document();
        doc.append(MECHANISM_VARIABLE_ID_KEY_NAME, (Object)variableName);
        doc.append(TENANT_ID_KEY_NAME, (Object)tenantId);
        doc.append(MECHANISM_VARIABLE_VALUE_FIELD_NAME, value);
        try {
            MongoCollection<Document> col = this.getVariableCollection();
            col.insertOne((Object)doc);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object postVariable(String variableName, String tenantId, Object value) throws Exception {
        return this.postVariable(variableName, tenantId, null, value);
    }

    @Override
    public Object postVariable(String variableName, String tenantId, OperationUnit operationUnit, Object value) throws Exception {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty", new Object[0]));
        }
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and(MECHANISM_VARIABLE_ID_KEY_NAME).is((Object)variableName);
        if (operationUnit != null && !operationUnit.isEmpty()) {
            criteria1 = operationUnit.addOperationToCriteria(criteria1);
        }
        query.addCriteria((CriteriaDefinition)criteria1);
        Update update = new Update();
        update.set(MECHANISM_VARIABLE_VALUE_FIELD_NAME, value);
        try {
            this.mongoTemplate2.upsert(query, update, MechanismTenantVariable.class);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object postSelectVariable(String variableCode, String tenantId) {
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and(MECHANISM_VARIABLE_ID_KEY_NAME).is((Object)variableCode);
        query.addCriteria((CriteriaDefinition)criteria1);
        MechanismTenantVariable variable = (MechanismTenantVariable)this.mongoTemplate2.findOne(query, MechanismTenantVariable.class);
        if (null == variable) {
            new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.selectVariable is null", new Object[0]));
            return null;
        }
        return variable.getValue();
    }

    @Override
    public Object postMechanism(String key, String tenantId, String product) throws DWBusinessException {
        MechanismOld me = this.getDetail(tenantId, key);
        Dimension d = new Dimension();
        d.setProduct(product);
        d.setTenant(tenantId);
        this.abstractionHandler.dealWithAbstraction((Object)me, d);
        return me;
    }

    @Override
    public Object postMechanismMaterialConfig(String key, String tenantId, String product) throws DWBusinessException {
        MechanismOld me = this.getDetail(tenantId, key);
        Dimension d = new Dimension();
        d.setProduct(product);
        d.setTenant(tenantId);
        this.abstractionHandler.dealWithAbstraction((Object)me, d);
        HashMap data = new HashMap();
        if (null != me.getClassifications()) {
            me.getClassifications().forEach(classfy -> {
                data.put(classfy.getKey(), classfy.getCondition());
                if (null != classfy.getConditions()) {
                    classfy.getConditions().forEach(cond -> data.put(cond.getKey(), cond.getCondition()));
                }
            });
        }
        if (null != me.getScenes()) {
            me.getScenes().forEach(sce -> {
                if (null != sce.getSuggests()) {
                    sce.getSuggests().forEach(sug -> data.put(sug.getKey(), sug.getValue()));
                }
            });
        }
        if (null != me.getDataAction()) {
            me.getDataAction().forEach(action -> {
                if (null != action.getParams()) {
                    action.getParams().forEach(param -> data.put(param.getKey(), param.getValue()));
                }
            });
        }
        if (null != me.getTaskConfigs()) {
            me.getTaskConfigs().forEach(task -> data.put(task.getKey(), task.getCondition()));
        }
        return data;
    }

    @Override
    public MechanismAchiveRecord findOne(String instanceId) {
        List<MechanismAchiveRecord> records = this.mechanismAchiveRecordRepository.findByInstanceId(instanceId);
        if (records.size() == 1) {
            return records.get(0);
        }
        if (records.size() > 0) {
            Collections.sort(records);
            MechanismAchiveRecord r = records.get(0);
            for (int i = 1; i < records.size(); ++i) {
                this.mongoTemplate2.remove(Query.query((CriteriaDefinition)Criteria.where((String)"instanceId").is((Object)instanceId).and("updateTime").is((Object)records.get(i).getUpdateTime())), MechanismAchiveRecord.class);
            }
            this.mongoTemplate2.remove(Query.query((CriteriaDefinition)Criteria.where((String)"instanceId").is((Object)instanceId).and("updateTime").ne((Object)r.getUpdateTime())), MechanismItemRecord.class);
            return r;
        }
        return null;
    }

    @Override
    public Object postMechanismRecordSave(MechanismAchiveRecord param) throws DWBusinessException {
        MechanismAchiveRecord record = this.findOne(param.getInstanceId());
        if (record != null) {
            record.setBatchAll(param.getBatchAll());
            if (null != param.getStatus()) {
                record.setStatus(param.getStatus());
                if (record.getStatus() == 3) {
                    record.setRecordStatus(2);
                }
            }
            if (null != param.getRemark()) {
                record.setRemark(param.getRemark());
            }
            if (null != param.getValue()) {
                record.setValue(param.getValue());
            }
            this.saveRecord(record);
            if (null != param.getStatus() && param.getStatus() == 3) {
                MechanismContext context = new MechanismContext();
                context.setMechanismKey(param.getMechanismKey());
                context.setKey(param.getKey());
                context.setTenant(param.getTenantId());
                context.setRecord(record);
                Object obj = this.compositeMechanismCustomer.notifyApproveSuccess(context);
                if (null != obj) {
                    return obj;
                }
            }
        } else {
            param.setCreateTime(new Date());
            this.saveRecord(param);
        }
        return null;
    }

    @Override
    public Object postMechanismRecordGet(String instanceId) {
        Query query;
        List items;
        MechanismAchiveRecord record = this.findOne(instanceId);
        if (null != record && Boolean.TRUE.equals(record.getValueIsArray()) && (items = this.mongoTemplate2.find(query = Query.query((CriteriaDefinition)Criteria.where((String)"instanceId").is((Object)instanceId)), MechanismItemRecord.class)) != null) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (MechanismItemRecord r : items) {
                list.add(r.getValue());
            }
            record.setValue(list);
        }
        return record;
    }

    @Override
    public Object postNotifyChange(MechanismContext data) throws DWBusinessException {
        Object result = this.compositeMechanismCustomer.notifyChange(data);
        return result;
    }

    @Override
    public Object postMechanismWithContext(MechanismContext data) throws DWBusinessException {
        if (null == data.getMechanismKey() || null == data.getInstanceId()) {
            throw new IllegalArgumentException(I18nUtils.getValue("knowledgegraph.mechanismKeyOrInstanceIdEmpty", new Object[0]));
        }
        HashMap<String, Object> result = null;
        MechanismOld me = this.getDetail(data.getTenant(), data.getMechanismKey());
        this.abstractionHandler.dealWithAbstraction((Object)me, data);
        MechanismAchiveRecord record = this.findOne(data.getInstanceId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mechanism", (Object)me);
        map.put("record", record);
        data.setAttach(map);
        HashMap<String, Object> processed = this.compositeMechanismCustomer.filter(data);
        result = null != processed ? processed : map;
        return result;
    }

    @Override
    public Object postReadMechanismMaterialConfig(String mechanismCode, String tenantId) throws DWBusinessException {
        AbsEntityDict dic = this.getAbsEntityDict(mechanismCode, tenantId);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (dic != null && dic.getAbstraction().getParams() != null) {
            for (Variable v : dic.getAbstraction().getParams()) {
                if (v.getSourceType() == null || !v.getSourceType().equals("1")) continue;
                variables.add(v);
            }
        }
        return variables;
    }

    @Override
    public Object postReadMechanismMaterialConfig(String mechanismCode, String tenantId, OperationUnit operationUnit) throws DWBusinessException {
        AbsEntityDict dic = this.getAbsEntityDict(mechanismCode, tenantId, operationUnit);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (dic != null && dic.getAbstraction().getParams() != null) {
            for (Variable v : dic.getAbstraction().getParams()) {
                if (v.getSourceType() == null || !v.getSourceType().equals("1")) continue;
                variables.add(v);
            }
        }
        return variables;
    }

    @Override
    public Object postSaveMechanismMaterialConfig(String mechanismCode, String tenantId, Map<String, Object> variables) throws DWBusinessException {
        if (variables == null || variables.isEmpty()) {
            throw new DWArgumentException("variables", I18nUtils.getValue("knowledgegraph.variablesEmpty", new Object[0]));
        }
        AbsEntityDict dic = this.getAbsEntityDict(mechanismCode, tenantId);
        if (dic.getAbstraction().getParams() != null) {
            for (Variable v : dic.getAbstraction().getParams()) {
                if (!variables.containsKey(v.getKey())) continue;
                v.setValue(variables.get(v.getKey()));
            }
        }
        this.mongoTemplate2.save((Object)dic);
        return null;
    }

    @Override
    public Object postSaveMechanismMaterialConfig(String mechanismCode, String tenantId, Map<String, Object> variables, OperationUnit operationUnit) throws DWBusinessException {
        if (variables == null || variables.isEmpty()) {
            throw new DWArgumentException("variables", I18nUtils.getValue("knowledgegraph.variablesEmpty", new Object[0]));
        }
        AbsEntityDict dic = this.getAbsEntityDict(mechanismCode, tenantId, operationUnit);
        if (dic.getAbstraction().getParams() != null) {
            for (Variable v : dic.getAbstraction().getParams()) {
                if (!variables.containsKey(v.getKey())) continue;
                v.setValue(variables.get(v.getKey()));
            }
        }
        this.mongoTemplate2.save((Object)dic);
        return null;
    }

    private AbsEntityDict getAbsEntityDict(String mechanismCode, String tenantId) {
        Query query = new Query();
        Criteria c1 = Criteria.where((String)"tenant").is((Object)tenantId);
        Criteria c2 = Criteria.where((String)"category").is((Object)"MechanismAction");
        Criteria c3 = Criteria.where((String)"status").is((Object)1);
        Criteria c4 = Criteria.where((String)"abstraction.mechanismKey").is((Object)mechanismCode);
        Criteria c5 = Criteria.where((String)"operationUnit").is(null);
        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{c1, c2, c3, c4, c5}));
        return (AbsEntityDict)((Object)this.mongoTemplate2.findOne(query, AbsEntityDict.class));
    }

    private AbsEntityDict getAbsEntityDict(String mechanismCode, String tenantId, OperationUnit operationUnit) {
        Query query = new Query();
        Criteria c1 = Criteria.where((String)"tenant").is((Object)tenantId);
        Criteria c2 = Criteria.where((String)"category").is((Object)"MechanismAction");
        Criteria c3 = Criteria.where((String)"status").is((Object)1);
        Criteria c4 = Criteria.where((String)"abstraction.mechanismKey").is((Object)mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{c1, c2, c3, c4}));
        return (AbsEntityDict)((Object)this.mongoTemplate2.findOne(query, AbsEntityDict.class));
    }

    private MongoCollection<Document> getVariableCollection() throws DWBusinessException {
        return this.mongoTemplate2.getCollection("mechanismVariable");
    }

    @Override
    public MechanismScene getScene(MechanismOld mechanism, String[] keys) {
        if (null != mechanism && null != mechanism.getScenes() && null != keys) {
            Arrays.sort(keys);
            for (MechanismScene s : mechanism.getScenes()) {
                if (null == s.getKeys()) continue;
                Collections.sort(s.getKeys());
                if (!Arrays.equals(keys, s.getKeys().toArray())) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    public MechanismOld getDetail(String tenantId, String key) throws DWBusinessException {
        Session session = this.sessionFactory.openSession();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        MechanismOld me = this.mechanismRepository.findMechanism(tenantId, key, tenantVersion);
        Assert.notNull((Object)((Object)me), (String)("cant find MechanismOld by tenantId:" + tenantId + " and key:" + key));
        me = (MechanismOld)((Object)session.load(MechanismOld.class, (Serializable)me.getNeo4jId(), -1));
        Assert.notNull((Object)((Object)me), (String)("can`t find MechanismOld by tenantId:" + tenantId + " and version:" + me.getVersion()));
        return me;
    }

    private void saveRecord(MechanismAchiveRecord param) {
        long time = System.currentTimeMillis();
        if (param.getValue() instanceof List) {
            List value = (List)param.getValue();
            param.setValue(null);
            param.setValueIsArray(true);
            if (Boolean.TRUE.equals(param.getBatchAll())) {
                this.mongoTemplate2.remove(Query.query((CriteriaDefinition)Criteria.where((String)"instanceId").is((Object)param.getInstanceId())), MechanismItemRecord.class);
                ArrayList<MechanismItemRecord> records = new ArrayList<MechanismItemRecord>();
                for (Map item : value) {
                    MechanismItemRecord record = new MechanismItemRecord();
                    record.setInstanceId(param.getInstanceId());
                    record.setUpdateTime(time);
                    record.setValue(item);
                    records.add(record);
                }
                this.mongoTemplate2.insert(records, MechanismItemRecord.class);
            } else {
                for (Map item : value) {
                    if (null != param.getValueKeys()) {
                        Query query = new Query();
                        query.addCriteria((CriteriaDefinition)Criteria.where((String)"instanceId").is((Object)param.getInstanceId()));
                        boolean hasValue = false;
                        for (String key : param.getValueKeys()) {
                            Object v = item.get(key);
                            if (null == v) continue;
                            query.addCriteria((CriteriaDefinition)Criteria.where((String)("value." + key)).is(v));
                            hasValue = true;
                        }
                        if (!hasValue) continue;
                        Document doc = new Document();
                        doc.put("instanceId", (Object)param.getInstanceId());
                        doc.put("updateTime", (Object)time);
                        doc.put(MECHANISM_VARIABLE_VALUE_FIELD_NAME, (Object)item);
                        this.mongoTemplate2.remove(query, MechanismItemRecord.class);
                        MechanismItemRecord record = new MechanismItemRecord();
                        record.setInstanceId(param.getInstanceId());
                        record.setValue(item);
                        record.setUpdateTime(time);
                        this.mongoTemplate2.save((Object)record);
                        continue;
                    }
                    MechanismItemRecord record = new MechanismItemRecord();
                    record.setInstanceId(param.getInstanceId());
                    record.setValue(item);
                    record.setUpdateTime(time);
                    this.mongoTemplate2.save((Object)record);
                }
            }
        }
        if (null != param.getId() && param.getUpdateTime() > 0L) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"instanceId").is((Object)param.getInstanceId()).and("updateTime").is((Object)param.getUpdateTime()));
            this.mongoTemplate2.updateMulti(query, Update.update((String)"updateTime", (Object)time), MechanismItemRecord.class);
        }
        param.setUpdateTime(time);
        this.mongoTemplate2.save((Object)param);
    }

    @Override
    public Object deleteVariable(String variableName, String tenantId) throws Exception {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty", new Object[0]));
        }
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWArgumentException(TENANT_ID_KEY_NAME, I18nUtils.getValue("knowledgegraph.tenantIdEmpty", new Object[0]));
        }
        Query query = new Query();
        Criteria criteria1 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId);
        Criteria criteria2 = Criteria.where((String)MECHANISM_VARIABLE_ID_KEY_NAME).is((Object)variableName);
        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{criteria1, criteria2}));
        try {
            this.mongoTemplate2.remove(query, MechanismTenantVariable.class);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }
        return null;
    }

    @Override
    public Object postSaveMechanismExecuteParam(String mechanismCode, Map<String, Object> parameters) throws DWBusinessException {
        this.postSaveMechanismExecuteParam(mechanismCode, parameters, new OperationUnit());
        return null;
    }

    @Override
    public Object postSaveMechanismExecuteParam(String mechanismCode, Map<String, Object> parameters, OperationUnit operationUnit) throws DWBusinessException {
        if (CollectionUtils.isEmpty(parameters)) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        Criteria c1 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("mechanismCode").is((Object)mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria((CriteriaDefinition)c1);
        Set<Map.Entry<String, Object>> entries = parameters.entrySet();
        Update update = new Update();
        update.set("params", Arrays.asList(parameters));
        this.mongoTemplate2.upsert(query, update, "mechanismExecuteParams");
        return null;
    }

    @Override
    public Object postReadMechanismExecuteParam(String mechanismCode) throws DWBusinessException {
        return this.postReadMechanismExecuteParam(mechanismCode, new OperationUnit());
    }

    @Override
    public Object postReadMechanismExecuteParam(String mechanismCode, OperationUnit operationUnit) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        Criteria c1 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("mechanismCode").is((Object)mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria((CriteriaDefinition)c1);
        Map mechanismExecuteParams = (Map)this.mongoTemplate2.findOne(query, Map.class, "mechanismExecuteParams");
        if (mechanismExecuteParams == null) {
            return null;
        }
        return mechanismExecuteParams.get("params");
    }

    @Override
    public Object postCopyMechanismExecuteParam(String mechanismCode, OperationUnit sourceOperationUnit, OperationUnit operationUnit, List<String> monitorRuleIds) throws DWBusinessException {
        Object o1;
        Object o;
        List sourceMonitoerList = null;
        if (!CollectionUtils.isEmpty(monitorRuleIds)) {
            Query query = new Query();
            Criteria criteria = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)AthenaUtils.getTenantId()).and("monitorRuleId").in(monitorRuleIds);
            criteria = this.operationUnitService.addEocMapToCriteria(sourceOperationUnit, criteria);
            query.addCriteria((CriteriaDefinition)criteria);
            sourceMonitoerList = this.mongoTemplate2.find(query, MonitorRuleTenantConfig.class);
        }
        if (!CollectionUtils.isEmpty(sourceMonitoerList)) {
            for (MonitorRuleTenantConfig tenantConfig : sourceMonitoerList) {
                MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
                config.setStatus(tenantConfig.getStatus());
                config.setTenantId(tenantConfig.getTenantId());
                config.setEocMap(this.operationUnitService.transToEocMapDTO(operationUnit));
                config.setMonitorRuleId(tenantConfig.getMonitorRuleId());
                config.setProductName(tenantConfig.getProductName());
                config.setStandardPollingRule((TriggerDTO)JSON.parseObject((String)JSON.toJSONString((Object)tenantConfig.getStandardPollingRule()), TriggerDTO.class));
                try {
                    this.monitorRuleConfigService.post(config);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
        }
        if (!ObjectUtils.isEmpty((Object)(o = this.postReadMechanismExecuteParam(mechanismCode, sourceOperationUnit)))) {
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)o), Map.class);
            this.postSaveMechanismExecuteParam(mechanismCode, map, operationUnit);
        }
        if (!ObjectUtils.isEmpty((Object)(o1 = this.postReadMechanismMaterialConfig(mechanismCode, AthenaUtils.getTenantId(), sourceOperationUnit)))) {
            Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)o1), Map.class);
            this.postSaveMechanismMaterialConfig(mechanismCode, AthenaUtils.getTenantId(), map, operationUnit);
        }
        return null;
    }

    @Override
    public Object postCopyMechanismParam(String appCode, List<String> mechanismCodes, OperationUnit operationUnit, String tenantId, String copyTenantId) throws DWBusinessException {
        for (String mechanismCode : mechanismCodes) {
            this.copyMechanism(mechanismCode, operationUnit, tenantId, copyTenantId);
            this.copyMechanismExecuteParams(mechanismCode, operationUnit, tenantId, copyTenantId);
        }
        return null;
    }

    private void copyMechanismTenantParadigm(String appCode, OperationUnit operationUnit, String tenantId, String copyTenantId) {
        Query query = new Query();
        Criteria c1 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("code").is((Object)appCode);
        query.addCriteria((CriteriaDefinition)c1);
        Map mechanismMap = (Map)this.mongoTemplate2.findOne(query, Map.class, MECHANISM_TENANT_PARADIGM);
        if (mechanismMap != null) {
            Query query2 = new Query();
            Criteria c2 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)copyTenantId).and("code").is((Object)appCode);
            query2.addCriteria((CriteriaDefinition)c2);
            Update update = new Update();
            mechanismMap.remove("_id");
            mechanismMap.forEach((key, value) -> update.set((String)key, value));
            this.mongoTemplate2.upsert(query2, update, MECHANISM_TENANT_PARADIGM);
        }
    }

    private void copyMechanism(String mechanismCode, OperationUnit operationUnit, String tenantId, String copyTenantId) {
        Query query = new Query();
        Criteria c1 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("code").is((Object)mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria((CriteriaDefinition)c1);
        Map mechanismMap = (Map)this.mongoTemplate2.findOne(query, Map.class, "mechanism");
        if (mechanismMap != null) {
            Query query2 = new Query();
            Criteria c2 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)copyTenantId).and("code").is((Object)mechanismCode);
            c2 = this.operationUnitService.addOperationToCriteria(operationUnit, c2);
            query2.addCriteria((CriteriaDefinition)c2);
            Update update = new Update();
            mechanismMap.remove("_id");
            mechanismMap.forEach((key, value) -> update.set((String)key, value));
            this.mongoTemplate2.upsert(query2, update, "mechanism");
        }
    }

    private void copyMechanismExecuteParams(String mechanismCode, OperationUnit operationUnit, String tenantId, String copyTenantId) {
        Query query = new Query();
        Criteria c1 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("mechanismCode").is((Object)mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria((CriteriaDefinition)c1);
        Map mechanismMap = (Map)this.mongoTemplate2.findOne(query, Map.class, "mechanismExecuteParams");
        if (mechanismMap != null) {
            Query query2 = new Query();
            Criteria c2 = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)copyTenantId).and("code").is((Object)mechanismCode);
            c2 = this.operationUnitService.addOperationToCriteria(operationUnit, c2);
            query2.addCriteria((CriteriaDefinition)c2);
            Update update = new Update();
            mechanismMap.remove("_id");
            mechanismMap.forEach((key, value) -> update.set((String)key, value));
            this.mongoTemplate2.upsert(query2, update, "mechanismExecuteParams");
        }
    }

    @Override
    public Object postTimeIntervalCode() throws DWBusinessException {
        return this.postTimeIntervalCode("TraceMaterialMechanism");
    }

    @Override
    public Object postTimeIntervalCode(String mechanismCode) throws DWBusinessException {
        Object obj = this.postReadMechanismExecuteParam(mechanismCode);
        if (ObjectUtils.isEmpty((Object)obj)) {
            return new TraceMaterialIntervalVO();
        }
        JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString((Object)obj));
        if (jsonArray == null || jsonArray.size() == 0) {
            return new ArrayList();
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject1 = jsonArray.getJSONObject(i);
            if (ObjectUtils.isEmpty((Object)jsonObject1.get((Object)"traceMaterialInterval"))) continue;
            TraceMaterialIntervalVO traceMaterialIntervalVO = (TraceMaterialIntervalVO)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject1), TraceMaterialIntervalVO.class);
            return traceMaterialIntervalVO;
        }
        return new ArrayList();
    }

    @Override
    public Object getTimeIntervalDetailByCode(String code) throws DWBusinessException {
        Object obj = this.postReadMechanismExecuteParam("TraceMaterialMechanism");
        if (ObjectUtils.isEmpty((Object)obj)) {
            return null;
        }
        JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString((Object)obj));
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject1 = jsonArray.getJSONObject(i);
            if (ObjectUtils.isEmpty((Object)jsonObject1.get((Object)"traceMaterialInterval"))) continue;
            JSONArray jsonArray1 = JSONArray.parseArray((String)JSON.toJSONString((Object)jsonObject1.get((Object)"traceMaterialInterval")));
            for (int j = 0; j < jsonArray1.size(); ++j) {
                JSONObject jsonObject = jsonArray1.getJSONObject(j);
                if (!StringUtils.equalsIgnoreCase((CharSequence)jsonObject.getString("timeIntervalCode"), (CharSequence)code)) continue;
                return jsonObject.getString("detail");
            }
        }
        return null;
    }

    @Override
    public Object getMechanismExecuteTableParam(String code, String key, String column) throws DWBusinessException {
        HashMap result = new HashMap();
        Object obj = this.postReadMechanismExecuteParam(code);
        if (ObjectUtils.isEmpty((Object)obj)) {
            return result;
        }
        JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString((Object)obj));
        if (jsonArray == null || jsonArray.size() == 0) {
            return result;
        }
        ArrayList resultList = new ArrayList();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject1 = jsonArray.getJSONObject(i);
            if (ObjectUtils.isEmpty((Object)jsonObject1.get((Object)key))) continue;
            JSONArray jsonArray1 = JSON.parseArray((String)JSON.toJSONString((Object)jsonObject1.get((Object)key)));
            for (int j = 0; j < jsonArray1.size(); ++j) {
                HashMap<String, String> map = new HashMap<String, String>();
                String o = jsonArray1.getJSONObject(j).getString(column);
                map.put(column, o);
                resultList.add(map);
            }
        }
        result.put(key, resultList);
        return result;
    }

    @Override
    public Object getVariableTableParam(String variableName, String tenantId, String keyColumn, String key, String valueColumn) throws DWBusinessException {
        Object re = null;
        Map map = (Map)this.getVariable(variableName, tenantId);
        if (map != null && !map.isEmpty()) {
            JSONArray jsonArray = JSON.parseArray((String)JSON.toJSONString(map.get(variableName)));
            if (jsonArray == null || jsonArray.size() == 0) {
                return re;
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                if (!StringUtils.equals((CharSequence)((String)obj.get((Object)keyColumn)), (CharSequence)key)) continue;
                re = obj.get((Object)valueColumn);
                break;
            }
        }
        return re;
    }

    @Override
    public Object postQueryMechanismByCode(String code, OperationUnit operationUnit) throws DWBusinessException {
        return this.postQueryMechanismByCode(code, operationUnit, (Boolean)false);
    }

    @Override
    public Object postQueryMechanismByCode(String code, OperationUnit operationUnit, Boolean queryWithEocLevel) throws DWBusinessException {
        Criteria criteria;
        log.info("Route==>MechanismService  method=postQueryMechanismByCode code:{},ThreadId:{}", (Object)code, (Object)Thread.currentThread().getId());
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        if (queryWithEocLevel.booleanValue()) {
            String eocLevel = this.operationUnitService.getEocLevel(operationUnit);
            criteria = Criteria.where((String)"code").is((Object)code).and("eocLevel").is((Object)eocLevel).and("version").is((Object)tenantVersion);
        } else {
            criteria = Criteria.where((String)"code").is((Object)code).and("version").is((Object)tenantVersion);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        Mechanism mechanism = this.dataPickService.findOneByCondition(criteria, Mechanism.class, "mechanism");
        if (mechanism == null) {
            log.info("Route==>MechanismService  method=postQueryMechanismByCode tenantVersion:{}", (Object)tenantVersion);
            return null;
        }
        Mechanism tenantMechanism = this.getTenantMechanism(tenantId, code, operationUnit);
        MechanismMergeVO mechanismMergeVO = this.setMechanismPrinciple(mechanism, tenantMechanism == null ? null : tenantMechanism.getMergeVersion());
        if (tenantMechanism != null) {
            this.mergeMechanismPrinciple(mechanism, tenantMechanism, mechanismMergeVO);
        }
        mechanism.setMergeVersion(mechanismMergeVO == null ? null : mechanismMergeVO.getCurrentHighestMergeVersion());
        this.mechanismDesignService.mergeMechanismDesignInfo(mechanism, 1);
        return mechanism;
    }

    @Override
    public Object postQueryMechanismByCode(List<String> codeList, OperationUnit operationUnit, Boolean queryWithEocLevel) throws DWBusinessException {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        log.info("Route==>MechanismService  method=postQueryMechanismByCode codeList:{}", (Object)JSON.toJSONString(codeList));
        DWServiceContext context = DWServiceContext.getContext();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        CopyOnWriteArrayList result = new CopyOnWriteArrayList();
        List collect = codeList.stream().distinct().collect(Collectors.toList());
        CompletableFuture.allOf((CompletableFuture[])collect.stream().map(code -> {
            CompletableFuture.completedFuture(code);
            return CompletableFuture.runAsync(() -> {
                DWServiceContext.setContext((DWServiceContext)context);
                try {
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                    log.info("Route==>MechanismService  method=postQueryMechanismByCodeFuture code:{},ThreadId:{}", code, (Object)Thread.currentThread().getId());
                    Object o = this.postQueryMechanismByCode((String)code, operationUnit, queryWithEocLevel);
                    if (!ObjectUtils.isEmpty((Object)o)) {
                        result.add(o);
                    }
                    log.info("Route==>MechanismService  method=postQueryMechanismByCodeFuture o:{},ThreadId:{}", (Object)JSON.toJSONString((Object)o), (Object)Thread.currentThread().getId());
                }
                catch (Exception e) {
                    log.error("postQueryMechanismByCode error:", (Throwable)e);
                }
            }, Constants.APP_EXECUTE_POOL);
        }).toArray(CompletableFuture[]::new)).join();
        log.info("Route==>MechanismService  method=postQueryMechanismByCode response:{}", (Object)JSON.toJSONString(result));
        return result;
    }

    @Override
    public Object postQueryMechanismByCode(List<String> codeList, OperationUnit operationUnit) throws DWBusinessException {
        return this.postQueryMechanismByCode(codeList, operationUnit, (Boolean)false);
    }

    private void mergeMechanismPrinciple(Mechanism mechanism, Mechanism tenantMechanism, MechanismMergeVO mechanismMergeVO) {
        HashSet highMergeVersionMPSet;
        if (tenantMechanism == null) {
            return;
        }
        if (mechanism.getPrinciples() == null) {
            mechanism.setPrinciples(tenantMechanism.getPrinciples());
            return;
        }
        if (tenantMechanism.getPrinciples() == null) {
            return;
        }
        HashSet<String> tenantAllRelatedParamKeys = new HashSet<String>();
        HashSet tenantAllPdCodes = new HashSet();
        tenantMechanism.getPrinciples().forEach(e -> {
            List<PrincipleDetail> details = e.getDetails();
            if (!CollectionUtils.isEmpty(details)) {
                for (PrincipleDetail pd : details) {
                    if (!CollectionUtils.isEmpty(pd.getRelatedParamKeys())) {
                        tenantAllRelatedParamKeys.addAll(pd.getRelatedParamKeys());
                    }
                    tenantAllPdCodes.add(pd.getCode());
                }
            }
        });
        Set<Object> set = mechanismMergeVO == null ? new HashSet() : (highMergeVersionMPSet = mechanismMergeVO.getHighMergeVersionMPSet() == null ? new HashSet() : mechanismMergeVO.getHighMergeVersionMPSet());
        HashSet<String> highMergeVersionMPDSet = mechanismMergeVO == null ? new HashSet<String>() : (mechanismMergeVO.getHighMergeVersionMPDSet() == null ? new HashSet<String>() : mechanismMergeVO.getHighMergeVersionMPDSet());
        ArrayList<Principle> result = new ArrayList<Principle>();
        for (Principle principle : mechanism.getPrinciples()) {
            List<PrincipleDetail> toAddDetails;
            Principle tenantPrincipleByCode = this.getTenantPrincipleByCode(tenantMechanism.getPrinciples(), principle.getCode());
            if (tenantPrincipleByCode == null) {
                if (!highMergeVersionMPSet.contains(principle.getCode())) continue;
                toAddDetails = this.getPrincipleDetails(tenantAllRelatedParamKeys, highMergeVersionMPDSet, principle, tenantPrincipleByCode);
                principle.setDetails(toAddDetails);
                result.add(principle);
                continue;
            }
            toAddDetails = this.getPrincipleDetails(tenantAllRelatedParamKeys, highMergeVersionMPDSet, principle, tenantPrincipleByCode);
            tenantPrincipleByCode.setDetails(toAddDetails);
            result.add(tenantPrincipleByCode);
        }
        mechanism.setPrinciples(result);
    }

    private List<PrincipleDetail> getPrincipleDetails(Set<String> tenantAllRelatedParamKeys, Set<String> highMergeVersionMPDSet, Principle principle, Principle tenantPrincipleByCode) {
        List<PrincipleDetail> details = principle.getDetails();
        ArrayList<PrincipleDetail> toAddDetails = new ArrayList<PrincipleDetail>();
        for (PrincipleDetail principleDetail : details) {
            List<String> newRelatedParamKeys;
            PrincipleDetail tenantPrincipleDetailByCode = this.getTenantPrincipleDetailByCode(tenantPrincipleByCode, principleDetail.getCode());
            if (tenantPrincipleDetailByCode == null) {
                if (!highMergeVersionMPDSet.contains(principleDetail.getCode())) continue;
                newRelatedParamKeys = this.getNewRelatedParamKeys(principleDetail.getRelatedParamKeys(), null, tenantAllRelatedParamKeys);
                principleDetail.setRelatedParamKeys(newRelatedParamKeys);
                toAddDetails.add(principleDetail);
                continue;
            }
            newRelatedParamKeys = this.getNewRelatedParamKeys(principleDetail.getRelatedParamKeys(), tenantPrincipleDetailByCode.getRelatedParamKeys(), tenantAllRelatedParamKeys);
            tenantPrincipleDetailByCode.setRelatedParamKeys(newRelatedParamKeys);
            toAddDetails.add(tenantPrincipleDetailByCode);
        }
        return toAddDetails;
    }

    private List<String> getNewRelatedParamKeys(List<String> sysKeys, List<String> tenantKeys, Set<String> tenantAllRelatedParamKeys) {
        if (CollectionUtils.isEmpty(sysKeys)) {
            return tenantKeys;
        }
        if (tenantKeys == null) {
            tenantKeys = new ArrayList<String>();
        }
        ArrayList<String> toAdd = new ArrayList<String>();
        for (String key : sysKeys) {
            if (tenantKeys.contains(key) || tenantAllRelatedParamKeys.contains(key)) continue;
            toAdd.add(key);
        }
        if (!CollectionUtils.isEmpty(toAdd)) {
            tenantKeys.addAll(toAdd);
        }
        return tenantKeys;
    }

    private PrincipleDetail getTenantPrincipleDetailByCode(Principle tenantPrinciple, String code) {
        if (tenantPrinciple == null || CollectionUtils.isEmpty(tenantPrinciple.getDetails()) || StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Optional<PrincipleDetail> first = tenantPrinciple.getDetails().stream().filter(e -> StringUtils.equals((CharSequence)code, (CharSequence)e.getCode())).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    private Principle getTenantPrincipleByCode(List<Principle> tenantPrinciple, String code) {
        if (CollectionUtils.isEmpty(tenantPrinciple) || StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Optional<Principle> first = tenantPrinciple.stream().filter(e -> StringUtils.equals((CharSequence)code, (CharSequence)e.getCode())).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    private MechanismMergeVO setMechanismPrinciple(Mechanism mechanism, String tenantMergeVersion) throws DWBusinessException {
        MechanismMergeVO mechanismMergeVO = new MechanismMergeVO();
        HashSet<String> highMergeVersionMPSet = new HashSet<String>();
        HashSet<String> highMergeVersionMPDSet = new HashSet<String>();
        mechanismMergeVO.setHighMergeVersionMPSet(highMergeVersionMPSet);
        mechanismMergeVO.setHighMergeVersionMPDSet(highMergeVersionMPDSet);
        ComponentStructuredList mechanismComponentStructuredList = null;
        String tenantId = AthenaUtils.getTenantId();
        String version = this.kgInnerService.getTenantVersion(tenantId);
        try {
            mechanismComponentStructuredList = this.componentManager.findMechanismComponentStructuredList(mechanism.getCode(), version, tenantId);
        }
        catch (DWBusinessException e) {
            log.info("\u672a\u5728\u7ec4\u4ef6\u6e05\u5355\u4e2d\u627e\u5230\u6570\u636e" + e.getMessage());
            return mechanismMergeVO;
        }
        if (mechanismComponentStructuredList != null) {
            List<StructuredComponentBO> components = mechanismComponentStructuredList.getComponents();
            ArrayList<Principle> principles = new ArrayList<Principle>();
            ArrayList paramDescriptionList = new ArrayList();
            ArrayList<ComponentBO> paramDescriptionComponentList = new ArrayList<ComponentBO>();
            if (!CollectionUtils.isEmpty(components)) {
                for (StructuredComponentBO structuredComponentDO : components) {
                    List subComponents;
                    String mergeVersion;
                    String code;
                    Principle principle;
                    ComponentTypeEnum type = structuredComponentDO.getType();
                    if (!ComponentTypeEnum.MechanismPrinciple.equals((Object)type) || (principle = this.getPrincipleByCode(code = structuredComponentDO.getCode())) == null) continue;
                    String string = structuredComponentDO.getConfigs() == null ? null : (mergeVersion = ObjectUtils.isEmpty(structuredComponentDO.getConfigs().get("mergeVersion")) ? null : String.valueOf(structuredComponentDO.getConfigs().get("mergeVersion")));
                    if (VersionUtil.compareVersion(mergeVersion, tenantMergeVersion) > 0) {
                        highMergeVersionMPSet.add(code);
                        mechanismMergeVO.compareAndSetMergeVersion(mergeVersion);
                    }
                    if (!CollectionUtils.isEmpty((Collection)(subComponents = structuredComponentDO.getSubComponents()))) {
                        ArrayList<PrincipleDetail> principleDetails = new ArrayList<PrincipleDetail>();
                        for (StructuredComponentBO subComponent : subComponents) {
                            List pdSubComponents;
                            String mergeVersion2;
                            PrincipleDetail principleDetail;
                            if (!ComponentTypeEnum.MechanismPrincipleDetail.equals((Object)subComponent.getType()) || (principleDetail = this.getPrincipleDetailByComponent(subComponent)) == null) continue;
                            String string2 = subComponent.getConfigs() == null ? null : (mergeVersion2 = ObjectUtils.isEmpty(subComponent.getConfigs().get("mergeVersion")) ? null : String.valueOf(subComponent.getConfigs().get("mergeVersion")));
                            if (VersionUtil.compareVersion(mergeVersion2, tenantMergeVersion) > 0) {
                                highMergeVersionMPDSet.add(subComponent.getCode());
                                mechanismMergeVO.compareAndSetMergeVersion(mergeVersion2);
                            }
                            if (!CollectionUtils.isEmpty((Collection)(pdSubComponents = subComponent.getSubComponents()))) {
                                ArrayList<String> relatedParamKeys = new ArrayList<String>();
                                for (StructuredComponentBO pdSubComponent : pdSubComponents) {
                                    relatedParamKeys.add(pdSubComponent.getCode());
                                    if (!BooleanUtils.isNotTrue((Boolean)pdSubComponent.getHidden())) continue;
                                    paramDescriptionComponentList.add((ComponentBO)pdSubComponent);
                                }
                                principleDetail.setRelatedParamKeys(relatedParamKeys);
                            }
                            principleDetails.add(principleDetail);
                        }
                        principle.setDetails(principleDetails);
                    }
                    principles.add(principle);
                }
            }
            mechanism.setPrinciples(principles);
            mechanism.setParamDescription(this.componentManager.generateParamDescriptionList(paramDescriptionComponentList));
        }
        return mechanismMergeVO;
    }

    @Override
    public Principle getPrincipleByCode(String code) throws DWBusinessException {
        return this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)code), Principle.class, "principle");
    }

    @Override
    public PrincipleDetail getPrincipleDetailByComponent(StructuredComponentBO subComponent) throws DWBusinessException {
        if (subComponent instanceof MechanismPrincipleDetailComponentBO) {
            List otherParamKeys = ((MechanismPrincipleDetailComponentBO)subComponent).getOtherParamKeys();
            PrincipleDetail principleDetailByCode = this.getPrincipleDetailByCode(subComponent.getCode());
            principleDetailByCode.setOtherParamKeys(otherParamKeys);
            return principleDetailByCode;
        }
        return this.getPrincipleDetailByCode(subComponent.getCode());
    }

    @Override
    public PrincipleDetail getPrincipleDetailByCode(String code) throws DWBusinessException {
        return this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)code), PrincipleDetail.class, "principleDetail");
    }

    @Override
    public Object postQueryTenantMechanismByCode(String code, OperationUnit operationUnit) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return this.getTenantMechanism(tenantId, code, operationUnit);
    }

    private Mechanism getTenantMechanism(String tenantId, String code, OperationUnit operationUnit) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and(TENANT_ID_KEY_NAME).is((Object)tenantId);
        Criteria criteria1 = this.operationUnitService.addEocMapToCriteria(operationUnit, criteria);
        query.addCriteria((CriteriaDefinition)criteria1);
        return (Mechanism)((Object)this.mongoTemplate2.findOne(query, Mechanism.class));
    }

    @Override
    public List<String> getVariableCode(String mechanismCode) throws DWBusinessException {
        ArrayList<String> re = new ArrayList<String>();
        List<MechanismRelation> relations = this.dataPickService.find(Criteria.where((String)"type").is((Object)"variable").and("mechanismCode").is((Object)mechanismCode), MechanismRelation.class, "mechanismRelation");
        relations.forEach(r -> re.add(r.getCode()));
        return re;
    }

    @Override
    public List<String> getMonitorRuleCode(String mechanismCode) throws DWBusinessException {
        ArrayList<String> codes = new ArrayList<String>();
        List<MechanismRelation> relations = this.dataPickService.find(Criteria.where((String)"type").is((Object)"monitorRule").and("mechanismCode").is((Object)mechanismCode), MechanismRelation.class, "mechanismRelation");
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    @Override
    public Map<String, String> postParadigmCode(List<String> mechanismCode) throws DWBusinessException {
        String version = this.kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
        List<ComponentStructuredList> mechanismComponentStructuredList = this.componentManager.findMechanismComponentStructuredList(mechanismCode, version, null);
        if (CollectionUtils.isEmpty(mechanismComponentStructuredList)) {
            return null;
        }
        return mechanismComponentStructuredList.stream().collect(Collectors.toMap(ComponentStructuredList::getMechanismCode, ComponentStructuredList::getParadigm, (a, b) -> a));
    }

    @Override
    public List<Paradigm> postParadigmNameAndCode(List<String> paradigmTypeCodeList) throws DWBusinessException {
        return this.dataPickService.find(Criteria.where((String)"code").in(paradigmTypeCodeList), Paradigm.class, "paradigm");
    }

    private void processMonitorRule(Mechanism mechanism) throws DWBusinessException {
        List<String> ruleList = this.getMonitorRuleCode(mechanism.getCode());
        if (ruleList != null && !ruleList.isEmpty()) {
            if (mechanism.getParamDescription() != null) {
                int seq = 1000;
                for (String ruleId : ruleList) {
                    boolean existed = false;
                    for (FieldDescription p : mechanism.getParamDescription()) {
                        if (!p.getCategory().toLowerCase(Locale.ROOT).equals("period") || !p.getExtendData().equals(ruleId)) continue;
                        existed = true;
                        break;
                    }
                    if (existed) continue;
                    FieldDescription para = this.appService.createMonitorRuleParam(ruleId, false);
                    para.setSequence(Integer.valueOf(seq));
                    seq += 10;
                    mechanism.getParamDescription().add(para);
                }
            } else {
                ArrayList<FieldDescription> paras = new ArrayList<FieldDescription>();
                int seq = 1000;
                for (String ruleId : ruleList) {
                    FieldDescription para = this.appService.createMonitorRuleParam(ruleId, false);
                    para.setSequence(Integer.valueOf(seq));
                    paras.add(para);
                    seq += 10;
                }
                mechanism.setParamDescription(paras);
            }
        }
    }

    private void processVariable(Mechanism mechanism) throws DWBusinessException {
        List<String> variableList = this.getVariableCode(mechanism.getCode());
        if (variableList != null && !variableList.isEmpty()) {
            if (mechanism.getParamDescription() != null) {
                int seq = 1000;
                for (String code : variableList) {
                    boolean existed = false;
                    for (FieldDescription p : mechanism.getParamDescription()) {
                        if (!p.getCategory().toLowerCase(Locale.ROOT).equals("variable") || !p.getKey().equals(code)) continue;
                        existed = true;
                        break;
                    }
                    if (existed) continue;
                    FieldDescription para = this.appService.createVariableParam(code);
                    para.setSequence(Integer.valueOf(seq));
                    mechanism.getParamDescription().add(para);
                    seq += 10;
                }
            } else {
                ArrayList<FieldDescription> paras = new ArrayList<FieldDescription>();
                int seq = 1000;
                for (String code : variableList) {
                    FieldDescription para = this.appService.createVariableParam(code);
                    para.setSequence(Integer.valueOf(seq));
                    paras.add(para);
                    seq += 10;
                }
                mechanism.setParamDescription(paras);
            }
        }
    }

    @Override
    public Object postUpdateTenantMechanism(String code, String name, List<Principle> principles, OperationUnit operationUnit) throws DWBusinessException {
        this.postUpdateTenantMechanism(code, name, principles, operationUnit, null);
        return null;
    }

    private void syncTenantMechanism(String mechanismCode) throws DWBusinessException {
        List needToUnapplyCapacity;
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.tenantService.getTenantVersion(tenantId);
        Query sysMechanismQuery = new Query();
        sysMechanismQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"mechanismCode").is((Object)mechanismCode).and(TENANT_ID_KEY_NAME).is((Object)SYSTEM).and("version").is((Object)tenantVersion));
        List<MechanismCapacity> sysMechanismCapacities = this.mongoTemplateSystem.find(sysMechanismQuery, MechanismCapacity.class);
        sysMechanismCapacities = this.dataPickService.excludeWithSameCode(sysMechanismCapacities, BaseEntity::getCode, HierarchicalEntity::getSourceLevel);
        Set sysCapacityCodes = sysMechanismCapacities.stream().map(BaseEntity::getCode).collect(Collectors.toSet());
        List userMechanismCapacities = this.mongoTemplate2.find(Query.query((CriteriaDefinition)Criteria.where((String)"mechanismCode").is((Object)mechanismCode).and(TENANT_ID_KEY_NAME).is((Object)tenantId).and("createdByDevPlatform").is((Object)true)), MechanismCapacity.class);
        List canRemovedCapacities = userMechanismCapacities.stream().filter(each -> sysCapacityCodes.contains(each.getCode())).collect(Collectors.toList());
        if (!canRemovedCapacities.isEmpty()) {
            this.mongoTemplate2.remove(Query.query((CriteriaDefinition)Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("code").in((Collection)canRemovedCapacities.stream().map(BaseEntity::getCode).collect(Collectors.toList()))), MechanismCapacity.class);
            this.mongoTemplate2.remove(Query.query((CriteriaDefinition)Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("code").in((Collection)canRemovedCapacities.stream().map(BaseEntity::getCode).collect(Collectors.toList()))), MechanismLogic.class);
        }
        if (!(needToUnapplyCapacity = userMechanismCapacities.stream().filter(each -> !sysCapacityCodes.contains(each.getCode())).collect(Collectors.toList())).isEmpty()) {
            this.mongoTemplate2.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("code").in((Collection)needToUnapplyCapacity.stream().map(BaseEntity::getCode).collect(Collectors.toList()))), Update.update((String)"deletedByDevPlatform", (Object)true), MechanismCapacity.class);
        }
        if (sysMechanismCapacities.isEmpty()) {
            return;
        }
        List userModifiedCapacities = this.mongoTemplate2.find(Query.query((CriteriaDefinition)Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("code").in(sysCapacityCodes).and("createdByDevPlatform").is((Object)false)), MechanismCapacity.class);
        List userModifiedCapacityCodes = userModifiedCapacities.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        List needSyncCapacities = sysMechanismCapacities.stream().filter(each -> !userModifiedCapacityCodes.contains(each.getCode())).collect(Collectors.toList());
        if (needSyncCapacities.isEmpty()) {
            return;
        }
        ArrayList<MechanismCapacity> mechanismCapacities = new ArrayList<MechanismCapacity>(needSyncCapacities.size());
        Map tentRemovedCapacity = canRemovedCapacities.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a));
        for (MechanismCapacity sysMechanismCapacity : needSyncCapacities) {
            MechanismCapacity mechanismCapacity = this.kgHelpService.convert(sysMechanismCapacity, MechanismCapacity.class);
            mechanismCapacity.setTenantId(tenantId);
            mechanismCapacity.setVersion(tenantVersion);
            mechanismCapacity.setHasApply(Boolean.valueOf(tentRemovedCapacity.containsKey(sysMechanismCapacity.getCode()) ? ((MechanismCapacity)tentRemovedCapacity.get(sysMechanismCapacity.getCode())).getHasApply() : false));
            mechanismCapacity.setId(null);
            mechanismCapacities.add(mechanismCapacity);
        }
        this.mongoTemplate2.insertAll(mechanismCapacities);
        List needSyncMechanismCodes = needSyncCapacities.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        Query sysMechanismLogicCodes = Query.query((CriteriaDefinition)Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)SYSTEM).and("version").is((Object)tenantVersion).and("code").in(needSyncMechanismCodes));
        List<MechanismLogic> sysLogics = this.mongoTemplateSystem.find(sysMechanismLogicCodes, MechanismLogic.class);
        sysLogics = this.dataPickService.excludeWithSameCode(sysLogics, BaseEntity::getCode, HierarchicalEntity::getSourceLevel);
        ArrayList<MechanismLogic> mechanismLogics = new ArrayList<MechanismLogic>(sysLogics.size());
        for (MechanismLogic sysLogic : sysLogics) {
            MechanismLogic mechanismLogic = this.kgHelpService.convert(sysLogic, MechanismLogic.class);
            mechanismLogic.setTenantId(tenantId);
            mechanismLogic.setVersion(tenantVersion);
            mechanismLogics.add(mechanismLogic);
            mechanismLogic.setId(null);
        }
        this.mongoTemplate2.insertAll(mechanismLogics);
    }

    @Override
    public Object postUpdateTenantMechanism(String code, String name, List<Principle> principles, OperationUnit operationUnit, String mergeVersion) throws DWBusinessException {
        this.syncTenantMechanism(code);
        String tenantId = AthenaUtils.getTenantId();
        MechanismUserDesignerInfo mechanismUserDesignerInfo = this.extractUserDesignMechanismCapacity(principles);
        mechanismUserDesignerInfo.setMechanismCode(code);
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and(TENANT_ID_KEY_NAME).is((Object)tenantId);
        Criteria criteria1 = this.operationUnitService.addOperationToCriteria(operationUnit, criteria);
        query.addCriteria((CriteriaDefinition)criteria1);
        Update update = new Update();
        update.set("name", (Object)name);
        update.set("principles", principles);
        update.set("mergeVersion", (Object)mergeVersion);
        this.mongoTemplate2.upsert(query, update, "mechanism");
        this.dataMapService.mechanismPluginMerge(tenantId, Arrays.asList(code));
        this.updateTenantComponentList(code, tenantId);
        this.mechanismDesignService.updateUserDesignMechanismInfo(mechanismUserDesignerInfo);
        return null;
    }

    private MechanismUserDesignerInfo extractUserDesignMechanismCapacity(List<Principle> principles) {
        MechanismUserDesignerInfo mechanismUserDesignerInfo = new MechanismUserDesignerInfo();
        ArrayList<MechanismTheory> mechanismTheoryList = new ArrayList<MechanismTheory>();
        ArrayList<MechanismCapacity> mechanismCapacityList = new ArrayList<MechanismCapacity>();
        mechanismUserDesignerInfo.setCapacity(mechanismCapacityList);
        mechanismUserDesignerInfo.setTheory(mechanismTheoryList);
        if (!CollectionUtils.isEmpty(principles)) {
            Iterator<Principle> iterator = principles.iterator();
            while (iterator.hasNext()) {
                Principle next = iterator.next();
                if ("user".equals(next.getFrom())) {
                    MechanismTheory mechanismTheory = new MechanismTheory();
                    mechanismTheory.setTitle(next.getTitle());
                    mechanismTheory.setCode(next.getCode());
                    mechanismTheory.setLang(next.getLang());
                    mechanismTheoryList.add(mechanismTheory);
                    List<PrincipleDetail> details = next.getDetails();
                    if (!CollectionUtils.isEmpty(details)) {
                        details.forEach(e -> {
                            if (e.getCode().startsWith("ud_pd_")) {
                                com.digiwin.athena.mechanism.pre.PrincipleDetail principleDetail = (com.digiwin.athena.mechanism.pre.PrincipleDetail)JSON.parseObject((String)JSON.toJSONString((Object)e), com.digiwin.athena.mechanism.pre.PrincipleDetail.class);
                                mechanismTheory.setDetails(Arrays.asList(principleDetail));
                            } else {
                                mechanismCapacityList.add(this.transToMechanismCapacity((PrincipleDetail)((Object)e), next.getCode()));
                            }
                        });
                    }
                    iterator.remove();
                    continue;
                }
                List<PrincipleDetail> details = next.getDetails();
                if (CollectionUtils.isEmpty(details)) continue;
                Iterator<PrincipleDetail> pdIterator = details.iterator();
                while (pdIterator.hasNext()) {
                    PrincipleDetail principleDetail = pdIterator.next();
                    if (!"user".equals(principleDetail.getFrom())) continue;
                    mechanismCapacityList.add(this.transToMechanismCapacity(principleDetail, next.getCode()));
                    pdIterator.remove();
                }
            }
        }
        return mechanismUserDesignerInfo;
    }

    private MechanismCapacity transToMechanismCapacity(PrincipleDetail principleDetail, String pCode) {
        MechanismCapacity capacity = new MechanismCapacity();
        capacity.setMechanismTheoryCode(pCode);
        capacity.setCode(principleDetail.getCode());
        capacity.setName(principleDetail.getTitle());
        capacity.setDescription(principleDetail.getDescription());
        capacity.setLang(principleDetail.getLang());
        return capacity;
    }

    @Override
    public Object getMechanismTenantParadigm(String code, String tenantId) throws DWBusinessException {
        Query query = new Query();
        Criteria criteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"code").is((Object)code), Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId)});
        query.fields().include(MECHANISM_VARIABLE_VALUE_FIELD_NAME);
        query.addCriteria((CriteriaDefinition)criteria);
        Map ten = (Map)this.mongoTemplate2.findOne(query, Map.class, MECHANISM_TENANT_PARADIGM);
        return ten == null ? new ArrayList() : (CollectionUtils.isEmpty((Collection)((List)ten.get(MECHANISM_VARIABLE_VALUE_FIELD_NAME))) ? new ArrayList() : (List)ten.get(MECHANISM_VARIABLE_VALUE_FIELD_NAME));
    }

    @Override
    public Object postMechanismTenantParadigm(String code, String tenantId, List<String> value) throws DWBusinessException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("code").is((Object)code));
        Update update = Update.update((String)MECHANISM_VARIABLE_VALUE_FIELD_NAME, value);
        return this.mongoTemplate2.upsert(query, update, MECHANISM_TENANT_PARADIGM);
    }

    @Override
    public Object postClearTenantMechanism(String code, OperationUnit operationUnit) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"code").is((Object)code).and(TENANT_ID_KEY_NAME).is((Object)tenantId);
        Criteria criteria1 = this.operationUnitService.addOperationToCriteria(operationUnit, criteria);
        query.addCriteria((CriteriaDefinition)criteria1);
        this.mongoTemplate2.remove(query, "mechanism");
        this.updateTenantComponentList(code, tenantId);
        this.postClearTenantMechanismCapacity(code, operationUnit);
        return null;
    }

    private void postClearTenantMechanismCapacity(String code, OperationUnit operationUnit) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"mechanismCode").is((Object)code).and(TENANT_ID_KEY_NAME).is((Object)tenantId);
        Criteria criteria1 = this.operationUnitService.addOperationToCriteria(operationUnit, criteria);
        query.addCriteria((CriteriaDefinition)criteria1);
        this.mongoTemplate2.remove(query, "mechanismCapacity");
    }

    @Override
    public Object postSaveMechanismLogic(MechanismLogic logic) throws DWBusinessException {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)logic.getCode()));
        Update update = Utils.toUpdate(logic);
        this.mongoTemplateSystem.upsert(query, update, MechanismLogic.class);
        return null;
    }

    @Override
    public Object getMechanismLogic(String code) throws DWBusinessException {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code));
        MechanismLogic logic = (MechanismLogic)this.mongoTemplateSystem.findOne(query, MechanismLogic.class);
        return logic;
    }

    @Override
    public Object getDeleteMechanismLogic(String code) throws DWBusinessException {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code));
        this.mongoTemplateSystem.remove(query, MechanismLogic.class);
        return null;
    }

    @Override
    public Object getHasGroundEnd() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List allSteadyProductList = (List)this.productService.getAllSteadyProduct();
        try {
            Object o = this.productNameResolver.tenantProductOperationList(tenantId);
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)o));
            JSONArray gateways = jsonObject.getJSONArray("prod_eoc_mapping");
            if (gateways == null) {
                return "N";
            }
            for (int i = 0; i < gateways.size(); ++i) {
                String prod_name = gateways.getJSONObject(i).getString("prod_name");
                if (!allSteadyProductList.contains(prod_name)) continue;
                if (this.iamUtils.isTenantOperationUnitV2()) {
                    return ObjectUtils.isEmpty((Object)gateways.getJSONObject(i).get((Object)"eoc_mapping_id")) ? "Y" : "N";
                }
                return !ObjectUtils.isEmpty((Object)gateways.getJSONObject(i).get((Object)"org_type_company")) || !ObjectUtils.isEmpty((Object)gateways.getJSONObject(i).get((Object)"org_type_region")) ? "Y" : "N";
            }
        }
        catch (Exception e) {
            log.error("hasGroundEnd\u83b7\u53d6\u4ea7\u54c1\u4fe1\u606f\u5931\u8d25:{}", (Throwable)e);
            return "N";
        }
        return "N";
    }

    @Override
    public Object getBuildGraph(String mechanismCode) throws DWBusinessException {
        String nodeId = this.mechanismGraphService.buildMechanismGraph(mechanismCode);
        return nodeId;
    }

    @Override
    public Object getMechanismSort(String appCode) throws DWBusinessException {
        MechanismSettings res = this.dataPickService.findOneByCondition(Criteria.where((String)"appCode").is((Object)appCode), MechanismSettings.class, "mechanismSettings");
        return res != null ? res.getSort() : null;
    }

    @Override
    public Object getMechanismAndParadigmSort(String appCode) throws DWBusinessException {
        return this.dataPickService.findOneByCondition(Criteria.where((String)"appCode").is((Object)appCode), MechanismSettings.class, "mechanismSettings");
    }

    private void updateTenantComponentList(String mechanismCode, String tenantId) throws DWBusinessException {
        List<ApplicationRelation> relations = this.appService.getAppCodeByMechanismCode(mechanismCode);
        if (relations.size() == 0) {
            return;
        }
        String appCode = relations.get(0).getAppCode();
        List mechanismList = (List)this.getMechanismTenantParadigm(appCode, tenantId);
        ArrayList<String> mechanismCodes = new ArrayList<String>();
        mechanismList.forEach(mechanism -> mechanismCodes.add(mechanism.toString()));
        try {
            String paradigm;
            String version = this.kgInnerService.getTenantVersion(tenantId);
            ComponentStructuredList mechanismComponentStructuredList = this.componentManager.findMechanismComponentStructuredList(mechanismCode, version, tenantId);
            String string = paradigm = mechanismComponentStructuredList == null ? null : mechanismComponentStructuredList.getParadigm();
            if (paradigm == null) {
                log.error("paradigm not found or not mechanisms found  of tenant {} componentList for {}", (Object)tenantId, (Object)appCode);
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.paradigmNotFound", new Object[0]));
            }
            this.componentManager.UpdateTenantApplicationComponentListByMechanism(appCode, tenantId, paradigm, mechanismCodes, mechanismCode);
        }
        catch (Exception ex) {
            log.error("error while updating component list of tenant {} componentList for {}", (Object)tenantId, (Object)appCode);
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public Object postMechanismPluginsMerge(String mechanismCode) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)mechanismCode));
        query.fields().include(TENANT_ID_KEY_NAME);
        List mechanismList = this.mongoTemplate2.find(query, Map.class, "mechanism");
        if (!CollectionUtils.isEmpty((Collection)mechanismList)) {
            for (Map map : mechanismList) {
                try {
                    String tenantId = String.valueOf(map.get(TENANT_ID_KEY_NAME));
                    log.info("mechanismPluginMerge tenantId:{}, plugins:{}", (Object)tenantId, (Object)mechanismCode);
                    this.dataMapService.mechanismPluginMerge(tenantId, Arrays.asList(mechanismCode));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public Object postMechanismApplyRecord(Map query) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        query.put(TENANT_ID_KEY_NAME, tenantId);
        Query q = this.kgHelpService.buildQuery(query);
        List records = this.mongoTemplate2.find(q, MechanismApplyRecord.class);
        return records;
    }

    @Override
    public Object postMechanismExecuteParamsUpdate(String tenantId) {
        Criteria criteria = Criteria.where((String)"mechanismCode").is((Object)"TraceMaterialLevelMechanism");
        if (StringUtils.isNotEmpty((CharSequence)tenantId)) {
            criteria.and(TENANT_ID_KEY_NAME).is((Object)tenantId);
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoCollection collection = this.mongoTemplate2.getCollection("mechanismExecuteParams");
        MongoCursor cursor = collection.find((Bson)query.getQueryObject()).iterator();
        Integer count = 0;
        while (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            Document traceMaterialLevel = (Document)((List)doc.get((Object)"params", List.class)).get(0);
            List onTimeArrivalLevels = (List)traceMaterialLevel.get((Object)"traceMaterialLevel", List.class);
            for (Document onTimeArrivalLevel : onTimeArrivalLevels) {
                String level = onTimeArrivalLevel.getString((Object)"onTimeArrivalLevel");
                Object defaultAdmissionLevel = onTimeArrivalLevel.get((Object)"defaultAdmissionLevel");
                if (!"A".equals(level) || !ObjectUtils.isEmpty((Object)defaultAdmissionLevel)) continue;
                onTimeArrivalLevel.append("defaultAdmissionLevel", (Object)true);
                collection.replaceOne(Filters.eq((String)"_id", (Object)doc.get((Object)"_id")), (Object)doc);
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
        }
        return count;
    }

    @Override
    public Object getPwdCustomizeVariable(String variableCode, String tenantId) throws DWBusinessException {
        if (variableCode == null || variableCode.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty", new Object[0]));
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)MECHANISM_VARIABLE_ID_KEY_NAME).is((Object)variableCode).and(TENANT_ID_KEY_NAME).is((Object)tenantId));
        MechanismTenantVariable tenantVariable = (MechanismTenantVariable)this.mongoTemplate2.findOne(query, MechanismTenantVariable.class);
        Object val = null;
        if (tenantVariable == null) {
            HashMap<String, String> keyConditions = new HashMap<String, String>();
            keyConditions.put("code", variableCode);
            VariableDefinition def = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)variableCode), VariableDefinition.class, "variableDefinition");
            if (def != null) {
                val = def.getDefaultValue();
            }
        } else {
            val = tenantVariable.getValue();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(variableCode, this.pwdCustomizeValConvert(variableCode, val));
        return result;
    }

    private Object pwdCustomizeValConvert(String variableName, Object val) {
        if (!"material_recovery_plan".equals(variableName) || val == null) {
            return val;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)val));
        Hashtable<Integer, JSONArray> map = new Hashtable<Integer, JSONArray>();
        int index = 0;
        if (jsonArray != null && !jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject.containsKey((Object)"times")) {
                    JSONArray array = new JSONArray();
                    Object value = jsonObject.getJSONObject("beforeDays").get((Object)MECHANISM_VARIABLE_VALUE_FIELD_NAME);
                    if (value != null) {
                        value = NumberUtil.parseInt((String)String.valueOf(value));
                    }
                    array.add(value);
                    map.put(i, array);
                    index = i;
                } else {
                    map.computeIfAbsent(index, k -> new JSONArray());
                    Iterator value = jsonObject.getJSONObject("beforeDays").get((Object)MECHANISM_VARIABLE_VALUE_FIELD_NAME);
                    if (value != null) {
                        value = NumberUtil.parseInt((String)String.valueOf(value));
                    }
                    ((JSONArray)map.get(index)).add((Object)value);
                }
                for (String key : jsonObject.keySet()) {
                    if (key.equals("beforeDays")) continue;
                    Object value = jsonObject.getJSONObject(key).get((Object)MECHANISM_VARIABLE_VALUE_FIELD_NAME);
                    if (value != null) {
                        value = NumberUtil.parseInt((String)String.valueOf(value));
                    }
                    jsonObject.put(key, value);
                }
            }
            JSONArray result = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (!jsonObject.containsKey((Object)"times")) continue;
                jsonObject.put("beforeDays", map.get(i));
                result.add((Object)jsonObject);
            }
            return result;
        }
        return val;
    }

    @Override
    public Object postQuerySmartDataVariable(List<String> variableIds, String tenantId) {
        Criteria criteria = Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId).and("code").in(variableIds);
        Query query = new Query((CriteriaDefinition)criteria);
        List tenantVariableList = this.mongoTemplate2.find(query, Map.class, "agiledata_business_variables_value");
        HashMap<String, Map> resultMap = new HashMap<String, Map>();
        if (!CollectionUtils.isEmpty((Collection)tenantVariableList)) {
            for (Map map : tenantVariableList) {
                resultMap.put(map.get("code").toString(), map);
            }
        }
        variableIds.forEach(variableId -> resultMap.putIfAbsent((String)variableId, (Map)null));
        return resultMap;
    }

    @Override
    public List<ActivityWidget> postGeneratePreActivities(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, String capacityCode) throws DWBusinessException {
        MechanismCapacity mechanismCapacity = (MechanismCapacity)this.mongoTemplate2.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)capacityCode).and(TENANT_ID_KEY_NAME).is((Object)AthenaUtils.getTenantId())), MechanismCapacity.class);
        if (null == mechanismCapacity) {
            return Collections.emptyList();
        }
        List<ActivityWidget> activityWidgets = this.advancedAssignDefinitionParser.generatePreActivities(advancedUserDefinitionWidget, mechanismCapacity);
        return activityWidgets;
    }

    @Override
    public Object postCopyTenantMechanismInfo(List<String> codes, String sourceTenantId, String targetTenantId) throws DWBusinessException {
        if (null == codes || codes.isEmpty() || StringUtils.isEmpty((CharSequence)sourceTenantId) || StringUtils.isEmpty((CharSequence)targetTenantId)) {
            throw new DWBusinessException("P.KG.500.0100", I18nUtils.getValue("knowledgegraph.copyTenantMechanism.parameterError", new Object[0]));
        }
        HashMap results = new HashMap();
        for (String mechanismCode : codes) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"mechanismCode").is((Object)mechanismCode).and(TENANT_ID_KEY_NAME).is((Object)sourceTenantId).and("status").is((Object)1));
            List sourceMechanismCapacityList = this.mongoTemplate2.find(query, Document.class, "mechanismCapacity");
            if (sourceMechanismCapacityList.isEmpty()) continue;
            ArrayList mechanismResults = new ArrayList();
            HashMap mechanismCapacityMap = new HashMap();
            ArrayList mechanismCapacityResults = new ArrayList(sourceMechanismCapacityList.size());
            ArrayList<String> mechanismCapacityCodes = new ArrayList<String>(sourceMechanismCapacityList.size());
            for (Document sMechanismCapacity : sourceMechanismCapacityList) {
                sMechanismCapacity.remove((Object)"_id");
                String mechanismCapacityCode = sMechanismCapacity.get((Object)"code").toString();
                mechanismCapacityCodes.add(mechanismCapacityCode);
                Query targetQuery = new Query((CriteriaDefinition)Criteria.where((String)"code").is((Object)mechanismCapacityCode).and(TENANT_ID_KEY_NAME).is((Object)targetTenantId));
                Update update = new Update();
                sMechanismCapacity.forEach((arg_0, arg_1) -> ((Update)update).set(arg_0, arg_1));
                update.set(TENANT_ID_KEY_NAME, (Object)targetTenantId);
                UpdateResult updateResult = this.mongoTemplate2.upsert(targetQuery, update, "mechanismCapacity");
                HashMap<String, UpdateResult> resultMap = new HashMap<String, UpdateResult>();
                resultMap.put(mechanismCapacityCode, updateResult);
                mechanismCapacityResults.add(resultMap);
            }
            mechanismCapacityMap.put("mechanismCapacity", mechanismCapacityResults);
            mechanismResults.add(mechanismCapacityMap);
            Query sourceLogicQueryQuery = new Query((CriteriaDefinition)Criteria.where((String)"code").in(mechanismCapacityCodes).and(TENANT_ID_KEY_NAME).is((Object)sourceTenantId));
            List sourceMechanismLogicList = this.mongoTemplate2.find(sourceLogicQueryQuery, Document.class, "mechanismLogic");
            if (!sourceMechanismLogicList.isEmpty()) {
                HashMap mechanismLogicMap = new HashMap();
                ArrayList mechanismLogicResults = new ArrayList(sourceMechanismLogicList.size());
                for (Document sMechanismLogic : sourceMechanismLogicList) {
                    sMechanismLogic.remove((Object)"_id");
                    String mechanismLogicCode = sMechanismLogic.get((Object)"code").toString();
                    Query targetLogicQuery = new Query((CriteriaDefinition)Criteria.where((String)"code").is((Object)mechanismLogicCode).and(TENANT_ID_KEY_NAME).is((Object)targetTenantId));
                    Update update = new Update();
                    sMechanismLogic.forEach((arg_0, arg_1) -> ((Update)update).set(arg_0, arg_1));
                    update.set(TENANT_ID_KEY_NAME, (Object)targetTenantId);
                    UpdateResult updateResult = this.mongoTemplate2.upsert(targetLogicQuery, update, "mechanismLogic");
                    HashMap<String, UpdateResult> resultMap = new HashMap<String, UpdateResult>();
                    resultMap.put(mechanismLogicCode, updateResult);
                    mechanismLogicResults.add(resultMap);
                }
                mechanismLogicMap.put("mechanismLogic", mechanismLogicResults);
                mechanismResults.add(mechanismLogicMap);
            }
            results.put(mechanismCode, mechanismResults);
        }
        return results;
    }

    @Override
    public Object postParadigmAndMechanismByApp(String appCode, OperationUnit operationUnit, Boolean queryWithEocLevel) throws Exception {
        JSONArray values;
        Criteria criteria;
        log.info("getMechanismByApp appCode:{},operationUnit:{}\uff0c queryWithEocLevel:{}", new Object[]{appCode, JSON.toJSONString((Object)operationUnit), queryWithEocLevel});
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        if (queryWithEocLevel.booleanValue()) {
            String eocLevel = this.operationUnitService.getEocLevel(operationUnit);
            criteria = Criteria.where((String)"application").is((Object)appCode).and("eocLevel").is((Object)eocLevel).and("version").is((Object)tenantVersion);
        } else {
            criteria = Criteria.where((String)"application").is((Object)appCode).and("version").is((Object)tenantVersion);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        Criteria tenantCriteria = new Criteria().andOperator(new Criteria[]{Criteria.where((String)"code").is((Object)appCode), Criteria.where((String)TENANT_ID_KEY_NAME).is((Object)tenantId)});
        query.fields().include(MECHANISM_VARIABLE_VALUE_FIELD_NAME);
        JSONObject mechanismTenantParadigm = (JSONObject)this.mongoTemplate2.findOne(Query.query((CriteriaDefinition)tenantCriteria), JSONObject.class, MECHANISM_TENANT_PARADIGM);
        List<Mechanism> mechanisms = this.dataPickService.find(criteria, Mechanism.class, "mechanism");
        if (mechanismTenantParadigm != null && mechanismTenantParadigm.containsKey((Object)MECHANISM_VARIABLE_VALUE_FIELD_NAME) && !CollectionUtils.isEmpty((Collection)(values = mechanismTenantParadigm.getJSONArray(MECHANISM_VARIABLE_VALUE_FIELD_NAME)))) {
            mechanisms.forEach(mechanism -> {
                if (values.contains((Object)mechanism.getCode())) {
                    mechanism.setParadigmChecked(true);
                }
            });
        }
        HashMap<String, List<Mechanism>> result = new HashMap<String, List<Mechanism>>();
        result.put("mechanisms", mechanisms);
        List<ApplicationRelation> paradigmByTypeAndAppCode = this.appService.getParadigmByTypeAndAppCode("paradigm", appCode);
        if (!CollectionUtils.isEmpty(paradigmByTypeAndAppCode)) {
            result.put("paradigms", paradigmByTypeAndAppCode.stream().map(BaseEntity::getCode).collect(Collectors.toList()));
        } else {
            result.put("paradigms", new ArrayList());
        }
        return result;
    }
}

