/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.report.hz.model.sence.BusinessTypeDTO;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.dto.report.ReportSceneDTOs;
import com.digiwin.athena.knowledgegraph.service.IMetricService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class MetricService
implements IMetricService {
    private static final Logger log = LoggerFactory.getLogger(MetricService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    ActionRepository actionRepository;
    @Autowired
    SceneService sceneService;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object postMetricDataSource(String appCode, String version) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode) || StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("appCode and version cannot be null or empty!");
        }
        HashMap<String, String> metricDataSource = new HashMap<String, String>();
        Application application = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)appCode), Application.class, "application");
        if (application != null && StringUtils.isNotEmpty((CharSequence)application.getSource())) {
            metricDataSource.put("dataSource", application.getSource());
            metricDataSource.put("appCode", appCode);
            metricDataSource.put("version", version);
        }
        return metricDataSource;
    }

    @Override
    public Object postMetricDataSource(List<String> indicatorIds) throws DWBusinessException {
        if (CollectionUtils.isEmpty(indicatorIds)) {
            throw new DWBusinessException("indicatorIds cannot be null or empty!");
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List dataSetList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(indicatorIds)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if (CollectionUtils.isEmpty((Collection)dataSetList)) {
            List<ReportSceneDTO> scenes = this.sceneService.querySceneMapsData(indicatorIds, tenantVersion);
            if (CollectionUtils.isEmpty(scenes)) {
                return Collections.emptyList();
            }
            dataSetList.addAll(scenes.stream().map(scene -> {
                ReportSceneDTOs reportSceneDTOs = new ReportSceneDTOs();
                BeanUtil.copyProperties((Object)scene, (Object)reportSceneDTOs, (String[])new String[0]);
                return reportSceneDTOs;
            }).collect(Collectors.toList()));
        }
        ArrayList<String> appCodes = new ArrayList<String>();
        HashMap<String, ReportSceneDTOs> metricMap = new HashMap<String, ReportSceneDTOs>();
        for (ReportSceneDTOs scene2 : dataSetList) {
            appCodes.add(scene2.getAppCode());
            metricMap.put(scene2.getCode(), scene2);
        }
        return this.getMetricDataSource(metricMap, appCodes, tenantVersion);
    }

    private List<Map<String, Object>> getMetricDataSource(Map<String, ReportSceneDTOs> metricMap, List<String> appCodes, String version) throws DWBusinessException {
        ArrayList<Map<String, Object>> metricDataSource = new ArrayList<Map<String, Object>>();
        List<Application> applications = this.dataPickService.find(Criteria.where((String)"code").in(appCodes), Application.class, "application");
        if (!CollectionUtils.isEmpty(applications)) {
            Map<String, String> applicationCodeToSource = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, app -> Optional.ofNullable(app.getSource()).orElse("")));
            for (Map.Entry<String, ReportSceneDTOs> entry : metricMap.entrySet()) {
                ReportSceneDTOs scene = entry.getValue();
                HashMap<String, Object> dataSource = new HashMap<String, Object>();
                dataSource.put("appCode", scene.getAppCode());
                dataSource.put("version", version);
                dataSource.put("indicatorId", scene.getCode());
                dataSource.put("businessType", this.getBusinessType(scene));
                dataSource.put("productLine", scene.getProductLine());
                dataSource.put("classification", scene.getClassification());
                if (StringUtils.isNotEmpty((CharSequence)scene.getAppCode()) && applicationCodeToSource.containsKey(scene.getAppCode())) {
                    dataSource.put("dataSource", applicationCodeToSource.get(scene.getAppCode()));
                } else {
                    dataSource.put("dataSource", "");
                }
                dataSource.put("fieldSchema", scene.getFieldSchema());
                dataSource.put("measures", scene.getMeasures());
                dataSource.put("dimensions", scene.getDimensions());
                metricDataSource.add(dataSource);
            }
        }
        return metricDataSource;
    }

    private void handleMetricBusinessType(List<Map<String, Object>> result, List<String> businessTypes, String tenantVersion) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List businessTypeDataList = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(businessTypes).and("tenantId").is((Object)tenantId)), BusinessTypeDTO.class, "agiledata_business_type");
        if (CollectionUtils.isEmpty((Collection)businessTypeDataList)) {
            return;
        }
        Map businessTypeDataMap = businessTypeDataList.stream().collect(Collectors.toMap(BusinessTypeDTO::getCode, Function.identity()));
        result.forEach(data -> {
            String businessTypeCode = ((BusinessTypeDTO)data.get("businessType")).getCode();
            if (businessTypeDataMap.containsKey(businessTypeCode)) {
                data.put("businessType", businessTypeDataMap.get(businessTypeCode));
            }
        });
    }

    @Override
    public Object postMetricQuerySchema(List<String> indicatorIds) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        String tenantId = AthenaUtils.getTenantId();
        HashMap indicatorIdMap = new HashMap();
        for (String indicatorId : indicatorIds) {
            ArrayDeque<String> stack = new ArrayDeque<String>(Collections.singletonList(indicatorId));
            List<Action> metricActionList = this.getAllMetricAction(stack, tenantId, tenantVersion);
            LanguageUtil.processLocaleLanguage(metricActionList, DWResourceBundleUtils.getCurrentLocale().toString());
            List actionInfoList = metricActionList.stream().filter(Objects::nonNull).map(action -> {
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("actionId", action.getActionId());
                info.put("actionName", action.getActionName());
                info.put("querySchema", action.getQuerySchema());
                info.put("response", (String)JSON.parseObject((String)action.getResponse_object()));
                info.put("productLine", StringUtils.isEmpty((CharSequence)action.getProductLine()) ? "ERP" : action.getProductLine());
                return info;
            }).collect(Collectors.toList());
            indicatorIdMap.put(indicatorId, actionInfoList);
        }
        return indicatorIdMap;
    }

    @Override
    public Object postMetricBusinessByCode(String tenantId, String appCode, List<String> codes) throws DWBusinessException {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List businessTypeSysDataList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(codes).and("appCode").is((Object)appCode).and("version").is((Object)tenantVersion)), BusinessTypeDTO.class, "agiledata_business_type");
        List businessTypeTenantDataList = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(codes).and("appCode").is((Object)appCode).and("source").is((Object)"custom").and("tenantId").is((Object)tenantId)), BusinessTypeDTO.class, "agiledata_business_type");
        Map<String, BusinessTypeDTO> tenantMap = businessTypeTenantDataList.stream().collect(Collectors.toMap(BusinessTypeDTO::getCode, dto -> dto));
        List result = businessTypeSysDataList.stream().map(dto -> tenantMap.getOrDefault(dto.getCode(), (BusinessTypeDTO)dto)).collect(Collectors.toList());
        Map resultBusinessMap = result.stream().collect(Collectors.toMap(BusinessTypeDTO::getCode, Function.identity(), (existing, replacement) -> existing));
        codes.forEach(code -> {
            BusinessTypeDTO cfr_ignored_0 = (BusinessTypeDTO)resultBusinessMap.putIfAbsent((String)code, tenantMap.get(code));
        });
        return resultBusinessMap;
    }

    private List<Action> getAllMetricAction(Deque<String> stack, String tenantId, String tenantVersion) throws DWBusinessException {
        ArrayList<Action> metricActionList = new ArrayList<Action>();
        HashSet<String> processedIndicatorIds = new HashSet<String>();
        while (!stack.isEmpty()) {
            String currentIndicatorId = stack.pop();
            if (processedIndicatorIds.contains(currentIndicatorId)) continue;
            processedIndicatorIds.add(currentIndicatorId);
            List<ActionLabel> metricActions = this.dataPickService.filterByIndividual(this.actionRepository.getActionAndLabelsByMetricId(Collections.singletonList(currentIndicatorId), tenantId, tenantVersion), tenantId, actionLabel -> actionLabel.getAction().getNameSpace());
            for (ActionLabel actionLabel2 : metricActions) {
                if (Objects.isNull(actionLabel2.getAction())) continue;
                if (Objects.equals(ActionTypeEnum.METRIC.toString(), actionLabel2.getAction().getType())) {
                    String metricId = actionLabel2.getAction().getQuoteMetricCode();
                    stack.push(metricId);
                    continue;
                }
                if (!Objects.equals(ActionTypeEnum.BMD_GENERAL.toString(), actionLabel2.getAction().getType())) continue;
                metricActionList.add(actionLabel2.getAction());
            }
        }
        return metricActionList;
    }

    public List<Object> getBusinessType(ReportSceneDTOs scene) {
        List<Object> businessType = scene.getBusinessType();
        if (!CollectionUtils.isEmpty(businessType)) {
            return businessType;
        }
        businessType = new ArrayList<Object>();
        this.extractBusinessType(scene.getFieldSchema(), businessType, "name");
        this.extractBusinessType(scene.getMeasures(), businessType, "data_name");
        return businessType;
    }

    private void extractBusinessType(List<Object> list, List<Object> businessType, String key) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List dataList = list.stream().filter(item -> item instanceof Map || item instanceof JSONObject).map(item -> {
            if (item instanceof JSONObject) {
                return (JSONObject)item;
            }
            return new JSONObject((Map)item);
        }).filter(jsonObject -> jsonObject.containsKey((Object)"businessType")).map(jsonObject -> {
            JSONObject businessTypeConfig = jsonObject.getJSONObject("businessType");
            businessTypeConfig.put("key", jsonObject.get((Object)key));
            return businessTypeConfig;
        }).collect(Collectors.toList());
        businessType.addAll(dataList);
    }
}

