/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.action.ActionMetadataDTO;
import com.digiwin.athena.kg.action.ActionRequestMetadataDTO;
import com.digiwin.athena.kg.action.ActionResponseMetadataDTO;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kg.monitorRule.StandardPollingRule;
import com.digiwin.athena.kg.monitorRule.secondCalculate.ActionRecast;
import com.digiwin.athena.kg.report.hz.model.ReportMonitorRuleDTO;
import com.digiwin.athena.kg.report.hz.model.SceneDTO;
import com.digiwin.athena.kg.report.hz.model.modelCenterMetaData.DataModelDTO;
import com.digiwin.athena.kg.report.hz.model.modelCenterMetaData.ModelFieldDTO;
import com.digiwin.athena.kg.report.hz.model.modelCenterMetaData.ModelTableDTO;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.ActionIntentions;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.DataSchemaDTO;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.DataSourceDTO;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.PushDataDTO;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.PushMetricDTO;
import com.digiwin.athena.kg.report.hz.model.sence.ActionDimension;
import com.digiwin.athena.kg.report.hz.model.sence.ActionRelation;
import com.digiwin.athena.kg.report.hz.model.sence.ActionRelationDTO;
import com.digiwin.athena.kg.report.hz.model.sence.ActionReportConfig;
import com.digiwin.athena.kg.report.hz.model.sence.BusinessTypeDTO;
import com.digiwin.athena.kg.report.hz.model.sence.DimensionDTO;
import com.digiwin.athena.kg.report.hz.model.sence.IncrementalPatch;
import com.digiwin.athena.kg.report.hz.model.sence.IntentionsDTO;
import com.digiwin.athena.kg.report.hz.model.sence.PushSceneDTO;
import com.digiwin.athena.kg.report.hz.model.sence.RelatedIntentionDTO;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.sence.RuleSceneDTO;
import com.digiwin.athena.kg.report.hz.model.sence.SceneTargetInfo;
import com.digiwin.athena.kg.report.hz.model.sence.SceneTemplate;
import com.digiwin.athena.kg.report.hz.model.sence.TargetIntentionsDTO;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionPathDTO;
import com.digiwin.athena.kmservice.action.metadata.ActionMetadataManager;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.MetadataTranslator;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.dto.report.PushDataSetDTO;
import com.digiwin.athena.knowledgegraph.dto.report.PushTableDTO;
import com.digiwin.athena.knowledgegraph.dto.report.ReportSceneDTOs;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.pullingMap.model.DataPullingActionDO;
import com.digiwin.athena.knowledgegraph.pullingMap.model.FormulaActionDO;
import com.digiwin.athena.knowledgegraph.pullingMap.model.PullingData;
import com.digiwin.athena.knowledgegraph.pullingMap.model.PullingDataRelation;
import com.digiwin.athena.knowledgegraph.pullingMap.service.EntityAndDependencyGeneratorService;
import com.digiwin.athena.knowledgegraph.report.MonitorPartParser;
import com.digiwin.athena.knowledgegraph.service.ISceneService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.MetricService;
import com.digiwin.athena.knowledgegraph.service.impl.ScreenService;
import com.digiwin.athena.knowledgegraph.service.impl.SectorService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.repository.neo4j.ReportSceneRepository;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Lang
@Service
@MyExceptionHandler
public class SceneService
implements ISceneService {
    private static final Logger log = LoggerFactory.getLogger(SceneService.class);
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    private MonitorPartParser monitorPartParser;
    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private ActionService actionService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    KgInnerService kgInnerService;
    @Value(value="${iamApToken}")
    private String iamApToken;
    @Autowired
    @Qualifier(value="cacRestTemplate")
    RestTemplate restTemplate;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    EntityAndDependencyGeneratorService entityAndDependencyGeneratorService;
    @Autowired
    ReportSceneRepository reportSceneRepository;
    @Value(value="${scrumbiUrl}")
    private String scrumbiUrl;
    @Autowired
    SessionFactory neo4jSessionFactory;
    @Autowired
    ActionMetadataManager actionMetadataManager;
    @Autowired
    CACUtils cacUtils;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    ScreenService screenService;
    @Autowired
    SectorService sectorService;
    @Autowired
    private CacService cacService;
    @Autowired
    AppService appService;
    @Autowired
    MetricService metricService;
    @Value(value="${deploy.cloud:''}")
    private String deployCloud;

    @Override
    public Object postCreateSceneMaps(ReportSceneDTO reportScene) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("code", reportScene.getCode());
        String deleteQuery = "match(t:ReportScene) where t.code=$code detach delete t";
        this.kgHelpService.executeCyhper(deleteQuery, props);
        String createQuery = "CREATE (n:ReportScene {code:$code,actionId:$actionId,scene: $scene, sceneTitle: $sceneTitle, showType: $showType, show: $show,version:$version,actionParamDefine:$actionParamDefine,recast:$recast,intentions:$intentions,incrementalPatch:$incrementalPatch,useRecast:$useRecast,relatedIntention:$relatedIntention,templateCode:$templateCode,targetId:$targetId,targetName:$targetName,dimension:$dimension})";
        props.put("actionId", reportScene.getActionId());
        props.put("scene", Objects.isNull(reportScene.getScene()) ? null : JSON.toJSONString((Object)reportScene.getScene()));
        props.put("sceneTitle", reportScene.getSceneTitle());
        props.put("version", StringUtils.isNotEmpty((CharSequence)reportScene.getVersion()) ? reportScene.getVersion() : "2.0");
        props.put("actionParamDefine", CollectionUtils.isEmpty((Map)reportScene.getActionParamDefine()) ? null : JSON.toJSONString((Object)reportScene.getActionParamDefine()));
        props.put("recast", CollectionUtils.isEmpty((Map)reportScene.getRecast()) ? null : JSON.toJSONString((Object)reportScene.getRecast()));
        props.put("intentions", CollectionUtils.isEmpty((Collection)reportScene.getIntentions()) ? null : JSON.toJSONString((Object)reportScene.getIntentions()));
        props.put("incrementalPatch", CollectionUtils.isEmpty((Collection)reportScene.getIncrementalPatch()) ? null : JSON.toJSONString((Object)reportScene.getIncrementalPatch()));
        props.put("useRecast", Objects.isNull(reportScene.getUseRecast()) ? true : reportScene.getUseRecast());
        props.put("relatedIntention", reportScene.getRelatedIntention());
        props.put("templateCode", reportScene.getTemplateCode());
        props.put("targetId", reportScene.getTargetId());
        props.put("targetName", reportScene.getTargetName());
        props.put("dimension", reportScene.getDimension());
        this.kgHelpService.executeCyhper(createQuery, props);
        return "success";
    }

    @Override
    public Object postQuerySceneMaps(String code) throws Exception {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        String tenantId = AthenaUtils.getTenantId();
        ReportSceneDTOs reportSceneDTOs = new ReportSceneDTOs();
        ReportSceneDTO reportScene = null;
        ReportSceneDTOs dataSet = (ReportSceneDTOs)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").is((Object)code)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if (Objects.isNull(dataSet)) {
            UserScreenConfig userScreen = this.screenService.postQueryUserScreen(code);
            reportScene = ObjectUtils.isEmpty((Object)userScreen) ? this.querySceneMaps(Collections.singletonList(code), tenantVersion) : this.sectorService.getReportSceneByBkCode(tenantId, userScreen);
            BeanUtil.copyProperties((Object)reportScene, (Object)reportSceneDTOs, (String[])new String[0]);
        } else {
            reportSceneDTOs = dataSet;
        }
        if (StringUtils.isNotEmpty((CharSequence)reportSceneDTOs.getCode())) {
            Application application;
            BigScreenViewConfig bigScreenViewConfig;
            String appCode = reportSceneDTOs.getAppCode();
            if (Objects.equals(reportSceneDTOs.getViewType(), "screen") && Objects.nonNull(bigScreenViewConfig = (BigScreenViewConfig)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("bigScreenCode").is((Object)reportSceneDTOs.getCode())), BigScreenViewConfig.class))) {
                reportSceneDTOs.setDataFlowFrequency(bigScreenViewConfig.getDataFlowFrequency());
                reportSceneDTOs.setFlashFrequency(bigScreenViewConfig.getFlashFrequency());
                reportSceneDTOs.setPageTurningFrequency(bigScreenViewConfig.getPageTurningFrequency());
            }
            if ((application = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)appCode), Application.class, "application")) != null && StringUtils.isNotEmpty((CharSequence)application.getSource())) {
                reportSceneDTOs.setDataSource(application.getSource());
                reportSceneDTOs.setBillingGoodsId(StringUtils.isEmpty((CharSequence)application.getBillingGoodsId()) ? "" : application.getBillingGoodsId());
            }
            reportSceneDTOs.setBusinessType(this.metricService.getBusinessType(reportSceneDTOs));
            return this.getTranslateContent(reportSceneDTOs);
        }
        return null;
    }

    ReportSceneDTO querySceneMaps(List<String> code, String tenantVersion) throws DWBusinessException {
        List<ReportSceneDTO> reportSceneData = this.querySceneMapsData(code, tenantVersion);
        if (!CollectionUtils.isEmpty(reportSceneData)) {
            return reportSceneData.get(0);
        }
        return null;
    }

    List<ReportSceneDTO> querySceneMapsData(List<String> code, String tenantVersion) throws DWBusinessException {
        if (CollectionUtils.isEmpty(code)) {
            return null;
        }
        List<String> uniqueAppCodes = this.getUniqueAppCodes();
        if (CollectionUtils.isEmpty(uniqueAppCodes)) {
            return null;
        }
        String query = "MATCH (n:ReportScene) WHERE n.code in $code and n.version = $version and n.appCode in $appCode and n.status = '1'  RETURN n";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("code", code);
        param.put("version", tenantVersion);
        param.put("appCode", uniqueAppCodes);
        return this.querySceneData(query, param);
    }

    private List<String> getUniqueAppCodes() throws DWBusinessException {
        return this.dataPickService.tenantInitializedAppCodes(AthenaUtils.getTenantId());
    }

    @Override
    public Object postQuerySceneByTemplateAndTarget(String templateCode, String targetId, List<String> dimension) throws Exception {
        ArrayList<ReportSceneDTO> reportSceneList = new ArrayList<ReportSceneDTO>();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List<String> uniqueAppCodes = this.getUniqueAppCodes();
        if (CollectionUtils.isEmpty(uniqueAppCodes)) {
            return null;
        }
        Criteria criteria = Criteria.where((String)"version").is((Object)tenantVersion).and("appType").in(new Object[]{6, 12}).and("code").in(uniqueAppCodes);
        List<Application> applications = this.dataPickService.find(criteria, Application.class, "application");
        Map<String, String> applicationCodeToSource = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, app -> Optional.ofNullable(app.getBillingGoodsId()).orElse("")));
        HashMap<String, Object> param = new HashMap<String, Object>();
        String query = this.getQueryCql(param, uniqueAppCodes, templateCode, targetId, dimension, tenantVersion);
        Session session = this.neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable iterableResult = (Iterable)result.queryResults();
        Iterator iterator = iterableResult.iterator();
        while (iterator.hasNext()) {
            ReportSceneDTO reportScene = new ReportSceneDTO();
            Map record = (Map)iterator.next();
            Node node = (Node)record.get("n");
            List propertyList = node.getPropertyList();
            for (Property property : propertyList) {
                this.setReportSceneProperty(reportScene, (Property<String, Object>)property);
            }
            reportScene.setBillingGoodsId(applicationCodeToSource.get(reportScene.getAppCode()));
            if (!CollectionUtils.isEmpty((Collection)reportScene.getActionDimension())) {
                ActionDimension actionDimension = (ActionDimension)reportScene.getActionDimension().get(0);
                if (actionDimension.getDimension().size() != dimension.size()) continue;
                reportSceneList.add(reportScene);
                continue;
            }
            reportSceneList.add(reportScene);
        }
        if (CollectionUtils.isEmpty(reportSceneList)) {
            return null;
        }
        return this.getTranslateContent(reportSceneList);
    }

    private String getQueryCql(Map<String, Object> param, List<String> uniqueAppCodes, String templateCode, String targetId, List<String> dimension, String tenantVersion) {
        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.templateCode = $templateCode and n.targetId = $targetId and n.version = $version and n.status = '1' ";
        param.put("appCode", uniqueAppCodes);
        param.put("templateCode", templateCode);
        param.put("targetId", targetId);
        param.put("version", tenantVersion);
        if (CollectionUtils.isEmpty(dimension)) {
            query = query + " AND NOT EXISTS(n.dimension) AND NOT EXISTS(n.actionDimension) ";
        } else {
            query = query + " AND (ALL(id IN $dimension WHERE id IN n.dimension) OR ALL(keyword in $keyword WHERE ANY(dim in n.actionDimension WHERE dim CONTAINS keyword)))";
            param.put("dimension", dimension);
            param.put("keyword", dimension);
        }
        query = query + " RETURN n ";
        return query;
    }

    public Object getTranslateContent(Object o) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        if (Objects.equals(this.deployCloud, "local")) {
            LanguageUtil.processLocaleLanguage(o, localeStr);
            return o;
        }
        Object dataStr = this.translateUtils.translateSmartDataContent(JSON.parseObject((String)JSON.toJSONString((Object)o, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), Object.class));
        LanguageUtil.processLocaleLanguage(dataStr, localeStr);
        return dataStr;
    }

    private void setReportSceneProperty(ReportSceneDTO reportScene, Property<String, Object> property) {
        if (Objects.isNull(property.getValue())) {
            return;
        }
        switch ((String)property.getKey()) {
            case "code": {
                reportScene.setCode((String)property.getValue());
                break;
            }
            case "status": {
                reportScene.setStatus((String)property.getValue());
                break;
            }
            case "appCode": {
                reportScene.setAppCode((String)property.getValue());
                break;
            }
            case "show": {
                reportScene.setShow((Object)JSON.parseArray((String)property.getValue().toString(), Object.class));
                break;
            }
            case "showType": {
                reportScene.setShowType((Object)JSON.parseArray((String)property.getValue().toString(), Object.class));
                break;
            }
            case "actionRelation": {
                reportScene.setActionRelation(JSON.parseArray((String)property.getValue().toString(), ActionRelationDTO.class));
                break;
            }
            case "intentions": {
                String input = property.getValue().toString().replace("[", "").replace("]", "").replace(" ", "");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{input})) break;
                reportScene.setIntentions(Arrays.asList(input.split(",")));
                break;
            }
            case "incrementalPatch": {
                reportScene.setIncrementalPatch(JSON.parseArray((String)property.getValue().toString(), IncrementalPatch.class));
                break;
            }
            case "sceneTitle": {
                reportScene.setSceneTitle((String)property.getValue());
                break;
            }
            case "scene": {
                reportScene.setScene((SceneDTO)JSON.parseObject((String)property.getValue().toString(), SceneDTO.class));
                break;
            }
            case "actionParamDefine": {
                reportScene.setActionParamDefine((Map)JSON.parseObject((String)property.getValue().toString(), Map.class));
                break;
            }
            case "recast": {
                reportScene.setRecast((Map)JSON.parseObject((String)property.getValue().toString(), Map.class));
                break;
            }
            case "actionId": {
                reportScene.setActionId((String)property.getValue());
                break;
            }
            case "targetId": {
                reportScene.setTargetId((String)property.getValue());
                break;
            }
            case "targetName": {
                reportScene.setTargetName((String)property.getValue());
                break;
            }
            case "templateCode": {
                reportScene.setTemplateCode((String)property.getValue());
                break;
            }
            case "templateName": {
                reportScene.setTemplateName((String)property.getValue());
                break;
            }
            case "version": {
                reportScene.setVersion((String)property.getValue());
                break;
            }
            case "description": {
                reportScene.setDescription((String)property.getValue());
                break;
            }
            case "useRecast": {
                reportScene.setUseRecast((Boolean)property.getValue());
                break;
            }
            case "relatedIntention": {
                List relatedIntention = JSON.parseArray((String)property.getValue().toString(), RelatedIntentionDTO.class);
                reportScene.setRelatedIntention(relatedIntention);
                List relatedIntentionList = relatedIntention.stream().map(RelatedIntentionDTO::getRelatedIntentions).flatMap(Collection::stream).collect(Collectors.toList());
                String relatedIntentionsStr = relatedIntentionList.stream().collect(Collectors.joining(";"));
                reportScene.setRelatedIntentions(relatedIntentionsStr);
                break;
            }
            case "dimension": {
                reportScene.setDimension((List)property.getValue());
                break;
            }
            case "actionDimension": {
                List actionDimensions = JSON.parseArray((String)property.getValue().toString(), ActionDimension.class);
                reportScene.setActionDimension(actionDimensions);
                break;
            }
            case "lang": {
                reportScene.setLang((Map)JSON.parseObject((String)property.getValue().toString(), Map.class));
                break;
            }
            case "viewType": {
                reportScene.setViewType((String)property.getValue());
                break;
            }
            case "prod": {
                reportScene.setProd((String)property.getValue());
                break;
            }
            case "businessType": {
                reportScene.setBusinessType((BusinessTypeDTO)JSON.parseObject((String)property.getValue().toString(), BusinessTypeDTO.class));
                break;
            }
            case "formula": {
                reportScene.setFormula((String)property.getValue());
                break;
            }
            case "fieldSchema": {
                reportScene.setFieldSchema(JSON.parseArray((String)property.getValue().toString(), Object.class));
                break;
            }
            case "productLine": {
                reportScene.setProductLine((List)property.getValue());
                break;
            }
            case "classification": {
                String valueOf = String.valueOf(property.getValue());
                if (!StringUtils.isNotBlank((CharSequence)valueOf)) break;
                Map map = (Map)JsonUtils.readValue((String)valueOf, (TypeReference)new TypeReference<Map<String, Object>>(){});
                reportScene.setClassification(map);
                break;
            }
        }
    }

    @Override
    public Object postCreateMonitorRule(String code, String name, String appCode, String appName, String productName) throws Exception {
        Object sceneData = this.postQuerySceneMaps(code);
        if (Objects.nonNull(sceneData)) {
            ReportSceneDTO reportScene = (ReportSceneDTO)JSON.parseObject((String)sceneData.toString(), ReportSceneDTO.class);
            ReportMonitorRuleDTO reportMonitorRuleDTO = new ReportMonitorRuleDTO();
            reportMonitorRuleDTO.setCode(UUID.randomUUID().toString().replaceAll("-", ""));
            reportMonitorRuleDTO.setName(name);
            reportMonitorRuleDTO.setAppCode(appCode);
            reportMonitorRuleDTO.setAppName(appName);
            reportMonitorRuleDTO.setActionId(reportScene.getActionId());
            reportMonitorRuleDTO.setProductName(productName);
            SceneDTO sceneDTO = reportScene.getScene();
            RuleSceneDTO scene = new RuleSceneDTO();
            scene.setCode(code);
            scene.setTerminal(sceneDTO.getTerminal());
            scene.setWhat(sceneDTO.getWhat());
            scene.setWhen(sceneDTO.getWhen());
            scene.setWhere(sceneDTO.getWhere());
            scene.setWho(sceneDTO.getWho());
            reportMonitorRuleDTO.setScene(scene);
            if (reportScene.getScene() != null && !CollectionUtils.isEmpty((Collection)reportScene.getScene().getWhen())) {
                reportMonitorRuleDTO.setStandard_polling_rule((StandardPollingRule)reportScene.getScene().getWhen().get(0));
            }
            reportMonitorRuleDTO.setActionParamDefine(reportScene.getActionParamDefine());
            reportMonitorRuleDTO.setRecast(reportScene.getRecast());
            return this.monitorPartParser.buildReportMonitorRule(reportMonitorRuleDTO);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object postPushData(List<String> appCodes, String tenantId, String version) {
        ArrayList<PushDataSetDTO> pushDataSetDTOS;
        ArrayList<PushMetricDTO> pushMetricDTOS;
        ArrayList<PushDataDTO> pushDataDTOS;
        HashMap<String, Object> result;
        block16: {
            HashMap<String, String> profile;
            block15: {
                HashMap<String, Object> profile2;
                Map map;
                block14: {
                    result = new HashMap<String, Object>();
                    result.put("code", 200);
                    result.put("msg", "success");
                    pushDataDTOS = new ArrayList<PushDataDTO>();
                    pushMetricDTOS = new ArrayList<PushMetricDTO>();
                    ArrayList<PushTableDTO> pushMetricDataSetDTOS = new ArrayList<PushTableDTO>();
                    pushDataSetDTOS = new ArrayList<PushDataSetDTO>();
                    try {
                        profile = new HashMap<String, String>();
                        profile.put("tenantId", tenantId);
                        DWServiceContext.getContext().setProfile(profile);
                        DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion", version);
                        String tenantVersion = this.kgInnerService.currentTenantVersion();
                        Criteria criteria = new Criteria();
                        criteria.and("code").in(appCodes);
                        List<Application> applications = this.dataPickService.find(criteria, Application.class, "application");
                        if (CollectionUtils.isEmpty(applications)) {
                            ArrayList<PushDataDTO> arrayList = pushDataDTOS;
                            return arrayList;
                        }
                        List dataSetList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("appCode").in(appCodes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
                        if (CollectionUtils.isEmpty((Collection)dataSetList)) {
                            this.handleMetricData(applications, tenantVersion, pushMetricDTOS);
                            this.handleMetricDataSetData(applications, tenantVersion, pushMetricDataSetDTOS);
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("table", pushMetricDataSetDTOS);
                            jsonObject.put("metric", pushMetricDTOS);
                            this.handlePushData(tenantId, version, applications, pushDataDTOS);
                            Map sceneDataResult = this.postDataSource(pushDataDTOS, "/scrumbi/pushKMDatas/V2");
                            if (!CollectionUtils.isEmpty((Map)sceneDataResult)) {
                                Map map2 = sceneDataResult;
                                return map2;
                            }
                            Map metricDataResult = this.postDataSource(jsonObject, "/scrumbi/pushIndicatorData");
                            if (!CollectionUtils.isEmpty((Map)metricDataResult)) {
                                Map map3 = metricDataResult;
                                return map3;
                            }
                        } else {
                            this.handleDataSetData(applications, dataSetList, tenantVersion, pushDataSetDTOS);
                            Map dataSetDataResult = this.postDataSource(pushDataSetDTOS, "/scrumbi/dataSet/push");
                            if (!CollectionUtils.isEmpty((Map)dataSetDataResult)) {
                                map = dataSetDataResult;
                                profile2 = new HashMap<String, Object>();
                                profile2.put("tenantId", null);
                                break block14;
                            }
                        }
                        profile = new HashMap();
                        break block15;
                    }
                    catch (Exception e) {
                        result.put("code", 500);
                        result.put("msg", "km\u63a8\u9001\u8bed\u4e49\u5931\u8d25");
                        log.error("postPushData error :{}", (Throwable)e);
                        break block16;
                    }
                }
                DWServiceContext.getContext().setProfile(profile2);
                DWServiceContext.getContext().getRequestHeader().remove(tenantId + "tenantVersion", version);
                return map;
            }
            profile.put("tenantId", null);
            DWServiceContext.getContext().setProfile(profile);
            DWServiceContext.getContext().getRequestHeader().remove(tenantId + "tenantVersion", version);
            break block16;
            finally {
                HashMap<String, Object> profile3 = new HashMap<String, Object>();
                profile3.put("tenantId", null);
                DWServiceContext.getContext().setProfile(profile3);
                DWServiceContext.getContext().getRequestHeader().remove(tenantId + "tenantVersion", version);
            }
        }
        result.put("scene", pushDataDTOS);
        result.put("metric", pushMetricDTOS);
        result.put("dataset", pushDataSetDTOS);
        log.error("pushData info is token:{},appCodes:{},tenantId:{},version:{}, data:{}", new Object[]{DWServiceContext.getContext().getToken(), appCodes, tenantId, version, result});
        return result;
    }

    private void handlePushData(String tenantId, String version, List<Application> applications, List<PushDataDTO> pushDataDTOS) throws Exception {
        for (Application application : applications) {
            List sceneTemplates = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)application.getVersion()).and("application").is((Object)application.getCode())), SceneTemplate.class);
            if (CollectionUtils.isEmpty((Collection)sceneTemplates)) {
                pushDataDTOS.add(this.createPushDataDTO(application));
                continue;
            }
            Map<String, List<SceneTemplate>> groupedSceneTemplates = sceneTemplates.stream().collect(Collectors.groupingBy(SceneTemplate::getApplication));
            HashMap<String, List<String>> mergedSceneCodesByAppCode = new HashMap<String, List<String>>();
            this.mergeSceneCodes(mergedSceneCodesByAppCode, groupedSceneTemplates);
            if (CollectionUtils.isEmpty(mergedSceneCodesByAppCode)) {
                pushDataDTOS.add(this.createPushDataDTO(application));
                continue;
            }
            for (Map.Entry<String, List<String>> entry : mergedSceneCodesByAppCode.entrySet()) {
                this.processApplicationScene(pushDataDTOS, entry, groupedSceneTemplates, application, tenantId, version);
            }
        }
    }

    private PushDataDTO createPushDataDTO(Application application) {
        PushDataDTO pushDataDTO = new PushDataDTO();
        pushDataDTO.setApplicationCode(application.getCode());
        pushDataDTO.setApplicationName(application.getName());
        pushDataDTO.setVersion(application.getVersion());
        return pushDataDTO;
    }

    private void handleMetricData(List<Application> applications, String tenantVersion, List<PushMetricDTO> pushMetricDTOS) throws Exception {
        for (Application application : applications) {
            List<ReportSceneDTO> reportSceneDTOList = this.querySceneByAppAndTag(Collections.singletonList(application.getCode()), "metric", tenantVersion);
            if (CollectionUtils.isEmpty(reportSceneDTOList)) {
                pushMetricDTOS.add(PushMetricDTO.builder().applicationCode(application.getCode()).applicationName(application.getName()).version(application.getVersion()).build());
                continue;
            }
            this.handlePushMetricData(pushMetricDTOS, application, reportSceneDTOList);
        }
    }

    private void handleMetricDataSetData(List<Application> applications, String tenantVersion, List<PushTableDTO> pushMetricDTOS) throws Exception {
        for (Application application : applications) {
            List<ReportSceneDTOs> reportSceneDTOList = this.querySceneByAppAndTags(Collections.singletonList(application.getCode()), "dataset", tenantVersion);
            if (CollectionUtils.isEmpty(reportSceneDTOList)) {
                pushMetricDTOS.add(PushTableDTO.builder().applicationCode(application.getCode()).applicationName(application.getName()).version(application.getVersion()).build());
                continue;
            }
            this.handlePushTableData(pushMetricDTOS, application, reportSceneDTOList);
        }
    }

    private void handleDataSetData(List<Application> applications, List<ReportSceneDTOs> dataSetList, String tenantVersion, List<PushDataSetDTO> pushDataSetDTOS) throws Exception {
        Map<String, List<ReportSceneDTOs>> reportSceneMap = dataSetList.stream().collect(Collectors.groupingBy(ReportSceneDTOs::getAppCode));
        for (Application application : applications) {
            List<ReportSceneDTOs> reportSceneDTOs = reportSceneMap.get(application.getCode());
            if (CollectionUtils.isEmpty(reportSceneDTOs)) {
                pushDataSetDTOS.add(PushDataSetDTO.builder().applicationCode(application.getCode()).applicationName(application.getName()).version(application.getVersion()).dataSetDto(new ArrayList<PushDataSetDTO.PushDataSetContentDTO>()).build());
                continue;
            }
            ArrayList<PushDataSetDTO.PushDataSetContentDTO> dataSetContentList = new ArrayList<PushDataSetDTO.PushDataSetContentDTO>();
            for (ReportSceneDTOs reportScene : reportSceneDTOs) {
                List<Object> measures = reportScene.getMeasures();
                for (Object measure : measures) {
                    Object item;
                    Object businessType;
                    if (measure instanceof JSONObject && !ObjectUtils.isEmpty((Object)(businessType = (item = (JSONObject)measure).getJSONObject("businessType")))) {
                        item.put("businessType", businessType.get((Object)"code"));
                    }
                    if (!(measure instanceof Map) || ObjectUtils.isEmpty((item = (Map)measure).get("businessType"))) continue;
                    businessType = (Map)item.get("businessType");
                    item.put("businessType", businessType.get("code"));
                }
                dataSetContentList.add(PushDataSetDTO.PushDataSetContentDTO.builder().datasetId(reportScene.getCode()).modelId(reportScene.getModelId()).modelCode(reportScene.getModelCode()).datasetName(reportScene.getName()).lang(reportScene.getLang()).billingGoodsId(application.getBillingGoodsId()).dimensions(reportScene.getDimensions()).measures(reportScene.getMeasures()).description(reportScene.getDescription()).questions(reportScene.getQuestions()).quickQuestion(reportScene.getQuickQuestion()).metrics(reportScene.getMetrics()).modules(reportScene.getModules()).entities(reportScene.getEntities()).build());
            }
            pushDataSetDTOS.add(PushDataSetDTO.builder().applicationCode(application.getCode()).applicationName(application.getName()).version(application.getVersion()).dataSetDto(dataSetContentList).build());
        }
    }

    private void handlePushMetricData(List<PushMetricDTO> pushMetricDTOS, Application application, List<ReportSceneDTO> reportSceneDTOList) {
        for (ReportSceneDTO reportScene : reportSceneDTOList) {
            pushMetricDTOS.add(PushMetricDTO.builder().metricId(reportScene.getCode()).metricName(reportScene.getSceneTitle()).applicationCode(application.getCode()).applicationName(application.getName()).billingGoodsId(application.getBillingGoodsId()).description(reportScene.getDescription()).prod(reportScene.getProd()).productLine(reportScene.getProductLine()).businessType(Objects.nonNull(reportScene.getBusinessType()) ? reportScene.getBusinessType().getCode() : null).formula(reportScene.getFormula()).lang(reportScene.getLang()).version(reportScene.getVersion()).fieldSchema(reportScene.getFieldSchema()).build());
        }
    }

    private void handlePushTableData(List<PushTableDTO> pushMetricDTOS, Application application, List<ReportSceneDTOs> reportSceneDTOList) {
        for (ReportSceneDTOs reportScene : reportSceneDTOList) {
            pushMetricDTOS.add(PushTableDTO.builder().metricId(reportScene.getCode()).metricName(reportScene.getSceneTitle()).applicationCode(application.getCode()).applicationName(application.getName()).billingGoodsId(application.getBillingGoodsId()).description(reportScene.getDescription()).prod(reportScene.getProd()).productLine(reportScene.getProductLine()).formula(reportScene.getFormula()).lang(reportScene.getLang()).version(reportScene.getVersion()).questions(reportScene.getQuestions()).quickQuestion(reportScene.getQuickQuestion()).fieldSchema(reportScene.getFieldSchema()).metrics(reportScene.getMetrics()).modules(reportScene.getModules()).entities(reportScene.getEntities()).build());
        }
    }

    private void mergeSceneCodes(Map<String, List<String>> mergedSceneCodesByAppCode, Map<String, List<SceneTemplate>> groupedSceneTemplates) {
        groupedSceneTemplates.forEach((appCode, mergedSceneTemplates) -> {
            List mergedSceneCodes = mergedSceneTemplates.stream().map(SceneTemplate::getTemplateCode).distinct().collect(Collectors.toList());
            mergedSceneCodesByAppCode.put((String)appCode, mergedSceneCodes);
        });
    }

    private void processApplicationScene(List<PushDataDTO> pushDataDTOS, Map.Entry<String, List<String>> entry, Map<String, List<SceneTemplate>> groupedSceneTemplates, Application application, String tenantId, String version) throws Exception {
        List<ReportSceneDTO> reportScenes = this.querySceneMapsByTemplate(entry.getValue(), application.getCode());
        if (CollectionUtils.isEmpty(reportScenes)) {
            pushDataDTOS.add(this.createPushDataDTO(application));
            return;
        }
        PushDataDTO pushData = new PushDataDTO();
        ArrayList<DimensionDTO> dimensions = new ArrayList<DimensionDTO>();
        HashMap<String, List<Object>> templateIntentionsMap = new HashMap<String, List<Object>>();
        ArrayList<PushSceneDTO> pushSceneList = new ArrayList<PushSceneDTO>();
        for (ReportSceneDTO reportSceneDTO : reportScenes) {
            if (!CollectionUtils.isEmpty((Collection)reportSceneDTO.getIntentions())) {
                if (templateIntentionsMap.containsKey(reportSceneDTO.getTemplateCode())) {
                    List existingIntentions = (List)templateIntentionsMap.get(reportSceneDTO.getTemplateCode());
                    existingIntentions.addAll(reportSceneDTO.getIntentions());
                    templateIntentionsMap.put(reportSceneDTO.getTemplateCode(), existingIntentions.stream().distinct().collect(Collectors.toList()));
                } else {
                    templateIntentionsMap.put(reportSceneDTO.getTemplateCode(), new ArrayList(new HashSet(reportSceneDTO.getIntentions())));
                }
            }
            List<DataSourceDTO> dataSource = this.mergeAndDistinct(this.transMetaData(new ArrayList<DataSourceDTO>(), Collections.singletonList(reportSceneDTO), tenantId, dimensions, version));
            PushSceneDTO pushScene = PushSceneDTO.builder().sceneCode(reportSceneDTO.getCode()).sceneTitle(reportSceneDTO.getSceneTitle()).productLine(reportSceneDTO.getProductLine()).targetName(reportSceneDTO.getTargetName()).targetId(reportSceneDTO.getTargetId()).templateCode(reportSceneDTO.getTemplateCode()).templateName(reportSceneDTO.getTemplateName()).schemas(dataSource.get(0).getSchemas()).billingGoodsId(StringUtils.isNotEmpty((CharSequence)application.getBillingGoodsId()) ? application.getBillingGoodsId() : "").intentions(CollectionUtils.isEmpty((Collection)reportSceneDTO.getIntentions()) ? new ArrayList() : reportSceneDTO.getIntentions()).dimensionKeys(CollectionUtils.isEmpty((Collection)reportSceneDTO.getActionDimension()) ? new ArrayList() : reportSceneDTO.getActionDimension().stream().map(ActionDimension::getDimension).flatMap(Collection::stream).distinct().collect(Collectors.toList())).build();
            pushSceneList.add(pushScene);
        }
        pushData.setScenes(pushSceneList);
        List distinctDimensions = dimensions.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DimensionDTO>(Comparator.comparing(DimensionDTO::getName))), ArrayList::new));
        pushData.setDimensions(distinctDimensions);
        List<SceneTemplate> templateList = groupedSceneTemplates.get(entry.getKey());
        for (SceneTemplate template : templateList) {
            template.setIntentions((List)templateIntentionsMap.get(template.getTemplateCode()));
        }
        pushData.setTemplate(templateList);
        pushData.setApplicationCode(application.getCode());
        pushData.setApplicationName(application.getName());
        pushData.setVersion(application.getVersion());
        pushDataDTOS.add(pushData);
    }

    List<DataSourceDTO> transMetaData(List<DataSourceDTO> dataSources, List<ReportSceneDTO> reportScenes, String tenantId, List<DimensionDTO> dimensions, String version) throws Exception {
        for (ReportSceneDTO reportScene : reportScenes) {
            String[] actionIds = reportScene.getActionId().split(",");
            List<Object> metaData = new ArrayList<GetActionLocaleResponseDTO>();
            ArrayList<String> pathActionId = new ArrayList<String>();
            for (String actionId : actionIds) {
                ActionExecutionPathDTO pathDTO = (ActionExecutionPathDTO)this.actionService.postQueryExecutionPath(actionId, tenantId, new ArrayList<String>(), new ArrayList<String>());
                List actionData = pathDTO.getActionMetadatas();
                for (ActionDefinitionDTO meta : actionData) {
                    pathActionId.add(meta.getActionId());
                }
                metaData = this.actionMetadataManager.getActionMetadatas(pathActionId, tenantId, version);
            }
            DataSourceDTO dataSourceDTO = this.convertActionDefinitionToDataSource(metaData, reportScene, dimensions);
            dataSourceDTO.setAppCode(reportScene.getAppCode());
            dataSourceDTO.setVersion(reportScene.getVersion());
            dataSources.add(dataSourceDTO);
        }
        return dataSources;
    }

    List<DataSourceDTO> transMetaData111(List<DataSourceDTO> dataSources, List<ReportSceneDTO> reportScenes, String tenantId, List<DimensionDTO> dimensions, String version) throws Exception {
        for (ReportSceneDTO reportScene : reportScenes) {
            String[] actionIds = reportScene.getActionId().split(",");
            List dataPullingActions = this.actionMetadataManager.getActionMetadatas(Arrays.asList(actionIds), tenantId, version);
            List codes = dataPullingActions.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getDataFlowCode())).map(GetActionLocaleResponseDTO::getDataFlowCode).collect(Collectors.toList());
            List metaData = this.actionMetadataManager.getActionMetadatasByDataFlowCode(codes, tenantId, version);
            DataSourceDTO dataSourceDTO = this.convertActionDefinitionToDataSource(metaData, reportScene, dimensions);
            dataSourceDTO.setAppCode(reportScene.getAppCode());
            dataSourceDTO.setVersion(reportScene.getVersion());
            dataSources.add(dataSourceDTO);
        }
        return dataSources;
    }

    public EspActionMetadataDTO getActionMetadata(ActionLabel actionAndLabels) throws Exception {
        Action action = actionAndLabels.getAction();
        EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
        metadataDTO.setActionId(action.getActionId());
        metadataDTO.setServiceName(action.getServiceName());
        metadataDTO.setIdempotency(action.getIdempotency());
        metadataDTO.setName(action.getName());
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray((String)action.getRequest_parameters(), ApiDataFieldMetadataDTO.class));
        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData((ApiDataFieldMetadataDTO)JSON.parseObject((String)action.getResponse_object(), ApiDataFieldMetadataDTO.class));
        metadataDTO.setRequest(requestMetadataDTO);
        metadataDTO.setResponse(responseMetadataDTO);
        metadataDTO.setSceneNodeType(action.getSceneNodeType());
        return metadataDTO;
    }

    List<ReportSceneDTO> querySceneMapsByTemplate(List<String> templateCode, String appCode) {
        if (CollectionUtils.isEmpty(templateCode)) {
            return null;
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String query = "MATCH (n:ReportScene) WHERE n.templateCode in $templateCode and n.version = $version and n.appCode = $appCode and n.status = '1' RETURN n";
        param.put("templateCode", templateCode);
        param.put("version", tenantVersion);
        param.put("appCode", appCode);
        return this.querySceneData(query, param);
    }

    public List<ReportSceneDTO> querySceneData(String query, Map<String, Object> param) {
        ArrayList<ReportSceneDTO> reportSceneList = new ArrayList<ReportSceneDTO>();
        Session session = this.neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable iterableResult = (Iterable)result.queryResults();
        Iterator iterator = iterableResult.iterator();
        while (iterator.hasNext()) {
            ReportSceneDTO reportScene = new ReportSceneDTO();
            Map record = (Map)iterator.next();
            Node node = (Node)record.get("n");
            List propertyList = node.getPropertyList();
            for (Property property : propertyList) {
                this.setReportSceneProperty(reportScene, (Property<String, Object>)property);
            }
            reportSceneList.add(reportScene);
        }
        return reportSceneList;
    }

    public List<ReportSceneDTOs> querySceneDatas(String query, Map<String, Object> param) {
        ArrayList<ReportSceneDTOs> reportSceneList = new ArrayList<ReportSceneDTOs>();
        Session session = this.neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable iterableResult = (Iterable)result.queryResults();
        Iterator iterator = iterableResult.iterator();
        while (iterator.hasNext()) {
            ReportSceneDTOs reportScene = new ReportSceneDTOs();
            Map record = (Map)iterator.next();
            Node node = (Node)record.get("n");
            List propertyList = node.getPropertyList();
            for (Property property : propertyList) {
                String key = (String)property.getKey();
                Object value = property.getValue();
                this.setReportScenePropertyUsingReflection(reportScene, key, value);
            }
            reportSceneList.add(reportScene);
        }
        return reportSceneList;
    }

    private void setReportScenePropertyUsingReflection(ReportSceneDTOs reportScene, String key, Object value) {
        try {
            Class<?> clazz = reportScene.getClass();
            Field[] fields = clazz.getDeclaredFields();
            Field targetField = null;
            for (Field field : fields) {
                if (!field.getName().equals(key)) continue;
                targetField = field;
                break;
            }
            if (targetField == null || ObjectUtils.isEmpty(targetField)) {
                return;
            }
            targetField.setAccessible(true);
            Class<?> fieldType = targetField.getType();
            Object convertedValue = this.convertValue(value, fieldType);
            targetField.set(reportScene, convertedValue);
        }
        catch (IllegalAccessException e) {
            log.error("setReportScenePropertyUsingReflection error", (Throwable)e);
        }
    }

    private Object convertValue(Object value, Class<?> targetType) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (targetType.equals(String.class)) {
            return value.toString();
        }
        if (value.toString().startsWith("[") && value.toString().endsWith("]") && !value.toString().startsWith("[{")) {
            return value;
        }
        return JSON.parseObject((String)value.toString(), targetType);
    }

    @Override
    public Object postRemoveData(String type, String sceneCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("type", type);
        paramMap.put("sceneCode", sceneCode);
        return "success";
    }

    public List<DataSourceDTO> mergeAndDistinct(List<DataSourceDTO> dataSourceDTOs) {
        HashMap<String, DataSourceDTO> mergedMap = new HashMap<String, DataSourceDTO>();
        for (DataSourceDTO dataSourceDTO : dataSourceDTOs) {
            String datasourceId = dataSourceDTO.getDatasourceId();
            if (mergedMap.containsKey(datasourceId)) {
                DataSourceDTO existing = (DataSourceDTO)mergedMap.get(datasourceId);
                List<DataSchemaDTO> mergedSchemas = this.mergeAndDistinctSchemas(existing.getSchemas(), dataSourceDTO.getSchemas());
                existing.setSchemas(mergedSchemas);
                if (CollectionUtils.isEmpty((Collection)dataSourceDTO.getIntentions())) continue;
                ArrayList mergedIntentions = CollectionUtils.isEmpty((Collection)existing.getIntentions()) ? new ArrayList() : new ArrayList(existing.getIntentions());
                mergedIntentions.addAll(dataSourceDTO.getIntentions());
                List mergedAndDistinctIntentions = mergedIntentions.stream().distinct().collect(Collectors.toList());
                existing.setIntentions(mergedAndDistinctIntentions);
                continue;
            }
            mergedMap.put(datasourceId, dataSourceDTO);
        }
        return new ArrayList<DataSourceDTO>(mergedMap.values());
    }

    private List<DataSchemaDTO> mergeAndDistinctSchemas(List<DataSchemaDTO> existingSchemas, List<DataSchemaDTO> newSchemas) {
        Map<String, DataSchemaDTO> schemaMap = existingSchemas.stream().collect(Collectors.toMap(DataSchemaDTO::getName, schema -> schema));
        for (DataSchemaDTO newSchema : newSchemas) {
            schemaMap.putIfAbsent(newSchema.getName(), newSchema);
        }
        return new ArrayList<DataSchemaDTO>(schemaMap.values());
    }

    public DataSourceDTO convertActionDefinitionToDataSource(List<GetActionLocaleResponseDTO> actionDefinitions, ReportSceneDTO reportScene, List<DimensionDTO> dimensions) {
        DataSourceDTO dataSource = new DataSourceDTO();
        dataSource.setDatasourceId(reportScene.getTargetId());
        dataSource.setDatasourceName(reportScene.getTargetName());
        dataSource.setIntentions(reportScene.getIntentions());
        ArrayList<DataSchemaDTO> schemas = new ArrayList<DataSchemaDTO>();
        for (GetActionLocaleResponseDTO actionDefinition : actionDefinitions) {
            if (actionDefinition.getRequest() == null || CollectionUtils.isEmpty((Collection)actionDefinition.getRequest().getParameters())) continue;
            for (ApiDataFieldLocaleMetadataDTO param : actionDefinition.getRequest().getParameters()) {
                schemas.addAll(this.convertApiDataFieldWithNestedFieldsToSchemas(param));
            }
        }
        List actionDimensionsData = reportScene.getActionDimension();
        if (!CollectionUtils.isEmpty((Collection)actionDimensionsData)) {
            for (ActionDimension actionDimension : actionDimensionsData) {
                List actionDimensions = actionDimension.getDimension();
                for (DataSchemaDTO schemaDTO : schemas) {
                    if (!actionDimensions.contains(schemaDTO.getName())) continue;
                    DimensionDTO dimensionDTO = new DimensionDTO();
                    dimensionDTO.setName(schemaDTO.getName());
                    dimensionDTO.setTitle(schemaDTO.getTitle());
                    dimensions.add(dimensionDTO);
                }
            }
        }
        dataSource.setSchemas(this.mergeAndAdjustInputOutput(schemas));
        return dataSource;
    }

    public List<DataSchemaDTO> convertApiDataFieldWithNestedFieldsToSchemas(ApiDataFieldLocaleMetadataDTO apiDataField) {
        ArrayList<DataSchemaDTO> schemas = new ArrayList<DataSchemaDTO>();
        if (!"object".equals(apiDataField.getData_type())) {
            DataSchemaDTO schema = this.convertApiDataFieldToSchema(apiDataField);
            schemas.add(schema);
        }
        if (!CollectionUtils.isEmpty((Collection)apiDataField.getField())) {
            for (ApiDataFieldLocaleMetadataDTO nestedField : apiDataField.getField()) {
                schemas.addAll(this.convertApiDataFieldWithNestedFieldsToSchemas(nestedField));
            }
        }
        return schemas;
    }

    public DataSchemaDTO convertApiDataFieldToSchema(ApiDataFieldLocaleMetadataDTO apiDataField) {
        DataSchemaDTO schema = new DataSchemaDTO();
        schema.setName(apiDataField.getData_name());
        schema.setTitle(apiDataField.getDescription());
        schema.setDataType(apiDataField.getData_type());
        return schema;
    }

    public List<DataSchemaDTO> mergeAndAdjustInputOutput(List<DataSchemaDTO> schemaList) {
        LinkedHashMap<String, DataSchemaDTO> mergedSchemas = new LinkedHashMap<String, DataSchemaDTO>();
        for (DataSchemaDTO schema : schemaList) {
            String name = schema.getName();
            if (mergedSchemas.containsKey(name)) {
                DataSchemaDTO existingSchema = (DataSchemaDTO)mergedSchemas.get(name);
                if (schema.getName().equals(existingSchema.getName()) && !Objects.equals(schema.getInput(), existingSchema.getInput()) && !Objects.equals(schema.getOutput(), existingSchema.getOutput())) {
                    schema.setInput(Boolean.valueOf(true));
                    schema.setOutput(Boolean.valueOf(true));
                }
            }
            mergedSchemas.put(name, schema);
        }
        return new ArrayList<DataSchemaDTO>(mergedSchemas.values());
    }

    @Override
    public Object postCreateActionIntentions(ActionIntentions actionIntentions) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionIntentions.getActionId()));
        Update update = Update.update((String)"intentions", (Object)actionIntentions.getIntentions()).set("version", (Object)tenantVersion);
        this.mongoTemplate.upsert(query, update, ActionIntentions.class);
        return "success";
    }

    @Override
    public List<ActionIntentions> postQueryActionIntentions(List<String> actionIds) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"actionId").in(actionIds).and("version").is((Object)tenantVersion)), ActionIntentions.class);
    }

    @Override
    public Object postCreateActionRecast(ActionRecast actionRecast) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionRecast.getActionId()));
        Update update = Update.update((String)"recast", (Object)actionRecast.getRecast());
        this.mongoTemplate.upsert(query, update, ActionRecast.class);
        return "success";
    }

    @Override
    public List<ActionRecast> postQueryActionRecast(List<String> actionIds) {
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"actionId").in(actionIds)), ActionRecast.class);
    }

    @Override
    public Object postCreateActionRelation(ActionRelation actionRelation) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionRelation.getActionId()));
        Update update = Update.update((String)"path", (Object)actionRelation.getPath()).set("version", (Object)tenantVersion);
        this.mongoTemplate.upsert(query, update, ActionRelation.class);
        return "success";
    }

    @Override
    public Object postQueryActionRelation(List<String> actionIds) throws Exception {
        List actionRelationList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"actionId").in(actionIds)), ActionRelation.class);
        Set<String> rootPath = this.findRootPath(actionRelationList);
        ArrayList<ActionRelationDTO> actionRelationDTOList = new ArrayList<ActionRelationDTO>();
        HashMap<String, String> isContainMap = new HashMap<String, String>();
        for (String parentPath : rootPath) {
            actionRelationDTOList.addAll(SceneService.buildActionRelationDTO(actionRelationList, parentPath, isContainMap));
        }
        return this.assemble(actionRelationDTOList);
    }

    private Set<String> findRootPath(List<ActionRelation> actionRelations) {
        HashSet<String> allPaths = new HashSet<String>();
        HashSet<String> childPaths = new HashSet<String>();
        for (ActionRelation actionRelation : actionRelations) {
            allPaths.add(actionRelation.getPath());
            childPaths.add(actionRelation.getActionId());
        }
        HashSet<String> rootPaths = new HashSet<String>();
        for (String path : allPaths) {
            boolean isRoot = true;
            for (String childPath : childPaths) {
                if (!path.contains(childPath) || !path.endsWith(childPath)) continue;
                isRoot = false;
                break;
            }
            if (!isRoot) continue;
            rootPaths.add(path);
        }
        return rootPaths;
    }

    private static List<ActionRelationDTO> buildActionRelationDTO(List<ActionRelation> actionRelations, String parentPath, Map<String, String> isContainMap) {
        ArrayList<ActionRelationDTO> actionRelationDTOList = new ArrayList<ActionRelationDTO>();
        for (ActionRelation actionRelation : actionRelations) {
            if (!actionRelation.getPath().startsWith(parentPath) || !Objects.isNull(isContainMap.get(actionRelation.getActionId()))) continue;
            ActionRelationDTO actionRelationDTO = new ActionRelationDTO();
            actionRelationDTO.setActionId(actionRelation.getActionId());
            actionRelationDTO.setType(actionRelation.getType());
            actionRelationDTO.setSubAction(SceneService.buildActionRelationDTO(actionRelations, parentPath + (StringUtils.isNotEmpty((CharSequence)parentPath) ? "." : "") + actionRelation.getActionId(), isContainMap));
            actionRelationDTOList.add(actionRelationDTO);
            isContainMap.put(actionRelation.getActionId(), actionRelation.getActionId());
        }
        return actionRelationDTOList;
    }

    public List<ActionRelationDTO> assemble(List<ActionRelationDTO> sceneActionRelation) throws Exception {
        if (CollectionUtils.isEmpty(sceneActionRelation)) {
            return Collections.emptyList();
        }
        ArrayList<ActionRelationDTO> assembledActionRelation = new ArrayList<ActionRelationDTO>();
        this.queryAction(sceneActionRelation, assembledActionRelation);
        return assembledActionRelation;
    }

    private List<ActionRelationDTO> assembleSubActions(List<ActionRelationDTO> subActions) throws Exception {
        ArrayList<ActionRelationDTO> assembledSubActions = new ArrayList<ActionRelationDTO>();
        this.queryAction(subActions, assembledSubActions);
        return assembledSubActions;
    }

    private void queryAction(List<ActionRelationDTO> subActions, List<ActionRelationDTO> assembledSubActions) throws Exception {
        for (ActionRelationDTO subAction : subActions) {
            ActionRelationDTO assembledSubAction = new ActionRelationDTO();
            assembledSubAction.setActionId(subAction.getActionId());
            if ("model".equals(subAction.getType())) {
                assembledSubAction.setAction(this.postModelCenterMetaData(Arrays.asList(subAction.getActionId())));
            } else {
                assembledSubAction.setAction(this.actionService.getMetadata(subAction.getActionId()));
            }
            List<ActionRelationDTO> assembledNestedSubActions = this.assembleSubActions(subAction.getSubAction());
            assembledSubAction.setSubAction(assembledNestedSubActions);
            assembledSubActions.add(assembledSubAction);
        }
    }

    @Override
    public Object postCreateActionReportConfig(ActionReportConfig actionReportConfig) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)actionReportConfig.getActionId()));
        Update update = Update.update((String)"show", (Object)actionReportConfig.getShow()).set("showType", (Object)actionReportConfig.getShowType()).set("version", (Object)tenantVersion);
        this.mongoTemplate.upsert(query, update, ActionReportConfig.class);
        return "success";
    }

    @Override
    public List<Object> postQueryActionReportConfig(List<String> actionIds) throws IllegalAccessException, NoSuchFieldException, DWBusinessException {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List actionReportConfigs = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"actionId").in(actionIds).and("version").is((Object)tenantVersion)), ActionReportConfig.class);
        if (!CollectionUtils.isEmpty((Collection)actionReportConfigs)) {
            return JSON.parseArray((String)this.getTranslateContent(actionReportConfigs).toString(), Object.class);
        }
        return Collections.emptyList();
    }

    @Override
    public Object postCreateSceneTemplate(SceneTemplate sceneTemplate) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"templateCode").is((Object)sceneTemplate.getTemplateCode()).and("version").is((Object)tenantVersion));
        this.mongoTemplate.remove(query, SceneTemplate.class);
        sceneTemplate.setVersion(tenantVersion);
        this.mongoTemplate.save((Object)sceneTemplate);
        return "success";
    }

    @Override
    public Object postQuerySceneTemplate(List<String> templateCodes) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        return this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"templateCode").in(templateCodes).and("version").is((Object)tenantVersion)), SceneTemplate.class);
    }

    public SceneTargetInfo postQuerySceneTargetInfo(String targetCode) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        return (SceneTargetInfo)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"targetCode").is((Object)targetCode).and("version").is((Object)tenantVersion)), SceneTargetInfo.class);
    }

    @Override
    public List<GetActionLocaleResponseDTO> postModelCenterMetaData(List<String> modelIds) throws IOException {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        String url = "https://bmd-dmsc-001-hz-test.apps.digiwincloud.com.cn/restful/service/dataModel/semantic/modelMeta";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", modelIds);
        DapResponse response = Utils.postJson(url, Utils.requiredMapHeaders(), params, DapResponse.class);
        JSONObject result = (JSONObject)response.getResponse();
        List respModelDTO = JSON.parseArray((String)result.get((Object)"data").toString(), DataModelDTO.class);
        ArrayList<GetActionLocaleResponseDTO> metadataDTOS = new ArrayList<GetActionLocaleResponseDTO>();
        for (DataModelDTO dataModelDTO : respModelDTO) {
            List dataTables = dataModelDTO.getTables();
            if (CollectionUtils.isEmpty((Collection)dataTables)) continue;
            for (ModelTableDTO modelTableDTO : dataTables) {
                ActionMetadataDTO metadataDTO = new ActionMetadataDTO();
                ActionResponseMetadataDTO actionResponseMetadataDTO = new ActionResponseMetadataDTO();
                ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = new ApiDataFieldMetadataDTO();
                apiDataFieldMetadataDTO.setData_name(modelTableDTO.getCode());
                apiDataFieldMetadataDTO.setData_type("object");
                apiDataFieldMetadataDTO.setRequired("true");
                ArrayList<ApiDataFieldMetadataDTO> field = new ArrayList<ApiDataFieldMetadataDTO>();
                List dataFields = modelTableDTO.getFields();
                if (!CollectionUtils.isEmpty((Collection)dataFields)) {
                    apiDataFieldMetadataDTO.setIs_array(Boolean.valueOf(true));
                    for (ModelFieldDTO modelFieldDTO : dataFields) {
                        MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO();
                        multiLanguageDTO.setZh_CN(modelFieldDTO.getName());
                        ApiDataFieldMetadataDTO apiDataFieldMetadataFieldDTO = new ApiDataFieldMetadataDTO();
                        apiDataFieldMetadataFieldDTO.setData_name(modelFieldDTO.getOriginalCode());
                        apiDataFieldMetadataFieldDTO.setData_type(this.convertDataTypeValue(modelFieldDTO.getDataType()));
                        apiDataFieldMetadataFieldDTO.setDescription(multiLanguageDTO);
                        apiDataFieldMetadataFieldDTO.setIs_array(Boolean.valueOf(false));
                        field.add(apiDataFieldMetadataFieldDTO);
                    }
                }
                apiDataFieldMetadataDTO.setField(field);
                actionResponseMetadataDTO.setData(apiDataFieldMetadataDTO);
                metadataDTO.setActionId(dataModelDTO.getId().toString());
                metadataDTO.setName(dataModelDTO.getName());
                metadataDTO.setResponse(actionResponseMetadataDTO);
                metadataDTO.setRequest(new ActionRequestMetadataDTO());
                GetActionLocaleResponseDTO localeResponseDTO = (GetActionLocaleResponseDTO)JSON.parseObject((String)JSON.toJSONString((Object)metadataDTO), GetActionLocaleResponseDTO.class);
                MetadataTranslator.translateField((GetActionLocaleResponseDTO)localeResponseDTO, (ActionMetadataDTO)metadataDTO, (String)localeStr, null);
                metadataDTOS.add(localeResponseDTO);
            }
        }
        return metadataDTOS;
    }

    private String convertDataTypeValue(int value) {
        switch (value) {
            case 0: {
                return "string";
            }
            case 1: {
                return "date";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "numeric";
            }
            case 4: {
                return "boolean";
            }
        }
        return "string";
    }

    public Map postDataSource(Object data, String url) {
        String apiMetadataUrl = this.scrumbiUrl + url;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            HttpHeaders headers = new HttpHeaders();
            Utils.requiredHeaders(headers);
            HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
            ResponseEntity res = this.restTemplate.postForEntity(apiMetadataUrl, (Object)httpEntity, Map.class, new Object[0]);
            if (!"200".equals(((Map)res.getBody()).get("code").toString())) {
                return (Map)res.getBody();
            }
        }
        catch (Exception e) {
            log.error("push data error : {}", (Throwable)e);
            resultMap.put("code", "500");
            resultMap.put("msg", "\u8bed\u4e49\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return resultMap;
        }
        return null;
    }

    @Override
    public Object getCreatePullingDataMap() throws DWBusinessException {
        List pullingDataList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"transStatus").is((Object)"1")), PullingData.class);
        ArrayList<String> actionIds = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)pullingDataList)) {
            return "";
        }
        String tenantId = AthenaUtils.getTenantId();
        for (PullingData pullingData : pullingDataList) {
            String actionId = pullingData.getActionId();
            String nameSpace = pullingData.getNameSpace();
            String executeScript = this.getExecuteCreateNodeScript(pullingData);
            if (StringUtils.isNotEmpty((CharSequence)executeScript)) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("actionId", actionId);
                String deleteQuery = "match(t:Action) where t.actionId=$actionId detach delete t";
                this.kgHelpService.executeCyhper(deleteQuery, props);
                this.kgHelpService.executeCyhper(executeScript, new HashMap<String, Object>());
                String tenantActionScript = String.format("MATCH (a:TenantEntity{tenantId: '%s'})\nMATCH (b:Action{actionId:'%s'})\nCREATE (a)-[:ACTION]->(b)", tenantId, actionId);
                this.kgHelpService.executeCyhper(tenantActionScript, new HashMap<String, Object>());
                this.entityAndDependencyGeneratorService.BuildOne(actionId, nameSpace);
            }
            actionIds.add(actionId);
        }
        for (PullingData pullingData : pullingDataList) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"actionId").is((Object)pullingData.getActionId()));
            Update update = Update.update((String)"transStatus", (Object)"0");
            this.mongoTemplate.upsert(query, update, PullingData.class);
        }
        return "success";
    }

    @Override
    public Object getCreatePullingDataRelation() {
        List pullingDataList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"transStatus").is((Object)"1")), PullingDataRelation.class);
        if (!CollectionUtils.isEmpty((Collection)pullingDataList)) {
            for (PullingDataRelation pullingDataRelation : pullingDataList) {
                String deleteQuery = String.format("match(a:Action)-[:Requires]->(ae:DataEntity)-->(ad:DataField)-[r:MapsTo]->(bd:DataField)\nwhere a.actionId = '%s'  \ndelete r", pullingDataRelation.getFromActionId());
                this.kgHelpService.executeCyhper(deleteQuery, new HashMap<String, Object>());
                deleteQuery = String.format("match(a:Action)-[:Requires]->(ad:DataField)-[r:MapsTo]->(bd:DataField)\nwhere a.actionId = '%s'  return r", pullingDataRelation.getFromActionId());
                this.kgHelpService.executeCyhper(deleteQuery, new HashMap<String, Object>());
                String executeScript = String.format("match(a:Action)-[:Requires]->(ae:DataEntity)-[:Contains*0..3]->(ad:DataField) \nmatch(b:Action)-[:Creates]->(be:DataEntity)-[:Contains*0..3]->(bd:DataField) \nwhere ad.name=bd.name and a.actionId = '%s' and b.actionId = '%s'  \nmerge (ad)-[:MapsTo]->(bd)", pullingDataRelation.getFromActionId(), pullingDataRelation.getToActionId());
                this.kgHelpService.executeCyhper(executeScript, new HashMap<String, Object>());
                executeScript = String.format("match(a:Action)-[:Requires]->(ad:DataField) \nmatch(b:Action)-[:Creates]->(be:DataEntity)-[:Contains*0..3]->(bd:DataField) \nwhere ad.name=bd.name and a.actionId = '%s' and b.actionId = '%s'  \nmerge (ad)-[:MapsTo]->(bd)", pullingDataRelation.getFromActionId(), pullingDataRelation.getToActionId());
                this.kgHelpService.executeCyhper(executeScript, new HashMap<String, Object>());
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"fromActionId").is((Object)pullingDataRelation.getFromActionId()).and("toActionId").is((Object)pullingDataRelation.getToActionId()));
                Update update = Update.update((String)"transStatus", (Object)"0");
                this.mongoTemplate.upsert(query, update, PullingDataRelation.class);
            }
        }
        return "success";
    }

    private String getExecuteCreateNodeScript(PullingData pullingData) {
        String script = null;
        String actionId = pullingData.getActionId();
        String type = pullingData.getType();
        String nameSpace = pullingData.getNameSpace();
        String querySchema = pullingData.getQuerySchema();
        String expression = pullingData.getExpression();
        String target = pullingData.getTarget();
        String microTrans = pullingData.getMicroTrans();
        String name = pullingData.getName();
        List<ApiDataFieldMetadataDTO> requestParams = pullingData.getRequestData();
        ApiDataFieldMetadataDTO processVar_output = pullingData.getResponseData();
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            switch (type) {
                case "DATA_PULLING": {
                    script = DataPullingActionDO.builder().actionId(actionId).name(name).request(requestParams).response(processVar_output).sceneNodeType(StringUtils.isNotEmpty((CharSequence)pullingData.getSceneNodeType()) ? pullingData.getSceneNodeType() : "1").build().GeneratePullDataCreateScript(nameSpace);
                    break;
                }
                case "BMD_GENERAL": {
                    script = DataPullingActionDO.builder().actionId(actionId).name(name).request(requestParams).response(processVar_output).build().GenerateBmdCreateScript(nameSpace, querySchema);
                    break;
                }
                case "BMD": {
                    script = DataPullingActionDO.builder().actionId(actionId).name(name).request(requestParams).response(processVar_output).sceneNodeType(StringUtils.isNotEmpty((CharSequence)pullingData.getSceneNodeType()) ? pullingData.getSceneNodeType() : "").build().GenerateBmdNewCreateScript(nameSpace, pullingData.getSpName());
                    break;
                }
                case "FormulaAction": {
                    script = FormulaActionDO.builder().actionId(actionId).name(name).request(requestParams).response(processVar_output).expression(expression).target(target).build().GenerateFormulaCreateScript(nameSpace);
                    break;
                }
                case "MICRO_TRANS": {
                    script = DataPullingActionDO.builder().actionId(actionId).name(name).request(requestParams).response(processVar_output).build().GenerateMicroTransCreateScript(nameSpace, microTrans);
                    break;
                }
                default: {
                    script = null;
                }
            }
        }
        return script;
    }

    private void executeNeo4jScript(List<String> executeNeo4jScripts, SessionFactory sessionFactory) {
        if (CollectionUtils.isEmpty(executeNeo4jScripts)) {
            return;
        }
        if (sessionFactory == null) {
            return;
        }
        Session session = sessionFactory.openSession();
        try (Transaction transaction = session.beginTransaction();){
            for (String cql : executeNeo4jScripts) {
                session.query(cql, new HashMap());
            }
            transaction.commit();
        }
        catch (Exception e) {
            log.error("executeNeo4jScript updateSceneShow error:{}", (Throwable)e);
        }
        session.clear();
    }

    @Override
    public Object getSceneSchema(String sceneCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        ReportSceneDTO reportScene = this.querySceneMaps(Collections.singletonList(sceneCode), tenantVersion);
        if (Objects.isNull(reportScene)) {
            return null;
        }
        return this.mergeAndDistinct(this.transMetaData(new ArrayList<DataSourceDTO>(), Collections.singletonList(reportScene), tenantId, new ArrayList<DimensionDTO>(), tenantVersion));
    }

    @Override
    public Object postQuerySceneIntention() throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        ArrayList<TargetIntentionsDTO> targetIntentionsDTOList = new ArrayList<TargetIntentionsDTO>();
        List<ReportSceneDTO> reportSceneList = this.querySceneMapsDataByAppCode();
        if (CollectionUtils.isEmpty(reportSceneList)) {
            return targetIntentionsDTOList;
        }
        Map<String, List<String>> groupedIntentions = this.getIntentionsByTargetName(reportSceneList);
        if (CollectionUtils.isEmpty(groupedIntentions)) {
            return targetIntentionsDTOList;
        }
        List<String> sortedTargetIds = groupedIntentions.keySet().stream().sorted().collect(Collectors.toList());
        this.setIntentionsByTargetName(groupedIntentions, sortedTargetIds, targetIntentionsDTOList);
        return this.getTranslateContent(targetIntentionsDTOList);
    }

    @Override
    public Object postQuerySceneIntentions() throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        ArrayList<TargetIntentionsDTO> targetIntentionsDTOList = new ArrayList<TargetIntentionsDTO>();
        List<ReportSceneDTO> reportSceneList = this.querySceneMapsDataByAppCode();
        if (CollectionUtils.isEmpty(reportSceneList)) {
            return targetIntentionsDTOList;
        }
        Map<String, Map<String, List<String>>> groupedIntentions = this.getIntentionsByTargetNameAndCode(reportSceneList);
        if (CollectionUtils.isEmpty(groupedIntentions)) {
            return targetIntentionsDTOList;
        }
        List<String> sortedTargetIds = groupedIntentions.keySet().stream().sorted().collect(Collectors.toList());
        this.setIntentionsByTargetNameAndCode(groupedIntentions, sortedTargetIds, targetIntentionsDTOList);
        return this.getDistinctData(this.getTranslateContent(targetIntentionsDTOList));
    }

    private List<ReportSceneDTO> querySceneMapsDataByAppCode() throws DWBusinessException {
        ArrayList<ReportSceneDTO> reportSceneDTOS = new ArrayList<ReportSceneDTO>();
        String userId = AthenaUtils.getUserId();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            throw new DWBusinessException("userId is empty");
        }
        List<String> uniqueAppCodes = this.cacUtils.getAppAuth(userId);
        if (CollectionUtils.isEmpty(uniqueAppCodes)) {
            return reportSceneDTOS;
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.version = $version and n.status = '1'  RETURN n";
        param.put("appCode", uniqueAppCodes);
        param.put("version", tenantVersion);
        return this.querySceneData(query, param);
    }

    private Map<String, List<String>> getIntentionsByTargetName(List<ReportSceneDTO> reportSceneList) {
        return reportSceneList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getTargetName())).collect(Collectors.groupingBy(ReportSceneDTO::getTargetName, Collectors.mapping(ReportSceneDTO::getIntentions, Collectors.reducing(new ArrayList(), (l1, l2) -> {
            ArrayList result = new ArrayList(l1);
            if (!CollectionUtils.isEmpty((Collection)l2)) {
                result.addAll(l2);
            }
            return result;
        }))));
    }

    public void setIntentionsByTargetName(Map<String, List<String>> groupedIntentions, List<String> sortedTargetIds, List<TargetIntentionsDTO> targetIntentionsDTOList) {
        for (String sortedTargetId : sortedTargetIds) {
            List<String> randomIntentions = groupedIntentions.get(sortedTargetId);
            if (CollectionUtils.isEmpty(randomIntentions)) continue;
            IntentionsDTO intentionsDTO = new IntentionsDTO();
            intentionsDTO.setIntention(randomIntentions.get(0));
            TargetIntentionsDTO targetIntentionsDTO = new TargetIntentionsDTO();
            targetIntentionsDTO.setTargetName(sortedTargetId);
            targetIntentionsDTO.setIntentions(Collections.singleton(intentionsDTO));
            targetIntentionsDTOList.add(targetIntentionsDTO);
        }
    }

    private Map<String, Map<String, List<String>>> getIntentionsByTargetNameAndCode(List<ReportSceneDTO> reportSceneList) {
        return reportSceneList.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getTargetName())).collect(Collectors.groupingBy(ReportSceneDTO::getTargetName, Collectors.groupingBy(ReportSceneDTO::getCode, Collectors.mapping(ReportSceneDTO::getIntentions, Collectors.reducing(new ArrayList(), (l1, l2) -> {
            ArrayList result = new ArrayList(l1);
            if (!CollectionUtils.isEmpty((Collection)l2)) {
                result.addAll(l2);
            }
            return result;
        })))));
    }

    public void setIntentionsByTargetNameAndCode(Map<String, Map<String, List<String>>> groupedIntentions, List<String> sortedTargetIds, List<TargetIntentionsDTO> targetIntentionsDTOList) {
        for (String sortedTargetId : sortedTargetIds) {
            Map<String, List<String>> codeIntentionsMap = groupedIntentions.get(sortedTargetId);
            HashSet<IntentionsDTO> intentionsDTOList = new HashSet<IntentionsDTO>();
            TargetIntentionsDTO targetIntentionsDTO = new TargetIntentionsDTO();
            for (Map.Entry<String, List<String>> codeIntentionsEntry : codeIntentionsMap.entrySet()) {
                List<String> intentions = codeIntentionsEntry.getValue();
                if (CollectionUtils.isEmpty(intentions)) continue;
                IntentionsDTO intentionsDTO = new IntentionsDTO();
                intentionsDTO.setIntention(intentions.get(0));
                intentionsDTOList.add(intentionsDTO);
            }
            if (CollectionUtils.isEmpty(intentionsDTOList)) continue;
            targetIntentionsDTO.setTargetName(sortedTargetId);
            targetIntentionsDTO.setIntentions(intentionsDTOList);
            targetIntentionsDTOList.add(targetIntentionsDTO);
        }
    }

    private Object getDistinctData(Object data) {
        if (Objects.isNull(data)) {
            return new JSONArray();
        }
        JSONArray jsonArray = JSON.parseArray((String)data.toString());
        return jsonArray.stream().map(obj -> this.processIntentions((JSONObject)obj)).collect(Collectors.toCollection(JSONArray::new));
    }

    private JSONObject processIntentions(JSONObject obj) {
        if (!obj.containsKey((Object)"intentions") || CollectionUtils.isEmpty((Collection)obj.getJSONArray("intentions"))) {
            return obj;
        }
        JSONArray intentions = obj.getJSONArray("intentions");
        HashMap<JSONObject, JSONObject> langIntentionsMap = new HashMap<JSONObject, JSONObject>();
        for (int i = 0; i < intentions.size(); ++i) {
            JSONObject intention = intentions.getJSONObject(i);
            JSONObject lang = intention.getJSONObject("lang");
            langIntentionsMap.put(lang, intention);
        }
        JSONArray uniqueIntentions = langIntentionsMap.values().stream().collect(Collectors.toCollection(JSONArray::new));
        obj.put("intentions", (Object)uniqueIntentions);
        return obj;
    }

    List<ReportSceneDTO> querySceneByAppAndTag(List<String> appCodes, String viewType, String tenantVersion) throws Exception {
        if (CollectionUtils.isEmpty(appCodes)) {
            return null;
        }
        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.version = $version and n.viewType = $viewType and n.status = '1'  RETURN n";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appCode", appCodes);
        param.put("viewType", viewType);
        param.put("version", tenantVersion);
        List<ReportSceneDTO> dataList = this.querySceneData(query, param);
        if (CollectionUtils.isEmpty(dataList)) {
            return dataList;
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)this.getTranslateContent(dataList)), ReportSceneDTO.class);
    }

    List<ReportSceneDTOs> querySceneByAppAndTags(List<String> appCodes, String viewType, String tenantVersion) throws Exception {
        if (CollectionUtils.isEmpty(appCodes)) {
            return null;
        }
        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.version = $version and n.viewType = $viewType and n.status = '1'  RETURN n";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appCode", appCodes);
        param.put("viewType", viewType);
        param.put("version", tenantVersion);
        List<ReportSceneDTOs> dataList = this.querySceneDatas(query, param);
        if (CollectionUtils.isEmpty(dataList)) {
            return dataList;
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)this.getTranslateContent(dataList)), ReportSceneDTOs.class);
    }

    List<ReportSceneDTO> querySceneByCodeAndTag(List<String> code, String tenantVersion) throws Exception {
        if (CollectionUtils.isEmpty(code)) {
            return null;
        }
        String query = "MATCH (n:ReportScene) WHERE n.code in $code and n.version = $version and n.viewType = 'screen' and n.status = '1'  RETURN n";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("code", code);
        param.put("version", tenantVersion);
        List<ReportSceneDTO> dataList = this.querySceneData(query, param);
        if (CollectionUtils.isEmpty(dataList)) {
            return dataList;
        }
        return JSON.parseArray((String)JSON.toJSONString((Object)this.getTranslateContent(dataList)), ReportSceneDTO.class);
    }

    @Override
    public Object postQuerySceneByTenantId(String tenantId) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List<String> authorizationsAppCodes = this.cacService.getAuthorizationsApplication(tenantId);
        String query = "MATCH (n:ReportScene) WHERE n.appCode in $appCode and n.version = $version and n.status = '1'  RETURN n.code as code";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appCode", authorizationsAppCodes);
        param.put("version", tenantVersion);
        Session session = this.neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable iterableResult = (Iterable)result.queryResults();
        return StreamSupport.stream(iterableResult.spliterator(), false).map(map -> map.get("code")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    @Override
    public Object postQueryApplicationByCode(String code) throws Exception {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        UserScreenConfig userScreen = this.screenService.postQueryUserScreen(code);
        ArrayList<String> appCodes = new ArrayList<String>();
        if (ObjectUtils.isEmpty((Object)userScreen)) {
            ReportSceneDTO reportScene = this.querySceneMaps(Collections.singletonList(code), tenantVersion);
            if (!ObjectUtils.isEmpty((Object)reportScene)) {
                appCodes.add(reportScene.getAppCode());
            }
        } else {
            List<Map> sectorList = this.sectorService.getSectorByCode(Arrays.asList(userScreen.getBkCode().split(",")), tenantVersion);
            appCodes.addAll(sectorList.stream().map(map -> map.get("appCode")).filter(Objects::nonNull).map(Object::toString).distinct().collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyList();
        }
        return this.appService.getApplicationsByCodes(appCodes);
    }

    @Override
    public Object postQueryDataSetsByApp(String appCode) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List<String> permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList<String>(), Collections.singletonList(appCode));
        if (CollectionUtils.isEmpty(permissionCodes)) {
            return Collections.emptyList();
        }
        List dataSetList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(permissionCodes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if (CollectionUtils.isEmpty((Collection)dataSetList)) {
            return Collections.emptyList();
        }
        LanguageUtil.processLocaleLanguage(dataSetList, DWResourceBundleUtils.getCurrentLocale().toString());
        return dataSetList;
    }
}

