/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfigDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.service.IScreenService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import com.digiwin.athena.knowledgegraph.service.impl.SectorService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Lang
@Service
@MyExceptionHandler
public class ScreenService
implements IScreenService {
    private static final Logger log = LoggerFactory.getLogger(ScreenService.class);
    @Autowired
    private IamService iamService;
    @Autowired
    CACUtils cacUtils;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    SceneService sceneService;
    @Autowired
    TenantService tenantService;
    @Autowired
    SectorService sectorService;
    public static final String FAIL_MSG = "fail";
    public static final String SUCCESS_MSG = "success";

    @Override
    public List<String> getUserPermissionScreen(List<String> type) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        List<Application> applications = this.tenantService.getUserMetricApplication();
        List<String> appCodes = applications.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        Map<String, Object> userPermission = this.iamService.batchQueryUserAppPermission(appCodes, userId);
        return this.resolvePermission(userPermission, type);
    }

    @Override
    public List<String> getUserPermissionScreen(String userId, List<String> type, List<String> appCodes) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        Map<String, Object> userPermission = this.iamService.batchQueryUserAppPermission(appCodes, userId);
        return this.resolvePermission(userPermission, type);
    }

    @Override
    public List<ReportSceneDTO> postQuerySceneByApp(List<String> appCodes) throws Exception {
        ArrayList<ReportSceneDTO> reportScenes = new ArrayList<ReportSceneDTO>();
        if (CollectionUtils.isEmpty(appCodes)) {
            return reportScenes;
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        return this.sceneService.querySceneByAppAndTag(appCodes, "screen", tenantVersion);
    }

    private List<String> resolvePermission(Map<String, Object> userPermission, List<String> type) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Object> permission : userPermission.entrySet()) {
            JSONObject responseJson = JSONObject.parseObject((String)JSON.toJSONString((Object)permission.getValue()));
            String code = responseJson.getString("code");
            if (!"200".equals(code)) continue;
            JSONArray permissions = responseJson.getJSONArray("data");
            for (int i = 0; i < permissions.size(); ++i) {
                JSONObject permissionJson = permissions.getJSONObject(i);
                String effect = permissionJson.getString("effect");
                String moduleId = permissionJson.getString("moduleId");
                String id = permissionJson.getString("id");
                if (!Objects.equals("allow", effect) || !StringUtils.isNotEmpty((CharSequence)id)) continue;
                result.add(id);
            }
        }
        return result;
    }

    @Override
    public Object postAddUserScreen(UserScreenConfigDTO config) throws Exception {
        List bkInfo;
        if (ObjectUtils.isEmpty((Object)config)) {
            return FAIL_MSG;
        }
        String userId = AthenaUtils.getUserId();
        Query queryExists = Query.query((CriteriaDefinition)Criteria.where((String)"name").is((Object)config.getName()).and("userId").is((Object)userId).and("code").ne((Object)config.getCode()));
        boolean result = this.mongoTemplateUser.exists(queryExists, UserScreenConfig.class);
        if (result) {
            String currentLocale = AthenaUtils.getCurrentLocale();
            if (Objects.equals("zh_TW", currentLocale)) {
                throw new DWBusinessException("P.KG.500.99999", "\u770b\u677f\u540d\u7a31\u5df2\u5b58\u5728");
            }
            throw new DWBusinessException("P.KG.500.99999", "\u770b\u677f\u540d\u79f0\u5df2\u5b58\u5728");
        }
        Date now = null;
        if (StringUtils.isEmpty((CharSequence)config.getCode())) {
            now = new Date();
            config.setCode("userScreen_" + UUID.randomUUID().toString().replace("-", ""));
        }
        if (CollectionUtils.isEmpty((Collection)(bkInfo = config.getBkInfo()))) {
            return FAIL_MSG;
        }
        String actionIds = bkInfo.stream().map(UserScreenConfigDTO.BkInfo::getActionId).distinct().collect(Collectors.joining(","));
        String bkCodes = bkInfo.stream().map(UserScreenConfigDTO.BkInfo::getBkCode).distinct().collect(Collectors.joining(","));
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)config.getCode()).and("userId").is((Object)userId));
        Update update = new Update().set("code", (Object)config.getCode()).set("name", (Object)config.getName()).set("actionId", (Object)actionIds).set("bkCode", (Object)bkCodes).set("layoutId", (Object)config.getLayoutId()).set("tenantId", (Object)config.getTenantId()).set("bkInfo", (Object)bkInfo).set("userId", (Object)userId);
        if (!ObjectUtils.isEmpty((Object)now)) {
            update.set("createDate", (Object)new Date());
        }
        this.mongoTemplateUser.bulkOps(BulkOperations.BulkMode.UNORDERED, UserScreenConfig.class).upsert(query, update).execute();
        return SUCCESS_MSG;
    }

    @Override
    public Object postDeleteUserScreen(List<String> codes) throws Exception {
        if (CollectionUtils.isEmpty(codes)) {
            return FAIL_MSG;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(codes).and("userId").is((Object)AthenaUtils.getUserId()));
        this.mongoTemplateUser.remove(query, UserScreenConfig.class);
        return SUCCESS_MSG;
    }

    @Override
    public UserScreenConfig postQueryUserScreen(String code) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code).and("userId").is((Object)AthenaUtils.getUserId()));
        return (UserScreenConfig)this.mongoTemplateUser.findOne(query, UserScreenConfig.class);
    }

    @Override
    public Object postQueryUserScreenByCode(String code) throws Exception {
        UserScreenConfig userScreen = this.postQueryUserScreen(code);
        if (ObjectUtils.isEmpty((Object)userScreen)) {
            return null;
        }
        return this.sectorService.getReportSceneByBkCode(AthenaUtils.getTenantId(), userScreen);
    }
}

