/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfigDTO;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.service.ISectorService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.SceneService;
import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class SectorService
implements ISectorService {
    private static final Logger log = LoggerFactory.getLogger(SectorService.class);
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    CACUtils cacUtils;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    SceneService sceneService;

    @Override
    public Object getUserSectors() throws Exception {
        String userId = AthenaUtils.getUserId();
        List<String> appCodes = this.cacUtils.getAppAuth(userId);
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyList();
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        Criteria criteria = Criteria.where((String)"version").is((Object)tenantVersion).and("appCode").in(appCodes);
        Query query = new Query((CriteriaDefinition)criteria);
        List userSectorList = this.mongoTemplate.find(query, Map.class, "agiledata_section_config");
        if (CollectionUtils.isEmpty((Collection)userSectorList)) {
            return Collections.emptyList();
        }
        return this.sceneService.getTranslateContent(userSectorList);
    }

    public List<Map> getSectorByCode(List<String> bkCodes, String tenantVersion) {
        Criteria criteria = Criteria.where((String)"version").is((Object)tenantVersion).and("bkCode").in(bkCodes);
        Query query = new Query((CriteriaDefinition)criteria);
        List userSectorList = this.mongoTemplate.find(query, Map.class, "agiledata_section_config");
        if (CollectionUtils.isEmpty((Collection)userSectorList)) {
            return Collections.emptyList();
        }
        return userSectorList;
    }

    public ReportSceneDTO getReportSceneByBkCode(String tenantId, UserScreenConfig userScreen) {
        String tenantVersion;
        List<String> bkCodes = Arrays.asList(userScreen.getBkCode().split(","));
        List<Map> userSectorList = this.getSectorByCode(bkCodes, tenantVersion = this.kgInnerService.currentTenantVersion());
        if (CollectionUtils.isEmpty(userSectorList)) {
            return null;
        }
        ArrayList showList = new ArrayList();
        ArrayList showTypeList = new ArrayList();
        for (Map o : userSectorList) {
            Map jsonObject = o;
            if (Objects.nonNull(jsonObject.get("show"))) {
                showList.addAll((Collection)jsonObject.get("show"));
            }
            if (!Objects.nonNull(jsonObject.get("showType"))) continue;
            showTypeList.addAll((Collection)jsonObject.get("showType"));
        }
        List recastList = userSectorList.stream().map(map -> map.get("recast")).filter(Objects::nonNull).collect(Collectors.toList());
        HashMap<String, List> result = new HashMap<String, List>();
        for (Object o : recastList) {
            Map jsonObject = (Map)o;
            for (String key : jsonObject.keySet()) {
                result.put(key, (List)jsonObject.get(key));
            }
        }
        List appCodes = userSectorList.stream().map(map -> map.get("appCode")).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
        List bkInfo = userScreen.getBkInfo();
        Map<String, String> userSectorMap = userSectorList.stream().collect(Collectors.toMap(map -> (String)map.get("bkCode"), map -> (String)map.get("actionId")));
        Map bkCodeToActionIdMap = bkInfo.stream().map(map -> (UserScreenConfigDTO.BkInfo)JSONObject.parseObject((String)JSON.toJSONString((Object)map), UserScreenConfigDTO.BkInfo.class)).collect(Collectors.toMap(UserScreenConfigDTO.BkInfo::getBkCode, map -> {
            String bkCode = map.getBkCode();
            return userSectorMap.getOrDefault(bkCode, bkCode);
        }, (existing, replacement) -> existing, LinkedHashMap::new));
        String actionIds = bkCodeToActionIdMap.values().stream().map(Object::toString).collect(Collectors.joining(","));
        ReportSceneDTO reportScene = new ReportSceneDTO();
        BigScreenViewConfig appBigScreenViewConfigs = (BigScreenViewConfig)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"appCode").in(appCodes).and("tenantId").is((Object)tenantId).and("type").is((Object)"custom")), BigScreenViewConfig.class);
        if (Objects.nonNull(appBigScreenViewConfigs)) {
            reportScene.setFlashFrequency(Optional.ofNullable(appBigScreenViewConfigs.getFlashFrequency()).orElse(5));
            reportScene.setPageTurningFrequency(Optional.ofNullable(appBigScreenViewConfigs.getPageTurningFrequency()).orElse(30));
        }
        reportScene.setCode(userScreen.getCode());
        reportScene.setSceneTitle(userScreen.getName());
        reportScene.setActionId(actionIds);
        reportScene.setShowType((Object)(CollectionUtils.isEmpty(showTypeList) ? new ArrayList() : showTypeList));
        reportScene.setShow((Object)(CollectionUtils.isEmpty(showList) ? new ArrayList() : showList));
        reportScene.setViewType("userScreen");
        reportScene.setLayoutId(userScreen.getLayoutId());
        reportScene.setBkInfo(bkInfo);
        reportScene.setRecast(result);
        return reportScene;
    }
}

