/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.service.ISetService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.set.PartParserService;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.TaskCardPart;
import com.mongodb.client.model.Filters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Lang
@Service
@MyExceptionHandler
public class SetService
implements ISetService {
    private static final Logger log = LoggerFactory.getLogger(SetService.class);
    @Autowired
    private PartParserService partParserService;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    private KgHelpService kgHelpService;
    public static Map<String, List<String>> mongoTables = new HashMap<String, List<String>>();
    public static List<String> neo4jTables;

    @Override
    public Object postCompileAndSaveSets(List<Sets> setsList) throws DWBusinessException {
        log.info("postCompileAndSaveSets:{}", (Object)JSON.toJSONString(setsList));
        if (!CollectionUtils.isEmpty(setsList)) {
            for (Sets sets : setsList) {
                String operate = sets.getOperate();
                SetParseContext context = new SetParseContext(sets);
                this.preProcess(context, sets);
                this.postDeleteSets(sets.getCode(), sets.getVersion());
                this.partParserService.parsePart(context, (Part)sets.getS().getPart());
                this.partParserService.parsePart(context, (Part)sets.getU().getPart());
                this.partParserService.parsePart(context, (Part)sets.getA().getPart());
            }
        }
        return "success";
    }

    private void preProcess(SetParseContext context, Sets sets) {
        Query partQuery = Query.query((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)sets.getCode()).and("type").is((Object)"smartAdjustProject"));
        TaskCardPart oldAPart = (TaskCardPart)this.mongoTemplateSystem.findOne(partQuery, TaskCardPart.class, "parts");
        if (oldAPart != null) {
            context.setEnableEmailNotice(oldAPart.getEnableEmailNotice());
            context.setEmailNotices(oldAPart.getEmailNotices());
        }
    }

    @Override
    public Object postDeleteSets(String code, String version) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return "ok";
        }
        mongoTables.forEach((db, tables) -> tables.forEach(table -> {
            if (StringUtils.isEmpty((CharSequence)version)) {
                this.mongoTemplateSystem.getMongoDbFactory().getDb(db).getCollection(table).deleteMany(Filters.eq((String)"pluginId", (Object)code));
            } else {
                this.mongoTemplateSystem.getMongoDbFactory().getDb(db).getCollection(table).deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"pluginId", (Object)code), Filters.eq((String)"version", (Object)version)}));
            }
        }));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("pluginId", code);
        param.put("version", version);
        neo4jTables.forEach(table -> {
            String cypher = StringUtils.isEmpty((CharSequence)version) ? "match(t:" + table + ") where t.pluginId = $pluginId detach delete t" : "match(t:" + table + ") where t.pluginId = $pluginId and t.version = $version detach delete t";
            this.kgHelpService.executeCyhper(cypher, param);
        });
        return "ok";
    }

    static {
        mongoTables.put("knowledgegraphSystem", Arrays.asList("applicationRelation", "monitorRuleProductConfig", "parts", "parts", "variableDefinition"));
        mongoTables.put("datamap", Arrays.asList("activity", "task", "project", "pageView", "flowGraph", "dataDescription", "dataState"));
        mongoTables.put("tagSystem", Arrays.asList("taggingData"));
        mongoTables.put("preset", Arrays.asList("rules"));
        neo4jTables = Arrays.asList("MonitorRule", "Action", "DataEntity", "DataField", "Tag", "RelatedObject");
    }
}

