/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.service.ISqlIndexAdvanceService;
import com.digiwin.athena.knowledgegraph.utils.FieldMergerUtils;
import com.digiwin.athena.knowledgegraph.utils.SQLIndexSuggestionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Lang
@Service
public class SqlIndexAdvanceService
implements ISqlIndexAdvanceService {
    private static final Logger log = LoggerFactory.getLogger(SqlIndexAdvanceService.class);

    @Override
    public Object postSqlIndex(String sql) {
        List<String> sqlList = Arrays.asList(sql.split(";"));
        HashSet<String> resultSet = new HashSet<String>();
        if (CollectionUtils.isEmpty(sqlList)) {
            return resultSet;
        }
        for (String sqlStr : sqlList) {
            try {
                Select select = (Select)CCJSqlParserUtil.parse((String)sqlStr);
                HashMap<String, String> tableAliasMap = new HashMap<String, String>();
                HashSet<String> joinColumnsSet = new HashSet<String>();
                SQLIndexSuggestionUtils.extractTablesWithAlias(select.getSelectBody(), tableAliasMap, joinColumnsSet);
                TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
                List tablesList = tablesNamesFinder.getTableList((Statement)select);
                ArrayList<String> joinColumnsList = new ArrayList<String>(joinColumnsSet);
                Collections.sort(joinColumnsList);
                List<String> data = SQLIndexSuggestionUtils.getOptimizationSuggestions(tablesList, tableAliasMap, joinColumnsList);
                resultSet.addAll(FieldMergerUtils.mergeFields(data));
            }
            catch (JSQLParserException e) {
                log.error("The Sql is error : {}", (Throwable)e);
            }
        }
        return resultSet;
    }
}

