/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.IndicatorNode;
import com.digiwin.athena.knowledgegraph.domain.targets.SystemIndicatorForestDto;
import com.digiwin.athena.knowledgegraph.domain.targets.SystemIndicatorTreeNodeRelation;
import com.digiwin.athena.knowledgegraph.service.ISystemTargetService;
import com.digiwin.athena.repository.neo4j.IndicatorRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Lang
@Service
public class SystemTargetService
implements ISystemTargetService {
    private static final Logger log = LoggerFactory.getLogger(SystemTargetService.class);
    @Autowired
    IndicatorRepository indicatorRepository;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactory1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactory2;

    @Override
    public Object deleteIndicatorForest() throws DWBusinessException {
        if (null != this.sessionFactory1) {
            this.sessionFactory1.openSession().deleteAll(IndicatorNode.class);
        }
        if (null != this.sessionFactory2) {
            this.sessionFactory2.openSession().deleteAll(IndicatorNode.class);
        }
        return null;
    }

    @Override
    public Object getIndicatorForest() throws DWBusinessException {
        List<IndicatorNode> roots = this.indicatorRepository.findRootIndicatorNodes();
        if (CollectionUtils.isEmpty(roots)) {
            return Collections.EMPTY_LIST;
        }
        List<String> rootIndicatorIds = roots.stream().map(IndicatorNode::getIndicatorId).collect(Collectors.toList());
        List<IndicatorNode> indicatorNodes = this.indicatorRepository.findAllByIndicatorIdIn(rootIndicatorIds);
        ArrayList<SystemIndicatorTreeNodeRelation> indicatorRelations = new ArrayList<SystemIndicatorTreeNodeRelation>();
        indicatorNodes.forEach(item -> {
            SystemIndicatorTreeNodeRelation nodeRelation = this.buildRelationByNodes(null, (IndicatorNode)item);
            if (!indicatorRelations.contains(nodeRelation)) {
                indicatorRelations.add(nodeRelation);
            }
            if (!CollectionUtils.isEmpty(item.getConsistsOf())) {
                this.traverseRecursively((IndicatorNode)item, (List<SystemIndicatorTreeNodeRelation>)indicatorRelations);
            }
        });
        SystemIndicatorForestDto systemIndicatorForestDto = new SystemIndicatorForestDto();
        systemIndicatorForestDto.setIndicatorRelations(indicatorRelations);
        return systemIndicatorForestDto;
    }

    private List<IndicatorNode> findForest() {
        List<IndicatorNode> roots = this.indicatorRepository.findRootIndicatorNodes();
        if (CollectionUtils.isEmpty(roots)) {
            return Collections.EMPTY_LIST;
        }
        List<String> rootIndicatorIds = roots.stream().map(IndicatorNode::getIndicatorId).collect(Collectors.toList());
        List<IndicatorNode> indicatorNodes = this.indicatorRepository.findAllByIndicatorIdIn(rootIndicatorIds);
        return indicatorNodes;
    }

    private void traverseRecursively(IndicatorNode parent, List<SystemIndicatorTreeNodeRelation> indicatorRelations) {
        if (!CollectionUtils.isEmpty(parent.getConsistsOf())) {
            parent.getConsistsOf().forEach(item -> {
                SystemIndicatorTreeNodeRelation nodeRelation = this.buildRelationByNodes(parent, (IndicatorNode)item);
                if (!indicatorRelations.contains(nodeRelation)) {
                    indicatorRelations.add(nodeRelation);
                }
                this.traverseRecursively((IndicatorNode)item, indicatorRelations);
            });
        }
    }

    private SystemIndicatorTreeNodeRelation buildRelationByNodes(IndicatorNode parent, IndicatorNode child) {
        SystemIndicatorTreeNodeRelation nodeRelation = new SystemIndicatorTreeNodeRelation();
        if (null == child) {
            throw new IllegalArgumentException("child cannot be null");
        }
        nodeRelation.setIndicatorId(child.getIndicatorId());
        nodeRelation.setGroup(child.getGroup());
        nodeRelation.setFeatureSelection(child.getFeatureSelection());
        nodeRelation.setName(child.getName());
        nodeRelation.setTendency(child.getTendency());
        nodeRelation.setUnit(child.getUnit());
        nodeRelation.setParentId(null == parent ? null : parent.getIndicatorId());
        return nodeRelation;
    }

    @Override
    public Object postIndicatorForest(@Valid SystemIndicatorForestDto systemIndicatorForest) throws DWBusinessException {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)systemIndicatorForest, new Class[0]);
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (ConstraintViolation violation : violations) {
            errorMessages.add(violation.getPropertyPath() + violation.getMessage() + ";");
        }
        if (!CollectionUtils.isEmpty(errorMessages)) {
            throw new DWBusinessException(((Object)errorMessages).toString());
        }
        List<SystemIndicatorTreeNodeRelation> indicatorRelations = systemIndicatorForest.getIndicatorRelations();
        List<IndicatorNode> forestInNeo4j = this.findForest();
        List<IndicatorNode> forest = this.buildForestByRelations(forestInNeo4j, indicatorRelations);
        if (!CollectionUtils.isEmpty(forest)) {
            forest.forEach(indicatorNode -> {
                if (null != this.sessionFactory1) {
                    this.sessionFactory1.openSession().save(indicatorNode);
                }
                if (null != this.sessionFactory2) {
                    this.sessionFactory2.openSession().save(indicatorNode);
                }
            });
        }
        return null;
    }

    private List<IndicatorNode> buildForestByRelations(List<IndicatorNode> forestInNeo4j, List<SystemIndicatorTreeNodeRelation> indicatorRelations) {
        Map<String, IndicatorNode> indicatorMap = this.buildMapByForest(forestInNeo4j);
        if (!CollectionUtils.isEmpty(indicatorRelations)) {
            indicatorRelations.forEach(item -> {
                if (!indicatorMap.keySet().contains(item.getIndicatorId())) {
                    IndicatorNode indicatorNode = new IndicatorNode();
                    indicatorNode.setIndicatorId(item.getIndicatorId());
                    indicatorNode.setName(item.getName());
                    indicatorNode.setGroup(item.getGroup());
                    indicatorNode.setTendency(item.getTendency());
                    indicatorNode.setUnit(item.getUnit());
                    indicatorNode.setFeatureSelection(item.getFeatureSelection());
                    indicatorMap.put(item.getIndicatorId(), indicatorNode);
                } else {
                    IndicatorNode indicatorNode = (IndicatorNode)indicatorMap.get(item.getIndicatorId());
                    indicatorNode.setName(item.getName());
                    indicatorNode.setGroup(item.getGroup());
                    indicatorNode.setTendency(item.getTendency());
                    indicatorNode.setUnit(item.getUnit());
                    indicatorNode.setFeatureSelection(item.getFeatureSelection());
                }
            });
            LinkedList<IndicatorNode> rootIndicatorNodes = new LinkedList<IndicatorNode>();
            rootIndicatorNodes.addAll(forestInNeo4j);
            indicatorRelations.forEach(item -> {
                if (!StringUtils.isEmpty((CharSequence)item.getParentId())) {
                    if (indicatorMap.keySet().contains(item.getParentId())) {
                        ((IndicatorNode)indicatorMap.get(item.getParentId())).addRelation((IndicatorNode)indicatorMap.get(item.getIndicatorId()));
                    }
                } else {
                    rootIndicatorNodes.add((IndicatorNode)indicatorMap.get(item.getIndicatorId()));
                }
            });
            return rootIndicatorNodes;
        }
        return Collections.EMPTY_LIST;
    }

    private Map<String, IndicatorNode> buildMapByForest(List<IndicatorNode> forestInNeo4j) {
        HashMap<String, IndicatorNode> indicatorNodeMap = new HashMap<String, IndicatorNode>();
        if (CollectionUtils.isEmpty(forestInNeo4j)) {
            return indicatorNodeMap;
        }
        forestInNeo4j.forEach(item -> {
            indicatorNodeMap.put(item.getIndicatorId(), (IndicatorNode)item);
            if (!CollectionUtils.isEmpty(item.getConsistsOf())) {
                this.traverseAndPutMap((IndicatorNode)item, (Map<String, IndicatorNode>)indicatorNodeMap);
            }
        });
        return indicatorNodeMap;
    }

    private void traverseAndPutMap(IndicatorNode parent, Map<String, IndicatorNode> indicatorNodeMap) {
        parent.getConsistsOf().forEach(child -> {
            indicatorNodeMap.put(child.getIndicatorId(), (IndicatorNode)child);
            if (!CollectionUtils.isEmpty(child.getConsistsOf())) {
                this.traverseAndPutMap((IndicatorNode)child, indicatorNodeMap);
            }
        });
    }
}

