/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.MockData;
import com.digiwin.athena.knowledgegraph.service.ITestService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.repository.neo4j.Activity2Repository;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Lang
@Service
public class TestService
implements ITestService {
    private static final Logger log = LoggerFactory.getLogger(TestService.class);
    private static Logger logger = LoggerFactory.getLogger(TestService.class);
    ThreadLocal<String> local;
    @Value(value="${hello1}")
    private String hello1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain1")
    SessionFactory sessionFactoryDomain1;
    @Autowired(required=false)
    @Qualifier(value="sessionFactoryForDomain2")
    SessionFactory sessionFactoryDomain2;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    Activity2Repository activity2Repository;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;

    public TestService() {
        System.out.println("TestService..........");
        this.local = new ThreadLocal();
    }

    @Override
    public String getTest01(String input) {
        System.out.println("test01..............." + this.hello1);
        Integer.parseInt("s");
        return "hello " + this.hello1;
    }

    @Override
    public String getTest02(final String input, String paas) {
        System.out.println("test02..............." + this.hello1);
        if (!"zhangtuo0813".equals(paas)) {
            return "error";
        }
        new Thread(){

            @Override
            public void run() {
                TestService.this.cleanData(input, TestService.this.sessionFactoryDomain1);
            }
        }.start();
        long count = this.cleanData(input, this.sessionFactoryDomain2);
        return count + "";
    }

    private long cleanData(String version, SessionFactory sessionFactory) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        String cypher = "match (te:TenantEntity{version:$version})-[r:ACTION]->(action:EspAction{version:$version,nameSpace:'espCommon'}) where te.ifCommon is null and action.inclusionTenant is null and action.notInclusionTenant is null with r limit 100000 delete r return count(r) as count";
        AtomicLong count = new AtomicLong(0L);
        AtomicLong total = new AtomicLong(0L);
        Session session = sessionFactory.openSession();
        do {
            Result result = session.query(cypher, param);
            ((Iterable)result.queryResults()).forEach(map -> {
                Object c = map.get("count");
                count.set((Long)c);
                total.addAndGet((Long)c);
            });
            System.out.println(Thread.currentThread().getName() + " delete " + count.get());
        } while (count.get() > 0L);
        System.out.println(Thread.currentThread().getName() + " total " + total.get());
        return total.get();
    }

    @Override
    public String getTest03(String input) throws DWBusinessException {
        System.out.println("test03..............." + input);
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        return tenantId + ":" + tenantVersion;
    }

    @Override
    public String getTest04(String input) {
        System.out.println("test04..............." + input);
        return input;
    }

    @Override
    public String postTest05(String input) {
        this.sessionFactoryDomain1.openSession().query(input, new HashMap());
        this.sessionFactoryDomain2.openSession().query(input, new HashMap());
        return null;
    }

    @Override
    public Object getMock01(String key) {
        String template = "[]";
        switch (key) {
            case "process": {
                template = "[{\"proNo\": \"pro01\",\"proName\": \"\u5236\u7a0b1\"},{\"proNo\": \"pro02\",\"proName\": \"\u5236\u7a0b2\"},{\"proNo\": \"pro03\",\"proName\": \"\u5236\u7a0b3\"}]";
                break;
            }
            case "material": {
                template = "[{\"mateNo\": \"mate01\",\"mateName\": \"\u7269\u65991\"},{\"mateNo\": \"mate02\",\"mateName\": \"\u7269\u65992\"},{\"mateNo\": \"mate03\",\"mateName\": \"\u7269\u65993\"}]";
            }
        }
        Object obj = JSON.parse((String)template);
        return obj;
    }

    @Override
    public String getBigRedisKeyValue(String pattern) {
        try {
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            Set keys = this.redisTemplate.keys((Object)pattern);
            if (keys == null || keys.isEmpty()) {
                return "km\u76f8\u5173key\u4e3a\u7a7a";
            }
            result.put("getBigRedisKeyValueScan\u89e3\u6790km\u76f8\u5173key\u6570\u91cf", Integer.valueOf(keys.size()));
            logger.info("getBigRedisKeyValueScan\u89e3\u6790km\u76f8\u5173keys\uff1a{}\uff0c\u6570\u91cf\uff1a{}", (Object)JsonUtil.toJsonString(keys), (Object)keys.size());
            HashMap<String, Integer> stringKeyValueMap = new HashMap<String, Integer>();
            HashMap<String, Integer> stringKeyValueBigMap = new HashMap<String, Integer>();
            HashSet<String> errorKeys = new HashSet<String>();
            for (String key : keys) {
                try {
                    String value = (String)this.redisTemplate.opsForValue().get((Object)key);
                    int valueSize = String.valueOf(value).getBytes().length;
                    stringKeyValueMap.put(key, valueSize);
                    int valueSizeKB = String.valueOf(value).getBytes().length / 1024;
                    if (valueSizeKB <= 10) continue;
                    stringKeyValueBigMap.put(key, valueSizeKB);
                }
                catch (RedisConnectionFailureException e) {
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan\u89e3\u6790Redis\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
                catch (Exception e) {
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan\u89e3\u6790Redis\u7684value\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
            result.put("stringKeyValueMap", stringKeyValueMap);
            result.put("stringKeyValueBigMap", stringKeyValueBigMap);
            result.put("errorKeys", errorKeys);
            logger.info("getBigRedisKeyValueScan\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJsonString(result));
            return JsonUtil.toJsonString(result);
        }
        catch (Exception e) {
            logger.error("getBigRedisKeyValueScan\u83b7\u53d6Redis Key\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return "getBigRedisKeyValueScan\u83b7\u53d6Redis Key\u53d1\u751f\u5f02\u5e38";
        }
    }

    @Override
    public String getBigRedisKeyValueScan(String pattern) {
        try {
            HashMap<String, Serializable> result = new HashMap<String, Serializable>();
            ScanOptions options = ScanOptions.scanOptions().match(pattern).build();
            HashSet keys = new HashSet();
            this.redisTemplate.execute(connection -> {
                try (Cursor cursor = connection.scan(options);){
                    while (cursor.hasNext()) {
                        String key = new String((byte[])cursor.next(), StandardCharsets.UTF_8);
                        DataType type = connection.type(key.getBytes());
                        if (type != DataType.STRING) continue;
                        keys.add(key);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return keys;
            });
            if (keys.isEmpty()) {
                return "km\u76f8\u5173key\u4e3a\u7a7a";
            }
            result.put("getBigRedisKeyValueScan\u89e3\u6790km\u76f8\u5173key\u7c7b\u578b\u4e3aString\u7684\u6570\u91cf", Integer.valueOf(keys.size()));
            logger.info("getBigRedisKeyValueScan\u89e3\u6790km\u76f8\u5173\u7c7b\u578b\u4e3aString\u7684keys\uff1a{}\uff0c\u6570\u91cf\uff1a{}", (Object)JsonUtil.toJsonString(keys), (Object)keys.size());
            HashMap<String, Integer> stringKeyValueMap = new HashMap<String, Integer>();
            HashMap<String, Integer> stringKeyValueBigMap = new HashMap<String, Integer>();
            HashSet<String> errorKeys = new HashSet<String>();
            for (String key : keys) {
                try {
                    String value = (String)this.redisTemplate.opsForValue().get((Object)key);
                    int valueSize = String.valueOf(value).getBytes().length;
                    stringKeyValueMap.put(key, valueSize);
                    int valueSizeKB = String.valueOf(value).getBytes().length / 1024;
                    if (valueSizeKB <= 10) continue;
                    stringKeyValueBigMap.put(key, valueSizeKB);
                }
                catch (RedisConnectionFailureException e) {
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan\u89e3\u6790Redis\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                }
                catch (Exception e) {
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan\u89e3\u6790Redis\u7684value\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
            result.put("stringKeyValueMap", stringKeyValueMap);
            result.put("stringKeyValueBigMap", stringKeyValueBigMap);
            result.put("errorKeys", errorKeys);
            logger.info("getBigRedisKeyValueScan\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JsonUtil.toJsonString(result));
            return JsonUtil.toJsonString(result);
        }
        catch (Exception e) {
            logger.error("getBigRedisKeyValueScan\u83b7\u53d6Redis Key\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return "getBigRedisKeyValueScan\u83b7\u53d6Redis Key\u53d1\u751f\u5f02\u5e38";
        }
    }

    @Override
    public String getTest06(String content) throws DWBusinessException {
        return this.translateUtils.translateContent(content);
    }

    @Override
    public Object getMockMetaData(String type, String condition) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"type").is((Object)type);
        query.addCriteria((CriteriaDefinition)criteria);
        MockData mockData = (MockData)this.mongoTemplate.findOne(query, MockData.class);
        Object metaData = mockData.getMetaData();
        if (condition != null && !condition.isEmpty() && metaData instanceof Map && ((Map)metaData).get("meta_data_list") != null) {
            String[] conditions;
            List list = (List)((Map)metaData).get("meta_data_list");
            for (String c : conditions = condition.split(";")) {
                this.filter(list, c);
            }
        }
        return metaData;
    }

    private void filter(List<Map<String, Object>> metadataList, String condition) {
        String[] con = condition.split("=");
        if (con.length != 2) {
            return;
        }
        metadataList.removeIf(metadata -> metadata.get(con[0]) == null || !metadata.get(con[0]).toString().equals(con[1]));
    }
}

