/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.constant.SystemWSConditionVO;
import com.digiwin.athena.knowledgegraph.domain.CardPresentConfig;
import com.digiwin.athena.knowledgegraph.domain.WorkbenchSetting;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroup;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupApplication;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupGroup;
import com.digiwin.athena.knowledgegraph.domain.task.CardGroupTask;
import com.digiwin.athena.knowledgegraph.domain.task.SystemGroup;
import com.digiwin.athena.knowledgegraph.enums.SourceType;
import com.digiwin.athena.knowledgegraph.enums.WSConfigType;
import com.digiwin.athena.knowledgegraph.enums.WSPageCode;
import com.digiwin.athena.knowledgegraph.po.DapResponse;
import com.digiwin.athena.knowledgegraph.service.ATMCService;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IWorkbenchSettingService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskFieldService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.ConditionScopeVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WSConditionVO;
import com.digiwin.athena.knowledgegraph.vo.workbenchSetting.WorkbenchSettingVO;
import com.digiwin.athena.knowledgegraph.workbenchSetting.CardPresentConfigReq;
import com.digiwin.athena.knowledgegraph.workbenchSetting.WorkbenchSettingSaveRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Lang
@Service
@MyExceptionHandler
public class WorkbenchSettingService
implements IWorkbenchSettingService {
    private static final Logger log = LoggerFactory.getLogger(WorkbenchSettingService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    TenantService tenantService;
    @Autowired
    private DataMapService dataMapService;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private TaskFieldService taskFieldService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private ATMCService atmcService;

    @Override
    public WorkbenchSettingVO getWorkbenchSetting(WSPageCode pageCode, WSConfigType configType, Boolean appCondition) {
        WorkbenchSettingVO workbenchSettingVO;
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        if (pageCode == WSPageCode.task && configType == WSConfigType.groups) {
            Map<String, String> aliasName;
            Map<String, Map<String, String>> lang;
            workbenchSettingVO = new WorkbenchSettingVO();
            workbenchSettingVO.setTenantId(tenantId);
            workbenchSettingVO.setPageCode(pageCode);
            workbenchSettingVO.setConfigType(configType);
            ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<WSConditionVO>();
            Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)criteria);
            CardGroup cardGroup = (CardGroup)this.mongoTemplateUser.findOne(query, CardGroup.class);
            if (null == cardGroup) {
                List<CardGroupGroup> cardGroupGroups = this.taskFieldService.sysCardGroups(tenantId);
                if (CollectionUtil.isNotEmpty(cardGroupGroups)) {
                    List<WSConditionVO> sysConditions = this.systemCardGroupGroupToCondition(cardGroupGroups);
                    wsConditionVOS.addAll(sysConditions);
                }
                if (Boolean.TRUE.equals(appCondition)) {
                    List<String> authApps;
                    String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
                    try {
                        authApps = this.tenantService.getAppCodes();
                    }
                    catch (DWBusinessException e) {
                        throw new RuntimeException(e);
                    }
                    List taskRelations = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"appCode").in(authApps).and("type").is((Object)"activity").and("version").is((Object)tenantVersion)), ApplicationRelation.class);
                    List taskCodes = taskRelations.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
                    HashMap taskRelationsMap = new HashMap();
                    taskRelations.forEach(applicationRelation -> taskRelationsMap.put(applicationRelation.getCode(), applicationRelation));
                    HashMap<String, Query> params = new HashMap<String, Query>();
                    params.put("query", query);
                    DapResponse resp = this.dataMapService.requestDataMap("/view/newCardConfig", "post", MapUtil.of((Object)"query", (Object)MapUtil.of((Object)"code", taskCodes)));
                    List appConditions = JSON.parseArray((String)JSON.toJSONString(resp.getResponse()), WSConditionVO.class);
                    if (CollectionUtil.isNotEmpty((Collection)appConditions)) {
                        Map<String, List<WSConditionVO>> conditionMap = appConditions.stream().collect(Collectors.groupingBy(v -> v.getAliasCode()));
                        String currentLocale = AthenaUtils.getCurrentLocale();
                        for (Map.Entry<String, List<WSConditionVO>> entry : conditionMap.entrySet()) {
                            List<WSConditionVO> conditionVOS = entry.getValue();
                            WSConditionVO wsConditionVO = conditionVOS.stream().sorted(Comparator.comparing(WSConditionVO::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).findFirst().get();
                            wsConditionVO.setAppCode(((ApplicationRelation)taskRelationsMap.get(wsConditionVO.getTaskCode())).getAppCode());
                            List<ConditionScopeVO> scopeVOList = conditionVOS.stream().flatMap(v -> v.getConditionScope().stream()).distinct().sorted(Comparator.comparing(ConditionScopeVO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeVO::getId, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
                            for (ConditionScopeVO conditionScopeVO : scopeVOList) {
                                ApplicationRelation applicationRelation2 = (ApplicationRelation)taskRelationsMap.get(conditionScopeVO.getCode());
                                if (applicationRelation2 == null) continue;
                                conditionScopeVO.setAppName(applicationRelation2.getAppName());
                                conditionScopeVO.setAppCode(applicationRelation2.getAppCode());
                            }
                            try {
                                LanguageUtil.processLocaleLanguage(scopeVOList, currentLocale);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                            catch (NoSuchFieldException e) {
                                throw new RuntimeException(e);
                            }
                            wsConditionVO.setConditionScope(scopeVOList);
                            wsConditionVOS.add(wsConditionVO);
                        }
                    }
                }
                List<WSConditionVO> defaultCondition = wsConditionVOS.stream().filter(v -> Boolean.TRUE.equals(v.getEnable())).map(v -> {
                    WSConditionVO wsConditionVO = (WSConditionVO)JSON.parseObject((String)JSON.toJSONString((Object)v), WSConditionVO.class);
                    if (wsConditionVO.getSourceType() == SourceType.customer) {
                        wsConditionVO.setEnable(false);
                    }
                    return wsConditionVO;
                }).collect(Collectors.toList());
                workbenchSettingVO.setCondition(wsConditionVOS);
                workbenchSettingVO.setDefaultCondition(defaultCondition);
            } else {
                workbenchSettingVO = this.cardGroupToWSConditionVO(cardGroup);
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getCondition()) {
                lang = wsConditionVO.getLang();
                if (lang == null || (aliasName = lang.get("aliasName")) != null) continue;
                wsConditionVO.setLang(MapUtil.of((Object)"aliasName", wsConditionVO.getLang().get("name")));
            }
            for (WSConditionVO wsConditionVO : workbenchSettingVO.getDefaultCondition()) {
                lang = wsConditionVO.getLang();
                if (lang == null || (aliasName = lang.get("aliasName")) != null) continue;
                wsConditionVO.setLang(MapUtil.of((Object)"aliasName", wsConditionVO.getLang().get("name")));
            }
            String currentLocale = AthenaUtils.getCurrentLocale();
            try {
                LanguageUtil.processLocaleLanguage(workbenchSettingVO.getCondition(), currentLocale);
                LanguageUtil.processLocaleLanguage(workbenchSettingVO.getDefaultCondition(), currentLocale);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("pageCode").is((Object)pageCode).and("configType").is((Object)configType);
        WorkbenchSetting workbenchSetting = (WorkbenchSetting)this.mongoTemplateUser.findOne(new Query((CriteriaDefinition)criteria), WorkbenchSetting.class);
        if (workbenchSetting == null) {
            workbenchSettingVO = this.getCardSetting(pageCode, configType, appCondition);
        } else {
            workbenchSettingVO = (WorkbenchSettingVO)JSON.parseObject((String)JSON.toJSONString((Object)workbenchSetting), WorkbenchSettingVO.class);
            this.addNewCondition(workbenchSettingVO.getCondition());
            this.addNewCondition(workbenchSettingVO.getDefaultCondition());
        }
        String currentLocale = AthenaUtils.getCurrentLocale();
        try {
            LanguageUtil.processLocaleLanguage(workbenchSettingVO.getCondition(), currentLocale);
            LanguageUtil.processLocaleLanguage(workbenchSettingVO.getDefaultCondition(), currentLocale);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        for (WSConditionVO wsConditionVO : workbenchSettingVO.getCondition()) {
            try {
                LanguageUtil.processLocaleLanguage(wsConditionVO.getConditionScope(), currentLocale);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return workbenchSettingVO;
    }

    private void addNewCondition(List<WSConditionVO> condition) {
        List aliasCodes;
        if (CollectionUtils.isNotEmpty(condition) && CollectionUtils.isNotEmpty(aliasCodes = condition.stream().map(WSConditionVO::getAliasCode).collect(Collectors.toList())) && !aliasCodes.contains("CREATE_TIME")) {
            WSConditionVO conditionVO = WSConditionVO.builder().sourceType(SourceType.system).aliasName("\u521b\u5efa\u65f6\u95f4").aliasCode("CREATE_TIME").dataType("datetime").enable(true).lang(MapUtil.builder((Object)"aliasName", (Object)MapUtil.builder((Object)"zh_TW", (Object)"\u5275\u5efa\u6642\u9593").put((Object)"en_US", (Object)"create time").put((Object)"zh_CN", (Object)"\u521b\u5efa\u65f6\u95f4").build()).build()).build();
            condition.add(conditionVO);
        }
    }

    public WorkbenchSettingVO cardGroupToWSConditionVO(CardGroup cardGroup) {
        List<WSConditionVO> defaultCondition;
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        String currentLocale = AthenaUtils.getCurrentLocale();
        WorkbenchSettingVO workbenchSettingVO = new WorkbenchSettingVO();
        workbenchSettingVO.setTenantId(tenantId);
        workbenchSettingVO.setPageCode(WSPageCode.task);
        workbenchSettingVO.setConfigType(WSConfigType.groups);
        ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<WSConditionVO>();
        if (!Boolean.FALSE.equals(cardGroup.getEnabled())) {
            List<CardGroupApplication> applications;
            List<CardGroupGroup> groups;
            SystemGroup system = cardGroup.getSystem();
            if (system != null && CollectionUtil.isNotEmpty(groups = system.getGroups())) {
                List<WSConditionVO> sysConditions = this.systemCardGroupGroupToCondition(groups);
                wsConditionVOS.addAll(sysConditions);
            }
            if (CollectionUtils.isNotEmpty(applications = cardGroup.getApplications())) {
                ArrayList<WSConditionVO> appConditionVOS = new ArrayList<WSConditionVO>();
                for (CardGroupApplication application : applications) {
                    List<CardGroupTask> tasks = application.getTasks();
                    if (!CollectionUtils.isNotEmpty(tasks)) continue;
                    for (CardGroupTask task : tasks) {
                        try {
                            LanguageUtil.processLocaleLanguage((Object)task, currentLocale);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (NoSuchFieldException e) {
                            throw new RuntimeException(e);
                        }
                        List<CardGroupGroup> groups1 = task.getGroups();
                        if (!CollectionUtils.isNotEmpty(groups1)) continue;
                        for (CardGroupGroup group : groups1) {
                            WSConditionVO wsConditionVO = (WSConditionVO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)group)), WSConditionVO.class);
                            wsConditionVO.setAppCode(application.getAppCode());
                            wsConditionVO.setTaskCode(task.getCode());
                            wsConditionVO.setBusinessMessageSourceMethod(task.getBusinessMessageSourceMethod());
                            wsConditionVO.setTaskName(task.getName());
                            wsConditionVO.setTaskLang(task.getLang());
                            wsConditionVO.setAliasCode(group.getCode());
                            wsConditionVO.setAliasName(group.getName());
                            wsConditionVO.setSourceType(SourceType.customer);
                            wsConditionVO.setDefaultEffective(group.isDefaultEffective());
                            Boolean defaultGroup = group.getDefaultGroup();
                            if (defaultGroup == null) {
                                defaultGroup = group.isDefaultEffective();
                            }
                            wsConditionVO.setDefaultGroup(defaultGroup);
                            wsConditionVO.setEnable(group.isEnabled());
                            wsConditionVO.setCommonEnable(group.getCommonEnable() != null ? group.getCommonEnable() : true);
                            ConditionScopeVO conditionScopeVO = new ConditionScopeVO();
                            conditionScopeVO.setAppCode(application.getAppCode());
                            conditionScopeVO.setName(task.getName());
                            conditionScopeVO.setAppName(application.getAppName());
                            conditionScopeVO.setCode(task.getCode());
                            conditionScopeVO.setCardGroupTask((ConditionScopeVO.CardGroupTask)JSON.parseObject((String)JSON.toJSONString((Object)((Object)task)), ConditionScopeVO.CardGroupTask.class));
                            conditionScopeVO.setId(task.getTaskId());
                            conditionScopeVO.setBusinessMessageSourceMethod(task.getBusinessMessageSourceMethod());
                            wsConditionVO.setConditionScope(Collections.singletonList(conditionScopeVO));
                            appConditionVOS.add(wsConditionVO);
                        }
                    }
                }
                Map conditionMap = appConditionVOS.stream().collect(Collectors.groupingBy(WSConditionVO::getAliasCode, LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
                for (Map.Entry entry : conditionMap.entrySet()) {
                    List conditionVOS = (List)entry.getValue();
                    WSConditionVO wsConditionDTO = (WSConditionVO)conditionVOS.get(0);
                    wsConditionDTO.setConditionScope(conditionVOS.stream().flatMap(v -> v.getConditionScope().stream()).distinct().sorted(Comparator.comparing(ConditionScopeVO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeVO::getId, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList()));
                    wsConditionVOS.add(wsConditionDTO);
                }
            }
        } else {
            List<CardGroupGroup> cardGroupGroups = this.taskFieldService.sysCardGroups(tenantId);
            if (CollectionUtil.isNotEmpty(cardGroupGroups)) {
                List<WSConditionVO> sysConditions = this.systemCardGroupGroupToCondition(cardGroupGroups);
                wsConditionVOS.addAll(sysConditions);
            }
        }
        if ((defaultCondition = wsConditionVOS.stream().filter(v -> Boolean.TRUE.equals(v.getEnable())).map(v -> {
            WSConditionVO wsConditionVO = (WSConditionVO)JSON.parseObject((String)JSON.toJSONString((Object)v), WSConditionVO.class);
            wsConditionVO.setEnable(v.getCommonEnable());
            return wsConditionVO;
        }).collect(Collectors.toList())).stream().anyMatch(v -> v.getSort() != null)) {
            defaultCondition = defaultCondition.stream().sorted(Comparator.comparing(v -> v.getSort(), Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        }
        workbenchSettingVO.setCondition(wsConditionVOS);
        workbenchSettingVO.setDefaultCondition(defaultCondition);
        return workbenchSettingVO;
    }

    private List<WSConditionVO> systemCardGroupGroupToCondition(List<CardGroupGroup> cardGroupGroups) {
        List<WSConditionVO> wsConditionVOS = cardGroupGroups.stream().map(v -> {
            WSConditionVO wsConditionVO = (WSConditionVO)JSON.parseObject((String)JSON.toJSONString((Object)v), WSConditionVO.class);
            wsConditionVO.setAliasName(v.getName());
            wsConditionVO.setAliasCode(v.getCode());
            wsConditionVO.setSourceType(SourceType.system);
            wsConditionVO.setDefaultEffective(v.isDefaultEffective());
            Boolean defaultGroup = v.getDefaultGroup();
            if (defaultGroup == null) {
                defaultGroup = v.isDefaultEffective();
            }
            wsConditionVO.setDefaultGroup(defaultGroup);
            wsConditionVO.setEnable(v.isEnabled());
            wsConditionVO.setCommonEnable(v.getCommonEnable() != null ? v.getCommonEnable() : true);
            return wsConditionVO;
        }).collect(Collectors.toList());
        List<WSConditionVO> taskGroupWSConditionVO = SystemWSConditionVO.taskGroupWSConditionVO;
        WSConditionVO groupByMember = taskGroupWSConditionVO.get(0);
        WSConditionVO groupByDepartment = taskGroupWSConditionVO.get(1);
        if (wsConditionVOS.stream().filter(v -> v.getAliasCode().equals(groupByMember.getAliasCode())).count() <= 0L) {
            wsConditionVOS.add(groupByMember);
        }
        if (wsConditionVOS.stream().filter(v -> v.getAliasCode().equals(groupByDepartment.getAliasCode())).count() <= 0L) {
            wsConditionVOS.add(groupByDepartment);
        }
        return wsConditionVOS;
    }

    public WorkbenchSettingVO getCardSetting(WSPageCode pageCode, WSConfigType configType, Boolean appCondition) {
        List taskRelations;
        List<String> authApps;
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
            authApps = this.tenantService.getAppCodes();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        WorkbenchSettingVO workbenchSettingVO = new WorkbenchSettingVO();
        workbenchSettingVO.setTenantId(tenantId);
        workbenchSettingVO.setConfigType(configType);
        workbenchSettingVO.setPageCode(pageCode);
        ArrayList<WSConditionVO> wsConditionVOS = new ArrayList<WSConditionVO>();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String type = null;
        if (WSPageCode.task == pageCode) {
            type = "activity";
        } else if (WSPageCode.project == pageCode) {
            type = "task";
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"appCode").in(authApps).and("type").is((Object)type).and("version").is((Object)tenantVersion));
        query.fields().include("code").include("appName");
        if (WSPageCode.task == pageCode) {
            if (WSConfigType.filter == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.taskFilterWSConditionVO);
            } else if (WSConfigType.order == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.taskOrderWSConditionVO);
            }
        } else if (WSPageCode.project == pageCode) {
            if (WSConfigType.groups == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectGroupWSConditionVO);
            } else if (WSConfigType.filter == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectFilterWSConditionVO);
            } else if (WSConfigType.order == configType) {
                wsConditionVOS.addAll(SystemWSConditionVO.projectOrderWSConditionVO);
            }
        }
        if (Boolean.TRUE.equals(appCondition) && CollectionUtil.isNotEmpty((Collection)(taskRelations = this.mongoTemplate.find(query, ApplicationRelation.class)))) {
            HashMap applicationNameMap = new HashMap();
            taskRelations.forEach(applicationRelation -> applicationNameMap.put(applicationRelation.getCode(), applicationRelation));
            List codeList = taskRelations.stream().map(v -> v.getCode()).distinct().collect(Collectors.toList());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("code", codeList);
            params.put("configType", (Object)configType);
            params.put("pageCode", (Object)pageCode);
            DapResponse dapResponse = this.dataMapService.requestDataMap("/view/workbenchSetting", "post", params);
            JSONArray jsonArray = (JSONArray)dapResponse.getResponse();
            if (!jsonArray.isEmpty()) {
                List customerConditionVOS = jsonArray.toJavaList(WSConditionVO.class);
                Map<String, List<WSConditionVO>> conditionMap = customerConditionVOS.stream().collect(Collectors.groupingBy(v -> v.getAliasCode()));
                for (Map.Entry<String, List<WSConditionVO>> entry : conditionMap.entrySet()) {
                    WSConditionVO wsConditionVO;
                    List<WSConditionVO> wsConditionDTOS = entry.getValue();
                    if (wsConditionDTOS.size() > 1) {
                        wsConditionVO = wsConditionDTOS.stream().sorted(Comparator.comparing(WSConditionVO::getCreateDate, Comparator.nullsLast(Comparator.naturalOrder()))).findFirst().get();
                        wsConditionVO.setConditionScope(wsConditionDTOS.stream().flatMap(v -> v.getConditionScope().stream()).distinct().sorted(Comparator.comparing(ConditionScopeVO::getAppName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ConditionScopeVO::getId, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList()));
                        String dataType = null;
                        for (String s : Arrays.asList("boolean", "date", "select", "string", "number")) {
                            if (!wsConditionDTOS.stream().anyMatch(v -> s.equals(v.getDataType()))) continue;
                            dataType = s;
                            break;
                        }
                        if (dataType != null) {
                            wsConditionVO.setDataType(dataType);
                        }
                    } else {
                        wsConditionVO = wsConditionDTOS.get(0);
                    }
                    wsConditionVOS.add(wsConditionVO);
                    for (ConditionScopeVO conditionScopeVO : wsConditionVO.getConditionScope()) {
                        ApplicationRelation applicationRelation2 = (ApplicationRelation)applicationNameMap.get(conditionScopeVO.getCode());
                        if (applicationRelation2 == null) continue;
                        conditionScopeVO.setAppCode(applicationRelation2.getAppCode());
                        conditionScopeVO.setAppName(applicationRelation2.getAppName());
                    }
                }
            }
        }
        List<WSConditionVO> defaultCondition = wsConditionVOS.stream().filter(v -> Boolean.TRUE.equals(v.getEnable())).map(v -> {
            WSConditionVO wsConditionVO = (WSConditionVO)JSON.parseObject((String)JSON.toJSONString((Object)v), WSConditionVO.class);
            if (wsConditionVO.getSourceType() == SourceType.customer) {
                wsConditionVO.setEnable(false);
            }
            return wsConditionVO;
        }).collect(Collectors.toList());
        workbenchSettingVO.setDefaultCondition(defaultCondition);
        workbenchSettingVO.setCondition(wsConditionVOS);
        return workbenchSettingVO;
    }

    @Override
    public WorkbenchSettingVO deleteWorkbenchSetting(WSPageCode wsPageCode, WSConfigType wsConfigType) throws Exception {
        WorkbenchSettingVO result;
        if (wsConfigType == WSConfigType.groups && wsPageCode == WSPageCode.task) {
            this.taskService.getDeleteCardGroup();
            result = this.getWorkbenchSetting(wsPageCode, wsConfigType, true);
        } else {
            String tenantId;
            try {
                tenantId = AthenaUtils.getTenantId();
            }
            catch (DWBusinessException e) {
                throw new RuntimeException(e);
            }
            Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("pageCode").is((Object)wsPageCode).and("configType").is((Object)wsConfigType);
            this.mongoTemplateUser.remove(new Query((CriteriaDefinition)criteria), WorkbenchSetting.class);
            WorkbenchSettingVO workbenchSettingVO = this.getCardSetting(wsPageCode, wsConfigType, true);
            WorkbenchSetting workbenchSetting = (WorkbenchSetting)JSON.parseObject((String)JSON.toJSONString((Object)workbenchSettingVO), WorkbenchSetting.class);
            workbenchSetting.setTenantId(tenantId);
            workbenchSetting.setConfigType(wsConfigType);
            workbenchSetting.setPageCode(wsPageCode);
            result = (WorkbenchSettingVO)JSON.parseObject((String)JSON.toJSONString((Object)this.saveWorkbenchSetting(workbenchSetting)), WorkbenchSettingVO.class);
            String currentLocale = AthenaUtils.getCurrentLocale();
            try {
                LanguageUtil.processLocaleLanguage(result.getCondition(), currentLocale);
                LanguageUtil.processLocaleLanguage(result.getDefaultCondition(), currentLocale);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            for (WSConditionVO wsConditionVO : result.getCondition()) {
                try {
                    LanguageUtil.processLocaleLanguage(wsConditionVO.getConditionScope(), currentLocale);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    @Override
    public void saveWorkbenchSetting(WorkbenchSettingSaveRequest workbenchSettingSaveRequest) throws DWBusinessException {
        WorkbenchSetting workbenchSetting = (WorkbenchSetting)JSON.parseObject((String)JSON.toJSONString((Object)workbenchSettingSaveRequest), WorkbenchSetting.class);
        this.saveWorkbenchSetting(workbenchSetting);
    }

    private WorkbenchSetting saveWorkbenchSetting(WorkbenchSetting workbenchSetting) throws DWBusinessException {
        String tenantId;
        WSPageCode pageCode = workbenchSetting.getPageCode();
        try {
            tenantId = AthenaUtils.getTenantId();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        workbenchSetting.setTenantId(tenantId);
        Update update = new Update();
        for (Field field : WorkbenchSetting.class.getDeclaredFields()) {
            try {
                Object value;
                field.setAccessible(true);
                if (field.getName().equals("id") || (value = field.get(workbenchSetting)) == null || value instanceof String && value.equals("")) continue;
                update.set(field.getName(), field.get(workbenchSetting));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.mongoTemplateUser.upsert(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("pageCode").is((Object)workbenchSetting.getPageCode()).and("configType").is((Object)workbenchSetting.getConfigType())), update, WorkbenchSetting.class);
        this.stringRedisTemplate.delete((Object)("knowledgegraph:" + tenantId + ":" + "workbenchsetting" + ":" + (Object)((Object)pageCode)));
        return workbenchSetting;
    }

    @Override
    public List<WorkbenchSetting> getWorkbenchTenantSetting(WSPageCode pageCode, List<WSConfigType> configTypes) {
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("pageCode").is((Object)pageCode).and("configType").in(configTypes);
        List workbenchSettings = this.mongoTemplateUser.find(new Query((CriteriaDefinition)criteria), WorkbenchSetting.class);
        String currentLocale = AthenaUtils.getCurrentLocale();
        try {
            for (WorkbenchSetting workbenchSetting : workbenchSettings) {
                LanguageUtil.processLocaleLanguage(workbenchSetting.getCondition(), currentLocale);
                LanguageUtil.processLocaleLanguage(workbenchSetting.getDefaultCondition(), currentLocale);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return workbenchSettings;
    }

    @Override
    public List<CardPresentConfig> getCardPresentConfig(String pageCode) {
        String tenantId;
        try {
            tenantId = AthenaUtils.getTenantId();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("pageCode").is((Object)pageCode);
        List cardPresentConfigs = this.mongoTemplateUser.find(new Query((CriteriaDefinition)criteria), CardPresentConfig.class);
        return cardPresentConfigs;
    }

    @Override
    public void postSaveCardPresentConfig(CardPresentConfigReq cardPresentConfigReq) {
        String tenantId;
        CardPresentConfig cardPresentConfig = (CardPresentConfig)JSON.parseObject((String)JSON.toJSONString((Object)cardPresentConfigReq), CardPresentConfig.class);
        try {
            tenantId = AthenaUtils.getTenantId();
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
        cardPresentConfig.setTenantId(tenantId);
        Update update = new Update();
        for (Field field : CardPresentConfig.class.getDeclaredFields()) {
            try {
                Object value;
                field.setAccessible(true);
                if (field.getName().equals("id") || (value = field.get(cardPresentConfig)) == null || value instanceof String && value.equals("")) continue;
                update.set(field.getName(), field.get(cardPresentConfig));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.mongoTemplateUser.upsert(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("pageCode").is((Object)cardPresentConfigReq.getPageCode())), update, CardPresentConfig.class);
        String redisKey = "getCardPresentConfigs:" + tenantId + ":" + cardPresentConfigReq.getPageCode();
        this.atmcService.cacheReset(tenantId, redisKey);
    }
}

