/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class KggDataPickService
extends DataPickService {
    private static final Logger log = LoggerFactory.getLogger(KggDataPickService.class);
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private CACUtils cacUtils;
    @Autowired
    TenantService tenantService;
    @Autowired
    KgInnerService kgInnerService;

    public MongoTemplate systemTemplate() {
        return this.mongoTemplate;
    }

    public MongoTemplate tenantTemplate() {
        return this.mongoTemplateUser;
    }

    public String tenantVersion(String tenantId) {
        return this.kgInnerService.getTenantVersion(tenantId);
    }

    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        List<String> codes = new ArrayList<String>();
        try {
            List<ApplicationRelation> relations = this.relations(app, type);
            if (null != relations) {
                codes = relations.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
            }
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return codes;
    }

    public List<ApplicationRelation> relations(String app, String type) throws DWBusinessException {
        String version = this.tenantVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)app).and("type").is((Object)type).and("version").is((Object)version));
        return this.mongoTemplate.find(query, ApplicationRelation.class);
    }

    public boolean isTenantCol(Class c) {
        return false;
    }

    public boolean isSystemCol(Class c) {
        return false;
    }
}

