/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.set.partParsers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.KgService;
import com.digiwin.athena.knowledgegraph.set.EmailEventIdEnum;
import com.digiwin.athena.knowledgegraph.set.IPartParser;
import com.digiwin.athena.knowledgegraph.set.ServiceComposerTaskTypeEnum;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.knowledgegraph.set.SetsStepTypeEnum;
import com.digiwin.athena.knowledgegraph.set.partParsers.enums.DetectType;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.Step;
import com.digiwin.athena.set.part.ApplicationDataSavePart;
import com.digiwin.athena.set.part.Connection;
import com.digiwin.athena.set.part.DataUnderstandingPart;
import com.digiwin.athena.set.part.EmailNotice;
import com.digiwin.athena.set.part.EmailNoticeTimingEnum;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.Processor;
import com.digiwin.athena.set.part.ReturnField;
import com.digiwin.athena.set.part.SmartAdjustProjectPart;
import com.digiwin.athena.set.part.SystemPart;
import com.digiwin.athena.set.part.ThresholdEvaluatePart;
import com.digiwin.athena.set.serviceComposer.InputParameters;
import com.digiwin.athena.set.serviceComposer.ServiceComposer;
import com.digiwin.athena.set.serviceComposer.ServiceComposerLink;
import com.digiwin.athena.set.serviceComposer.ServiceComposerTask;
import io.seata.common.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DataUnderstandingPartParser
implements IPartParser {
    private static final Logger log = LoggerFactory.getLogger(DataUnderstandingPartParser.class);
    private static final String TASK = "Task_";
    private static final String LINK = "Link_";
    private static final String URI = "$(taskEngineUrl)/restful/standard/taskengine/api/project/create";
    private static final String EOC_URI = "$(eocUrl)/api/eoc/v2/emp/user/id";
    private static final String EMAIL_URI = "$(atmcUrl)/api/atmc/v1/email/template";
    private static final String PUBLISH_URL = "/restful/standard/scdispatcher/template/publish";
    @Autowired
    @Qualifier(value="dataFootprintTemplate")
    RestTemplate restTemplate;
    @Value(value="${scdispatcherUrl}")
    private String scdispatcherUrl;
    @Autowired
    KgService kgService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    CacService cacService;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase((CharSequence)"DataUnderstanding", (CharSequence)part.getType()) || StringUtils.equalsIgnoreCase((CharSequence)"ThresholdEvaluate", (CharSequence)part.getType());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        ApplicationDataSavePart dataSavePart;
        Sets sets = context.getCurrentSet();
        if (Objects.equals(sets.getOperate(), "delete")) {
            return;
        }
        String version = sets.getVersion();
        ArrayList<Step> steps = new ArrayList<Step>();
        ServiceComposer serviceComposer = new ServiceComposer();
        String startId = UUID.randomUUID().toString().replaceAll("-", "_");
        String filterId = UUID.randomUUID().toString().replaceAll("-", "_");
        String decisionId = UUID.randomUUID().toString().replaceAll("-", "_");
        String dataSaveTaskId = UUID.randomUUID().toString().replaceAll("-", "_");
        String applicationDataSaveTaskId = UUID.randomUUID().toString().replaceAll("-", "_");
        String httpTaskId = UUID.randomUUID().toString().replaceAll("-", "_");
        String endTaskId = UUID.randomUUID().toString().replaceAll("-", "_");
        String startBatchId = UUID.randomUUID().toString().replaceAll("-", "_");
        String endBatchId = UUID.randomUUID().toString().replaceAll("-", "_");
        DataUnderstandingPart dataUnderstandingPart = sets.getU().getPart();
        ThresholdEvaluatePart thresholdEvaluatePart = sets.getP().getPart();
        SmartAdjustProjectPart smartAdjustProjectPart = (SmartAdjustProjectPart)JSON.parseObject((String)JSON.toJSONString((Object)sets.getA().getPart()), SmartAdjustProjectPart.class);
        if (CollectionUtils.isNotEmpty((Collection)dataUnderstandingPart.getSteps())) {
            List<ReturnField> returnFields = context.getReturnFieldAll();
            for (Step step : dataUnderstandingPart.getSteps()) {
                returnFields.addAll(step.getReturnFields());
            }
            context.setReturnFieldAll(returnFields);
        }
        steps.add(this.buildStartStep(sets, startId));
        if (StringUtils.isNotEmpty((CharSequence)thresholdEvaluatePart.getThresholdCondition().getType())) {
            String javascriptExpressions = thresholdEvaluatePart.toJavaScriptExpression();
            steps.add(this.buildFilterStep(filterId, javascriptExpressions));
        }
        if ("field".equalsIgnoreCase(smartAdjustProjectPart.getPersonIncharge().getType()) && smartAdjustProjectPart.getPersonIncharge().isConvert()) {
            String personInChargeValue = smartAdjustProjectPart.getPersonIncharge().getValue();
            steps.add(this.buildDefaultPersonInChargeStep(UUID.randomUUID().toString().replaceAll("-", "_"), personInChargeValue));
        }
        log.info("\u6570\u636e\u5b58\u50a8\u5230\u5e94\u7528api V:{}", (Object)JSON.toJSONString((Object)sets.getV()));
        if (Objects.nonNull(sets.getV()) && Objects.nonNull(sets.getV().getPart()) && StringUtils.isNotEmpty((CharSequence)(dataSavePart = sets.getV().getPart()).getServiceName()) && StringUtils.isNotEmpty((CharSequence)dataSavePart.getActionId())) {
            steps.add(this.buildApplicationDataSaveApiStep(applicationDataSaveTaskId, dataSavePart, context.getReturnFieldAll(), version));
        }
        steps.add(this.buildDataSaveApiStep(dataSaveTaskId, sets.getCode()));
        List<Step> emailSteps = this.buildEmailNoticeSteps(sets, smartAdjustProjectPart);
        if (CollectionUtils.isNotEmpty(emailSteps)) {
            steps.addAll(emailSteps);
        }
        steps.add(this.buildDecisionStep(decisionId));
        String personInChargeType = smartAdjustProjectPart.getPersonIncharge().getType();
        if ("field".equalsIgnoreCase(personInChargeType)) {
            String personInChargeValue = smartAdjustProjectPart.getPersonIncharge().getValue();
            boolean personInchargeConvert = smartAdjustProjectPart.getPersonIncharge().isConvert();
            if (personInchargeConvert) {
                String startEocBatchId = UUID.randomUUID().toString().replaceAll("-", "_");
                String endEocBatchId = UUID.randomUUID().toString().replaceAll("-", "_");
                String httpEocTaskId = "eoc_" + UUID.randomUUID().toString().replaceAll("-", "_");
                steps.add(this.buildBatchStep(startEocBatchId));
                steps.add(this.buildHttpEocStep(sets.getCode(), httpEocTaskId, personInChargeValue));
                steps.add(this.buildBatchEndStep(endEocBatchId));
            } else {
                String dataSetId = UUID.randomUUID().toString().replaceAll("-", "_");
                steps.add(this.buildDataSetStep(dataSetId, personInChargeValue));
            }
            String dataGroupId = UUID.randomUUID().toString().replaceAll("-", "_");
            steps.add(this.buildDataGroupStep(dataGroupId, personInChargeValue));
            steps.add(this.buildBatchStep(startBatchId));
            steps.add(this.buildHttpStep(sets.getCode(), httpTaskId, "1", smartAdjustProjectPart.getPersonIncharge()));
            steps.add(this.buildBatchEndStep(endBatchId));
        } else {
            steps.add(this.buildHttpStep(sets.getCode(), httpTaskId, "0", smartAdjustProjectPart.getPersonIncharge()));
        }
        steps.add(this.buildEndStep(endTaskId));
        List<ServiceComposerTask> tasks = this.executePart(dataUnderstandingPart, steps, version);
        List<ServiceComposerLink> links = this.convertConnectionsToLinks(tasks);
        serviceComposer.setId("ServiceComposerBySet_" + sets.getCode());
        serviceComposer.setName("\u53c2\u6570\u8c03\u6574\u5957\u4ef6\u7684\u670d\u52a1\u7f16\u6392");
        serviceComposer.setLinks(links);
        serviceComposer.setTasks(tasks);
        this.publishTemplate(JSON.toJSONString((Object)serviceComposer));
        log.info("sets dsl : {}", (Object)JSON.toJSONString((Object)serviceComposer));
    }

    public List<ServiceComposerTask> executePart(DataUnderstandingPart part, List<Step> steps, String version) throws DWBusinessException {
        ArrayList<ServiceComposerTask> resultMap = new ArrayList<ServiceComposerTask>();
        List<Step> executionOrder = this.getExecutionOrder(part, steps);
        for (Step step : executionOrder) {
            this.executeStep(step, resultMap, version);
        }
        return resultMap;
    }

    private List<Step> getExecutionOrder(DataUnderstandingPart part, List<Step> steps) {
        List partStep = part.getSteps();
        List conns = part.getConns();
        ArrayList<Step> orderedSteps = new ArrayList<Step>();
        HashSet<String> visited = new HashSet<String>();
        String to = "";
        if (CollectionUtils.isNotEmpty(steps)) {
            orderedSteps.add(steps.get(0));
            steps.remove(0);
        }
        HashMap<String, Step> stepMap = new HashMap<String, Step>();
        for (Step step : partStep) {
            String id = step.getId();
            stepMap.put(id, step);
        }
        for (Connection conn : conns) {
            String from = conn.getFrom();
            if (!from.isEmpty()) continue;
            to = conn.getTo();
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)to)) {
            DataUnderstandingPartParser.traverseSteps(stepMap, to, visited, orderedSteps, conns);
        }
        orderedSteps.addAll(steps);
        return orderedSteps;
    }

    private static void traverseSteps(Map<String, Step> stepMap, String currentStepId, Set<String> visited, List<Step> orderedSteps, List<Connection> conns) {
        visited.add(currentStepId);
        Step currentStep = stepMap.get(currentStepId);
        orderedSteps.add(currentStep);
        String from = currentStepId;
        block0: while (!from.isEmpty()) {
            for (Connection conn : conns) {
                if (!conn.getFrom().equals(from)) continue;
                String to = conn.getTo();
                Step step = stepMap.get(to);
                if (step != null) {
                    orderedSteps.add(step);
                }
                from = to;
                continue block0;
            }
        }
    }

    private void executeStep(Step step, List<ServiceComposerTask> resultMap, String version) throws DWBusinessException {
        if (Objects.equals(SetsStepTypeEnum.API.toString(), step.getType()) || Objects.equals(SetsStepTypeEnum.DataSaveApi.toString(), step.getType())) {
            this.executeAPI(step, resultMap, version, step.getType());
        } else if (Objects.equals(SetsStepTypeEnum.Script.toString(), step.getType()) || Objects.equals(SetsStepTypeEnum.Constant.toString(), step.getType()) || Objects.equals(SetsStepTypeEnum.Filter.toString(), step.getType()) || Objects.equals(SetsStepTypeEnum.End.toString(), step.getType()) || Objects.equals(SetsStepTypeEnum.Start.toString(), step.getType()) || Objects.equals(SetsStepTypeEnum.Group.toString(), step.getType())) {
            this.executeScript(step, resultMap);
        } else if (Objects.equals(SetsStepTypeEnum.Http.toString(), step.getType())) {
            this.executeHttp(step, resultMap);
        } else if (Objects.equals(SetsStepTypeEnum.Decision.toString(), step.getType()) || Objects.equals(SetsStepTypeEnum.Batch_End.toString(), step.getType())) {
            this.executeDecisionAndBatchEnd(step, resultMap);
        } else if (Objects.equals(SetsStepTypeEnum.Batch.toString(), step.getType())) {
            this.executeBatch(step, resultMap);
        } else {
            throw new DWBusinessException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684type:" + step.getType());
        }
    }

    private void executeAPI(Step step, List<ServiceComposerTask> resultMap, String version, String type) throws DWBusinessException {
        String responseScript;
        String requestScript;
        String tenantId = AthenaUtils.getTenantId();
        ServiceComposerTask task = new ServiceComposerTask();
        InputParameters inputParameters = new InputParameters();
        task.setId(TASK + step.getId().replaceAll("-", "_"));
        task.setType(ServiceComposerTaskTypeEnum.ESP.toString());
        task.setName(step.getDescription());
        task.setTaskTimeoutSeconds(Integer.valueOf(86400));
        task.setInputParameters(inputParameters);
        if (Objects.equals(SetsStepTypeEnum.API.toString(), step.getType())) {
            List<ApiDataFieldMetadataDTO> actionParameters = this.kgService.getActionParameters(step.getActionId(), tenantId, version);
            requestScript = this.buildBeforeRequestScript(step, actionParameters);
            inputParameters.setProductName("");
            responseScript = this.buildAfterResponseScript(step);
        } else {
            requestScript = step.getScript();
            inputParameters.setProductName(step.getProductName());
            responseScript = step.getResponseScript();
        }
        inputParameters.setBeforeRequestScript(requestScript);
        inputParameters.setAfterResponseScript(responseScript);
        inputParameters.setServiceName(step.getServiceName());
        resultMap.add(task);
    }

    private void executeScript(Step step, List<ServiceComposerTask> resultMap) {
        ServiceComposerTask task = new ServiceComposerTask();
        InputParameters inputParameters = new InputParameters();
        task.setId(TASK + step.getId().replaceAll("-", "_"));
        task.setType(ServiceComposerTaskTypeEnum.JS.toString());
        task.setName(step.getDescription());
        task.setInputParameters(inputParameters);
        if (Objects.equals(SetsStepTypeEnum.Script.toString(), step.getType())) {
            inputParameters.setScript(this.buildExecuteScript(step));
        } else if (Objects.equals(SetsStepTypeEnum.Constant.toString(), step.getType())) {
            inputParameters.setScript(this.buildExecuteConstant(step));
        } else {
            inputParameters.setScript(step.getScript());
        }
        resultMap.add(task);
    }

    private void executeHttp(Step step, List<ServiceComposerTask> resultMap) {
        ServiceComposerTask task = new ServiceComposerTask();
        InputParameters inputParameters = new InputParameters();
        task.setId(step.getId());
        task.setType(step.getType());
        task.setName(step.getDescription());
        task.setTaskTimeoutSeconds(Integer.valueOf(86400));
        task.setInputParameters(inputParameters);
        inputParameters.setBeforeRequestScript(step.getScript());
        inputParameters.setMethod(HttpMethod.POST.toString());
        if (step.getId().contains("eoc")) {
            inputParameters.setAfterResponseScript(step.getResponseScript());
            inputParameters.setUri(EOC_URI);
        } else if (step.getId().contains("email")) {
            inputParameters.setAfterResponseScript("var response = $(response);\n return {\n    'response': response \n};");
            inputParameters.setUri(EMAIL_URI);
        } else {
            inputParameters.setAfterResponseScript("var response = $(response);\n return {\n    'response': response \n};");
            inputParameters.setUri(URI);
        }
        resultMap.add(task);
    }

    private void executeDecisionAndBatchEnd(Step step, List<ServiceComposerTask> resultMap) {
        ServiceComposerTask task = new ServiceComposerTask();
        task.setId(step.getId());
        task.setName(step.getDescription());
        task.setType(step.getType());
        resultMap.add(task);
    }

    private void executeBatch(Step step, List<ServiceComposerTask> resultMap) {
        ServiceComposerTask task = new ServiceComposerTask();
        InputParameters inputParameters = new InputParameters();
        inputParameters.setLoopList("$(detectedData)");
        inputParameters.setLoopVarName("data");
        inputParameters.setResultVarName("result");
        task.setId(step.getId());
        task.setName(step.getDescription());
        task.setType(step.getType());
        task.setInputParameters(inputParameters);
        resultMap.add(task);
    }

    private String buildBeforeRequestScript(Step step, List<ApiDataFieldMetadataDTO> actionParameters) {
        ApiDataFieldMetadataDTO apiDataFieldMetadataDTO;
        boolean isArray = true;
        String dataName = "credit_info";
        if (CollectionUtils.isNotEmpty(actionParameters) && (apiDataFieldMetadataDTO = actionParameters.get(0)) != null) {
            dataName = apiDataFieldMetadataDTO.getData_name();
            isArray = apiDataFieldMetadataDTO.getIs_array();
        }
        StringBuilder codeBuilder = new StringBuilder();
        List paramsArray = step.getParams();
        JSONArray jsonArray = new JSONArray();
        for (Processor param2 : paramsArray) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)param2.getName());
            jsonObject.put("value", (Object)param2.getValue());
            jsonObject.put("type", (Object)param2.getType());
            jsonArray.add((Object)jsonObject);
        }
        codeBuilder.append("var jsonArray = [];\n").append("var paramsArray = ").append(jsonArray.toJSONString()).append(";\n").append("var jsonParam = {};\n").append("var detectedData = $(detectedData);\n");
        if (!isArray) {
            codeBuilder.append("var jsonObject = {};\n");
        }
        if (paramsArray.stream().anyMatch(param -> "Field".equals(param.getType()))) {
            codeBuilder.append("detectedData.forEach(function(item) {\n");
        }
        if (isArray) {
            codeBuilder.append("var jsonObject = {};\n");
        }
        codeBuilder.append("if (paramsArray != null) {").append("\n").append("paramsArray.forEach(function(paramObject) {").append("\n").append("var paramName = paramObject[\"name\"];").append("\n").append("var paramValue = paramObject[\"value\"];").append("\n").append("var paramType = paramObject[\"type\"];").append("\n");
        if (paramsArray.stream().anyMatch(param -> "Field".equals(param.getType()))) {
            codeBuilder.append("if (paramType === \"Field\") {").append("\n").append("var detectedValue = item[paramValue]; ").append("\n").append("jsonObject[paramName] = detectedValue;").append("\n").append("} else {").append("\n");
        }
        codeBuilder.append("jsonObject[paramName] = paramValue;").append("\n");
        if (paramsArray.stream().anyMatch(param -> "Field".equals(param.getType()))) {
            codeBuilder.append("}").append("\n");
        }
        codeBuilder.append("});").append("\n").append("}").append("\n");
        codeBuilder.append("jsonArray.push(jsonObject);\n");
        if (paramsArray.stream().anyMatch(param -> "Field".equals(param.getType()))) {
            codeBuilder.append("});\n");
        }
        if (isArray) {
            codeBuilder.append("if (jsonArray[0] && Object.keys(jsonArray[0]).length !== 0) { jsonParam.").append(dataName).append("= jsonArray; }\n");
        } else {
            codeBuilder.append("if (jsonArray[0] && Object.keys(jsonArray[0]).length !== 0) { jsonParam.").append(dataName).append("= jsonObject; }\n");
        }
        codeBuilder.append("var request = {").append("\n").append("\"std_data\": {").append("\n").append(" \"parameter\": jsonParam").append("\n").append("}};").append("\n").append("return request;").append("\n");
        return codeBuilder.toString();
    }

    private String buildAfterResponseScript(Step step) {
        StringBuilder codeBuilder = new StringBuilder();
        List params = step.getParams();
        JSONArray paramsArrays = new JSONArray();
        for (Processor param : params) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("value", (Object)param.getValue());
            paramsArrays.add((Object)jsonObject);
        }
        List paramsArray = step.getReturnFields();
        JSONArray jsonArray = new JSONArray();
        for (ReturnField param : paramsArray) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)param.getDatasourceField());
            jsonArray.add((Object)jsonObject);
        }
        codeBuilder.append("var response = $(response);\n").append("var jsonObject = {};\n").append("  var tSuccess = true;\n").append("var tErrorMessage = \"\";\n").append("var data=[];\n").append("var newData=[];\n").append("var paramsArrays = ").append(paramsArrays.toJSONString()).append(";\n").append("var paramsArray = ").append(jsonArray.toJSONString()).append(";\n").append("var detectedData = $(detectedData);\n").append("if(response['std_data']['execution']['code'] == \"0\"){").append("\n").append("tErrorMessage = 'Success';").append("\n").append("var parameter = response.std_data.parameter;").append("\n").append("var dynamicPropertyName = Object.keys(parameter)[0];").append("\n").append(" data = parameter[dynamicPropertyName];").append("\n").append("if(data == null || data.length == 0){").append("\n").append("tSuccess = false;").append("\n").append("}else {").append("\n").append("detectedData.forEach(function(item, index) {").append("\n").append("var newDataItem = {};").append("\n").append("for (var prop in item) {").append("\n").append("if (item.hasOwnProperty(prop)) {\n      newDataItem[prop] = item[prop];\n       }\n      }\nparamsArray.forEach(function(fieldItem) {").append("\n").append("newDataItem[fieldItem.name] = (index < data.length) ? data[index][fieldItem.name] : data[data.length-1][fieldItem.name];").append("\n").append("});").append("\n").append("newData.push(newDataItem);").append("\n").append("});").append("\n").append("detectedData = (newData === null || newData.length === 0) ? detectedData : newData;").append("\n").append("}").append("\n").append("}else{").append("\n").append("tSuccess = false;").append("\n").append("tErrorMessage = response['std_data']['execution']['description'];}\n").append("return {").append("\n").append("\"success\" : tSuccess,\n").append("\"processVariable\": {\n").append("\"detectedData\":detectedData").append("\n").append("},").append("\n").append("\"errorMessage\" : tErrorMessage").append("\n").append("};").append("\n");
        return codeBuilder.toString();
    }

    private String buildExecuteScript(Step step) {
        String script = step.getScript();
        String returnField = CollectionUtils.isNotEmpty((Collection)step.getReturnFields()) ? ((ReturnField)step.getReturnFields().get(0)).getDatasourceField() : "";
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var detectedData = $(detectedData);\n");
        codeBuilder.append(" detectedData.forEach(function(currentRow) {\n");
        if ("ByRow".equalsIgnoreCase(step.getExecuteMode())) {
            codeBuilder.append(script).append("\n");
        } else {
            script = script.replace("currentRow", "detectedData[0]");
            codeBuilder.append(script).append("\n");
        }
        codeBuilder.append("    currentRow.").append(returnField).append(" = data;\n");
        codeBuilder.append("});\n");
        codeBuilder.append("\n");
        codeBuilder.append(" return {\n");
        codeBuilder.append("  \"processVariable\": {\n");
        codeBuilder.append("    \"detectedData\": detectedData\n");
        codeBuilder.append("  }\n");
        codeBuilder.append(" };\n");
        return codeBuilder.toString();
    }

    private String buildExecuteConstant(Step step) {
        String returnField;
        String value = step.getValue();
        if (CollectionUtils.isNotEmpty((Collection)step.getReturnFields())) {
            ReturnField field = (ReturnField)step.getReturnFields().get(0);
            returnField = field.getDatasourceField();
            if (!("number".equals(field.getValueType()) || "numeric".equals(field.getValueType()) || "boolean".equals(field.getValueType()) || !"string".equals(field.getValueType()) || "\"\"".equals(value))) {
                value = "'" + value + "'";
            }
        } else {
            returnField = "";
        }
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var detectedData = $(detectedData);\n");
        codeBuilder.append(" detectedData.forEach(function(currentRow) {\n");
        codeBuilder.append("  var data = ").append(value).append(";\n");
        codeBuilder.append("    currentRow.").append(returnField).append(" = data;\n");
        codeBuilder.append("});\n");
        codeBuilder.append("\n");
        codeBuilder.append(" return {\n");
        codeBuilder.append("  \"processVariable\": {\n");
        codeBuilder.append("    \"detectedData\": detectedData\n");
        codeBuilder.append("  }\n");
        codeBuilder.append(" };\n");
        return codeBuilder.toString();
    }

    private Step buildStartStep(Sets sets, String startId) throws DWBusinessException {
        Step step = new Step();
        step.setId(startId);
        step.setType(SetsStepTypeEnum.Start.toString());
        step.setScript(this.getStartScript(sets));
        step.setDescription("\u5f00\u59cb\u8282\u70b9");
        return step;
    }

    private Step buildDataSetStep(String id, String fieldName) {
        Step step = new Step();
        step.setId(id);
        step.setType(SetsStepTypeEnum.Start.toString());
        step.setScript(this.getDataSetScript(fieldName));
        step.setDescription("\u8bbe\u7f6echarge_id");
        return step;
    }

    private Step buildFilterStep(String filterId, String condition) {
        Step step = new Step();
        step.setId(filterId);
        step.setType(SetsStepTypeEnum.Filter.toString());
        step.setScript(this.getFilterScript(condition));
        step.setDescription("\u6570\u636e\u7b5b\u9009");
        return step;
    }

    private Step buildDecisionStep(String decisionId) {
        Step step = new Step();
        step.setId(TASK + decisionId);
        step.setType(SetsStepTypeEnum.Decision.toString());
        step.setDescription("\u5224\u65ad\u662f\u5426\u53d1\u5361");
        return step;
    }

    private Step buildDataGroupStep(String dataGroupId, String personInChargeValue) {
        Step step = new Step();
        step.setId(dataGroupId);
        step.setType(SetsStepTypeEnum.Group.toString());
        step.setScript(this.getDataFroupScript(personInChargeValue));
        step.setDescription("\u6570\u636e\u5206\u7ec4\u6216\u5904\u7406");
        return step;
    }

    private Step buildBatchStep(String id) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.Batch.toString());
        step.setDescription("Http\u5faa\u73af\u5f00\u59cb");
        return step;
    }

    private Step buildBatchEndStep(String id) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.Batch_End.toString());
        step.setDescription("Http\u5faa\u73af\u7ed3\u675f");
        return step;
    }

    private Step buildDataSaveApiStep(String id, String setsCode) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.DataSaveApi.toString());
        step.setServiceName("common.driven.heart.ctl." + setsCode + ".create");
        step.setProductName("common-driven");
        step.setDescription("\u8c03\u7528\u6570\u636e\u5b58\u50a8api");
        step.setScript(this.getDataSaveScript("heart_ctl_" + setsCode));
        step.setResponseScript(this.getDataSaveResponseScript("heart_ctl_" + setsCode));
        return step;
    }

    private Step buildApplicationDataSaveApiStep(String applicationDataSaveTaskId, ApplicationDataSavePart part, List<ReturnField> returnFieldAll, String version) throws DWBusinessException {
        Step step = new Step();
        step.setId(TASK + applicationDataSaveTaskId);
        step.setType(SetsStepTypeEnum.DataSaveApi.toString());
        step.setServiceName(part.getServiceName());
        step.setProductName(part.getProductName());
        step.setDescription("\u8c03\u7528\u5e94\u7528api\u4fdd\u5b58\u6570\u636e");
        step.setActionId(part.getActionId());
        String tenantId = AthenaUtils.getTenantId();
        List<ApiDataFieldMetadataDTO> actionParameters = this.kgService.getActionParameters(step.getActionId(), tenantId, version);
        if (CollectionUtils.isEmpty(actionParameters)) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.dataNameIsEmpty", (Object[])new Object[]{tenantId}));
        }
        ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = actionParameters.get(0);
        if (apiDataFieldMetadataDTO == null || !StringUtils.isNotEmpty((CharSequence)apiDataFieldMetadataDTO.getData_name())) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.dataNameIsEmpty", (Object[])new Object[]{tenantId}));
        }
        step.setScript(this.getDataSaveScript(apiDataFieldMetadataDTO.getData_name()));
        log.info("\u6784\u5efa\u4fdd\u5b58\u6570\u636e\u81f3\u5e94\u7528\u7684step:{}", (Object)JSON.toJSONString((Object)step));
        return step;
    }

    private Step buildDefaultPersonInChargeStep(String stepId, String fieldName) {
        Step step = new Step();
        step.setId(stepId);
        step.setType(SetsStepTypeEnum.Start.toString());
        step.setScript(this.getDefaultPersonInChargeScript(fieldName));
        step.setDescription("\u5b57\u6bb5\u7c7b\u578b\u5f53\u8d23\u8005\u9ed8\u8ba4\u503c");
        return step;
    }

    private String getDefaultPersonInChargeScript(String fieldName) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var detectedData = $(detectedData);\n").append(" for (var i = 0; i < detectedData.length; i++) {\n").append(" if (!detectedData[i].").append(fieldName).append("){\n").append(" detectedData[i].").append(fieldName).append(" = '1';\n").append(" }\n").append("}\n").append("return {").append("\n").append("\"processVariable\": {").append("\n").append("\"detectedData\":detectedData").append("\n").append("}};").append("\n");
        return codeBuilder.toString();
    }

    private String getDataSaveScript(String code) {
        return "var dispatchData = $(detectedData);\nvar jsonParam = {'" + code + "': dispatchData};\nvar request = {\n\"std_data\": {\n \"parameter\": jsonParam\n}};\nreturn request;\n";
    }

    private String getApplicationDataSaveScript() {
        return "var dispatchData = $(detectedData);\nvar request = {\n\"std_data\": {\n \"parameter\": dispatchData\n}};\nreturn request;\n";
    }

    private String getDataSaveResponseScript(String code) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var response = $(response);\n").append("var tableData = $(detectedData);\n").append("var tSuccess = true;\n").append("var tErrorMessage = \"\";\n").append("if(response['std_data']['execution']['code'] == \"0\"){").append("\n").append("tErrorMessage = 'Success';").append("\n").append("tableData = response.std_data.parameter.").append(code).append(";\n").append("}else{").append("\n").append("tSuccess = false;").append("\n").append("tErrorMessage = response['std_data']['execution']['description'];}\n").append("return {").append("\n").append("\"success\" : tSuccess,\n").append("\"processVariable\": {\n").append("\"detectedData\":tableData").append("\n").append("},").append("\n").append("\"errorMessage\" : tErrorMessage").append("\n").append("};").append("\n");
        return codeBuilder.toString();
    }

    public List<Step> buildEmailNoticeSteps(Sets currentSet, SmartAdjustProjectPart part) throws DWBusinessException {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (CollectionUtils.isNotEmpty((Collection)part.getEmailNotices())) {
            List<Object> tenantIds = new ArrayList();
            List tenantIdDataList = this.cacService.getAllEffectiveTenantAndAppInfo(currentSet.getAppCode()).getList();
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)tenantIdDataList)) {
                tenantIds = tenantIdDataList.stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
            }
            for (EmailNotice emailNotice : part.getEmailNotices()) {
                for (String string : tenantIds) {
                    Step step = this.buildEmailNoticeStep(currentSet, string, emailNotice, part);
                    if (step == null) continue;
                    steps.add(step);
                }
            }
        }
        return steps;
    }

    private Step buildEmailNoticeStep(Sets currentSet, String tenantId, EmailNotice emailNotice, SmartAdjustProjectPart part) throws DWBusinessException {
        if (CollectionUtils.isEmpty((Collection)emailNotice.getReceivers())) {
            return null;
        }
        Step step = new Step();
        step.setId("email_" + UUID.randomUUID().toString().replaceAll("-", "_"));
        step.setType(SetsStepTypeEnum.Http.toString());
        step.setDescription("\u8c03\u7528\u90ae\u4ef6\u6a21\u677f");
        step.setScript(this.getEmailNoticeScript(currentSet, tenantId, emailNotice, part));
        return step;
    }

    private String getEmailNoticeScript(Sets currentSet, String tenantId, EmailNotice emailNotice, SmartAdjustProjectPart part) throws DWBusinessException {
        int type;
        String userId = AthenaUtils.getUserId();
        String currentLocale = "zh_CN";
        String projectCode = "ProjectBySet_" + currentSet.getCode();
        String manualTaskCode = currentSet.getCode() + "_" + "task" + "_" + "manual";
        List receivers = emailNotice.getReceivers();
        String code = (String)receivers.get(0);
        EmailNoticeTimingEnum timingEnum = EmailNoticeTimingEnum.getByCode((String)emailNotice.getTiming());
        String emailName = String.format("\u4e1a\u52a1\u8fc7\u7a0b\u968f\u5fc3\u63a7%s\u90ae\u4ef6\u901a\u77e5", timingEnum.getDesc());
        switch (timingEnum) {
            case TASK_END: {
                type = 2;
                break;
            }
            case PROJECT_BEGIN: {
                type = 3;
                break;
            }
            case PROJECT_END: {
                type = 4;
                break;
            }
            default: {
                type = 1;
            }
        }
        int state = Boolean.TRUE.equals(part.getEnableEmailNotice()) ? 1 : 0;
        String manualActivityId = EmailNoticeTimingEnum.PROJECT_END.equals((Object)timingEnum) ? null : manualTaskCode;
        StringBuilder sb = new StringBuilder();
        sb.append("var detectedData = $(detectedData);").append("\n").append("var receivers = [];").append("\n").append("var lang = {'zh_CN':'").append(emailName).append("','zh_TW':'").append(emailName).append("','en_US':'").append(emailName).append("'};").append("\n").append("var activities = [{'taskId': '").append(projectCode).append("', 'activityId':").append(manualActivityId == null ? "null" : "'" + manualActivityId + "'").append("}];\n").append("for (var i=0;i<detectedData.length;i++) {").append("\n").append("var item=detectedData[i];").append("if(item.").append(code).append("){").append("\n").append("var exists = false;\n").append("for (var j = 0;j < receivers.length;j++) {").append("\n").append("if(item.").append(code).append(" == receivers[j]) {").append("\n").append("exists = true;}}\n").append("if(!exists) {").append("\n").append("receivers.push(item.").append(code).append(");\n").append("}}};").append("\n").append("var request = {").append("\n").append("'receiveStaff' : receivers,").append("\n").append("'activityList' : activities,").append("\n").append("'tenantId':'").append(tenantId).append("',").append("\n").append("'appCode':'").append(currentSet.getAppCode()).append("',").append("\n").append("'emailName':lang,").append("\n").append("'description':lang,").append("\n").append("'type':'").append(type).append("',").append("\n").append("'state':'").append(state).append("',").append("\n").append("'updateBy':'").append(userId).append("',").append("\n").append("'langName':'$(processLocale)'").append(",").append("\n").append("'previewId':'").append(EmailEventIdEnum.getEmailEventId(timingEnum.getCode(), currentLocale)).append("'\n").append("}").append("\n").append("return request;");
        return sb.toString();
    }

    private Step buildHttpStep(String setsCode, String id, String byGroup, Processor personInCharge) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.Http.toString());
        step.setScript(this.getHttpScript(setsCode, byGroup, personInCharge));
        step.setDescription("Http\u8bf7\u6c42\u53d1\u8d77\u9879\u76ee");
        return step;
    }

    private Step buildHttpEocStep(String setsCode, String id, String fieldName) {
        Step step = new Step();
        step.setId(TASK + id);
        step.setType(SetsStepTypeEnum.Http.toString());
        step.setScript(this.getHttpEocScript(fieldName));
        step.setResponseScript(this.getHttpEocResponseScript(fieldName));
        step.setDescription("Http\u8bf7\u6c42\u53d1\u8d77eoc\u8bf7\u6c42\u8fdb\u5458\u5de5\u8f6c\u6362");
        return step;
    }

    private Step buildEndStep(String endTaskId) {
        Step step = new Step();
        step.setId(endTaskId);
        step.setType(SetsStepTypeEnum.End.toString());
        step.setScript("return {'msg': '\u7ed3\u675f'};");
        step.setDescription("\u7ed3\u675f");
        return step;
    }

    private List<ServiceComposerLink> convertConnectionsToLinks(List<ServiceComposerTask> tasks) {
        ArrayList<ServiceComposerLink> links = new ArrayList<ServiceComposerLink>();
        for (int i = 0; i < tasks.size(); ++i) {
            String from = tasks.get(i).getId();
            if (i + 1 == tasks.size()) break;
            String to = tasks.get(i + 1).getId();
            ServiceComposerLink link = new ServiceComposerLink();
            link.setId(LINK + UUID.randomUUID().toString().replaceAll("-", "_"));
            link.setFrom(from);
            link.setTo(to);
            if (Objects.equals(ServiceComposerTaskTypeEnum.Decision.toString(), tasks.get(i).getType())) {
                link.setName("\u662f");
                link.setType(ServiceComposerTaskTypeEnum.Decision.toString());
                link.setCaseExpression("$(detectedData).length > 0");
                ServiceComposerLink endLink = new ServiceComposerLink();
                endLink.setId(LINK + UUID.randomUUID().toString().replaceAll("-", "_"));
                endLink.setFrom(from);
                endLink.setTo(tasks.get(tasks.size() - 1).getId());
                endLink.setName("\u5426");
                endLink.setType(ServiceComposerTaskTypeEnum.Decision.toString());
                links.add(endLink);
            } else {
                link.setType("Link");
            }
            links.add(link);
        }
        return links;
    }

    private String getStartScript(Sets sets) throws DWBusinessException {
        boolean isArray = false;
        String dataName = "purchase_info";
        SystemPart sPart = sets.getS().getPart();
        String detectType = sPart.getDetectType();
        if (StringUtils.equalsIgnoreCase((CharSequence)MonitorRuleCategoryEnum.API.toString(), (CharSequence)detectType)) {
            String tenantId = AthenaUtils.getTenantId();
            ApiDataFieldMetadataDTO actionResponse = this.kgService.getActionResponse(sPart.getActionId(), tenantId, sets.getVersion());
            if (actionResponse != null) {
                isArray = actionResponse.getIs_array();
                dataName = actionResponse.getData_name();
            }
        }
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var scWorkflowModelContext = $(scWorkflowModelContext);\n").append(" var detectedDataKey = Object.keys(scWorkflowModelContext.requestParams)[0];\n");
        if (StringUtils.equalsIgnoreCase((CharSequence)DetectType.SQL.toString(), (CharSequence)detectType)) {
            codeBuilder.append(" var dataNew = [];\n");
        }
        if (isArray) {
            codeBuilder.append(" var detectedData = scWorkflowModelContext.requestParams[detectedDataKey][0].").append(dataName).append(";\n");
        } else {
            codeBuilder.append(" var detectedData = scWorkflowModelContext.requestParams[detectedDataKey];\n");
        }
        codeBuilder.append(" for (var i = 0; i < detectedData.length; i++) {\n");
        if (StringUtils.equalsIgnoreCase((CharSequence)DetectType.SQL.toString(), (CharSequence)detectType)) {
            codeBuilder.append(" var newDataItem ={};\n").append(" Object.keys(detectedData[i]).forEach( function(key){ \n if(key.toUpperCase()==key){ \n         newDataItem[key.toLocaleLowerCase()] = detectedData[i][key];\n } else{ \n        newDataItem[key] = detectedData[i][key];\n }     }); \n").append(" newDataItem.remark = '';\n").append(" newDataItem.adjust = true;\n").append(" newDataItem.sourceIds = '\u667a\u80fd\u8c03\u53c2';\n").append(" newDataItem.charge_id = '1';\n").append(" newDataItem.performer_id = '1';\n").append(" dataNew.push(newDataItem);\n").append(" }\n").append("return {").append("\n").append("\"processVariable\": {").append("\n");
            codeBuilder.append("\"detectedData\":dataNew").append("\n");
        } else {
            codeBuilder.append(" detectedData[i].remark = '';\n").append(" detectedData[i].adjust = true;\n").append(" detectedData[i].sourceIds = '\u667a\u80fd\u8c03\u53c2';\n").append(" detectedData[i].charge_id = '1';\n").append(" detectedData[i].performer_id = '1';\n").append(" }\n").append("return {").append("\n").append("\"processVariable\": {").append("\n");
            codeBuilder.append("\"detectedData\":detectedData").append("\n");
        }
        codeBuilder.append("}};").append("\n");
        return codeBuilder.toString();
    }

    private String getDataSetScript(String fieldName) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append(" var detectedData = $(detectedData);\n").append(" for (var i = 0; i < detectedData.length; i++) {\n").append(" detectedData[i].charge_id = detectedData[i].").append(fieldName).append(";\n").append(" }\n").append("return {").append("\n").append("\"processVariable\": {").append("\n").append("\"detectedData\":detectedData").append("\n").append("}};").append("\n");
        return codeBuilder.toString();
    }

    private String getDataFroupScript(String value) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var detectedData = $(detectedData);").append("\n").append(" var groupedData = {};\n").append(" var output = [];\n").append(" for (var i = 0; i < detectedData.length; i++) {\n").append(" var customer_id = detectedData[i].").append(value).append("\n").append(" if (!groupedData[customer_id]) {\n").append(" groupedData[customer_id] = [];\n").append(" }\n").append(" groupedData[customer_id].push(detectedData[i]);\n").append(" }\n").append(" for (var key in groupedData) {\n").append(" if (groupedData.hasOwnProperty(key)) {\n").append(" var obj = {};\n").append(" obj[\"data\"] = groupedData[key];\n").append(" output.push(obj)\n").append(" }\n").append(" }\n").append("return {").append("\n").append("\"processVariable\": {").append("\n").append("\"detectedData\":output").append("\n").append("}};").append("\n");
        return codeBuilder.toString();
    }

    private String getFilterScript(String condition) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var detectedData = $(detectedData);").append("\n").append("var filteredData = detectedData.filter(function(data) {").append("\n").append("var result = ").append(condition).append(";").append("\n").append(" return result;").append("\n").append("});").append("\n").append("detectedData = filteredData;").append("\n").append("return {").append("\n").append("\"processVariable\": {").append("\n").append("\"detectedData\":detectedData").append("\n").append("}};").append("\n");
        return codeBuilder.toString();
    }

    private String getHttpScript(String setsCode, String isGroup, Processor personInCharge) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var dispatchData = [];").append("\n");
        if (Objects.equals(isGroup, "1")) {
            codeBuilder.append("var d = $(data);").append("\n").append(" dispatchData = d.data;").append("\n");
        } else {
            codeBuilder.append("dispatchData = $(detectedData);").append("\n");
        }
        codeBuilder.append("var requesterId = ");
        if ("field".equalsIgnoreCase(personInCharge.getType())) {
            codeBuilder.append("dispatchData[0].charge_id;").append("\n");
        } else {
            codeBuilder.append("'").append(personInCharge.getValue()).append("';\n");
        }
        codeBuilder.append("var variables = {};").append("\n").append("variables.charge_id = requesterId;").append("\n").append("var request = {").append("\n").append("\"projectCode\":'").append("ProjectBySet_" + setsCode).append("',").append("\n").append("\"dispatchData\": dispatchData").append(",").append("\n").append("\"variables\": variables").append(",").append("\n");
        if ("field".equalsIgnoreCase(personInCharge.getType()) || "user".equalsIgnoreCase(personInCharge.getType())) {
            codeBuilder.append("\"requesterId\":requesterId,").append("\n");
        }
        codeBuilder.append("\"locale\":\"zh_CN\",").append("\n").append("\"startDataStateCode\":'").append(setsCode + "_start").append("'\n").append("};").append("\n").append("return request;").append("\n");
        return codeBuilder.toString();
    }

    private String getHttpEocScript(String fieldName) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var d = $(data);").append("\n").append("var empId = d.").append(fieldName).append(";\n").append("var request = {").append("\n").append("\"empId\":empId").append("\n").append("};").append("\n").append("return request;").append("\n");
        return codeBuilder.toString();
    }

    private String getHttpEocResponseScript(String fieldName) {
        StringBuilder codeBuilder = new StringBuilder();
        codeBuilder.append("var response = $(response);\n").append("var detectedData = $(detectedData);").append("\n").append("var d = $(data);").append("\n").append("var empId = d.").append(fieldName).append(";\n").append("if (response.code  === 200)").append("\n").append("{").append("\n").append("detectedData.forEach(function(item) {\n").append("if (item.").append(fieldName).append("== empId)").append("\n").append("{").append("\n").append(" item.charge_id").append("= response.data;").append("\n").append("}").append("\n").append("});\n").append("} else {").append("\n").append("detectedData.forEach(function(item) {\n").append("if (item.").append(fieldName).append("== empId) {").append("\n").append(" item.charge_id").append("= empId;").append("\n").append("}").append("\n").append("});\n").append("}").append("\n").append("  return {\n    \"processVariable\": {\n      \"detectedData\": detectedData\n  }\n  };");
        return codeBuilder.toString();
    }

    private void publishTemplate(String dsl) {
        try {
            HashMap<String, String> requestMap = new HashMap<String, String>();
            requestMap.put("dsl", dsl);
            requestMap.put("tenantId", null);
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            headers.add("token", AthenaUtils.getHeaderToken());
            headers.add("routerKey", AthenaUtils.getTenantId());
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
            ResponseEntity result = this.restTemplate.exchange(this.scdispatcherUrl + PUBLISH_URL, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            if (result.getStatusCodeValue() != 200) {
                log.error("publishTemplate failed");
            }
        }
        catch (Exception e) {
            log.error("publishTemplate failed,error:{}", (Throwable)e);
        }
    }

    public static void main(String[] args) throws DWBusinessException {
        String emailName = String.format("\u4e1a\u52a1\u8fc7\u7a0b\u968f\u5fc3\u63a7%s\u90ae\u4ef6\u901a\u77e5", "123");
        String projectCode = "projectCode";
        String code = "limit1";
        String tenantId = "tenantId";
        StringBuilder sb = new StringBuilder();
        sb.append("var detectedData = $(detectedData);").append("\n").append("var receivers = [];").append("\n").append("var lang = {'zh_CN':'").append(emailName).append("','zh_TW':'").append(emailName).append("','en_US':'").append(emailName).append("'};").append("\n").append("var activities = [{'taskId': '").append(projectCode).append("', 'activityId':").append("null").append("}];\n").append("for (var i=0;i<detectedData.length;i++) {").append("\n").append("var item=detectedData[i];").append("if(item.").append(code).append(" && !receivers.some(e => item.").append(code).append(" == e)){").append("\n").append("receivers.push(item.").append(code).append(")}};").append("\n").append("var request = {").append("\n").append("'receiveStaff' : receivers,").append("\n").append("'activityList' : activities,").append("\n").append("'tenantId':'").append(tenantId).append("',").append("\n").append("'appCode':'").append("appcode").append("',").append("\n").append("'emailName':lang,").append("\n").append("'description':lang,").append("\n").append("'type':'").append(1).append("',").append("\n").append("'state':'").append(1).append("',").append("\n").append("'updateBy':'").append("userId").append("',").append("\n").append("'langName':'$(processLocale)'").append(",").append("\n").append("'previewId':'").append("previewId").append("'\n").append("}").append("\n").append("return request;");
        System.out.println(sb);
    }
}

