/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.set.partParsers;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.set.IOperateParser;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.set.part.Part;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OperatePartParser
implements IOperateParser {
    private static final Logger log = LoggerFactory.getLogger(OperatePartParser.class);
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplate;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;

    @Override
    public boolean accept(SetParseContext context) {
        return StringUtils.equalsIgnoreCase((CharSequence)"delete", (CharSequence)context.getCurrentSet().getOperate());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        this.updateTenantMonitorRuleStatus("MonitorRuleBySet_" + context.getCurrentSet().getCode());
    }

    private void updateTenantMonitorRuleStatus(String ruleId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        query.addCriteria((CriteriaDefinition)criteria);
        List monitorRuleTenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        try {
            if (!CollectionUtils.isEmpty((Collection)monitorRuleTenantConfigList)) {
                for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
                    this.monitorRuleConfigService.putDisable(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap());
                }
            }
        }
        catch (Exception e) {
            log.error("Sets updateTenantMonitorRuleStatus error: {}", (Throwable)e);
        }
    }
}

