/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.set.partParsers;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.digiwin.athena.kg.monitorRule.DynamicCondition;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.kg.monitorRule.StandardPollingRule;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.RuleDO;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.rule.model.MonitorRuleCategoryEnum;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.KgProductService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.knowledgegraph.set.IPartParser;
import com.digiwin.athena.knowledgegraph.set.PartParserService;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.knowledgegraph.set.SetsRelatedInfo;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.set.Acting;
import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.factor.Factor;
import com.digiwin.athena.set.part.DataUnderstandingPart;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.SystemPart;
import com.digiwin.athena.set.part.TaskCardPart;
import com.digiwin.athena.set.part.ThresholdEvaluatePart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SystemPartParser
implements IPartParser {
    private static final Logger log = LoggerFactory.getLogger(SystemPartParser.class);
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    CacService cacService;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    PartParserService partParserService;
    @Autowired
    ActionService actionService;
    @Autowired
    KgProductService productService;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase((CharSequence)"System", (CharSequence)part.getType());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        this.buildSetsAndParts(context, part);
    }

    public Object buildSetsAndParts(SetParseContext context, Part part) throws DWBusinessException {
        Sets sets = context.getCurrentSet();
        if (null != sets) {
            String productName;
            String tenantId = AthenaUtils.getTenantId();
            String tenantVersion = sets.getVersion();
            SetsRelatedInfo setsRelatedInfo = new SetsRelatedInfo();
            String setsCode = sets.getCode();
            String appCode = sets.getAppCode();
            String appName = sets.getAppName();
            String ruleId = "MonitorRuleBySet_" + setsCode;
            String ruleName = sets.getName() + "_\u4fa6\u6d4b";
            this.deleteIfPresent(context, appCode, setsCode, ruleId, tenantVersion);
            if (Objects.equals(sets.getOperate(), "delete")) {
                this.updateTenantMonitorRuleStatus(ruleId);
                return null;
            }
            String detectType = sets.getS().getPart().getDetectType();
            String string = productName = StringUtils.isNotEmpty((CharSequence)sets.getS().getPart().getConnectionObject()) ? sets.getS().getPart().getConnectionObject() : this.getTenantProduct();
            if (StringUtil.isEmpty((CharSequence)detectType)) {
                this.saveMonitorRule(sets, ruleId, ruleName, tenantVersion, productName);
            } else {
                MonitorRule monitorRule = new MonitorRule();
                monitorRule.setId(ruleId);
                monitorRule.setName(ruleName);
                monitorRule.setVersion(tenantVersion);
                monitorRule.setProductName(productName);
                this.partParserService.parseMonitorRulePart(monitorRule, sets);
            }
            List returnFields = sets.getS().getPart().getReturnFields();
            if (!CollectionUtils.isEmpty((Collection)returnFields)) {
                context.setReturnFieldAll(returnFields);
            }
            this.buildVariableDefinition(setsRelatedInfo, sets, ruleId, ruleName, tenantVersion, productName);
            this.buildApplicationRelation(setsRelatedInfo, setsCode, appCode, appName, ruleId, ruleName, tenantVersion);
            this.buildSetsAndPart(setsRelatedInfo, sets);
            this.saveSetsRelatedInfo(setsRelatedInfo);
            List<String> tenantIds = this.createMonitorRelation(appCode, ruleId);
            this.saveMonitorRuleByTeanant(tenantIds, ruleId, productName);
            HashMap<String, String> profile = new HashMap<String, String>();
            profile.put("tenantId", tenantId);
            DWServiceContext.getContext().setProfile(profile);
        }
        return "success";
    }

    private void saveSetsRelatedInfo(SetsRelatedInfo setsRelatedInfo) throws DWBusinessException {
        String setsRelatedInfoStr = this.translateUtils.translateContent(setsRelatedInfo);
        SetsRelatedInfo relatedInfo = (SetsRelatedInfo)JSON.parseObject((String)setsRelatedInfoStr, SetsRelatedInfo.class);
        this.mongoTemplateSystem.save((Object)relatedInfo.getSets());
        this.mongoTemplateSystem.save((Object)relatedInfo.getSPart(), "parts");
        this.mongoTemplateSystem.save((Object)relatedInfo.getAPart(), "parts");
        this.mongoTemplateSystem.save((Object)relatedInfo.getUPart(), "parts");
        this.mongoTemplateSystem.save((Object)relatedInfo.getPPart(), "parts");
        this.mongoTemplateSystem.save((Object)relatedInfo.getApplicationRelation());
        this.mongoTemplateSystem.save((Object)relatedInfo.getVariableDefinition());
    }

    private void deleteIfPresent(SetParseContext context, String appCode, String setsCode, String ruleId, String tenantVersion) {
        if (StringUtils.isNotEmpty((CharSequence)setsCode)) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)setsCode).and("version").is((Object)tenantVersion));
            Sets oldSets = (Sets)this.mongoTemplateSystem.findOne(query, Sets.class);
            if (oldSets != null) {
                this.deleteSetsAndPart(oldSets, query, tenantVersion);
                context.setExists(true);
            }
            this.deleteMonitorRule(setsCode, tenantVersion);
            this.deleteApplicationRelation(appCode, ruleId, tenantVersion);
            this.deleteVariableDefinition(ruleId, tenantVersion);
        }
    }

    private void buildSetsAndPart(SetsRelatedInfo setsRelatedInfo, Sets sets) throws DWBusinessException {
        String sPartId = "part_s_" + UUID.randomUUID().toString().replace("-", "");
        String aPartId = "part_a_" + UUID.randomUUID().toString().replace("-", "");
        String uPartId = "part_u_" + UUID.randomUUID().toString().replace("-", "");
        String pPartId = "part_p_" + UUID.randomUUID().toString().replace("-", "");
        String infoStr = this.translateUtils.translateContent(sets);
        Sets tempSets = (Sets)JSON.parseObject((String)JSON.toJSONString((Object)(sets = (Sets)JSON.parseObject((String)infoStr, Sets.class))), Sets.class);
        if (null != tempSets.getS() && null != tempSets.getS().getPart()) {
            SystemPart sPart = tempSets.getS().getPart();
            sPart.setPartId(sPartId);
            sPart.setVersion(sets.getVersion());
            sPart.setAthena_namespace(sets.getAppCode());
            sPart.setPluginId(sets.getCode());
            setsRelatedInfo.setSPart(sPart);
            SystemPart systemPart = new SystemPart();
            systemPart.setPartId(sPartId);
            tempSets.getS().setPart(systemPart);
        }
        if (null != tempSets.getA() && null != tempSets.getA().getPart()) {
            TaskCardPart aPart = tempSets.getA().getPart();
            aPart.setPartId(aPartId);
            aPart.setVersion(sets.getVersion());
            aPart.setAthena_namespace(sets.getAppCode());
            aPart.setPluginId(sets.getCode());
            setsRelatedInfo.setAPart(aPart);
            TaskCardPart taskCardPart = new TaskCardPart();
            taskCardPart.setPartId(aPartId);
            tempSets.getA().setPart(taskCardPart);
        }
        if (null != tempSets.getU() && null != tempSets.getU().getPart()) {
            DataUnderstandingPart uPart = tempSets.getU().getPart();
            uPart.setPartId(uPartId);
            uPart.setVersion(sets.getVersion());
            uPart.setAthena_namespace(sets.getAppCode());
            uPart.setPluginId(sets.getCode());
            setsRelatedInfo.setUPart(uPart);
            DataUnderstandingPart dataUnderstandingPart = new DataUnderstandingPart();
            dataUnderstandingPart.setPartId(uPartId);
            tempSets.getU().setPart(dataUnderstandingPart);
        }
        if (null != tempSets.getP() && null != tempSets.getP().getPart()) {
            ThresholdEvaluatePart pPart = tempSets.getP().getPart();
            pPart.setPartId(pPartId);
            pPart.setVersion(sets.getVersion());
            pPart.setAthena_namespace(sets.getAppCode());
            pPart.setPluginId(sets.getCode());
            setsRelatedInfo.setPPart(pPart);
            ThresholdEvaluatePart thresholdEvaluatePart = new ThresholdEvaluatePart();
            thresholdEvaluatePart.setPartId(pPartId);
            tempSets.getP().setPart(thresholdEvaluatePart);
        }
        tempSets.setPluginId(sets.getCode());
        tempSets.setAthena_namespace(sets.getAppCode());
        setsRelatedInfo.setSets(tempSets);
    }

    private void deleteSetsAndPart(Sets oldSets, Query query, String tenantVersion) {
        Query query1;
        this.mongoTemplateSystem.remove(query, Sets.class);
        if (oldSets.getS() != null && oldSets.getS().getPart() != null && StringUtils.isNotEmpty((CharSequence)oldSets.getS().getPart().getPartId())) {
            query1 = Query.query((CriteriaDefinition)Criteria.where((String)"partId").is((Object)oldSets.getS().getPart().getPartId()).and("version").is((Object)tenantVersion));
            this.mongoTemplateSystem.remove(query1, "parts");
        }
        if (oldSets.getA() != null && oldSets.getA().getPart() != null && StringUtils.isNotEmpty((CharSequence)oldSets.getA().getPart().getPartId())) {
            query1 = Query.query((CriteriaDefinition)Criteria.where((String)"partId").is((Object)oldSets.getA().getPart().getPartId()).and("version").is((Object)tenantVersion));
            this.mongoTemplateSystem.remove(query1, "parts");
        }
        if (oldSets.getU() != null && oldSets.getU().getPart() != null && StringUtils.isNotEmpty((CharSequence)oldSets.getU().getPart().getPartId())) {
            query1 = Query.query((CriteriaDefinition)Criteria.where((String)"partId").is((Object)oldSets.getU().getPart().getPartId()).and("version").is((Object)tenantVersion));
            this.mongoTemplateSystem.remove(query1, "parts");
        }
        if (oldSets.getP() != null && oldSets.getP().getPart() != null && StringUtils.isNotEmpty((CharSequence)oldSets.getP().getPart().getPartId())) {
            query1 = Query.query((CriteriaDefinition)Criteria.where((String)"partId").is((Object)oldSets.getP().getPart().getPartId()).and("version").is((Object)tenantVersion));
            this.mongoTemplateSystem.remove(query1, "parts");
        }
    }

    private void saveMonitorRule(Sets sets, String ruleId, String ruleName, String tenantVersion, String productName) {
        if (sets.getS() == null || sets.getS().getPart() == null) {
            return;
        }
        SystemPart sPart = sets.getS().getPart();
        String jsonString = "CREATE (m:MonitorRule{actionType:'task',code:$code,autoRun:true,pluginId:$pluginId,name:$name,actionCommonId:$actionCommonId,standardPollingRule:$standardPollingRule,type:'SQL_SCRIPT',category:'SQL_SCRIPT',version:$version,athena_namespace:$athena_namespace})";
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("code", ruleId);
        props.put("pluginId", sets.getCode());
        props.put("name", ruleName);
        props.put("actionCommonId", "ProjectBySet_" + sets.getCode());
        props.put("standardPollingRule", JSON.toJSONString((Object)sPart.getStandard_polling_rule()));
        props.put("version", tenantVersion);
        props.put("athena_namespace", sets.getAppCode());
        this.kgHelpService.executeCyhper(jsonString, props);
        MonitorRuleProductConfig monitorRuleProductConfig = new MonitorRuleProductConfig();
        monitorRuleProductConfig.setMonitorRuleId(ruleId);
        monitorRuleProductConfig.setProductName(productName);
        monitorRuleProductConfig.setVersion(tenantVersion);
        monitorRuleProductConfig.setPluginId(sets.getCode());
        monitorRuleProductConfig.setIsPollingIds(Boolean.FALSE);
        monitorRuleProductConfig.setDbName(sPart.getTargetDataBase());
        monitorRuleProductConfig.setDynamicParams(this.getDynamicParams());
        String script = this.getScript(sets);
        monitorRuleProductConfig.setScript(script);
        monitorRuleProductConfig.setAthena_namespace(sets.getAppCode());
        this.mongoTemplateSystem.save((Object)monitorRuleProductConfig);
    }

    private List<String> createMonitorRelation(String appCode, String ruleId) {
        List<String> tenantIds = new ArrayList<String>();
        List tenantIdDatas = this.cacService.getAllEffectiveTenantAndAppInfo(appCode).getList();
        if (!CollectionUtils.isEmpty((Collection)tenantIdDatas)) {
            tenantIds = tenantIdDatas.stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
        }
        return tenantIds;
    }

    private void saveMonitorRuleByTeanant(List<String> tenantIds, String ruleId, String product) {
        if (CollectionUtils.isEmpty(tenantIds)) {
            return;
        }
        for (String id : tenantIds) {
            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setMonitorRuleId(ruleId);
            config.setTenantId(id);
            config.setProductName(product);
            config.setStatus(1);
            try {
                this.monitorRuleConfigService.post(config);
            }
            catch (Exception e) {
                log.error("buildSetsAndParts call post method error : {}", (Throwable)e);
            }
        }
    }

    private List<DynamicParamsDO> getDynamicParams() {
        ArrayList<DynamicParamsDO> dynamicParams = new ArrayList<DynamicParamsDO>();
        DynamicParamsDO sParam = new DynamicParamsDO();
        sParam.setParam_target("SQL_SCRIPT");
        sParam.setParam_name("startTime_s");
        sParam.setSource_name("last_monitor_time");
        sParam.setParam_type("DATE_TIME");
        RuleDO sRule = new RuleDO();
        sRule.setAdd_day("0");
        sRule.setPeriod("DAY");
        sRule.setTime_type("START");
        sRule.setRange("0");
        sRule.setDay("0");
        sParam.setRule(sRule);
        DynamicParamsDO eParam = new DynamicParamsDO();
        eParam.setParam_target("SQL_SCRIPT");
        eParam.setParam_name("startTime_e");
        eParam.setSource_name("monitor_time");
        eParam.setParam_type("DATE_TIME");
        RuleDO eRule = new RuleDO();
        eRule.setAdd_day("0");
        eRule.setPeriod("DAY");
        eRule.setTime_type("END");
        eRule.setRange("0");
        eRule.setDay("0");
        eParam.setRule(eRule);
        dynamicParams.add(sParam);
        dynamicParams.add(eParam);
        return dynamicParams;
    }

    private String getScript(Sets sets) {
        if (sets.getS() == null && sets.getS().getPart() == null) {
            return "";
        }
        SystemPart sPart = sets.getS().getPart();
        String targetColumn = "";
        String riskWarningDays = "0";
        String riskWarningDaysUnit = "DAY";
        String bufferDays = "0";
        String bufferDaysUnit = "DAY";
        List factorList = sets.getFactors();
        for (Factor factor : factorList) {
            String code = factor.getCode();
            if ("preScheuleDate".equals(code)) {
                targetColumn = factor.getValue();
                continue;
            }
            if ("riskWarningPart".equals(code)) {
                riskWarningDays = factor.getValue();
                riskWarningDaysUnit = factor.getUnit();
                continue;
            }
            if (!"bufferPart".equals(code)) continue;
            bufferDays = factor.getValue();
            bufferDaysUnit = factor.getUnit();
        }
        String columnKeyString = this.getColumnKeyString(sets);
        String firstData = "";
        firstData = StringUtils.isNotEmpty((CharSequence)columnKeyString) && columnKeyString.contains(",") ? columnKeyString.split(",")[0] : columnKeyString;
        String sql = "";
        sql = StringUtils.isEmpty((CharSequence)bufferDays) || StringUtils.isEmpty((CharSequence)bufferDaysUnit) ? String.format("SELECT %s FROM %s WHERE DATEADD(%s, -%s, %s) >= @#{startTime_s} AND DATEADD(%s, -%s, %s) <= @#{startTime_e}", columnKeyString + "," + targetColumn + "," + firstData + " as sourceIds ", sPart.getTargetTable(), riskWarningDaysUnit.toLowerCase(), riskWarningDays, targetColumn, riskWarningDaysUnit.toLowerCase(), riskWarningDays, targetColumn) : String.format("SELECT %s FROM %s WHERE DATEADD(%s, -%s, DATEADD(%s, -%s, %s)) >= @#{startTime_s} AND DATEADD(%s, -%s, DATEADD(%s, -%s, %s)) <= @#{startTime_e}", columnKeyString + "," + targetColumn + "," + firstData + " as sourceIds ", sPart.getTargetTable(), riskWarningDaysUnit.toLowerCase(), riskWarningDays, bufferDaysUnit.toLowerCase(), bufferDays, targetColumn, riskWarningDaysUnit.toLowerCase(), riskWarningDays, bufferDaysUnit.toLowerCase(), bufferDays, targetColumn);
        return sql;
    }

    private String getTimeType(SystemPart sPart) {
        String timeType = "day";
        if (sPart.getStandard_polling_rule() == null) {
            return timeType;
        }
        Integer frequency = sPart.getStandard_polling_rule().getFrequency();
        Integer weekly = sPart.getStandard_polling_rule().getWeekly();
        Integer monthly = sPart.getStandard_polling_rule().getMonthly();
        if (weekly != null) {
            timeType = "week";
        } else if (monthly != null) {
            timeType = "month";
        } else {
            switch (frequency) {
                case 1: {
                    timeType = "minute";
                    break;
                }
                case 2: {
                    timeType = "hour";
                    break;
                }
                default: {
                    timeType = "day";
                }
            }
        }
        return timeType;
    }

    private String getColumnKeyString(Sets sets) {
        if (sets.getA() == null || sets.getA().getPart() == null) {
            return "";
        }
        Set keys = Optional.ofNullable(sets.getA()).map(Acting::getPart).map(TaskCardPart::getPageViewDESC).orElse(Collections.emptyList()).stream().flatMap(pg -> Optional.ofNullable(pg.getColumn()).orElse(Collections.emptyList()).stream()).flatMap(column -> column.keySet().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        return String.join((CharSequence)",", keys);
    }

    private void deleteMonitorRule(String ruleId, String tenantVersion) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pluginId", ruleId);
        param.put("version", tenantVersion);
        String deleteCyhper = "match(m:MonitorRule{pluginId:$pluginId,version:$version}) detach delete m";
        this.kgHelpService.executeCyhper(deleteCyhper, param);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)ruleId).and("version").is((Object)tenantVersion));
        this.mongoTemplateSystem.remove(query, MonitorRuleProductConfig.class);
    }

    private void buildApplicationRelation(SetsRelatedInfo setsRelatedInfo, String setsCode, String appCode, String appName, String ruleId, String ruleName, String tenantVersion) {
        ApplicationRelation applicationRelation = new ApplicationRelation();
        applicationRelation.setAppCode(appCode);
        applicationRelation.setAppName(appName);
        applicationRelation.setCode(ruleId);
        applicationRelation.setType("monitorRule");
        applicationRelation.setName(ruleName);
        applicationRelation.setVersion(tenantVersion);
        applicationRelation.setApplication(appCode);
        applicationRelation.setAthena_namespace(appCode);
        applicationRelation.setPluginId(setsCode);
        applicationRelation.setTenantId("SYSTEM");
        setsRelatedInfo.setApplicationRelation(applicationRelation);
    }

    private void deleteApplicationRelation(String appCode, String ruleId, String tenantVersion) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode).and("version").is((Object)tenantVersion).and("code").is((Object)ruleId));
        this.mongoTemplateSystem.remove(query, ApplicationRelation.class);
    }

    private void buildVariableDefinition(SetsRelatedInfo setsRelatedInfo, Sets sets, String ruleId, String ruleName, String tenantVersion, String productName) {
        StandardPollingRule rules = sets.getS().getPart().getStandard_polling_rule();
        String detectType = sets.getS().getPart().getDetectType();
        String timeType = this.getDefaultValue(rules);
        VariableDefinition variableDefinition = new VariableDefinition();
        variableDefinition.setName(ruleName);
        variableDefinition.setDescription(ruleName);
        variableDefinition.setIsExecute(Boolean.TRUE);
        variableDefinition.setCode(ruleId);
        variableDefinition.setForceOpen(Boolean.FALSE);
        variableDefinition.setIsOperation(Boolean.FALSE);
        variableDefinition.setDefaultValue(timeType);
        variableDefinition.setExtendData(ruleId);
        variableDefinition.setFormat("rule;yyyyMMdd HH:mm;switch");
        variableDefinition.setReadOnly(Boolean.FALSE);
        variableDefinition.setRequired(Boolean.TRUE);
        variableDefinition.setExecutable(1);
        variableDefinition.setSequence(1);
        variableDefinition.setDisplayType("PERIODIC");
        variableDefinition.setCategory("period");
        variableDefinition.setIsSimulation(Boolean.FALSE);
        variableDefinition.setVersion(tenantVersion);
        variableDefinition.setAthena_namespace(sets.getAppCode());
        variableDefinition.setPluginId(sets.getCode());
        if (!StringUtils.equalsIgnoreCase((CharSequence)MonitorRuleCategoryEnum.API.toString(), (CharSequence)detectType)) {
            DynamicCondition visibleCondition = new DynamicCondition();
            visibleCondition.setType("SINGLE");
            visibleCondition.setOp("IN");
            visibleCondition.setLeft("productName");
            visibleCondition.setLeftValueType("SYSTEM");
            visibleCondition.setRightValueType("CONSTANT");
            visibleCondition.setRight(productName);
            variableDefinition.setVisibleCondition(visibleCondition);
        }
        setsRelatedInfo.setVariableDefinition(variableDefinition);
    }

    private String getDefaultValue(StandardPollingRule rules) {
        String timeType = "";
        if (null != rules.getRepeat_type()) {
            if (rules.getRepeat_type() == 1) {
                timeType = "F";
            }
            if (rules.getRepeat_type() == 2) {
                timeType = "H";
            }
            if (rules.getRepeat_type() == 3) {
                timeType = "D";
            }
            timeType = timeType + rules.getFrequency();
        } else if (rules.getWeekly() != null) {
            HashMap<String, String> week = new HashMap<String, String>();
            week.put("SU", "7");
            week.put("MO", "1");
            week.put("TU", "2");
            week.put("WE", "3");
            week.put("TH", "4");
            week.put("FR", "5");
            week.put("SA", "6");
            timeType = "W" + (String)week.get(rules.getByday());
        } else if (rules.getMonthly() != null) {
            timeType = "M" + rules.getBymonthday();
        }
        return timeType + ";" + rules.getStart_time().substring(0, 16).replaceAll("-", "") + ";" + Boolean.TRUE;
    }

    private void deleteVariableDefinition(String ruleId, String tenantVersion) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"code").is((Object)ruleId).and("version").is((Object)tenantVersion));
        this.mongoTemplateSystem.remove(query, VariableDefinition.class);
    }

    public String getTenantProduct() {
        try {
            List<String> tenantProductList = this.actionService.getTenantProductList();
            if (!CollectionUtils.isEmpty(tenantProductList)) {
                List productName = (List)this.productService.getAllSteadyProduct();
                String s = productName.stream().filter(e -> tenantProductList.contains(e)).findFirst().orElse("E10");
                return s;
            }
        }
        catch (Exception e2) {
            log.error("Sets getTenantProduct error:{}", (Throwable)e2);
        }
        return "E10";
    }

    private void updateTenantMonitorRuleStatus(String ruleId) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"monitorRuleId").is((Object)ruleId);
        query.addCriteria((CriteriaDefinition)criteria);
        List monitorRuleTenantConfigList = this.mongoTemplate.find(query, MonitorRuleTenantConfig.class);
        try {
            if (!CollectionUtils.isEmpty((Collection)monitorRuleTenantConfigList)) {
                for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
                    this.monitorRuleConfigService.putDisable(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap());
                }
            }
        }
        catch (Exception e) {
            log.error("Sets  updateTenantMonitorRuleStatus error: {}", (Throwable)e);
        }
    }
}

