/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.set.partParsers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.DataDescription;
import com.digiwin.athena.domain.core.DataState;
import com.digiwin.athena.domain.core.Phase;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.StateMap;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.flow.FlowGraph;
import com.digiwin.athena.domain.core.flow.FlowLink;
import com.digiwin.athena.domain.core.flow.FlowNode;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.domain.definition.AssignConfig;
import com.digiwin.athena.domain.definition.AtmcData;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.domain.definition.ProjectTarget;
import com.digiwin.athena.domain.definition.UserDefinition;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.set.AssistanMetadata;
import com.digiwin.athena.knowledgegraph.set.DTDRelatedInfo;
import com.digiwin.athena.knowledgegraph.set.IPartParser;
import com.digiwin.athena.knowledgegraph.set.SetParseContext;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import com.digiwin.athena.set.part.PageViewDESC;
import com.digiwin.athena.set.part.Part;
import com.digiwin.athena.set.part.Processor;
import com.digiwin.athena.set.part.TaskCardPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TaskCardPartParser
implements IPartParser {
    private static final Logger log = LoggerFactory.getLogger(TaskCardPartParser.class);
    @Autowired
    DataMapService dataMapService;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Override
    public boolean accept(Part part) {
        return StringUtils.equalsIgnoreCase((CharSequence)"taskCard", (CharSequence)part.getType());
    }

    @Override
    public void parse(SetParseContext context, Part part) throws DWBusinessException {
        HashMap<String, Object> dtdRelatedInfoMap = new HashMap<String, Object>();
        TaskCardPart taskCardPart = (TaskCardPart)part;
        DTDRelatedInfo dtdRelatedInfo = new DTDRelatedInfo();
        context.setDtdRelatedInfo(dtdRelatedInfo);
        this.buildDataDescriptionAndDataState(context, taskCardPart);
        this.buildPageView(context, taskCardPart);
        this.buildTask(context, taskCardPart);
        this.buildProject(context, taskCardPart);
        this.buildAppRelation(context);
        log.info("before translateContent:{}", (Object)context.getDtdRelatedInfo());
        String infoStr = this.translateUtils.translateContent(JSON.parseObject((String)JSON.toJSONString((Object)context.getDtdRelatedInfo(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), DTDRelatedInfo.class));
        dtdRelatedInfoMap.put("dtdRelatedInfo", JSON.parseObject((String)infoStr, DTDRelatedInfo.class));
        this.dataMapService.requestDataMap("/set/saveDtdRelatedInfo", "post", dtdRelatedInfoMap);
    }

    private void buildAppRelation(SetParseContext context) {
        String pluginId = context.getCurrentSet().getCode();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"pluginId").is((Object)pluginId));
        this.mongoTemplateSystem.remove(query, "applicationRelation");
        ArrayList<ApplicationRelation> lists = new ArrayList<ApplicationRelation>();
        DTDRelatedInfo dtdRelatedInfo = context.getDtdRelatedInfo();
        Project project = dtdRelatedInfo.getProject();
        ApplicationRelation applicationRelation = new ApplicationRelation();
        applicationRelation.setCode(project.getCode());
        applicationRelation.setName(project.getName());
        applicationRelation.setType("task");
        applicationRelation.setAppCode(context.getCurrentSet().getAppCode());
        applicationRelation.setPluginId(pluginId);
        applicationRelation.setVersion("1.0");
        lists.add(applicationRelation);
        List<Task> taskList = dtdRelatedInfo.getTaskList();
        for (Task task : taskList) {
            ApplicationRelation applicationRelation1 = new ApplicationRelation();
            applicationRelation1.setCode(task.getCode());
            applicationRelation1.setName(task.getName());
            applicationRelation1.setType("activity");
            applicationRelation1.setAppCode(context.getCurrentSet().getAppCode());
            applicationRelation1.setPluginId(pluginId);
            applicationRelation1.setVersion("1.0");
            lists.add(applicationRelation1);
        }
        this.mongoTemplateSystem.insert(lists, "applicationRelation");
    }

    private void buildDataDescriptionAndDataState(SetParseContext context, TaskCardPart part) {
        DataDescription dataDescription = new DataDescription();
        dataDescription.setCode(context.getCurrentSet().getCode());
        dataDescription.setTenantId("SYSTEM");
        dataDescription.setApplication(context.getCurrentSet().getAppCode());
        dataDescription.setVersion("1.0");
        FieldDescription dataStruct = new FieldDescription();
        dataStruct.setDataType("OBJECT");
        dataStruct.setKey("sets_task_data");
        dataStruct.setFields(this.getFields(part));
        dataDescription.setDataStruct(dataStruct);
        dataDescription.setUniKeys(this.getUnKeys(part));
        dataDescription.setPluginId(context.getCurrentSet().getCode());
        ArrayList<DataState> dataStateList = new ArrayList<DataState>();
        DataState dataState = new DataState();
        dataState.setTenantId("SYSTEM");
        dataState.setApplication(context.getCurrentSet().getAppCode());
        dataState.setVersion("1.0");
        dataState.setCode(context.getCurrentSet().getCode() + "_1");
        dataState.setDataCode(dataDescription.getCode());
        dataState.setName("\u5f85\u6267\u884c");
        dataState.setPluginId(context.getCurrentSet().getCode());
        DataState dataState2 = new DataState();
        dataState2.setTenantId("SYSTEM");
        dataState2.setApplication(context.getCurrentSet().getAppCode());
        dataState2.setVersion("1.0");
        dataState2.setCode(context.getCurrentSet().getCode() + "_2");
        dataState2.setDataCode(dataDescription.getCode());
        dataState2.setName("\u5df2\u6267\u884c");
        dataState2.setPluginId(context.getCurrentSet().getCode());
        dataStateList.add(dataState);
        dataStateList.add(dataState2);
        context.getDtdRelatedInfo().setDataDescription(dataDescription);
        context.getDtdRelatedInfo().setDataStateList(dataStateList);
        context.getDtdRelatedInfo().setFrom(dataState.getCode());
        context.getDtdRelatedInfo().setTo(dataState2.getCode());
        context.getDtdRelatedInfo().setProjectInitDataState(dataState);
        context.getDtdRelatedInfo().setProjectEndDataState(dataState2);
    }

    private List<String> getUnKeys(TaskCardPart part) {
        ArrayList<String> unKeys = new ArrayList<String>();
        List pageViewDESCList = part.getPageViewDESC();
        if (!CollectionUtils.isEmpty((Collection)pageViewDESCList)) {
            PageViewDESC pageViewDESC = (PageViewDESC)pageViewDESCList.get(0);
            List columnList = pageViewDESC.getColumn();
            for (Map map : columnList) {
                FieldDescription fieldDescription = new FieldDescription();
                fieldDescription.setDataType("STRING");
                Set keySet = map.keySet();
                String key = (String)keySet.iterator().next();
                unKeys.add(key);
            }
        }
        return unKeys;
    }

    private List<FieldDescription> getFields(TaskCardPart part) {
        ArrayList<FieldDescription> list = new ArrayList<FieldDescription>();
        List pageViewDESCList = part.getPageViewDESC();
        if (!CollectionUtils.isEmpty((Collection)pageViewDESCList)) {
            PageViewDESC pageViewDESC = (PageViewDESC)pageViewDESCList.get(0);
            List columnList = pageViewDESC.getColumn();
            for (Map map : columnList) {
                FieldDescription fieldDescription = new FieldDescription();
                fieldDescription.setDataType("STRING");
                Set keySet = map.keySet();
                String key = (String)keySet.iterator().next();
                fieldDescription.setKey(key);
                fieldDescription.setName(String.valueOf(map.get(key)));
                list.add(fieldDescription);
            }
        }
        return list;
    }

    private Project buildProject(SetParseContext context, TaskCardPart part) {
        Project project = new Project();
        project.setTenantId("SYSTEM");
        project.setApplication(context.getCurrentSet().getAppCode());
        project.setVersion("1.0");
        project.setPluginId(context.getCurrentSet().getCode());
        project.setCode("ProjectBySet_" + context.getCurrentSet().getCode());
        project.setName(this.getTaskCardName(part));
        project.setDescription(this.getTaskCardName(part));
        project.setType("BUSINESS");
        project.setExecuteType("user");
        project.setPresetVariables(Arrays.asList(new Identity[0]));
        project.setMerge(Boolean.valueOf(false));
        project.setAssignConfig(this.getAssignConfig());
        project.setAtmcDatas(this.atmcDatas());
        ProjectTarget projectTarget = new ProjectTarget();
        projectTarget.setName(this.getTaskCardName(part));
        projectTarget.setCode("ProjectBySet_" + context.getCurrentSet().getCode());
        project.setTarget(projectTarget);
        project.setEnd(context.getDtdRelatedInfo().getProjectEndDataState());
        project.setInit(context.getDtdRelatedInfo().getProjectInitDataState());
        project.setPersonInCharge(this.getUserDefinition(part.getProcessor()));
        project.setPhases(this.getPhases(context.getDtdRelatedInfo().getTaskList()));
        project.setMainLineTasks(this.getMainLineTask(context.getDtdRelatedInfo().getTaskList()));
        project.setSourceName((Object)"sets_task_data");
        project.setSourceEntityName("sets_task_data");
        project.setAssignAble(Boolean.valueOf(true));
        context.getDtdRelatedInfo().setProject(project);
        return project;
    }

    private List<String> getMainLineTask(List<Task> tasks) {
        List<String> collect = tasks.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        return collect;
    }

    private List<Phase> getPhases(List<Task> tasks) {
        ArrayList<Phase> phases = new ArrayList<Phase>();
        for (Task task : tasks) {
            Phase phase = new Phase();
            phase.setCode(task.getCode());
            phase.setName(task.getName());
            phase.setTaskCodes(Arrays.asList(task.getCode()));
            phases.add(phase);
        }
        return phases;
    }

    private void buildTask(SetParseContext context, TaskCardPart part) throws DWBusinessException {
        List<Activity> activities = this.buildActivity(context, part);
        FlowGraph flowGraph = this.buildFlow(context, activities);
        List<PageView> pageViews = context.getDtdRelatedInfo().getPageViewList();
        if (CollectionUtils.isEmpty(pageViews)) {
            throw new DWBusinessException("PageView is empty");
        }
        PageView pageView = pageViews.get(0);
        Task task = new Task();
        task.setTenantId("SYSTEM");
        task.setApplication(context.getCurrentSet().getAppCode());
        task.setVersion("1.0");
        task.setPluginId(context.getCurrentSet().getCode());
        task.setCode(context.getCurrentSet().getCode());
        task.setPattern("BUSINESS_ASSISTAN");
        task.setType("business");
        task.setExecuteType("manual");
        task.setFlowCode(flowGraph.getCode());
        task.setPageCode(pageView.getCode());
        task.setMerge(Boolean.valueOf(false));
        task.setCategory("ASSISTAN");
        task.setMilestone(Boolean.valueOf(true));
        task.setPriority(Integer.valueOf(0));
        task.setName(this.getTaskCardName(part));
        task.setFrom(Arrays.asList(context.getDtdRelatedInfo().getFrom()));
        task.setTo(Arrays.asList(context.getDtdRelatedInfo().getTo()));
        StateMap stateMap = new StateMap();
        stateMap.setInput(context.getDtdRelatedInfo().getFrom());
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("end0", context.getDtdRelatedInfo().getTo());
        stateMap.setOutput(output);
        task.setStateMaps(Arrays.asList(stateMap));
        task.setAssignConfig(this.getAssignConfig());
        task.setAtmcDatas(this.atmcDatas());
        context.getDtdRelatedInfo().setTaskList(Arrays.asList(task));
        context.getDtdRelatedInfo().setFlowGraphList(Arrays.asList(flowGraph));
        context.getDtdRelatedInfo().setActivityList(activities);
    }

    private List<AtmcData> atmcDatas() {
        ArrayList<AtmcData> atmcDatas = new ArrayList<AtmcData>();
        AtmcData atmcData = new AtmcData();
        atmcData.setProVarKey("personInCharge");
        atmcData.setAthenaKey("personInCharge");
        atmcDatas.add(atmcData);
        AtmcData atmcData2 = new AtmcData();
        atmcData2.setProVarKey("dueDate");
        atmcData2.setAthenaKey("dueDate");
        atmcDatas.add(atmcData2);
        AtmcData atmcData3 = new AtmcData();
        atmcData3.setProVarKey("sourceIds");
        atmcData3.setAthenaKey("sourceIds");
        atmcDatas.add(atmcData3);
        AtmcData atmcData5 = new AtmcData();
        atmcData5.setProVarKey("ASSISTAN_WAITTING");
        atmcData5.setAthenaKey("ASSISTAN_WAITTING");
        atmcDatas.add(atmcData5);
        AtmcData atmcData6 = new AtmcData();
        atmcData6.setProVarKey("ASSISTAN_FINISHED");
        atmcData6.setAthenaKey("ASSISTAN_FINISHED");
        atmcDatas.add(atmcData6);
        AtmcData atmcData7 = new AtmcData();
        atmcData7.setProVarKey("ASSISTAN_METADATA");
        atmcData7.setAthenaKey("ASSISTAN_METADATA");
        atmcDatas.add(atmcData7);
        return atmcDatas;
    }

    private AssignConfig getAssignConfig() {
        String assignConfigStr = "{\"action\":{\"sequence\":0,\"actionParams\":[{\"name\":\"liable_person_info\",\"type\":\"PROCESS_VARIABLE\",\"value\":\"question_info\"}],\"actionId\":\"esp_transfer.principal.info.update\",\"title\":\"\u66f4\u65b0\u4efb\u52a1\",\"type\":\"ESP\",\"serviceName\":\"transfer.principal.info.update\"},\"assignAble\":true}";
        AssignConfig assignConfig = (AssignConfig)JSON.parseObject((String)assignConfigStr, AssignConfig.class);
        return assignConfig;
    }

    private String getTaskCardName(TaskCardPart part) {
        String title = null;
        List pageViewDESC = part.getPageViewDESC();
        if (!CollectionUtils.isEmpty((Collection)pageViewDESC)) {
            title = ((PageViewDESC)pageViewDESC.get(0)).getTitle();
        }
        return title == null ? "\u5957\u4ef6\u4efb\u52a1" : title;
    }

    private FlowGraph buildFlow(SetParseContext context, List<Activity> activitys) {
        FlowGraph flowGraph = new FlowGraph();
        flowGraph.setCode(context.getCurrentSet().getCode());
        flowGraph.setTenantId("SYSTEM");
        flowGraph.setVersion("1.0");
        flowGraph.setPluginId(context.getCurrentSet().getCode());
        flowGraph.setApplication(context.getCurrentSet().getAppCode());
        flowGraph.setLinks(new ArrayList());
        flowGraph.setNodes(new ArrayList());
        String startNodeId = "start_" + context.getCurrentSet().getCode();
        String endNodeId = "end_" + context.getCurrentSet().getCode();
        FlowNode start = new FlowNode();
        start.setId(startNodeId);
        start.setType("start");
        flowGraph.getNodes().add(start);
        FlowNode endNode = new FlowNode();
        endNode.setId(endNodeId);
        endNode.setDataKey("end0");
        endNode.setType("end");
        flowGraph.getNodes().add(endNode);
        String from = startNodeId;
        for (Activity activity : activitys) {
            FlowNode endNode2 = new FlowNode();
            endNode2.setId(activity.getCode());
            endNode2.setActivityCode(activity.getCode());
            endNode2.setName(activity.getName());
            endNode2.setType("activity");
            flowGraph.getNodes().add(endNode2);
            FlowLink flowLink = new FlowLink();
            flowLink.setFrom(from);
            flowLink.setTo(activity.getCode());
            flowGraph.getLinks().add(flowLink);
            from = activity.getCode();
        }
        FlowLink flowLink2 = new FlowLink();
        flowLink2.setFrom(from);
        flowLink2.setTo(endNodeId);
        flowGraph.getLinks().add(flowLink2);
        return flowGraph;
    }

    private List<Activity> buildActivity(SetParseContext context, TaskCardPart part) {
        Activity activity0 = new Activity();
        activity0.setTenantId("SYSTEM");
        activity0.setApplication(context.getCurrentSet().getAppCode());
        activity0.setVersion("1.0");
        activity0.setPluginId(context.getCurrentSet().getCode());
        activity0.setCode(context.getCurrentSet().getCode() + "_1");
        activity0.setType("script");
        activity0.setName("\u83b7\u53d6\u6570\u636e\u6765\u6e90");
        activity0.setMilestone(Boolean.valueOf(false));
        HashMap<String, Object> config = new HashMap<String, Object>();
        HashMap<String, String> scriptMode = new HashMap<String, String>();
        scriptMode.put("responseScript", this.getResponseScript(context, part));
        config.put("scriptMode", scriptMode);
        config.put("executionMode", "script");
        activity0.setConfig(config);
        Activity activity = new Activity();
        activity.setTenantId("SYSTEM");
        activity.setApplication(context.getCurrentSet().getAppCode());
        activity.setVersion("1.0");
        activity.setPluginId(context.getCurrentSet().getCode());
        activity.setCode(context.getCurrentSet().getCode() + "_2");
        activity.setType("manual");
        activity.setName("\u624b\u52a8");
        activity.setExecutor(this.getUserDefinition(part.getProcessor()));
        activity.setMilestone(Boolean.valueOf(true));
        ArrayList<Activity> lists = new ArrayList<Activity>();
        lists.add(activity0);
        lists.add(activity);
        return lists;
    }

    private String getSourceIdKey(TaskCardPart part) {
        List pageViewDESCList = part.getPageViewDESC();
        if (!CollectionUtils.isEmpty((Collection)pageViewDESCList)) {
            PageViewDESC pageViewDESC = (PageViewDESC)pageViewDESCList.get(0);
            List columnList = pageViewDESC.getColumn();
            for (Map map : columnList) {
                if (map.isEmpty()) continue;
                Set keySet = map.keySet();
                return (String)keySet.iterator().next();
            }
        }
        return "";
    }

    private AssistanMetadata getAssistanMetadataFields(TaskCardPart part) {
        ArrayList<AssistanMetadata> list = new ArrayList<AssistanMetadata>();
        List pageViewDESCList = part.getPageViewDESC();
        if (!CollectionUtils.isEmpty((Collection)pageViewDESCList)) {
            PageViewDESC pageViewDESC = (PageViewDESC)pageViewDESCList.get(0);
            List columnList = pageViewDESC.getColumn();
            for (Map map : columnList) {
                AssistanMetadata fieldDescription = new AssistanMetadata();
                fieldDescription.setData_type("string");
                Set keySet = map.keySet();
                String key = (String)keySet.iterator().next();
                fieldDescription.setData_name(key);
                fieldDescription.setDescription(String.valueOf(map.get(key)));
                fieldDescription.setIs_businesskey(true);
                fieldDescription.setRequired(true);
                fieldDescription.setIs_array(false);
                list.add(fieldDescription);
            }
        }
        AssistanMetadata assistanMetadata = new AssistanMetadata();
        assistanMetadata.setData_name("render_array");
        assistanMetadata.setDescription(this.getTaskCardName(part));
        assistanMetadata.setIs_array(true);
        assistanMetadata.setField(list);
        assistanMetadata.setData_type("object");
        assistanMetadata.setIs_businesskey(false);
        assistanMetadata.setRequired(true);
        AssistanMetadata assistanMetadata0 = new AssistanMetadata();
        assistanMetadata0.setData_name("render_obj");
        assistanMetadata0.setDescription(this.getTaskCardName(part));
        assistanMetadata0.setIs_array(false);
        assistanMetadata0.setField(Arrays.asList(assistanMetadata));
        assistanMetadata0.setData_type("object");
        assistanMetadata0.setIs_businesskey(false);
        assistanMetadata0.setRequired(true);
        String infoStr = null;
        try {
            infoStr = this.translateUtils.translateContent(JSON.parseObject((String)JSON.toJSONString((Object)assistanMetadata0, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}), AssistanMetadata.class));
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        AssistanMetadata assistanMetadata1 = (AssistanMetadata)JSON.parseObject(infoStr, AssistanMetadata.class);
        return assistanMetadata1;
    }

    private String getResponseScript(SetParseContext context, TaskCardPart part) {
        StringBuilder sb = new StringBuilder();
        sb.append("var ASSISTAN_WAITTING = $(data); \n").append("var ASSISTAN_FINISHED = []; \n").append("var ASSISTAN_METADATA = ").append(JSON.toJSONString((Object)this.getAssistanMetadataFields(part))).append(";\n").append("var sourceIdKey = '").append(this.getSourceIdKey(part)).append("';\n").append("var sourceIdArray = []; \n").append("ASSISTAN_WAITTING.forEach(function (dat) {\n").append("var sourceId = dat[sourceIdKey]; \n").append("sourceIdArray.push(sourceId);\n").append("});\n").append("var sourceIds = sourceIdArray.join(\",\"); \n").append("return {\n").append("'success': true,\n").append("'processVariable': {\n").append("'ASSISTAN_WAITTING': ASSISTAN_WAITTING,").append("\n").append("'ASSISTAN_FINISHED': ASSISTAN_FINISHED,").append("\n").append("'ASSISTAN_METADATA': ASSISTAN_METADATA,").append("\n").append("'sourceIds': sourceIds,").append("\n").append(" },\n").append("'errorMessage': '' \n").append("};");
        return sb.toString();
    }

    private void buildPageView(SetParseContext context, TaskCardPart part) {
        ArrayList<PageView> pageViewList = new ArrayList<PageView>();
        String scriptTemplate = AthenaUtils.loadStream("/sets/PageView.json");
        List pageViewDESC = part.getPageViewDESC();
        if (!CollectionUtils.isEmpty((Collection)pageViewDESC)) {
            for (PageViewDESC pg : pageViewDESC) {
                String replaced = scriptTemplate.replaceAll("#template_prefix#", context.getCurrentSet().getCode()).replaceAll("#appCode#", context.getCurrentSet().getAppCode()).replaceAll("#name#", context.getCurrentSet().getName()).replaceAll("#title#", pg.getTitle() == null ? "" : pg.getTitle());
                pageViewList.add((PageView)JSON.parseObject((String)replaced, PageView.class));
            }
        }
        context.getDtdRelatedInfo().setPageViewList(pageViewList);
    }

    private UserDefinition getUserDefinition(Processor processor) {
        UserDefinition userDefinition = new UserDefinition();
        userDefinition.setChoosePolicy("single");
        userDefinition.setProcessType("signOr");
        Identity identity = new Identity();
        identity.setPerformerType(processor.getType());
        identity.setPerformerValue((Object)processor.getValue());
        identity.setPerformerName(processor.getName());
        userDefinition.setIdentities(Arrays.asList(identity));
        return userDefinition;
    }
}

