/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.spi;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.knowledgegraph.dto.apimgmt.AdvanceSearchConditions;
import com.digiwin.athena.knowledgegraph.dto.apimgmt.ApiAdvanceSearchInfo;
import com.digiwin.athena.knowledgegraph.dto.apimgmt.ApiAdvanceSearchResponse;
import com.digiwin.athena.knowledgegraph.dto.apimgmt.ApiMgmtBaseInfo;
import com.digiwin.athena.knowledgegraph.dto.apimgmt.ApiMgmtCondition;
import com.digiwin.athena.knowledgegraph.dto.apimgmt.ApiMgmtDeleteModel;
import com.digiwin.athena.knowledgegraph.dto.apimgmt.ApiMgmtUpdateModel;
import com.digiwin.athena.knowledgegraph.support.BusinessException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApimgmtService {
    private static final Logger log = LoggerFactory.getLogger(ApimgmtService.class);
    @Value(value="${apimgmtUrl}")
    private String apimgmtUrl;
    @Value(value="${envMode}")
    private String envMode;

    public void publishActionMeataDataToApimgmt(JSONArray publishActionMetaDataInfo, String token) {
        if (publishActionMetaDataInfo == null) {
            log.info("publishActionMeataDataToApimgmt, publishActionMetaDataInfo is null");
            return;
        }
        log.info("----------------\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
        List<ApiMgmtBaseInfo> apiMgmtBaseInfos = this.dealApiMgmtProcessSave(publishActionMetaDataInfo, token);
        log.info("----------------\u5f00\u59cb\u4fdd\u5b58\u6570\u636e--\u5b8c\u6210");
        log.info("----------------\u5f00\u59cb\u9001\u5ba1");
        this.dealApiMgmtProcessUpdate(apiMgmtBaseInfos, token);
        log.info("----------------\u9001\u5ba1\u5b8c\u6210--\u5b8c\u6210");
        if (!this.envMode.equals("HuaweiTest-TEST") && !this.envMode.equals("AliTest-PAAS")) {
            log.info("--------------\u9700\u8981\u5b9a\u7248--\u5f00\u59cb\u5b9a\u7248--\u5b9a\u7248");
            this.dealApiMgmtProcessConfirmed(apiMgmtBaseInfos, token);
            log.info("----------------\u5b9a\u7248\u5b8c\u6210--\u5b8c\u6210");
        }
        log.info("update api mgmt success, apiName is list");
    }

    private void dealApiMgmtProcessConfirmed(List<ApiMgmtBaseInfo> apiUpdateList, String token) {
        if (CollUtil.isEmpty(apiUpdateList)) {
            log.info("update api mgmt apiUpdateList is null, not need to Confirmed");
            return;
        }
        ApiMgmtUpdateModel apiMgmtUpdateModel = new ApiMgmtUpdateModel();
        apiMgmtUpdateModel.setApiList(apiUpdateList);
        String jsonUpdateRequest = JSON.toJSONString((Object)apiMgmtUpdateModel);
        String domain = this.apimgmtUrl;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String confirmedUrl = domain + "/restful/standard/apimgmt/ApiComfirmed/Update";
        log.info("apiConfirmedUpdate api mgmt request is -->{}", (Object)jsonUpdateRequest);
        String confirmedResponse = ((HttpRequest)HttpUtil.createPost((String)confirmedUrl).addHeaders(headers)).body(jsonUpdateRequest).execute().body();
        log.info("apiConfirmedUpdate api mgmt response is -->{}", (Object)confirmedResponse);
        JSONObject jsonObjectUpdateResponse = JSON.parseObject((String)confirmedResponse);
        JSONObject responseUpdate = jsonObjectUpdateResponse.getJSONObject("response");
        String updateCode = responseUpdate.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(confirmedResponse);
        }
    }

    private void dealApiMgmtProcessUpdate(List<ApiMgmtBaseInfo> apiUpdateList, String token) {
        if (CollUtil.isEmpty(apiUpdateList)) {
            log.info("update api mgmt apiUpdateList is null, no need to update");
            return;
        }
        String domain = this.apimgmtUrl;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String updateUrl = domain + "/restful/standard/apimgmt/ApiReview/Update";
        ApiMgmtUpdateModel apiMgmtUpdateModel = new ApiMgmtUpdateModel();
        apiMgmtUpdateModel.setApiList(apiUpdateList);
        String jsonUpdateRequest = JSON.toJSONString((Object)apiMgmtUpdateModel);
        log.info("update api mgmt request is -->{}", (Object)jsonUpdateRequest);
        String updateResponse = ((HttpRequest)HttpUtil.createPost((String)updateUrl).body(jsonUpdateRequest).addHeaders(headers)).execute().body();
        log.info("update api mgmt update response is -->{}", (Object)updateResponse);
        JSONObject jsonObjectUpdateResponse = JSON.parseObject((String)updateResponse);
        JSONObject responseUpdate = jsonObjectUpdateResponse.getJSONObject("response");
        String updateCode = responseUpdate.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(updateResponse);
        }
    }

    private List<ApiMgmtBaseInfo> dealApiMgmtProcessSave(JSONArray publishActionMetaDataInfo, String token) {
        if (publishActionMetaDataInfo == null) {
            log.info("publishActionMeataDataToApimgmt, publishActionMetaDataInfo is null");
            return new ArrayList<ApiMgmtBaseInfo>();
        }
        String domain = this.apimgmtUrl;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        ArrayList<ApiMgmtBaseInfo> apiUpdateList = new ArrayList<ApiMgmtBaseInfo>();
        for (int i = 0; i < publishActionMetaDataInfo.size(); ++i) {
            ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
            JSONObject jsonObject = publishActionMetaDataInfo.getJSONObject(i);
            JSONObject apiMgmtModelSaveJson = jsonObject.getJSONObject("apiMgmtModelSave");
            if (apiMgmtModelSaveJson == null) continue;
            String tenantId = apiMgmtModelSaveJson.getString("tenantId");
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                apiMgmtModelSaveJson.remove((Object)"tenantId");
            }
            String apiName = jsonObject.getString("apiName");
            String version = jsonObject.getString("version");
            if (null == version) {
                version = "1.0";
            }
            apiMgmtBaseInfo.setApiName(apiName);
            this.dealApiMgmtDelete(apiName, version, token);
            apiMgmtBaseInfo.setVersion(version);
            log.info(apiName + "\u6ca1\u6709\u6570\u636e\uff0c\u7b2c\u4e00\u6b21\u4fdd\u5b58");
            this.dealApiMgmtSave(apiMgmtModelSaveJson, version, token);
            apiUpdateList.add(apiMgmtBaseInfo);
        }
        return apiUpdateList;
    }

    private void dealApiMgmtDelete(String apiName, String version, String token) {
        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setVersion(version);
        ArrayList<ApiMgmtBaseInfo> apiList = new ArrayList<ApiMgmtBaseInfo>();
        apiList.add(apiMgmtBaseInfo);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String domain = this.apimgmtUrl;
        String deleteUrl = domain + "/restful/standard/apimgmt/ApiDelete/Delete";
        ApiMgmtUpdateModel apiMgmtApiDelete = new ApiMgmtUpdateModel();
        apiMgmtApiDelete.setApiList(apiList);
        apiMgmtApiDelete.setStatusId(3);
        String jsonRetrieveApi = JSON.toJSONString((Object)apiMgmtApiDelete);
        log.info("ApiDelete api mgmt request is -->{}", (Object)jsonRetrieveApi);
        String deleteApiResponse = ((HttpRequest)HttpUtil.createPost((String)deleteUrl).body(jsonRetrieveApi).addHeaders(headers)).execute().body();
        log.info("ApiDelete api mgmt response is -->{}", (Object)deleteApiResponse);
        JSONObject jsonObjectResponse = JSON.parseObject((String)deleteApiResponse);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(deleteApiResponse);
        }
        log.info("\u5220\u9664\u6210\u529f, apiName is -->{}", (Object)apiName);
    }

    private String getApiVersion(String apiName, String token) {
        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setTenantId("");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String domain = this.apimgmtUrl;
        String getVersionUrl = domain + "/restful/standard/apimgmt/ApiVersion/Get";
        String jsonStringRequest = JSON.toJSONString((Object)apiMgmtBaseInfo);
        log.info("get version api mgmt request is -->{}", (Object)jsonStringRequest);
        String response = ((HttpRequest)HttpUtil.createPost((String)getVersionUrl).addHeaders(headers)).body(jsonStringRequest).execute().body();
        log.info("get version api mgmt response is -->{}", (Object)response);
        JSONObject jsonObjectResponse = JSON.parseObject((String)response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }
        String version = response1.getString("version");
        return version;
    }

    private void dealApiMgmtRetrieve(String apiName, String version, String token) {
        ApiMgmtUpdateModel apiMgmtRetrieveModel = new ApiMgmtUpdateModel();
        ArrayList<ApiMgmtBaseInfo> apiList = new ArrayList<ApiMgmtBaseInfo>();
        ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
        apiMgmtBaseInfo.setApiName(apiName);
        apiMgmtBaseInfo.setVersion(version);
        apiList.add(apiMgmtBaseInfo);
        apiMgmtRetrieveModel.setApiList(apiList);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String domain = this.apimgmtUrl;
        String retrieveUrl = domain + "/restful/standard/apimgmt/ApiSpecRetrieve/Update";
        String jsonStringRequest = JSON.toJSONString((Object)apiMgmtRetrieveModel);
        log.info("retrieve api mgmt request is -->{}", (Object)jsonStringRequest);
        String response = ((HttpRequest)HttpUtil.createPost((String)retrieveUrl).addHeaders(headers)).body(jsonStringRequest).execute().body();
        log.info("retrieve api mgmt response is -->{}", (Object)response);
        JSONObject jsonObjectResponse = JSON.parseObject((String)response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }
        log.info("retrieve api mgmt success, apiName is -->{}", (Object)apiName);
    }

    private void dealApiMgmtSave(JSONObject apiMgmtModelSaveJson, String version, String token) {
        apiMgmtModelSaveJson.put("apiVersion", (Object)version);
        String apiName = apiMgmtModelSaveJson.getString("apiName");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String domain = this.apimgmtUrl;
        String saveUrl = domain + "/restful/standard/apimgmt/ApiSpec/Save";
        String jsonStringRequest = JSON.toJSONString((Object)apiMgmtModelSaveJson);
        log.info("save api mgmt request is -->{}", (Object)jsonStringRequest);
        String response = ((HttpRequest)HttpUtil.createPost((String)saveUrl).addHeaders(headers)).body(jsonStringRequest).execute().body();
        log.info("save api mgmt response is -->{}", (Object)response);
        JSONObject jsonObjectResponse = JSON.parseObject((String)response);
        JSONObject response1 = jsonObjectResponse.getJSONObject("response");
        String code = response1.getString("code");
        if (!"000".equals(code)) {
            throw new BusinessException(response);
        }
        log.info("\u4fdd\u5b58\u6210\u529f, apiName is -->{}", (Object)apiName);
    }

    public void deleteActionMeataDataInApimgmt(JSONObject publishActionMetaDataInfo, String token) {
        if (publishActionMetaDataInfo == null) {
            log.info("deleteActionMeataDataInApimgmt, publishActionMetaDataInfo is null");
            return;
        }
        String domain = this.apimgmtUrl;
        String uri = domain + "/restful/standard/apimgmt/ApiDelete/Delete";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        ApiMgmtDeleteModel apiMgmtDeleteModel = new ApiMgmtDeleteModel();
        ArrayList<ApiMgmtBaseInfo> list = new ArrayList<ApiMgmtBaseInfo>();
        JSONArray jsonArray = publishActionMetaDataInfo.getJSONArray("apiList");
        if (jsonArray == null || jsonArray.size() == 0) {
            log.info("dpublishActionMetaDataInfo.getJSONArray is null");
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ApiMgmtBaseInfo apiMgmtBaseInfo = new ApiMgmtBaseInfo();
            String apiName = jsonObject.getString("apiName");
            ApiAdvanceSearchInfo apiAdvanceSearchInfo = this.queryApiVersionAndStatus(apiName, token);
            if (apiAdvanceSearchInfo == null) continue;
            int approvedStatusCode = apiAdvanceSearchInfo.getApprovedStatusCode();
            if (4 == approvedStatusCode) {
                log.info("do not delete confirmed api , apiName is = {}", (Object)apiName);
                continue;
            }
            apiMgmtBaseInfo.setApiName(apiName);
            apiMgmtBaseInfo.setVersion(apiAdvanceSearchInfo.getVersion());
            list.add(apiMgmtBaseInfo);
        }
        apiMgmtDeleteModel.setStatusId(1);
        apiMgmtDeleteModel.setApiList(list);
        String jsonStringRequest = JSON.toJSONString((Object)apiMgmtDeleteModel);
        log.info("deleteActionMeataDataInApimgmt api mgmt request is -->{}", (Object)jsonStringRequest);
        String response = ((HttpRequest)HttpUtil.createPost((String)uri).addHeaders(headers)).body(jsonStringRequest).execute().body();
        log.info("deleteActionMeataDataInApimgmt api mgmt response is -->{}", (Object)response);
        JSONObject jsonObjectDelResponse = JSON.parseObject((String)response);
        JSONObject responseDel = jsonObjectDelResponse.getJSONObject("response");
        String updateCode = responseDel.getString("code");
        if (!"000".equals(updateCode)) {
            throw new BusinessException(response);
        }
        log.info("delete api mgmt success");
    }

    private ApiAdvanceSearchInfo queryApiVersionAndStatus(String apiName, String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("token", token);
        headers.put("Content-Type", "application/json");
        String domain = this.apimgmtUrl;
        String advanceSearchUrl = domain + "/restful/standard/apimgmt/AdvanceSearchApiList/Get";
        ArrayList<ApiMgmtCondition> apiMgmtConditions = new ArrayList<ApiMgmtCondition>();
        ApiMgmtCondition apiMgmtCondition = new ApiMgmtCondition();
        apiMgmtCondition.setCondition("apiName");
        apiMgmtCondition.setEquation("equal");
        apiMgmtCondition.setContent(apiName);
        apiMgmtConditions.add(apiMgmtCondition);
        AdvanceSearchConditions advanceSearchConditions = new AdvanceSearchConditions();
        advanceSearchConditions.setConditionList(apiMgmtConditions);
        String advanceSearchRequest = JSON.toJSONString((Object)advanceSearchConditions);
        log.info("advanceSearch api mgmt request is -->{}", (Object)advanceSearchRequest);
        String advanceSearchResponse = ((HttpRequest)HttpUtil.createPost((String)advanceSearchUrl).addHeaders(headers)).body(advanceSearchRequest).execute().body();
        log.info("advanceSearch api mgmt response is -->{}", (Object)advanceSearchResponse);
        int status = 0;
        List<Object> apiAdvanceSearchList = new ArrayList();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ApiAdvanceSearchResponse apiAdvanceSearchResponse = (ApiAdvanceSearchResponse)objectMapper.readValue(advanceSearchResponse, (TypeReference)new TypeReference<ApiAdvanceSearchResponse>(){});
            status = apiAdvanceSearchResponse.getStatus();
            apiAdvanceSearchList = apiAdvanceSearchResponse.getResponse();
        }
        catch (Exception exception) {
            log.info("get apiName is nothing!!!!!");
            return null;
        }
        if (status != 200) {
            throw new BusinessException(advanceSearchResponse);
        }
        if (CollUtil.isEmpty(apiAdvanceSearchList)) {
            return null;
        }
        return (ApiAdvanceSearchInfo)apiAdvanceSearchList.get(0);
    }
}

