/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.support;

import com.digiwin.athena.kg.action.Abstraction;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.knowledgegraph.domain2.base.AbsEntityDict;
import com.digiwin.athena.knowledgegraph.domain2.base.Dimension;
import com.digiwin.athena.knowledgegraph.repoSystem.AbsEntityDictRepository;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class AbstractionHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractionHandler.class);
    @Autowired
    AbsEntityDictRepository absRepo;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    public void dealWithAbstraction(Object obj, Dimension dimension) {
        if (obj == null || ServiceUtils.isPrimitive(obj.getClass()) || Dimension.isNull(dimension)) {
            return;
        }
        Class<?> c = obj.getClass();
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            for (Object o : collection) {
                this.dealWithAbstraction(o, dimension);
            }
        } else if (obj.getClass().isArray()) {
            Object[] arr;
            for (Object o : arr = (Object[])obj) {
                this.dealWithAbstraction(o, dimension);
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Object o : map.values()) {
                this.dealWithAbstraction(o, dimension);
            }
        } else {
            List fields = ServiceUtils.getFields(obj.getClass());
            for (Field f : fields) {
                f.setAccessible(true);
                try {
                    Object o = f.get(obj);
                    this.dealWithAbstraction(o, dimension);
                }
                catch (IllegalAccessException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (obj instanceof Abstraction) {
                Abstraction abs = (Abstraction)obj;
                this.innerDo(abs, dimension);
            }
        }
    }

    public void innerDo(Abstraction abs, Dimension dimension) {
        if (null == abs.getDimension() || null == abs.getKey() || 0 == abs.getDimension()) {
            return;
        }
        AbsEntityDict dict = this.getDict(abs, dimension);
        if (null != dict && null != dict.getAbstraction()) {
            AbstractionHandler.cloneAbs(abs, dict.getAbstraction());
        }
    }

    private AbsEntityDict getDict(Abstraction abs, Dimension dimension) {
        AbsEntityDict result = null;
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"category").is((Object)abs.getClass().getSimpleName()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"key").is((Object)abs.getKey()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)1));
        if ((Abstraction.tenant & abs.getDimension()) > 0) {
            Assert.notNull((Object)dimension.getTenant(), (String)"\u79df\u6237id\u4e0d\u80fd\u4f4d\u7a7a!");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)dimension.getTenant()));
        }
        if ((Abstraction.product & abs.getDimension()) > 0) {
            Assert.notNull((Object)dimension.getProduct(), (String)"\u4ea7\u54c1\u4e0d\u80fd\u4f4d\u7a7a!");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"product").is((Object)dimension.getProduct()));
        }
        if ((Abstraction.unit & abs.getDimension()) > 0) {
            Assert.notEmpty(dimension.getUnit(), (String)"\u8fd0\u8425\u5355\u5143\u4e0d\u80fd\u4f4d\u7a7a!");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"unit").is(dimension.getUnit()));
        }
        result = (AbsEntityDict)((Object)this.mongoTemplate.findOne(query, AbsEntityDict.class));
        return result;
    }

    private static void cloneAbs(Object abs, Object absNew) {
        List fields = ServiceUtils.getFields(abs.getClass());
        for (Field f : fields) {
            f.setAccessible(true);
            try {
                Object newValue = f.get(absNew);
                if (null == newValue) continue;
                f.set(abs, newValue);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

