/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.support.custom;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismContext;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismAchiveRecord;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismFormula2;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismOld;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismScene;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.TaskMechanismConfig;
import com.digiwin.athena.knowledgegraph.repo.MechanismAchiveRecordRepository;
import com.digiwin.athena.knowledgegraph.repoSystem.AbsEntityDictRepository;
import com.digiwin.athena.knowledgegraph.service.impl.MechanismService;
import com.digiwin.athena.knowledgegraph.support.MechanismCustomer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SupplierChooseCustomer
implements MechanismCustomer {
    private Log log = LogFactory.getLog(SupplierChooseCustomer.class);
    @Autowired
    private MechanismService mechanismService;
    @Autowired
    MechanismAchiveRecordRepository mechanismAchiveRecordRepository;
    @Autowired(required=false)
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateTenant;
    @Autowired
    AbsEntityDictRepository absEntityDictRepository;
    @Autowired
    SessionFactory sessionFactory;

    @Override
    public boolean accept(MechanismContext context) {
        return context != null && "mechanism_SupplierChoose".equalsIgnoreCase(context.getMechanismKey());
    }

    @Override
    public Object notifyChange(MechanismContext context) throws DWBusinessException {
        if (null == context.getKey()) {
            this.log.warn((Object)"config key  is null");
            return null;
        }
        if (null == context.getTaskId()) {
            this.log.warn((Object)"config taskId  is null");
            return null;
        }
        MechanismOld me = this.mechanismService.getDetail(context.getTenant(), context.getMechanismKey());
        if (null != me && null != me.getScenes()) {
            String key = context.getKey();
            String taskId = context.getTaskId();
            for (MechanismScene sc : me.getScenes()) {
                if (!key.equals(sc.getKey())) continue;
                MechanismFormula2 formula2 = sc.getFormula();
                if (null == formula2) break;
                MechanismAchiveRecord dict1 = new MechanismAchiveRecord();
                dict1.setMechanismKey(context.getMechanismKey());
                dict1.setKey(taskId);
                dict1.setTenantId(context.getTenant());
                dict1.setRecordStatus(0);
                dict1.setKey(taskId);
                dict1.setInstanceId(context.getInstanceId());
                dict1.setValue((Object)formula2);
                this.mongoTemplateTenant.save((Object)dict1);
                break;
            }
        }
        return null;
    }

    @Override
    public Object notifyApproveSuccess(MechanismContext context) throws DWBusinessException {
        MechanismAchiveRecord record = context.getRecord();
        Session session = this.sessionFactory.openSession();
        MechanismOld me = this.mechanismService.getDetail(context.getTenant(), context.getMechanismKey());
        MechanismFormula2 newF = (MechanismFormula2)((Object)JSON.parseObject((String)JSON.toJSONString((Object)record.getValue()), MechanismFormula2.class));
        for (TaskMechanismConfig config : me.getTaskConfigs()) {
            if (!context.getKey().equals(config.getKey())) continue;
            config.setFormula(newF);
            session.save((Object)me);
            break;
        }
        return null;
    }

    @Override
    public Object filter(MechanismContext context) {
        Assert.notNull((Object)context.getKey(), (String)"taskId is null");
        if (null != context.getAttach()) {
            MechanismOld me = (MechanismOld)((Object)context.getAttach().get("mechanism"));
            MechanismAchiveRecord record = (MechanismAchiveRecord)context.getAttach().get("record");
            HashMap<String, MechanismAchiveRecord> result = new HashMap<String, MechanismAchiveRecord>();
            if (null != me && null != me.getTaskConfigs()) {
                for (TaskMechanismConfig tc : me.getTaskConfigs()) {
                    if (!context.getKey().equalsIgnoreCase(tc.getKey())) continue;
                    MechanismAchiveRecord record1 = new MechanismAchiveRecord();
                    record1.setInstanceId(context.getInstanceId());
                    record1.setTenantId(context.getTenant());
                    record1.setKey(context.getKey());
                    record1.setMechanismKey(context.getMechanismKey());
                    record1.setValue((Object)tc.getFormula());
                    result.put("old", record1);
                    break;
                }
            }
            if (null != record && null != record.getValue()) {
                result.put("new", record);
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        return null;
    }

    @Override
    public void innerDoMechanismMaterialConfig(MechanismContext context) {
        MechanismOld me = context.getMechanism();
        Map<String, Object> data = context.getAttach();
    }
}

