/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.svcomposition.graph;

import com.digiwin.athena.knowledgegraph.svcomposition.graph.Edge;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.Graph;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import java.util.ArrayList;
import java.util.List;

public class MatrixGraph<T>
implements Graph {
    private final int DISCONNECTED = 0;
    private final int CONNECTED = 1;
    protected ArrayList<T> vertexList;
    protected int[][] matrix;
    private int order;

    public MatrixGraph(int size) {
        size = size < 10 ? 10 : size;
        this.vertexList = new ArrayList(size);
        this.matrix = new int[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.matrix[i][j] = 0;
            }
        }
    }

    public MatrixGraph(T[] vertices, Edge[] edges) {
        this(vertices.length);
        for (T t : vertices) {
            this.insertVertex(t);
        }
        if (edges != null) {
            for (Edge edge : edges) {
                this.insertEdge(edge);
            }
        }
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public ArrayList<T> getVertexList() {
        return this.vertexList;
    }

    public int size() {
        return this.order;
    }

    @Override
    public int inDegree(int ver) {
        if (ver < 0 || ver > this.order) {
            throw new IndexOutOfBoundsException(I18nUtils.getValue("knowledgegraph.indexOutOfBounds", ver));
        }
        int inDegree = 0;
        for (int hor = 0; hor < this.order; ++hor) {
            if (this.matrix[hor][ver] == 0) continue;
            ++inDegree;
        }
        return inDegree;
    }

    @Override
    public int outDegree(int hor) {
        if (hor < 0 || hor > this.order) {
            throw new IndexOutOfBoundsException(I18nUtils.getValue("knowledgegraph.indexOutOfBounds", hor));
        }
        int outDegree = 0;
        for (int ver = 0; ver < this.order; ++ver) {
            if (this.matrix[hor][ver] == 0) continue;
            ++outDegree;
        }
        return outDegree;
    }

    @Override
    public List<Integer> inNodeIndexes(int currentNodeSeq) {
        ArrayList<Integer> inIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.order; ++i) {
            if (this.matrix[i][currentNodeSeq] <= 0) continue;
            inIndexes.add(i);
        }
        return inIndexes;
    }

    @Override
    public List<Integer> outNodeIndexes(int currentNodeSeq) {
        ArrayList<Integer> outIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.order; ++i) {
            if (this.matrix[currentNodeSeq][i] <= 0) continue;
            outIndexes.add(i);
        }
        return outIndexes;
    }

    public void trimEdge() {
        for (int i = 0; i < this.order; ++i) {
            for (int j = 0; j < this.order; ++j) {
                boolean existOtherPath;
                if (j == i || this.matrix[i][j] <= 0 || !(existOtherPath = this.findOtherPath(i, j))) continue;
                this.removeEdge(i, j);
            }
        }
    }

    private boolean findOtherPath(int start, int dest) {
        for (int i = 0; i < this.order; ++i) {
            if (i == start || i == dest || this.matrix[i][dest] <= 0) continue;
            return this.traceBack(start, i);
        }
        return false;
    }

    private boolean traceBack(int start, int mid) {
        for (int i = 0; i < this.order; ++i) {
            if (i == mid || this.matrix[i][mid] <= 0) continue;
            if (i == start) {
                return true;
            }
            if (!this.traceBack(start, i)) continue;
            return true;
        }
        return false;
    }

    public int vertexCount() {
        return this.vertexList.size();
    }

    public T get(int i) {
        return this.vertexList.get(i);
    }

    public int getWeight(int i, int j) {
        return this.matrix[i][j];
    }

    public int insertVertex(T x) {
        this.vertexList.add(x);
        if (this.vertexCount() > this.matrix.length) {
            int j;
            int i;
            int[][] temp = this.matrix;
            this.matrix = new int[temp.length * 2][temp.length * 2];
            for (i = 0; i < temp.length; ++i) {
                for (j = 0; j < temp.length; ++j) {
                    this.matrix[i][j] = temp[i][j];
                }
                for (j = temp.length; j < temp.length * 2; ++j) {
                    this.matrix[i][j] = 0;
                }
            }
            for (i = temp.length; i < temp.length * 2; ++i) {
                for (j = 0; j < temp.length * 2; ++j) {
                    this.matrix[i][j] = 0;
                }
            }
        }
        ++this.order;
        return this.vertexList.size() - 1;
    }

    public void insertEdge(int i, int j) {
        int n = this.vertexCount();
        if (i >= 0 && i < n && j >= 0 && j < n && this.matrix[i][j] == 0 && i != j) {
            this.matrix[i][j] = 1;
        }
    }

    public void insertEdge(int i, int j, int weight) {
        int n = this.vertexCount();
        if (i >= 0 && i < n && j >= 0 && j < n && this.matrix[i][j] == 0 && i != j) {
            this.matrix[i][j] = weight;
        }
    }

    @Override
    public void insertEdge(Edge edge) {
        this.insertEdge(edge.start, edge.dest, edge.weight);
    }

    @Override
    public void removeEdge(int i, int j) {
        if (i >= 0 && i < this.vertexCount() && j >= 0 && j < this.vertexCount() && i != j) {
            this.matrix[i][j] = 0;
        }
    }

    public void removeVertex(int i) {
        int k;
        int j;
        int n = this.vertexCount();
        if (i < 0 || i > n) {
            return;
        }
        this.vertexList.remove(i);
        for (j = 0; j < i; ++j) {
            for (k = i + 1; k < n; ++k) {
                this.matrix[j][k - 1] = this.matrix[j][k];
            }
        }
        for (j = i + 1; j < n; ++j) {
            for (k = 0; k < i; ++k) {
                this.matrix[j - 1][k] = this.matrix[j][k];
            }
        }
        for (j = i + 1; j < n; ++j) {
            for (k = i + 1; k < n; ++k) {
                this.matrix[j - 1][k - 1] = this.matrix[j][k];
            }
        }
        --this.order;
    }

    public String toString() {
        String str = "\u9876\u70b9\u96c6\u5408:" + this.vertexList.toString() + "\n\u90bb\u63a5\u77e9\u9635\uff1a\n";
        int n = this.vertexCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                str = str + this.matrix[i][j];
            }
            str = str + "\n";
        }
        return str;
    }

    public static void main(String[] args) {
        String[] verices = new String[]{"A", "B", "C", "D", "E"};
        Edge[] edges = new Edge[]{new Edge(0, 1, 5), new Edge(0, 3, 2), new Edge(1, 0, 5), new Edge(1, 2, 7), new Edge(1, 3, 6), new Edge(2, 1, 7), new Edge(2, 3, 8), new Edge(2, 4, 3), new Edge(3, 0, 2), new Edge(3, 1, 6), new Edge(3, 2, 8), new Edge(3, 4, 9), new Edge(4, 2, 3), new Edge(4, 3, 9)};
        MatrixGraph<String> graph = new MatrixGraph<String>(verices, edges);
        System.out.println("\u5e26\u6743\u65e0\u5411\u56fe" + graph.toString());
        System.out.println("\u63d2\u5165\u9876\u70b9F,\u63d2\u5165\u8fb9(A,F,9),\u5220\u9664\u9876\u70b9C,\u5220\u9664\u8fb9(D,E)");
        int i = graph.insertVertex("F");
        graph.insertEdge(0, i, 9);
        graph.insertEdge(i, 0, 9);
        graph.removeVertex(2);
        graph.removeEdge(2, 3);
        graph.removeEdge(3, 2);
        System.out.println(graph.toString());
    }
}

