/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.controller.impl;

import com.digiwin.athena.knowledgegraph.synonym.controller.IEntityTypeService;
import com.digiwin.athena.knowledgegraph.synonym.dao.EntityTypeDao;
import com.digiwin.athena.knowledgegraph.synonym.dao.SystemEntityType;
import com.digiwin.athena.knowledgegraph.synonym.domain.EntityType;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.DeleteVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityTypeServiceImpl
implements IEntityTypeService {
    @Autowired
    private EntityTypeDao entityTypeDao;

    @Override
    public ResultBean<Object> creatOrUpdate(EntityType entityTypeVo) {
        try {
            entityTypeVo.setCreateDate(new Date());
            this.entityTypeDao.insert(entityTypeVo);
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> getList(String tid) {
        try {
            return ResultBean.success(this.entityTypeDao.findList(tid));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getPage(String tid, int pageNum, int pageSize) {
        try {
            return ResultBean.success(this.entityTypeDao.getPage(tid, pageNum, pageSize));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> delete(DeleteVo deleteVo) {
        try {
            this.entityTypeDao.delete(deleteVo.getId(), deleteVo.getTid());
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> deleteList(DeleteVo deleteVo) {
        try {
            this.entityTypeDao.deleteList(deleteVo.getTid(), deleteVo.getIds());
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> getSystemEntityTypePage(int pageNum, int pageSize, String entityTypeName) {
        try {
            return ResultBean.success(this.entityTypeDao.getSystemPage(entityTypeName, pageNum, pageSize));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> getAllSystemEntityType() {
        try {
            return ResultBean.success(this.entityTypeDao.getAll());
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }

    @Override
    public ResultBean<Object> deleteSystemEntityType(String id) {
        try {
            this.entityTypeDao.deleteSysEntity(id);
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> insertSystemEntityType(List<SystemEntityType> systemEntityTypes) {
        try {
            this.entityTypeDao.saveAll(systemEntityTypes);
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
        return ResultBean.success("");
    }

    @Override
    public ResultBean<Object> listByNames(List<String> nameList) {
        try {
            return ResultBean.success(this.entityTypeDao.getSystemListByNames(nameList));
        }
        catch (BusinessException businessException) {
            return ResultBean.fail(1, businessException.getMessage());
        }
    }
}

