/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.QuerySmartUserConfigRequest;
import com.digiwin.athena.knowledgegraph.synonym.domain.SmartUserConfig;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SmartUserConfigDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void saveAll(List<SmartUserConfig> configs) {
        if (CollectionUtils.isEmpty(configs)) {
            return;
        }
        List<String> collect = configs.stream().map(SmartUserConfig::getId).collect(Collectors.toList());
        this.delete(collect);
        configs.forEach(config -> config.setCreateDate(new Date()));
        this.mongoTemplate.insertAll(configs);
    }

    public List<SmartUserConfig> findList(QuerySmartUserConfigRequest findVo) {
        if (StringUtils.isEmpty((CharSequence)findVo.getTenantId())) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)findVo.getTenantId())});
        if (StringUtils.isNotEmpty((CharSequence)findVo.getKeyWord())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"userId").regex(findVo.getKeyWord()), Criteria.where((String)"userName").regex(findVo.getKeyWord())});
        }
        if (StringUtils.isNotEmpty((CharSequence)findVo.getUserId())) {
            criteria.and("userId").is((Object)findVo.getUserId());
        }
        if (!CollectionUtils.isEmpty(findVo.getIdList())) {
            criteria.and("id").in(findVo.getIdList());
        }
        query.addCriteria((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        return this.mongoTemplate.find(query, SmartUserConfig.class);
    }

    public void delete(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(idList));
        this.mongoTemplate.remove(query, SmartUserConfig.class);
    }

    public void dataMigration() {
        long count = this.systemMongoTemplate.count(new Query(), SmartUserConfig.class);
        if (count > 0L) {
            List appThresholdConfigs = this.systemMongoTemplate.find(new Query(), SmartUserConfig.class);
            this.mongoTemplate.insertAll((Collection)appThresholdConfigs);
        }
    }
}

