/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.DeleteDto;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.GetSubscriptionByPageRequest;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.Subscription;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class SubscriptionDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void insertOne(Subscription subscription) {
        this.mongoTemplate.insert((Object)subscription);
    }

    public Subscription fineOne(Query query) {
        return (Subscription)this.mongoTemplate.findOne(query, Subscription.class);
    }

    public void saveOne(Subscription subscription) {
        this.mongoTemplate.save((Object)subscription);
    }

    public PageVo<Subscription> getEntryPage(Integer pageNum, Integer pageSize, String question, String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)"entry")});
        if (StringUtils.isNotEmpty((CharSequence)question)) {
            Pattern questionPattern = Pattern.compile("^.*" + question + ".*$", 2);
            criteria.and("question.question").regex(questionPattern);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate", "_id"});
        long totalCount = this.mongoTemplate.count(query, Subscription.class);
        List subscriptionList = this.mongoTemplate.find(query.with((Pageable)pageable), Subscription.class);
        int totalPage = (int)(totalCount % (long)pageSize.intValue() == 0L ? totalCount / (long)pageSize.intValue() : totalCount / (long)pageSize.intValue() + 1L);
        return new PageVo<Subscription>((int)totalCount, subscriptionList, pageNum, pageSize, totalPage);
    }

    public PageVo<Subscription> getSubscriptionPage(GetSubscriptionByPageRequest request) {
        Pattern patternDesc;
        String tenantId = request.getTenantId();
        Integer pageSize = request.getPageSize();
        Integer pageNum = request.getPage();
        String question = request.getQuestion();
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)"subscription")});
        if (StringUtils.isNotEmpty((CharSequence)question)) {
            Pattern questionPattern = Pattern.compile("^.*" + question + ".*$", 2);
            criteria.and("question.question").regex(questionPattern);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getCreateDateStart()) && StringUtils.isNotEmpty((CharSequence)request.getCreateDateEnd())) {
            criteria.and("createDate").gte((Object)request.getCreateDateStart()).lte((Object)request.getCreateDateEnd());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getEditDateStart()) && StringUtils.isNotEmpty((CharSequence)request.getEditDateEnd())) {
            criteria.and("editDate").gte((Object)request.getEditDateStart()).lte((Object)request.getEditDateEnd());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getCreateBy())) {
            patternDesc = Pattern.compile("^.*" + request.getCreateBy() + ".*$", 2);
            criteria.and("createBy").regex(patternDesc);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getEditBy())) {
            patternDesc = Pattern.compile("^.*" + request.getEditBy() + ".*$", 2);
            criteria.and("editBy").regex(patternDesc);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate", "_id"});
        long totalCount = this.mongoTemplate.count(query, Subscription.class);
        List subscriptionList = this.mongoTemplate.find(query.with((Pageable)pageable), Subscription.class);
        int totalPage = (int)(totalCount % (long)pageSize.intValue() == 0L ? totalCount / (long)pageSize.intValue() : totalCount / (long)pageSize.intValue() + 1L);
        return new PageVo<Subscription>((int)totalCount, subscriptionList, pageNum, pageSize, totalPage);
    }

    public void deleteSubscription(String tenantId, List<String> ruleIds) {
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").in(ruleIds)), Subscription.class);
    }

    public void deleteEntry(DeleteDto deleteDto) {
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)deleteDto.getTenantId()).and("code").is((Object)deleteDto.getCode())), Subscription.class);
    }

    public List<Subscription> findByQuestion(String tenantId, String question) {
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)"subscription").and("question.question").is((Object)question)), Subscription.class);
    }
}

