/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.EntityTypeConfig;
import com.digiwin.athena.knowledgegraph.synonym.domain.LocalAppInfo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageSelectVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageVo;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SyncAppInfoDao {
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void insertLocalList(List<LocalAppInfo> localList) {
        this.mongoTemplate.insertAll(localList);
    }

    public PageVo getLocalListPage(PageSelectVo page) {
        if (StringUtils.isEmpty((CharSequence)page.getTenantId())) {
            throw new BusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)page.getTenantId())});
        query.addCriteria((CriteriaDefinition)criteria);
        long totalCount = this.mongoTemplate.count(query, LocalAppInfo.class);
        int pageNum = page.getPage();
        int pageSize = page.getPageSize();
        if (pageNum == 0 && pageSize == 0) {
            List localAppInfos = this.mongoTemplate.find(query, LocalAppInfo.class);
            return new PageVo((int)totalCount, localAppInfos, page.getPage(), pageSize, 1);
        }
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        List pageSelectVos = this.mongoTemplate.find(query.with((Pageable)pageable), PageSelectVo.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo((int)totalCount, pageSelectVos, page.getPage(), pageSize, totalPage);
    }

    public List<LocalAppInfo> getLocalList(String tenantId) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        query.addCriteria((CriteriaDefinition)criteria);
        List localAppInfos = this.mongoTemplate.find(query, LocalAppInfo.class);
        return localAppInfos;
    }

    public List<LocalAppInfo> getAll() {
        List localAppInfos = this.mongoTemplate.findAll(LocalAppInfo.class);
        return localAppInfos;
    }

    public void updateLocal(LocalAppInfo localAppInfo) {
        if (StringUtils.isEmpty((CharSequence)localAppInfo.getObjectId())) {
            throw new BusinessException("\u5f53\u524d\u6570\u636e\u65e0id" + localAppInfo.toString());
        }
        this.mongoTemplate.save((Object)localAppInfo);
    }

    public void deleteLocal(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").in(list));
        this.mongoTemplate.remove(query, LocalAppInfo.class);
    }

    public void saveAll(List<LocalAppInfo> localAppInfos) {
        Map uniqueInfos = localAppInfos.stream().filter(info -> info.getObjectId() != null).collect(Collectors.toMap(LocalAppInfo::getObjectId, Function.identity(), (existing, replacement) -> existing));
        BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.ORDERED, LocalAppInfo.class);
        uniqueInfos.values().forEach(info -> {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)info.getObjectId()));
            Document doc = new Document();
            this.mongoTemplate.getConverter().write(info, (Object)doc);
            doc.remove((Object)"_id");
            Update update = new Update();
            doc.forEach((key, value) -> update.set(key, value));
            bulkOps.upsert(query, update);
        });
        bulkOps.execute();
    }

    public void deleteEntityConfig(String appName, String appType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"appName").is((Object)appName).and("appType").is((Object)appType)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.systemMongoTemplate.remove(query, EntityTypeConfig.class);
    }

    public void saveConfigsAll(List<EntityTypeConfig> configs) {
        List collect = configs.stream().map(EntityTypeConfig::getId).collect(Collectors.toList());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(collect));
        this.systemMongoTemplate.remove(query, EntityTypeConfig.class);
        this.systemMongoTemplate.insertAll(configs);
    }

    public List<EntityTypeConfig> getEntityConfigs(String appName, String appType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"appName").is((Object)appName).and("appType").is((Object)appType)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.systemMongoTemplate.find(query, EntityTypeConfig.class);
    }

    public LocalAppInfo find(String id) {
        return (LocalAppInfo)this.mongoTemplate.findById((Object)id, LocalAppInfo.class);
    }

    public void updateEntityTypeConfig(EntityTypeConfig entityTypeConfig) {
        if (StringUtils.isEmpty((CharSequence)entityTypeConfig.getId())) {
            throw new BusinessException("\u5f53\u524d\u6570\u636e\u65e0id" + entityTypeConfig.toString());
        }
        this.systemMongoTemplate.save((Object)entityTypeConfig);
    }

    public void dataMigration() {
        long count = this.systemMongoTemplate.count(new Query(), LocalAppInfo.class);
        if (count > 0L) {
            List appThresholdConfigs = this.systemMongoTemplate.find(new Query(), LocalAppInfo.class);
            this.mongoTemplate.insertAll((Collection)appThresholdConfigs);
        }
    }
}

