/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.domain.definition.actions.DataEntity;
import com.digiwin.athena.domain.definition.actions.DataField;
import com.digiwin.athena.kg.activity.Activities;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.kg.activity.ActivityBaseInfoVO;
import com.digiwin.athena.kg.activity.ActivityComposition;
import com.digiwin.athena.kg.activity.ActivityCompositionItem;
import com.digiwin.athena.kg.activity.ActivityConfig;
import com.digiwin.athena.kg.activity.ActivityVO;
import com.digiwin.athena.kg.activity.AuthorityConfigVO;
import com.digiwin.athena.kg.activity.DynamicActivity;
import com.digiwin.athena.kg.activity.DynamicActivityComposition;
import com.digiwin.athena.kg.activity.DynamicActivityCompositionConditionVO;
import com.digiwin.athena.kg.activity.DynamicApproveInfo;
import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import com.digiwin.athena.kg.domain.OpenWindowDefinition;
import com.digiwin.athena.kg.monitorRule.Conditon;
import com.digiwin.athena.kg.monitorRule.DynamicCondition;
import com.digiwin.athena.kg.monitorRule.tenant.ConditionOperatorTypeEnum;
import com.digiwin.athena.kg.monitorRule.tenant.ConditionValueTypeEnum;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionTypeEnum;
import com.digiwin.athena.kmservice.action.metadata.model.DataEntityMetadataDTO;
import com.digiwin.athena.knowledgegraph.cache.CacheService;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.task.ActivityInputData;
import com.digiwin.athena.knowledgegraph.domain.task.ActivityVisibleConfig;
import com.digiwin.athena.knowledgegraph.repoSystem.ActivityCompositionRepository;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IActivityService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.task.model.ActivityCompositionData;
import com.digiwin.athena.knowledgegraph.task.model.ActivityCompositionItemVO;
import com.digiwin.athena.knowledgegraph.task.model.ActivityCompositionVO;
import com.digiwin.athena.knowledgegraph.task.model.DynamicActivityData;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import com.digiwin.athena.repository.neo4j.DynamicTaskRepository;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class ActivityService
implements IActivityService {
    private static final Logger log = LoggerFactory.getLogger(ActivityService.class);
    @Autowired
    ActivityRepository activityRepository;
    @Autowired
    DynamicTaskRepository dynamicTaskRepository;
    @Autowired
    ActivityCompositionRepository activityCompositionRepository;
    @Autowired
    @Qualifier(value="knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    TenantService tenantService;
    @Autowired
    AppService appService;
    @Autowired
    @Qualifier(value="knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    private AppService applicationService;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    ActionService actionService;
    @Autowired
    TaskService taskService;
    @Autowired
    ComponentManager componentManager;
    @Autowired
    IMechanismService mechanismService;
    @Autowired
    CacheService cacheService;
    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object getInputData(String activityId) throws DWBusinessException {
        Object obj2 = this.dataMapService.taskInputData(activityId);
        return obj2;
    }

    @Override
    public Object getInputData(String taskId, String activityId) throws DWBusinessException {
        String tenantVersion;
        String tenantId = AthenaUtils.getTenantId();
        Optional<ActivityInputData> inputData = this.activityRepository.getActivityInputData(tenantId, taskId, activityId, tenantVersion = this.kgInnerService.getTenantVersion(tenantId));
        if (inputData.isPresent()) {
            ActivityInputData data = inputData.get();
            data.getInputData().setField(new ArrayList<DataField>(data.getFields()));
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("activity", activityId);
            result.put("inputData", (String)DataEntityMetadataDTO.ConvertFromDataEntity((DataEntity)data.getInputData()));
            return result;
        }
        return null;
    }

    @Override
    public Object postQueryCompositionBySolvePlan(String planId, String dataName) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        Activities activities = this.activityRepository.getActivitySetByPlanId(planId, dataName, tenantVersion);
        Assert.notNull((Object)activities, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u6d3b\u52a8\u5b9a\u4e49");
        List activityVOS = activities.getActivities();
        Assert.notNull((Object)activityVOS, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u6d3b\u52a8\u5b9a\u4e49");
        Assert.notEmpty((Collection)activityVOS, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u6d3b\u52a8\u5b9a\u4e49");
        Assert.notEmpty((Collection)activityVOS, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u6d3b\u52a8\u5b9a\u4e49");
        List<String> ids = activityVOS.stream().map(ActivityVO::getActivityId).collect(Collectors.toList());
        List<ActivityVO> activityVOS2 = this.activityRepository.getActivitySetByIds(ids, locale, tenantVersion, tenantId);
        activityVOS2 = this.dataPickService.excludeWithSameCode(activityVOS2);
        Assert.notEmpty(activityVOS2, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u6d3b\u52a8\u5b9a\u4e49");
        Map<String, ActivityVO> map = activityVOS.stream().collect(Collectors.toMap(ActivityVO::getActivityId, a -> a, (k1, k2) -> k1));
        activityVOS2.forEach(item -> item.setSequence(((ActivityVO)map.get(item.getActivityId())).getSequence()));
        activities.setActivities(activityVOS2);
        return activities;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object postComposition(String taskId, List<String> sequenceFields, List<String> keyFields, Map<String, String> conditionFields, String dueDateField, List<Map> data) throws Exception {
        if (taskId == null || taskId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.taskIdEmpty", new Object[0]));
        }
        List<DynamicActivityComposition> compositions = this.dynamicTaskRepository.getDynamicActivityCompositionByTask(taskId);
        if (compositions == null || compositions.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.compositionsNotFound", new Object[0]));
        }
        HashMap<String, Object> conditionDefines = new HashMap<String, Object>();
        for (DynamicActivityComposition item : compositions) {
            HashMap cons = new HashMap();
            for (DynamicActivityCompositionConditionVO dynamicActivityCompositionConditionVO : item.getConditions()) {
                cons.put(dynamicActivityCompositionConditionVO.getKey(), dynamicActivityCompositionConditionVO.getValue());
            }
            conditionDefines.put(item.getCode(), cons);
        }
        HashMap dataConditions = new HashMap();
        HashMap<String, Map> sortData = new HashMap<String, Map>();
        for (Map map : data) {
            HashMap hashMap = new HashMap();
            for (Map.Entry<String, String> entry : conditionFields.entrySet()) {
                String conditionKey = entry.getKey();
                String string = entry.getValue();
                hashMap.put(conditionKey, map.get(string));
            }
            String seq = "";
            for (String seqField : sequenceFields) {
                seq = seq + map.get(seqField).toString();
            }
            dataConditions.put(seq, hashMap);
            sortData.put(seq, map);
        }
        if (data.size() != sortData.size()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.sequenceNotUnique", new Object[0]));
        }
        TreeMap dataComposition = new TreeMap();
        block5: for (Map.Entry entry : dataConditions.entrySet()) {
            int conditionCount = ((Map)entry.getValue()).size();
            for (Map.Entry conDef : conditionDefines.entrySet()) {
                if (((Map)conDef.getValue()).size() != conditionCount) continue;
                boolean bl = true;
                for (Map.Entry con : ((Map)entry.getValue()).entrySet()) {
                    if (((Map)conDef.getValue()).get(con.getKey()).toString().equals(con.getValue().toString())) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                dataComposition.put(entry.getKey(), conDef.getKey());
                continue block5;
            }
        }
        ArrayList<DynamicActivityData> arrayList = new ArrayList<DynamicActivityData>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap compSeqDataKey = new HashMap();
        int n = 10;
        for (Map.Entry entry : dataComposition.entrySet()) {
            void var15_33;
            String opSeq = (String)entry.getKey();
            String code = (String)entry.getValue();
            Map d = (Map)sortData.get(opSeq);
            List<DynamicActivity> dynamicActs = this.dynamicTaskRepository.getDynamicActivityByComposition(taskId, code);
            DynamicActivityComposition composition = this.dynamicTaskRepository.getDynamicActivityCompositionByCode(taskId, code);
            TreeMap<Integer, DynamicActivity> acts = new TreeMap<Integer, DynamicActivity>();
            for (DynamicActivity dynamicActivity : dynamicActs) {
                acts.put(dynamicActivity.getSequence(), dynamicActivity);
            }
            for (Map.Entry entry2 : acts.entrySet()) {
                arrayList.add(new DynamicActivityData((DynamicActivity)entry2.getValue(), d, composition, (int)var15_33));
            }
            if (!arrayList2.contains(code)) {
                arrayList2.add(code);
            }
            HashMap dataKey = new HashMap();
            for (String key : keyFields) {
                dataKey.put(key, d.get(key));
            }
            compSeqDataKey.put((int)var15_33, dataKey);
            var15_33 += 10;
        }
        ArrayList<ActivityCompositionItem> items = new ArrayList<ActivityCompositionItem>();
        int n2 = 10;
        for (DynamicActivityData actData : arrayList) {
            void var17_39;
            ActivityCompositionItem item = new ActivityCompositionItem();
            DynamicActivity activity = actData.getActivity();
            String dynActCode = activity.getCode();
            Map d = actData.getData();
            item.setActivityId(String.format("%s-%s", dynActCode, ActivityService.processTemplate(activity.getIdSuffixFormula(), d)));
            item.setFlowId(activity.getFlowId());
            item.setName(ActivityService.processTemplate(activity.getNameFormula(), d));
            item.setSequence((int)var17_39);
            item.setDynamicActivityCode(dynActCode);
            item.setCompositionCode(actData.getComposition().getCode());
            item.setCompositionFlowId(actData.getComposition().getFlowId());
            item.setCompositionSequence(actData.getCompositionSequence());
            item.setDueDate((String)d.get(dueDateField));
            items.add(item);
            var17_39 += 10;
        }
        ActivityComposition ac = new ActivityComposition();
        String compositionId = UUID.randomUUID().toString();
        ac.setCompositionId(compositionId);
        ac.setCompositionCodes(arrayList2);
        ac.setCompositionSequenceDataKey(compSeqDataKey);
        ac.setActivities(items);
        this.activityCompositionRepository.insert(ac);
        HashMap<String, String> re = new HashMap<String, String>();
        re.put("compositionId", compositionId);
        return re;
    }

    public static String processTemplate(String template, Map<String, Object> params) {
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\$\\{\\w+\\}").matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 1));
            m.appendReplacement(sb, value == null ? "" : value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public Object getComposition(String compositionId) throws Exception {
        ActivityComposition re = this.activityCompositionRepository.findOneByCompositionId(compositionId);
        ActivityCompositionData data = null;
        if (re != null) {
            data = new ActivityCompositionData();
            data.setCompositionId(re.getCompositionId());
            data.setCompositionCodes(re.getCompositionCodes());
            Map compSeqDataKey = re.getCompositionSequenceDataKey();
            TreeMap<Integer, ActivityCompositionVO> comps = new TreeMap<Integer, ActivityCompositionVO>();
            for (ActivityCompositionItem item : re.getActivities()) {
                int compSeq = item.getCompositionSequence();
                ActivityCompositionVO compVO = (ActivityCompositionVO)comps.get(compSeq);
                if (compVO == null) {
                    String compFlowId = item.getCompositionFlowId();
                    String compCode = item.getCompositionCode();
                    compVO = new ActivityCompositionVO(compCode, compFlowId, compSeq, (Map)compSeqDataKey.get(compSeq));
                    comps.put(compSeq, compVO);
                }
                ActivityCompositionItemVO itemVO = new ActivityCompositionItemVO(item.getActivityId(), item.getFlowId(), item.getName(), item.getDynamicActivityCode(), item.getSequence());
                compVO.getActivities().add(itemVO);
            }
            ArrayList<ActivityCompositionVO> compositionVOS = new ArrayList<ActivityCompositionVO>();
            for (Map.Entry item : comps.entrySet()) {
                compositionVOS.add((ActivityCompositionVO)item.getValue());
            }
            data.setCompositions(compositionVOS);
        }
        return data;
    }

    @Override
    public Object postUpdateActivity(Activity data) throws Exception {
        List dynamicApproves = data.getDynamicApproves();
        ArrayList res = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)dynamicApproves)) {
            for (DynamicApproveInfo dynamicApprove : dynamicApproves) {
                HashMap<String, String> map = new HashMap<String, String>();
                Object dynamicConditionObj = dynamicApprove.getDynamicCondition();
                String expression = this.expressionHandle(dynamicConditionObj);
                dynamicApprove.setExpression(expression);
                map.put("name", dynamicApprove.getName());
                map.put("code", dynamicApprove.getCode());
                map.put("seq", dynamicApprove.getSeq());
                map.put("expression", dynamicApprove.getExpression());
                res.add(map);
            }
        }
        this.dataMapService.updateTask(data);
        return res;
    }

    @Override
    public Object postUpdateActivity(Activity data, OperationUnit operationUnit) throws Exception {
        List dynamicApproves = data.getDynamicApproves();
        ArrayList res = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)dynamicApproves)) {
            for (DynamicApproveInfo dynamicApprove : dynamicApproves) {
                HashMap<String, String> map = new HashMap<String, String>();
                Object dynamicConditionObj = dynamicApprove.getDynamicCondition();
                String expression = this.expressionHandle(dynamicConditionObj);
                dynamicApprove.setExpression(expression);
                map.put("name", dynamicApprove.getName());
                map.put("code", dynamicApprove.getCode());
                map.put("seq", dynamicApprove.getSeq());
                map.put("expression", dynamicApprove.getExpression());
                res.add(map);
            }
        }
        if (null != operationUnit) {
            HashMap<String, String> eocInfo = new HashMap<String, String>();
            eocInfo.put("eoc_company_id", operationUnit.getEoc_company_id());
            eocInfo.put("eoc_site_id", operationUnit.getEoc_site_id());
            eocInfo.put("eoc_region_id", operationUnit.getEoc_region_id());
            eocInfo.put("operation_unit_v2", (String)operationUnit.getOperation_unit_v2());
            data.setEocInfo(eocInfo);
        }
        this.dataMapService.updateTask(data);
        return res;
    }

    private String expressionHandle(Object dynamicConditionObj) throws DWBusinessException {
        String expression = null;
        ArrayList<String> list = new ArrayList<String>();
        if (dynamicConditionObj instanceof Map) {
            DynamicConditionConfigDO dynamicCondition = (DynamicConditionConfigDO)JsonUtils.readValue((String)JSON.toJSONString((Object)dynamicConditionObj), DynamicConditionConfigDO.class);
            expression = this.typeHandle(dynamicCondition);
        }
        if (dynamicConditionObj instanceof List) {
            List conditionObj = (List)dynamicConditionObj;
            DynamicConditionConfigDO dy = new DynamicConditionConfigDO();
            dy.setType(DynamicConditionTypeEnum.AND_GROUP);
            ArrayList<DynamicConditionConfigDO> items = new ArrayList<DynamicConditionConfigDO>();
            for (Object o : conditionObj) {
                DynamicConditionConfigDO dynamicCondition = (DynamicConditionConfigDO)JsonUtils.readValue((String)JSON.toJSONString(o), DynamicConditionConfigDO.class);
                items.add(dynamicCondition);
            }
            dy.setItems(items);
            list.add(this.typeHandle(dy));
            expression = "(" + StringUtils.join(list, (String)"&&") + ")";
        }
        return expression;
    }

    private String typeHandle(DynamicConditionConfigDO dynamicCondition) throws DWBusinessException {
        List items;
        String expression = null;
        ArrayList<String> list = new ArrayList<String>();
        if (dynamicCondition.getType().equals((Object)DynamicConditionTypeEnum.OR_GROUP) && !CollectionUtils.isEmpty((Collection)dynamicCondition.getItems())) {
            items = dynamicCondition.getItems();
            for (DynamicConditionConfigDO item : items) {
                list.add(this.typeHandle(item));
            }
            expression = "(" + StringUtils.join(list, (String)"||") + ")";
        }
        if (dynamicCondition.getType().equals((Object)DynamicConditionTypeEnum.AND_GROUP) && !CollectionUtils.isEmpty((Collection)dynamicCondition.getItems())) {
            items = dynamicCondition.getItems();
            for (DynamicConditionConfigDO item : items) {
                list.add(this.typeHandle(item));
            }
            expression = "(" + StringUtils.join(list, (String)"&&") + ")";
        }
        if (dynamicCondition.getType().equals((Object)DynamicConditionTypeEnum.SINGLE)) {
            list.add(this.conversionExpression(dynamicCondition));
            expression = StringUtils.join(list, (String)"");
        }
        return expression;
    }

    private String conversionExpression(DynamicConditionConfigDO item) throws DWBusinessException {
        StringBuilder stringBuffer = new StringBuilder();
        String leftValue = ActivityService.substituteParameters(item.getLeft(), item.getLeftValueType());
        if (item.getOp().equals((Object)ConditionOperatorTypeEnum.EQUAL)) {
            return String.valueOf(stringBuffer.append(leftValue).append("==").append(ActivityService.substituteParameters(item.getRight().toString(), item.getRightValueType())));
        }
        if (item.getOp().equals((Object)ConditionOperatorTypeEnum.NOT_EQUAL)) {
            return String.valueOf(stringBuffer.append(leftValue).append("!=").append(ActivityService.substituteParameters(item.getRight().toString(), item.getRightValueType())));
        }
        if (item.getOp().equals((Object)ConditionOperatorTypeEnum.IN)) {
            List right = (List)item.getRight();
            ArrayList<String> rightList = new ArrayList<String>();
            for (Object s : right) {
                String rightValue = ActivityService.substituteParameters(s, item.getRightValueType());
                rightList.add(leftValue + "==" + rightValue);
            }
            return "(" + StringUtils.join(rightList, (String)"||") + ")";
        }
        if (item.getOp().equals((Object)ConditionOperatorTypeEnum.NOT_IN)) {
            List right = (List)item.getRight();
            ArrayList<String> rightList = new ArrayList<String>();
            for (Object s : right) {
                String rightValue = ActivityService.substituteParameters(s, item.getRightValueType());
                rightList.add(leftValue + "!=" + rightValue);
            }
            return "(" + StringUtils.join(rightList, (String)"&&") + ")";
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.requirementNotExist", new Object[0]));
    }

    private static String substituteParameters(Object str, ConditionValueTypeEnum type) {
        if (type.equals((Object)ConditionValueTypeEnum.COLUMN)) {
            return "'$(" + str + ")'";
        }
        return "'" + str + "'";
    }

    @Override
    public Object getAllApproveActivityByApp(String applicationCode, String locale) throws Exception {
        Object obj = this.dataMapService.allApproveActivityByApp(applicationCode, locale);
        return obj;
    }

    @Override
    @Deprecated
    public Object getManualActivityByApp(String applicationCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List<String> taskIdList = this.applicationService.getTaskCode(applicationCode);
        List<ActivityBaseInfoVO> approveActivityListByTaskIds = this.activityRepository.getManualActivityListByTaskIds(taskIdList, tenantId, tenantVersion);
        return approveActivityListByTaskIds;
    }

    @Override
    public Object getActivityByTask(String taskCode, String locale) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("projectCode", taskCode);
        param.put("locale", locale);
        return this.dataMapService.postTasksByProject(param);
    }

    @Override
    public Object postAuthorityConfigs(List<String> activityIdList) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(activityIdList).and("version").is((Object)this.kgInnerService.getTenantVersion(tenantId)));
        query.fields().include("code").include("authorityPrefix");
        List defaultActivity = this.mongoTemplate.find(query, AuthorityConfigVO.class, "activityConfigs");
        return defaultActivity;
    }

    @Override
    public Object postAllApproveActivityByApp(String applicationCode, String locale, Map<String, Object> paramCodeAndValue) throws Exception {
        String tenantId2 = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId2);
        List<String> taskIdList = this.applicationService.getTaskCode(applicationCode);
        ArrayList approveActivityListByTaskId = new ArrayList();
        ArrayList<ActivityBaseInfoVO> approveActivityListByTaskIds = new ArrayList<ActivityBaseInfoVO>();
        List<ApplicationRelation> activity = this.applicationService.getApplicationRelationByTypeAndAppCode(tenantId2, "activity", applicationCode);
        List codeList = activity.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(codeList)) {
            HashMap<String, Object> q = new HashMap<String, Object>();
            q.put("code", codeList);
            q.put("type", "approve");
            List dmlist = this.dataMapService.approveTaskList(q);
            if (null != dmlist) {
                approveActivityListByTaskId.addAll(dmlist);
            }
            HashMap openWin = new HashMap();
            for (Object o : approveActivityListByTaskId) {
                ActivityBaseInfoVO activityBaseInfoVO = (ActivityBaseInfoVO)JSON.parseObject((String)JSON.toJSONString(o), ActivityBaseInfoVO.class);
                approveActivityListByTaskIds.add(activityBaseInfoVO);
                FieldDescription dropDown = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)activityBaseInfoVO.getActivityId()), FieldDescription.class, "subApproveConditionDropDown");
                if (dropDown == null) continue;
                if (dropDown.getFieldOpenWindowMap() != null) {
                    activityBaseInfoVO.setFieldOpenWindowMap(dropDown.getFieldOpenWindowMap());
                    HashMap<String, String> map = new HashMap<String, String>();
                    List fieldOpenWindowSettings = JSON.parseArray((String)JSON.toJSONString((Object)dropDown.getFieldOpenWindowMap()), FieldOpenWindowSetting.class);
                    for (FieldOpenWindowSetting setting : fieldOpenWindowSettings) {
                        map.put(setting.getColumn(), setting.getOpenWindowKey());
                    }
                    openWin.put(activityBaseInfoVO.getActivityId(), map);
                    Map<String, Map<String, OpenWindowDefinition>> openWinInfo = this.appService.postOpenWinInfo(openWin);
                    Map<String, OpenWindowDefinition> temp = openWinInfo.get(activityBaseInfoVO.getActivityId());
                    activityBaseInfoVO.setFieldOpenWindowDefinitions(temp);
                }
                if (dropDown.getFieldMappings() == null) continue;
                LanguageUtil.processLocaleLanguage(dropDown.getFieldMappings(), locale);
                activityBaseInfoVO.setFieldMappings(dropDown.getFieldMappings());
            }
        }
        List<ActivityBaseInfoVO> filterResult = this.filterActivityInfo(applicationCode, approveActivityListByTaskIds, paramCodeAndValue);
        ArrayList<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<ComponentBaseInfoBO>();
        for (ActivityBaseInfoVO activityInfo : approveActivityListByTaskIds) {
            ComponentBaseInfoBO componentInfo = new ComponentBaseInfoBO();
            componentInfo.setCode(activityInfo.getActivityId());
            componentInfo.setType(ComponentTypeEnum.Task);
            componentBaseInfos.add(componentInfo);
        }
        List<ComponentBaseInfoBO> filteredBaseInfos = this.componentManager.FilterByTenantApplicationComponentList(applicationCode, tenantId2, componentBaseInfos);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(filteredBaseInfos) && filteredBaseInfos.size() != componentBaseInfos.size()) {
            Set collect = filteredBaseInfos.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toSet());
            Iterator<ActivityBaseInfoVO> iterator = filterResult.iterator();
            while (iterator.hasNext()) {
                ActivityBaseInfoVO next = iterator.next();
                if (collect.contains(next.getActivityId())) continue;
                iterator.remove();
            }
            return filterResult;
        }
        return filterResult;
    }

    @Override
    public Object postActivityByTask(String taskCode, String appCode, String locale, Map<String, Object> paramCodeAndValue) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("taskCode", taskCode);
        param.put("appCode", appCode);
        param.put("locale", locale);
        param.put("paramCodeAndValue", paramCodeAndValue);
        return this.dataMapService.postActivityByTask(param);
    }

    private List<ActivityBaseInfoVO> setConfig(String taskCode, String tenantId, List<ActivityBaseInfoVO> filterResult) {
        if (CollectionUtils.isEmpty(filterResult)) {
            return filterResult;
        }
        filterResult.forEach(item -> {
            Object dm = this.taskService.getTaskInfoFromDataMap(taskCode, item.getActivityId(), null, tenantId);
            Activity result = (Activity)JSON.parseObject((String)JSON.toJSONString((Object)dm), Activity.class);
            item.setConfig(result.getConfig());
        });
        return filterResult;
    }

    private List<ActivityBaseInfoVO> filterActivityInfo(String applicationCode, List<ActivityBaseInfoVO> approveActivityList, Map<String, Object> paramCodeAndValue) throws Exception {
        ArrayList<ActivityBaseInfoVO> result = new ArrayList<ActivityBaseInfoVO>();
        List<String> productList = this.actionService.getTenantProductList();
        for (ActivityBaseInfoVO activityBaseInfo : approveActivityList) {
            Object activityCode = JSONPath.eval((Object)activityBaseInfo, (String)"activityId");
            Query queryHasProduct = Query.query((CriteriaDefinition)Criteria.where((String)"activityCode").is(activityCode).and("appCode").is((Object)applicationCode).and("productCode").in(productList));
            ActivityVisibleConfig activityVisibleConfig = (ActivityVisibleConfig)this.mongoTemplate.findOne(queryHasProduct, ActivityVisibleConfig.class, "activityVisibleConfig");
            if (activityVisibleConfig == null) {
                Criteria criteria = new Criteria();
                criteria.and("activityCode").is(activityCode).and("appCode").is((Object)applicationCode);
                criteria = new Criteria().andOperator(new Criteria[]{criteria, new Criteria().orOperator(new Criteria[]{Criteria.where((String)"productCode").is((Object)""), Criteria.where((String)"productCode").is(null)})});
                Query queryHasNoProduct = Query.query((CriteriaDefinition)criteria);
                activityVisibleConfig = (ActivityVisibleConfig)this.mongoTemplate.findOne(queryHasNoProduct, ActivityVisibleConfig.class, "activityVisibleConfig");
            }
            if (!this.conditionResult(activityVisibleConfig, paramCodeAndValue).booleanValue()) continue;
            result.add(activityBaseInfo);
        }
        return result;
    }

    private Boolean conditionResult(ActivityVisibleConfig activityVisibleConfig, Map<String, Object> paramCodeAndValue) throws DWBusinessException {
        if (activityVisibleConfig != null) {
            DynamicCondition dynamicCondition = activityVisibleConfig.getAcitvityVisibleCondition();
            if (DynamicConditionTypeEnum.SINGLE.toString().equals(dynamicCondition.getType())) {
                return this.judgeExpression((Conditon)dynamicCondition, paramCodeAndValue);
            }
            if (DynamicConditionTypeEnum.AND_GROUP.toString().equals(dynamicCondition.getType())) {
                List conditons = dynamicCondition.getItems();
                for (Conditon cd : conditons) {
                    if (this.judgeExpression(cd, paramCodeAndValue).booleanValue()) continue;
                    return false;
                }
                return true;
            }
            if (DynamicConditionTypeEnum.OR_GROUP.toString().equals(dynamicCondition.getType())) {
                List conditons = dynamicCondition.getItems();
                for (Conditon cd : conditons) {
                    if (!this.judgeExpression(cd, paramCodeAndValue).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private Boolean judgeExpression(Conditon dc, Map<String, Object> paramCodeAndValue) throws DWBusinessException {
        boolean result = false;
        if (paramCodeAndValue == null || paramCodeAndValue.isEmpty()) {
            paramCodeAndValue = (Map)this.mechanismService.getVariable(dc.getLeft(), AthenaUtils.getTenantId());
        }
        if (paramCodeAndValue == null || paramCodeAndValue.isEmpty()) {
            return true;
        }
        Object variable = paramCodeAndValue.get(dc.getLeft());
        String op = dc.getOp();
        String[] value = dc.getRight().split(",");
        if (ConditionOperatorTypeEnum.IN.toString().equals(op) && Arrays.asList(value).contains(String.valueOf(variable))) {
            result = true;
        }
        try {
            double douValue;
            if (ConditionOperatorTypeEnum.GREATER_THAN.toString().equals(op)) {
                double d = douValue = variable != null ? Double.parseDouble(String.valueOf(variable)) : 0.0;
                if (douValue > Double.parseDouble(value[0])) {
                    result = true;
                }
            }
            if (ConditionOperatorTypeEnum.LESS_THAN.toString().equals(op)) {
                double d = douValue = variable != null ? Double.parseDouble(String.valueOf(variable)) : 0.0;
                if (douValue < Double.parseDouble(value[0])) {
                    result = true;
                }
            }
        }
        catch (Exception e) {
            log.error("\u6761\u4ef6\u6570\u503c\u6bd4\u8f83\u51fa\u73b0\u5f02\u5e38, \u8bf7\u68c0\u67e5\u914d\u7f6e\u6761\u4ef6\u503c\u7c7b\u578b\uff01");
            throw e;
        }
        return result;
    }

    @Override
    public Object postCopyApiStatus(List<String> codeList, String tenantId, String appCode) throws Exception {
        Criteria criteria;
        List<ActivityConfig> activityConfigs;
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        if (CollectionUtils.isEmpty(codeList)) {
            codeList = new ArrayList<String>();
        }
        if (StringUtils.isNotEmpty((CharSequence)appCode)) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode).and("version").is((Object)tenantVersion));
            List applicationRelations = this.mongoTemplate.find(query, ApplicationRelation.class);
            if (!CollectionUtils.isEmpty((Collection)applicationRelations)) {
                for (ApplicationRelation applicationRelation : applicationRelations) {
                    codeList.add(applicationRelation.getCode());
                }
            }
        }
        if (CollectionUtils.isEmpty(activityConfigs = this.dataPickService.find(criteria = Criteria.where((String)"code").in(codeList).and("copyApi").ne(null), ActivityConfig.class, "activityConfigs"))) {
            return new ArrayList();
        }
        LanguageUtil.processLocaleLanguage(activityConfigs, AthenaUtils.getCurrentLocale());
        return activityConfigs;
    }

    @Override
    public Object getAddActionsByPluginId(String code, String variableId, String pluginId) throws DWBusinessException {
        ActivityConfig activityConfigs = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)code), ActivityConfig.class, "activityConfigs");
        try {
            Map pages = activityConfigs.getPages();
            Map basicData = (Map)pages.get("basic-data");
            Object submitActions = basicData.get("submitActions");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", variableId);
            map.put("value", variableId);
            map.put("type", "TM_VARIABLE");
            map.put("pluginId", pluginId);
            if (ObjectUtils.isEmpty(submitActions)) {
                basicData.put("submitActions", Collections.singletonList(ImmutableMap.of((Object)"actionParams", Collections.singletonList(map))));
            } else {
                List submitAction = (List)submitActions;
                submitAction.add(ImmutableMap.of((Object)"actionParams", Collections.singletonList(map)));
            }
            Query query1 = new Query();
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)activityConfigs.getId()));
            Update update = new Update();
            update.set("pages", (Object)pages);
            this.mongoTemplate.upsert(query1, update, "activityConfigs");
            this.cacheService.deleteWithPattern("knowledgegraph:*");
        }
        catch (Exception e) {
            throw new DWBusinessException("getAddActionsByPluginId  error,{}", e.toString());
        }
        return "ok";
    }

    @Override
    public Object getCleanActionsByPluginId(String code, String pluginId) throws DWBusinessException {
        ActivityConfig activityConfigs = this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)code), ActivityConfig.class, "activityConfigs");
        try {
            Map basicData = (Map)activityConfigs.getPages().get("basic-data");
            if (!ObjectUtils.isEmpty(basicData.get("submitActions"))) {
                List list = (List)basicData.get("submitActions");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map next = (Map)iterator.next();
                    Object actionParams = next.get("actionParams");
                    if (ObjectUtils.isEmpty(actionParams)) continue;
                    List list1 = (List)actionParams;
                    for (Map next1 : list1) {
                        if (!"TM_VARIABLE".equals(next1.get("type")) || !pluginId.equals(next1.get("pluginId"))) continue;
                        iterator.remove();
                    }
                }
            }
            Query query1 = new Query();
            query1.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)activityConfigs.getId()));
            Update update = new Update();
            update.set("pages", (Object)activityConfigs.getPages());
            this.mongoTemplate.upsert(query1, update, "activityConfigs");
        }
        catch (Exception e) {
            throw new DWBusinessException("getCleanActionsByPluginId  error,{}", e.toString());
        }
        return "ok";
    }
}

