/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.utils;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import io.seata.common.util.StringUtils;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class DataSubscriptionUtils {
    private static final Logger log = LoggerFactory.getLogger(DataSubscriptionUtils.class);
    @Autowired
    @Qualifier(value="sdRestTemplate")
    RestTemplate restTemplate;
    @Value(value="${xxlJobUrl}")
    private String xxlJobUrl;
    @Value(value="${scdispatcherUrl}/restful/standard/AgileDataEngine/schedule")
    private String scdispatcherUrl;
    @Value(value="${xxlJobFlag}")
    private String xxlJobFlag;
    @Autowired
    private IamService iamService;
    public static final String FAIL_MSG = "fail";
    public static final String SUCCESS_MSG = "success";

    public String postDataSubscription(Object data, String url, HttpMethod method) {
        try {
            ResponseEntity res;
            String routerKey;
            HttpHeaders headers = new HttpHeaders();
            String tenantId = AthenaUtils.getTenantId();
            String token = AthenaUtils.getHeaderToken();
            String string = Objects.nonNull(KgFilter.getLoginInfo()) ? (StringUtils.isNotEmpty((CharSequence)KgFilter.getLoginInfo().getRouterKey()) ? KgFilter.getLoginInfo().getRouterKey() : tenantId) : (routerKey = tenantId);
            if (StringUtils.isBlank((String)token)) {
                token = this.iamService.getTenantToken(tenantId);
            }
            headers.add("token", token);
            headers.add("routerKey", routerKey);
            HttpEntity httpEntity = new HttpEntity(data, (MultiValueMap)headers);
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = this.xxlJobFlag.equals("true") ? this.xxlJobUrl + url : this.scdispatcherUrl;
            }
            if (!"200".equals((res = this.restTemplate.exchange(url, method, httpEntity, HashMap.class, new Object[0])).getStatusCode().toString())) {
                return FAIL_MSG;
            }
        }
        catch (Exception e) {
            log.error("postDataSubscription method error : {},data:{},type:{}", new Object[]{e, JSON.toJSON((Object)data), "sdRestTemplate"});
            return FAIL_MSG;
        }
        return SUCCESS_MSG;
    }
}

