/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.knowledgegraph.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@Deprecated
public class KgHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(KgHttpUtil.class);
    private static Logger LOGGER = LoggerFactory.getLogger(KgHttpUtil.class);
    @Autowired
    @Qualifier(value="routeRestTemplate")
    RestTemplate routeRestTemplate;
    static RestTemplate restTemplate;

    @PostConstruct
    public void init() {
        restTemplate = this.routeRestTemplate;
    }

    public static String post(String url, String content) {
        String result = "";
        try {
            HttpHeaders headers = new HttpHeaders();
            Utils.requiredHeaders(headers);
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            LOGGER.info("url:{}", (Object)url);
            LOGGER.info("content:{}", (Object)content);
            org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity((Object)content, (MultiValueMap)headers);
            result = (String)restTemplate.postForObject(url, (Object)formEntity, String.class, new Object[0]);
            LOGGER.info("result:{}", (Object)result);
        }
        catch (JSONException e) {
            LOGGER.error("http post error:", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("http post error2:", (Throwable)e);
        }
        return result;
    }

    public static String post(String url, String content, Map<String, String> headerParam) {
        String result = "";
        try {
            HttpHeaders headers = new HttpHeaders();
            Utils.requiredHeaders(headers);
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            for (String k : headerParam.keySet()) {
                headers.add(k, headerParam.get(k));
            }
            LOGGER.info("url:{}", (Object)url);
            LOGGER.info("content:{}", (Object)content);
            org.springframework.http.HttpEntity formEntity = new org.springframework.http.HttpEntity((Object)content, (MultiValueMap)headers);
            result = (String)restTemplate.postForObject(url, (Object)formEntity, String.class, new Object[0]);
            LOGGER.info("result:{}", (Object)result);
        }
        catch (JSONException e) {
            LOGGER.error("http post error:", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("http post error2:", (Throwable)e);
        }
        return result;
    }

    public static String sendGet(String url, String reqJson, Map<String, String> header) {
        String responseContent = "";
        HttpClient httpClient = Utils.getHttpClient();
        try {
            HttpResponse httpResponse;
            HttpEntity entity;
            URIBuilder uriBuilder = new URIBuilder(url);
            if (StringUtils.isNotEmpty((CharSequence)reqJson)) {
                List<NameValuePair> nameValuePairList = KgHttpUtil.json2NameValuePairList(JSON.parseObject((String)reqJson));
                uriBuilder.setParameters(nameValuePairList);
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            httpGet.setHeader("Content-Type", "application/json");
            if (null != header && !header.isEmpty()) {
                for (Map.Entry<String, String> i : header.entrySet()) {
                    httpGet.setHeader(i.getKey(), i.getValue());
                }
            }
            if (null != (entity = (httpResponse = httpClient.execute((HttpUriRequest)httpGet)).getEntity())) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            return responseContent;
        }
        catch (IOException | URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(I18nUtils.getValue("knowledgegraph.httpRequestError", e.getMessage()));
        }
    }

    private static List<NameValuePair> json2NameValuePairList(JSONObject params) {
        if (params != null && !params.isEmpty()) {
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            for (Map.Entry entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                String value = String.valueOf(entry.getValue());
                list.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), value));
            }
            return list;
        }
        return null;
    }
}

